/*
 * Decompiled with CFR 0.152.
 */
package clib.phtree.v13SynchedPool;

import ch.ethz.globis.pht64kd.MaxKTreeI;
import clib.phtree.PhEntry;
import clib.phtree.v13SynchedPool.Bits;
import clib.phtree.v13SynchedPool.Node;
import clib.phtree.v13SynchedPool.PhQueryKnnHS;
import clib.phtree.v13SynchedPool.nt.NtIteratorMinMax;

public class NodeIteratorFullToList<T> {
    private final int dims;
    private Node node;
    private NtIteratorMinMax<Object> ntIterator;
    private long[] prefix;
    private final long maxPos;

    public NodeIteratorFullToList(int dims) {
        this.dims = dims;
        this.maxPos = (1L << dims) - 1L;
    }

    private void reinit(Node node, PhQueryKnnHS.KnnResultList<T> resultList, long[] prefix) {
        this.node = node;
        this.prefix = prefix;
        this.getAll(resultList);
    }

    private void readValue(int posInNode, long hcPos, PhQueryKnnHS.KnnResultList<T> resultList) {
        if (this.node.values()[posInNode] == null) {
            return;
        }
        PhEntry result = resultList.phGetTempEntry();
        long[] key = result.getKey();
        System.arraycopy(this.prefix, 0, key, 0, this.prefix.length);
        Object v = this.node.getEntryPIN(posInNode, hcPos, key, key);
        if (v == null) {
            throw new IllegalStateException();
        }
        if (v instanceof Node) {
            result.setNodeInternal(v);
        } else {
            result.setValueInternal(v);
        }
        resultList.phOffer(result);
    }

    private void readValue(long[] kdKey, Object value, PhQueryKnnHS.KnnResultList<T> resultList) {
        PhEntry result = resultList.phGetTempEntry();
        if (value instanceof Node) {
            Node sub = (Node)value;
            System.arraycopy(kdKey, 0, result.getKey(), 0, kdKey.length);
            result.setNodeInternal(sub);
        } else {
            System.arraycopy(kdKey, 0, result.getKey(), 0, kdKey.length);
            result.setValueInternal(value);
        }
        resultList.phOffer(result);
    }

    private void getAll(PhQueryKnnHS.KnnResultList<T> resultList) {
        if (this.node.isNT()) {
            this.niFindNext(resultList);
        } else if (this.node.isAHC()) {
            this.getAllAHC(resultList);
        } else {
            this.getNextLHC(resultList);
        }
    }

    private void getAllAHC(PhQueryKnnHS.KnnResultList<T> resultList) {
        long currentPos = 0L;
        do {
            this.readValue((int)currentPos, currentPos, resultList);
        } while (++currentPos <= this.maxPos);
    }

    private void getNextLHC(PhQueryKnnHS.KnnResultList<T> resultList) {
        int currentOffsetKey = this.node.getBitPosIndex();
        int postEntryLenLHC = Node.IK_WIDTH(this.dims) + this.dims * this.node.postLenStored();
        int nEntriesFound = 0;
        int nMaxEntries = this.node.getEntryCount();
        while (nEntriesFound < nMaxEntries) {
            long currentPos = Bits.readArray(this.node.ba(), currentOffsetKey, Node.IK_WIDTH(this.dims));
            currentOffsetKey += postEntryLenLHC;
            this.readValue(++nEntriesFound - 1, currentPos, resultList);
        }
    }

    private void niFindNext(PhQueryKnnHS.KnnResultList<T> resultList) {
        if (this.ntIterator == null) {
            this.ntIterator = new NtIteratorMinMax(this.dims);
        }
        this.ntIterator.reset(this.node.ind(), 0L, Long.MAX_VALUE);
        while (this.ntIterator.hasNext()) {
            MaxKTreeI.NtEntry<Object> e = this.ntIterator.nextEntryReuse();
            this.readValue(e.getKdKey(), e.value(), resultList);
        }
    }

    void init(Node node, PhQueryKnnHS.KnnResultList<T> resultList, long[] prefix) {
        this.reinit(node, resultList, prefix);
    }
}

