/*
 * Decompiled with CFR 0.152.
 */
package clib.phtree.v13SynchedPool.nt;

import ch.ethz.globis.pht64kd.MaxKTreeI;
import clib.phtree.v13SynchedPool.nt.Bits;
import clib.phtree.v13SynchedPool.nt.NodeTreeV13;
import clib.phtree.v13SynchedPool.nt.NtNode;

public class NtNodeIteratorMinMax<T> {
    private static final long FINISHED = Long.MAX_VALUE;
    private static final long START = -1L;
    private boolean isHC;
    private long next;
    private NtNode<T> nextSubNode;
    private NtNode<T> node;
    private int currentOffsetKey;
    private int nMaxEntry;
    private int nFound = 0;
    private int postEntryLenLHC;
    private long prefix;
    private long localMin;
    private long localMax;
    private long globalMin;
    private long globalMax;

    private void reinit(NtNode<T> node, long prefix, long globalMin, long globalMax) {
        this.prefix = prefix;
        this.globalMin = globalMin;
        this.globalMax = globalMax;
        this.next = -1L;
        this.nextSubNode = null;
        this.currentOffsetKey = 0;
        this.nFound = 0;
        this.node = node;
        this.isHC = node.isAHC();
        this.nMaxEntry = node.getEntryCount();
        this.currentOffsetKey = node.getBitPosIndex();
        if (!this.isHC) {
            this.postEntryLenLHC = NtNode.IK_WIDTH(8) + 8 * node.getPostLen();
        }
    }

    boolean increment(MaxKTreeI.NtEntry<T> result) {
        this.getNext(result);
        return this.next != Long.MAX_VALUE;
    }

    long getCurrentPos() {
        return this.next;
    }

    boolean isNextSub() {
        return this.nextSubNode != null;
    }

    private boolean readValue(int pin, long pos, MaxKTreeI.NtEntry<T> result) {
        Object v = this.node.getValueByPIN(pin);
        if (v == null) {
            return false;
        }
        this.prefix = this.node.localReadAndApplyReadPostfixAndHc(pin, pos, this.prefix);
        if (v instanceof NtNode) {
            NtNode sub = (NtNode)v;
            long mask = -1L << (sub.getPostLen() + 1) * 8;
            if (this.prefix < (this.globalMin & mask) || (this.prefix & mask) > this.globalMax) {
                return false;
            }
            this.nextSubNode = sub;
        } else {
            if (this.prefix < this.globalMin || this.prefix > this.globalMax) {
                return false;
            }
            this.nextSubNode = null;
            this.node.getKdKeyByPIN(pin, result.getKdKey());
            result.setValue(v == NodeTreeV13.NT_NULL ? null : v);
        }
        result.setKey(this.prefix);
        return true;
    }

    private void getNext(MaxKTreeI.NtEntry<T> result) {
        if (this.isHC) {
            this.getNextAHC(result);
        } else {
            this.getNextLHC(result);
        }
    }

    private void getNextAHC(MaxKTreeI.NtEntry<T> result) {
        long currentPos;
        long l = currentPos = this.next == -1L ? this.localMin : this.next + 1L;
        while (currentPos <= this.localMax) {
            if (this.readValue((int)currentPos, currentPos, result)) {
                this.next = currentPos;
                return;
            }
            ++currentPos;
        }
        this.next = Long.MAX_VALUE;
    }

    private void getNextLHC(MaxKTreeI.NtEntry<T> result) {
        while (++this.nFound <= this.nMaxEntry) {
            long currentPos = Bits.readArray(this.node.ba, this.currentOffsetKey, NtNode.IK_WIDTH(8));
            this.currentOffsetKey += this.postEntryLenLHC;
            if (currentPos > this.localMax) break;
            if (!this.readValue(this.nFound - 1, currentPos, result)) continue;
            this.next = currentPos;
            return;
        }
        this.next = Long.MAX_VALUE;
    }

    public NtNode<T> getCurrentSubNode() {
        return this.nextSubNode;
    }

    public NtNode<T> node() {
        return this.node;
    }

    boolean calcLimits(long globalMin, long globalMax, long prefix, boolean isNegativeRoot) {
        int postLen = this.node.getPostLen();
        if (isNegativeRoot) {
            this.localMin = 0L;
            this.localMax = 255L;
        } else {
            this.localMin = (globalMin ^ prefix) >> postLen == 0L ? NtNode.pos2LocalPos(globalMin, postLen) : 0L;
            this.localMax = (globalMax ^ prefix) >> postLen == 0L ? NtNode.pos2LocalPos(globalMax, postLen) : 255L;
        }
        if (this.localMin > this.localMax) {
            throw new IllegalStateException("localMin=" + this.localMin + " / " + this.localMax);
        }
        return true;
    }

    void init(long globalMin, long globalMax, long valTemplate, NtNode<T> node, boolean isNegativeRoot) {
        this.node = node;
        this.calcLimits(globalMin, globalMax, valTemplate, isNegativeRoot);
        this.reinit(node, valTemplate, globalMin, globalMax);
    }

    public long getPrefix() {
        return this.prefix;
    }
}

