/*
 * Decompiled with CFR 0.152.
 */
package clib.phtree.v16.bst;

import clib.phtree.v16.Node;
import clib.phtree.v16.bst.BSTreePage;
import java.util.NoSuchElementException;

public class BSTIteratorMask {
    private BSTreePage currentPage = null;
    private int currentPos = 0;
    private long minMask;
    private long maxMask;
    private Node.BSTEntry nextValue;

    public BSTIteratorMask reset(BSTreePage root, long minMask, long maxMask, int nEntries) {
        this.minMask = minMask;
        this.maxMask = maxMask;
        this.currentPage = root;
        this.currentPos = 0;
        if (nEntries > 4 && Long.bitCount(minMask ^ maxMask) == 0) {
            BSTreePage page;
            long key = minMask;
            for (page = root; page != null && !page.isLeaf(); page = page.findSubPage(key)) {
            }
            if (page != null) {
                this.currentPos = page.binarySearch(key);
                if (this.currentPos >= 0) {
                    this.nextValue = page.getValues()[this.currentPos];
                    this.currentPage = page;
                } else {
                    this.currentPage = null;
                }
                this.currentPos = Integer.MAX_VALUE;
            } else {
                this.currentPage = null;
            }
            return this;
        }
        if (this.findFirstLeafPage()) {
            this.findNext();
        }
        return this;
    }

    private boolean findFirstLeafPage() {
        while (!this.currentPage.isLeaf()) {
            if (this.currentPage.getNKeys() == -1) {
                this.currentPage = null;
                return false;
            }
            this.currentPage = this.currentPage.getPageByPos(0);
        }
        return true;
    }

    private void findNext() {
        while (this.currentPage != null) {
            short nKeys = this.currentPage.getNKeys();
            long[] keys = this.currentPage.getKeys();
            while (this.currentPos < nKeys) {
                long key = keys[this.currentPos];
                if (this.check(key)) {
                    this.nextValue = this.currentPage.getValues()[this.currentPos];
                    ++this.currentPos;
                    return;
                }
                if (key > this.maxMask) {
                    this.currentPage = null;
                    return;
                }
                ++this.currentPos;
            }
            this.currentPage = this.currentPage.getNextLeaf();
            this.currentPos = 0;
        }
    }

    public boolean hasNextEntry() {
        return this.currentPage != null;
    }

    public Node.BSTEntry nextEntry() {
        if (!this.hasNextEntry()) {
            throw new NoSuchElementException();
        }
        Node.BSTEntry ret = this.nextValue;
        this.findNext();
        return ret;
    }

    public void adjustMinMax(long maskLower, long maskUpper) {
        this.minMask = maskLower;
        this.maxMask = maskUpper;
    }

    private boolean check(long key) {
        return ((key | this.minMask) & this.maxMask) == key;
    }
}

