/*
 * Decompiled with CFR 0.152.
 */
package clib.phtree.v16hd;

import clib.phtree.util.BitsLong;
import java.util.Arrays;

public class BitsHD {
    private static final long UNIT_0xFF = -1L;

    public static int mod64(int x) {
        return x & 0x3F;
    }

    public static int mod65x(int x) {
        return 1 + (x - 1 & 0x3F);
    }

    public static int div64(int x) {
        return x >> 6;
    }

    public static int xorBitCount(long[] a, long[] b) {
        int bitCount = 0;
        for (int i = 0; i < a.length; ++i) {
            bitCount += Long.bitCount(a[i] ^ b[i]);
        }
        return bitCount;
    }

    public static int binarySearch(long[][] keys, int fromIndex, int toIndex, long[] key) {
        int min = fromIndex;
        int max = toIndex - 1;
        int maxI = key.length - 1;
        block0: while (min <= max) {
            int mid = min + max >>> 1;
            int readPos = mid + fromIndex;
            long[] midKey = keys[readPos];
            for (int i = 0; i <= maxI; ++i) {
                int comp = Long.compareUnsigned(midKey[i], key[i]);
                if (comp < 0) {
                    min = mid + 1;
                    continue block0;
                }
                if (comp > 0) {
                    max = mid - 1;
                    continue block0;
                }
                if (i != maxI) continue;
                return mid;
            }
        }
        return -(min + 1);
    }

    public static boolean isLess(long[] a, long[] b) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return Long.compareUnsigned(a[i], b[i]) < 0;
        }
        return false;
    }

    public static boolean isLessEq(long[] a, long[] b) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return Long.compareUnsigned(a[i], b[i]) < 0;
        }
        return true;
    }

    public static boolean isEq(long[] a, long[] b) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public static void writeArrayHD(long[] ba, int offsetBit, int entryLen, long[] val) {
        if (entryLen == 0) {
            return;
        }
        int subEntryLen = BitsHD.mod65x(entryLen);
        for (int i = 0; i < val.length; ++i) {
            BitsLong.writeArray(ba, offsetBit, subEntryLen, val[i]);
            offsetBit += subEntryLen;
            subEntryLen = 64;
        }
    }

    public static long[] newArray(int bits) {
        return new long[1 + (bits - 1 >>> 6)];
    }

    public static void set(long[] dst, long[] src) {
        System.arraycopy(src, 0, dst, 0, src.length);
    }

    public static void set0(long[] dst) {
        Arrays.fill(dst, 0L);
    }

    public static boolean checkHcPosHD(long[] hcPos, long[] min, long[] max) {
        for (int i = 0; i < hcPos.length; ++i) {
            if (((hcPos[i] | min[i]) & max[i]) == hcPos[i]) continue;
            return false;
        }
        return true;
    }

    public static long[] inc(long[] v) {
        for (int i = v.length - 1; i >= 0; --i) {
            long prev;
            int n = i;
            v[n] = v[n] + 1L;
            if (Long.compareUnsigned(prev, v[i]) >= 0) continue;
            return v;
        }
        return v;
    }

    public static long[] dec(long[] v) {
        for (int i = v.length - 1; i >= 0; --i) {
            long prev;
            int n = i;
            v[n] = v[n] - 1L;
            if (Long.compareUnsigned(prev, v[i]) <= 0) continue;
            return v;
        }
        return v;
    }

    public static boolean incHD(long[] v, long[] min, long[] max) {
        int msb;
        for (int i = msb = v.length - 1; i >= 0; --i) {
            long result;
            long in = v[i];
            v[i] = result = BitsHD.inc(in, min[i], max[i]);
            if (Long.compareUnsigned(result, in) <= 0) continue;
            return true;
        }
        return false;
    }

    static long inc(long v, long min, long max) {
        long r = v | max ^ 0xFFFFFFFFFFFFFFFFL;
        return ++r & max | min;
    }

    public static int getFilterBits(long[] maskLower, long[] maskUpper, int dims) {
        int msbDims = BitsHD.mod65x(dims);
        long maxHcAddr = msbDims == 64 ? -1L : -1L << dims ^ 0xFFFFFFFFFFFFFFFFL;
        int nSetFilterBits = 0;
        for (int i = 0; i < maskLower.length; ++i) {
            nSetFilterBits += Long.bitCount(maskLower[i] | (maskUpper[i] ^ 0xFFFFFFFFFFFFFFFFL) & maxHcAddr);
            maxHcAddr = -1L;
        }
        return nSetFilterBits;
    }

    public static int getMaxConflictingBits(long[] v1, long[] v2, int rangeMax) {
        int iMin = v1.length - BitsHD.div64(rangeMax) - 1;
        int rmMod64 = BitsHD.mod64(rangeMax);
        long mask = rmMod64 == 63 ? -1L : -1L << rmMod64 + 1 ^ 0xFFFFFFFFFFFFFFFFL;
        for (int i = iMin; i < v1.length; ++i) {
            long x = (v1[i] ^ v2[i]) & mask;
            if (x != 0L) {
                int cb = 64 - Long.numberOfLeadingZeros(x);
                return cb += 64 * (v1.length - i - 1);
            }
            mask = -1L;
        }
        return 0;
    }

    public static int getMaxConflictingBits(long[] v1, long[] v2, int rangeMin, int rangeMax) {
        int iMin = v1.length - BitsHD.div64(rangeMax) - 1;
        int iMax = v1.length - BitsHD.div64(rangeMin + 1);
        int rmMod64 = BitsHD.mod64(rangeMax);
        long mask = rmMod64 == 63 ? -1L : -1L << rmMod64 + 1 ^ 0xFFFFFFFFFFFFFFFFL;
        for (int i = iMin; i < iMax; ++i) {
            long x = (v1[i] ^ v2[i]) & mask;
            if (x != 0L) {
                int cb = 64 - Long.numberOfLeadingZeros(x);
                return (cb += 64 * (v1.length - i - 1)) > rangeMin ? cb : 0;
            }
            mask = -1L;
        }
        return 0;
    }

    public static boolean hasConflictingBits(long[] v1, long[] v2, int rangeMax) {
        int iMin = v1.length - BitsHD.div64(rangeMax) - 1;
        int rmMod64 = BitsHD.mod64(rangeMax);
        long mask = rmMod64 == 63 ? -1L : -1L << rmMod64 + 1 ^ 0xFFFFFFFFFFFFFFFFL;
        for (int i = iMin; i < v1.length; ++i) {
            long x = (v1[i] ^ v2[i]) & mask;
            if (x != 0L) {
                return true;
            }
            mask = -1L;
        }
        return false;
    }

    public static boolean hasConflictingBits(long[] v1, long[] v2, int rangeMin, int rangeMax) {
        int iMin = v1.length - BitsHD.div64(rangeMax) - 1;
        int iMax = v1.length - BitsHD.div64(rangeMin + 1);
        int rmMod64 = BitsHD.mod64(rangeMax);
        long mask = rmMod64 == 63 ? -1L : -1L << rmMod64 + 1 ^ 0xFFFFFFFFFFFFFFFFL;
        for (int i = iMin; i < iMax; ++i) {
            long x = (v1[i] ^ v2[i]) & mask;
            if (x != 0L) {
                int cb = 64 - Long.numberOfLeadingZeros(x);
                return (cb += 64 * (v1.length - i - 1)) > rangeMin;
            }
            mask = -1L;
        }
        return false;
    }
}

