/*
 * Decompiled with CFR 0.152.
 */
package clib.phtree.v16hd;

import clib.phtree.PhEntry;
import clib.phtree.v16hd.BitsHD;
import clib.phtree.v16hd.Node;
import clib.phtree.v16hd.PhResultList;
import clib.phtree.v16hd.bst.BSTIteratorMask;
import java.util.List;

public class NodeIteratorListReuse<T, R> {
    private final int dims;
    private final PhResultList<T, R> results;
    private int maxResults;
    private long[] rangeMin;
    private long[] rangeMax;
    private final PhIteratorStack pool;

    NodeIteratorListReuse(int dims, PhResultList<T, R> results) {
        this.dims = dims;
        this.results = results;
        this.pool = new PhIteratorStack();
    }

    List<R> resetAndRun(Node node, long[] rangeMin, long[] rangeMax, int maxResults) {
        this.results.clear();
        this.rangeMin = rangeMin;
        this.rangeMax = rangeMax;
        this.maxResults = maxResults;
        this.run(node, null);
        return this.results;
    }

    private void run(Node node, long[] prefix) {
        NodeIterator nIt = this.pool.prepare();
        nIt.reinitAndRun(node, prefix);
        this.pool.pop();
    }

    private final class NodeIterator {
        private final BSTIteratorMask niIterator = new BSTIteratorMask();
        private final long[] maskLower;
        private final long[] maskUpper;

        private NodeIterator(int dims) {
            this.maskLower = BitsHD.newArray(dims);
            this.maskUpper = BitsHD.newArray(dims);
        }

        void reinitAndRun(Node node, long[] prefix) {
            this.calcLimits(node, NodeIteratorListReuse.this.rangeMin, NodeIteratorListReuse.this.rangeMax, prefix);
            this.niIterator.reset(node.getRoot(), this.maskLower, this.maskUpper);
            this.getAll();
        }

        private void checkAndRunSubnode(Node sub, long[] subPrefix) {
            if (NodeIteratorListReuse.this.results.phIsPrefixValid(subPrefix, sub.getPostLen() + 1)) {
                NodeIteratorListReuse.this.run(sub, subPrefix);
            }
        }

        private void readValue(Node.BSTEntry candidate) {
            PhEntry<Object> result = NodeIteratorListReuse.this.results.phGetTempEntry();
            result.setKeyInternal(candidate.getKdKey());
            result.setValueInternal(candidate.getValue());
            NodeIteratorListReuse.this.results.phOffer(result);
        }

        private void checkEntry(Node.BSTEntry be) {
            Object v = be.getValue();
            if (v instanceof Node) {
                this.checkAndRunSubnode((Node)v, be.getKdKey());
            } else if (v != null) {
                this.readValue(be);
            }
        }

        private void getAll() {
            this.niAllNext();
        }

        private void niAllNext() {
            this.niAllNextIterator();
        }

        private void niAllNextIterator() {
            while (this.niIterator.hasNextEntry() && NodeIteratorListReuse.this.results.size() < NodeIteratorListReuse.this.maxResults) {
                Node.BSTEntry be = this.niIterator.nextEntry();
                this.checkEntry(be);
            }
        }

        private void calcLimits(Node node, long[] rangeMin, long[] rangeMax, long[] prefix) {
            if (prefix == null) {
                prefix = rangeMin;
            }
            int postLen = node.getPostLen();
            long maskHcBit = 1L << postLen;
            long maskVT = -1L << postLen;
            long[] lowerLimit = this.maskLower;
            long[] upperLimit = this.maskUpper;
            BitsHD.set0(lowerLimit);
            BitsHD.set0(upperLimit);
            int maskSlot = 0;
            long mask1 = 1L << BitsHD.mod65x(prefix.length) - 1;
            if (maskHcBit >= 0L) {
                for (int i = 0; i < prefix.length; ++i) {
                    long nodeBisection = (prefix[i] | maskHcBit) & maskVT;
                    if (rangeMin[i] >= nodeBisection) {
                        int n = maskSlot;
                        lowerLimit[n] = lowerLimit[n] | mask1;
                    }
                    if (rangeMax[i] >= nodeBisection) {
                        int n = maskSlot;
                        upperLimit[n] = upperLimit[n] | mask1;
                    }
                    if ((mask1 >>>= 1) != 0L) continue;
                    mask1 = Long.MIN_VALUE;
                    ++maskSlot;
                }
            } else {
                for (int i = 0; i < prefix.length; ++i) {
                    if (rangeMin[i] < 0L) {
                        int n = maskSlot;
                        upperLimit[n] = upperLimit[n] | mask1;
                    }
                    if (rangeMax[i] < 0L) {
                        int n = maskSlot;
                        lowerLimit[n] = lowerLimit[n] | mask1;
                    }
                    if ((mask1 >>>= 1) != 0L) continue;
                    mask1 = Long.MIN_VALUE;
                    ++maskSlot;
                }
            }
        }
    }

    private class PhIteratorStack {
        private final NodeIterator[] stack = new NodeIterator[64];
        private int size = 0;

        private PhIteratorStack() {
        }

        NodeIterator prepare() {
            NodeIterator ni;
            if ((ni = this.stack[this.size++]) == null) {
                this.stack[this.size - 1] = ni = new NodeIterator(NodeIteratorListReuse.this.dims);
            }
            return ni;
        }

        NodeIterator pop() {
            return this.stack[--this.size];
        }
    }
}

