/*
 * Decompiled with CFR 0.152.
 */
package clib.phtree.v16hd;

import clib.phtree.PhEntry;
import clib.phtree.PhFilter;
import clib.phtree.PhTree;
import clib.phtree.util.unsynced.LongArrayOps;
import clib.phtree.v16hd.Node;
import clib.phtree.v16hd.NodeIteratorFullNoGC;
import clib.phtree.v16hd.PhTree16HD;
import java.util.NoSuchElementException;

public final class PhIteratorFullNoGC<T>
implements PhTree.PhExtent<T> {
    private final PhIteratorStack stack;
    private PhFilter checker;
    private final PhTree16HD<T> pht;
    private PhEntry<T> resultFree;
    private PhEntry<T> resultToReturn;
    private boolean isFinished = false;

    public PhIteratorFullNoGC(PhTree16HD<T> pht, PhFilter checker) {
        int dims = pht.getDim();
        this.checker = checker;
        this.stack = new PhIteratorStack();
        this.pht = pht;
        this.resultFree = new PhEntry<Object>(new long[dims], null);
        this.resultToReturn = new PhEntry<Object>(new long[dims], null);
    }

    @Override
    public PhIteratorFullNoGC<T> reset() {
        this.stack.size = 0;
        this.isFinished = false;
        if (this.pht.getRoot() == null) {
            this.isFinished = true;
            return this;
        }
        this.stack.prepareAndPush(this.pht.getRoot());
        this.findNextElement();
        return this;
    }

    private void findNextElement() {
        PhEntry<T> result = this.resultFree;
        while (!this.stack.isEmpty()) {
            NodeIteratorFullNoGC<T> p = this.stack.peek();
            while (p.increment(result)) {
                if (result.hasNodeInternal()) {
                    p = this.stack.prepareAndPush((Node)result.getNodeInternal());
                    continue;
                }
                this.resultFree = this.resultToReturn;
                this.resultToReturn = result;
                return;
            }
            this.stack.pop();
        }
        this.isFinished = true;
    }

    @Override
    public long[] nextKey() {
        long[] key = ((PhEntry)this.nextEntryReuse()).getKey();
        long[] ret = new long[key.length];
        LongArrayOps.arraycopy(key, 0, ret, 0, key.length);
        return ret;
    }

    @Override
    public T nextValue() {
        return ((PhEntry)this.nextEntryReuse()).getValue();
    }

    @Override
    public boolean hasNext() {
        return !this.isFinished;
    }

    @Override
    public PhEntry<T> nextEntry() {
        return new PhEntry(this.nextEntryReuse());
    }

    @Override
    public T next() {
        return ((PhEntry)this.nextEntryReuse()).getValue();
    }

    @Override
    public PhEntry<T> nextEntryReuse() {
        if (this.isFinished) {
            throw new NoSuchElementException();
        }
        PhEntry<T> ret = this.resultToReturn;
        this.findNextElement();
        return ret;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private class PhIteratorStack {
        private final NodeIteratorFullNoGC<T>[] stack = new NodeIteratorFullNoGC[64];
        private int size = 0;

        PhIteratorStack() {
        }

        public boolean isEmpty() {
            return this.size == 0;
        }

        public NodeIteratorFullNoGC<T> prepareAndPush(Node node) {
            NodeIteratorFullNoGC ni;
            if ((ni = this.stack[this.size++]) == null) {
                ni = new NodeIteratorFullNoGC();
                this.stack[this.size - 1] = ni;
            }
            ni.init(node, PhIteratorFullNoGC.this.checker);
            return ni;
        }

        public NodeIteratorFullNoGC<T> peek() {
            return this.stack[this.size - 1];
        }

        public NodeIteratorFullNoGC<T> pop() {
            return this.stack[--this.size];
        }
    }
}

