/*
 * Decompiled with CFR 0.152.
 */
package clib.phtree.v16hd.bst;

import clib.phtree.v16hd.BitsHD;
import clib.phtree.v16hd.Node;
import clib.phtree.v16hd.bst.BSTreePage;
import java.util.NoSuchElementException;

public class BSTIteratorMask {
    private BSTreePage currentPage = null;
    private int currentPos = 0;
    private long[] minMask;
    private long[] maxMask;
    private Node.BSTEntry nextValue;

    public BSTIteratorMask reset(BSTreePage root, long[] minMask, long[] maxMask) {
        this.minMask = minMask;
        this.maxMask = maxMask;
        this.currentPage = root;
        this.currentPos = 0;
        if (this.findFirstLeafPage()) {
            this.findNext();
        }
        return this;
    }

    private boolean findFirstLeafPage() {
        while (!this.currentPage.isLeaf()) {
            if (this.currentPage.getNKeys() == -1) {
                this.currentPage = null;
                return false;
            }
            this.currentPage = this.currentPage.getPageByPos(0);
        }
        return true;
    }

    private void findNext() {
        while (this.currentPage != null) {
            if (this.currentPos >= this.currentPage.getNKeys()) {
                this.currentPage = this.currentPage.getNextLeaf();
                this.currentPos = 0;
                continue;
            }
            if (this.check(this.currentPage.getKeys()[this.currentPos])) {
                this.nextValue = this.currentPage.getValues()[this.currentPos];
                ++this.currentPos;
                return;
            }
            ++this.currentPos;
        }
    }

    public boolean hasNextEntry() {
        return this.currentPage != null;
    }

    public Node.BSTEntry nextEntry() {
        if (!this.hasNextEntry()) {
            throw new NoSuchElementException();
        }
        Node.BSTEntry ret = this.nextValue;
        this.findNext();
        return ret;
    }

    public void adjustMinMax(long[] maskLower, long[] maskUpper) {
        this.minMask = maskLower;
        this.maxMask = maskUpper;
    }

    private boolean check(long[] key) {
        return BitsHD.checkHcPosHD(key, this.minMask, this.maxMask);
    }
}

