/*
 * Decompiled with CFR 0.152.
 */
package clib.phtree.v16hd.bst;

import clib.phtree.util.unsynced.LongArrayArrayPool;
import clib.phtree.util.unsynced.ObjectArrayPool;
import clib.phtree.util.unsynced.ObjectPool;
import clib.phtree.v16hd.Node;
import clib.phtree.v16hd.PhTree16HD;
import clib.phtree.v16hd.bst.BSTreePage;

public class BSTPool {
    private final ObjectArrayPool<Node.BSTEntry> entryPool = ObjectArrayPool.create(Node.BSTEntry[]::new);
    private final LongArrayArrayPool longArrayPool = LongArrayArrayPool.create();
    private final ObjectArrayPool<BSTreePage> pageArrayPool = ObjectArrayPool.create(BSTreePage[]::new);
    private final ObjectPool<BSTreePage> pagePool = ObjectPool.create(null);

    public static BSTPool create() {
        return new BSTPool();
    }

    private BSTPool() {
    }

    public Node.BSTEntry[] arrayCreateEntries(int newSize) {
        return this.entryPool.arrayCreate(newSize);
    }

    public Node.BSTEntry[] arrayExpand(Node.BSTEntry[] oldA, int newSize) {
        return this.entryPool.arrayExpand((Node.BSTEntry[])oldA, newSize);
    }

    public long[][] arrayCreateLong(int newSize) {
        return this.longArrayPool.arrayCreate(newSize);
    }

    public long[][] arrayExpand(long[][] oldA, int newSize) {
        return this.longArrayPool.arrayExpand(oldA, newSize);
    }

    public BSTreePage[] arrayCreateNodes(int newSize) {
        return this.pageArrayPool.arrayCreate(newSize);
    }

    public BSTreePage[] arrayExpand(BSTreePage[] oldA, int newSize) {
        return this.pageArrayPool.arrayExpand((BSTreePage[])oldA, newSize);
    }

    public void reportFreeNode(BSTreePage p) {
        this.longArrayPool.arrayDiscard(p.getKeys());
        if (p.isLeaf()) {
            p.updateNeighborsRemove();
            this.entryPool.arrayDiscard((Node.BSTEntry[])p.getValues());
        } else {
            this.pageArrayPool.arrayDiscard((BSTreePage[])p.getSubPages());
        }
        p.nullify();
        this.pagePool.offer(p);
    }

    public BSTreePage getNode(Node ind, BSTreePage parent, boolean isLeaf, BSTreePage leftPredecessor, PhTree16HD<?> tree) {
        BSTreePage p = this.pagePool.get();
        if (p != null) {
            p.init(ind, parent, isLeaf, leftPredecessor);
            return p;
        }
        return new BSTreePage(ind, parent, isLeaf, leftPredecessor, tree);
    }
}

