/*
 * Decompiled with CFR 0.152.
 */
package clib.phtree.v8;

import clib.phtree.PhTreeHelper;
import clib.phtree.v8.Bits;
import clib.phtree.v8.Node;
import clib.phtree.v8.PhTree8;
import java.util.NoSuchElementException;
import org.zoodb.index.critbit.CritBit64;

class NodeIteratorFull<T> {
    private final int DIM;
    private final int postLen;
    private long next = -1L;
    private long nextPost = -1L;
    private long nextSub = -1L;
    private long[] nextPostKey;
    private T nextPostVal;
    private Node<T> nextSubNode;
    private final Node<T> node;
    private int currentOffsetPostKey;
    private int currentOffsetPostVal;
    private int currentOffsetSub;
    private CritBit64.CBIterator<PhTree8.NodeEntry<T>> niIterator;
    private final int nMaxPost;
    private final int nMaxSub;
    private int postsFound = 0;
    private int posSubLHC = -1;
    private final int postEntryLen;
    private final long[] valTemplate;
    private boolean isPostFinished;
    private boolean isSubFinished;

    public NodeIteratorFull(Node<T> node, int DIM, long[] valTemplate) {
        this.DIM = DIM;
        this.node = node;
        this.valTemplate = valTemplate;
        this.postLen = node.getPostLen();
        this.nMaxPost = node.getPostCount();
        this.nMaxSub = node.getSubCount();
        this.isPostFinished = this.nMaxPost <= 0;
        this.isSubFinished = this.nMaxSub <= 0;
        this.currentOffsetSub = node.getBitPos_SubNodeIndex(DIM);
        this.currentOffsetSub -= node.isSubHC() ? 0 : Node.SIK_WIDTH(DIM);
        if (node.isPostNI()) {
            this.niIterator = node.ind().iterator();
            this.postEntryLen = -1;
        } else {
            this.currentOffsetPostKey = node.getBitPos_PostIndex(DIM);
            if (node.isPostHC()) {
                this.postEntryLen = DIM * this.postLen;
                this.currentOffsetPostVal = this.currentOffsetPostKey + (1 << DIM) * 1;
                --this.currentOffsetPostKey;
            } else {
                this.postEntryLen = Node.PIK_WIDTH(DIM) + DIM * this.postLen;
                this.currentOffsetPostVal = this.currentOffsetPostKey + Node.PIK_WIDTH(DIM);
                this.currentOffsetPostKey -= this.postEntryLen;
            }
        }
        if (valTemplate != null) {
            node.getInfix(valTemplate);
        }
        this.next = this.getNext();
    }

    boolean hasNext() {
        return this.next != -1L;
    }

    void increment() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.next = this.getNext();
    }

    long getCurrentPos() {
        return this.next;
    }

    boolean isNextSub() {
        return this.node.isPostNI() ? this.nextSubNode != null : this.next == this.nextSub;
    }

    private void readValue(long pos, int offsPostKey) {
        if (this.valTemplate != null) {
            long[] key = new long[this.DIM];
            System.arraycopy(this.valTemplate, 0, key, 0, this.DIM);
            PhTreeHelper.applyHcPos(pos, this.postLen, key);
            this.nextPostVal = this.node.getPostPOB(offsPostKey, pos, key);
            this.nextPostKey = key;
        }
    }

    private void readValue(long pos, PhTree8.NodeEntry<T> e) {
        if (this.valTemplate != null) {
            long[] buf = new long[this.DIM];
            System.arraycopy(this.valTemplate, 0, buf, 0, this.valTemplate.length);
            PhTreeHelper.applyHcPos(pos, this.postLen, buf);
            long mask = -1L << this.postLen;
            long[] eKey = e.getKey();
            for (int i = 0; i < buf.length; ++i) {
                int n = i;
                buf[n] = buf[n] & mask;
                int n2 = i;
                buf[n2] = buf[n2] | eKey[i];
            }
            this.nextPostKey = e.getKey();
        }
        this.nextPostVal = e.getValue();
        this.nextSubNode = null;
    }

    private long getNext() {
        long currentPos;
        if (this.node.isPostNI()) {
            this.niFindNext();
            return this.next;
        }
        if (!this.isPostFinished && this.nextPost == this.next) {
            if (this.node.isPostHC()) {
                currentPos = this.next;
                this.nextPost = -1L;
                while (!this.isPostFinished) {
                    currentPos = currentPos >= 0L ? ++currentPos : 0L;
                    if (currentPos >= (long)(1 << this.DIM)) {
                        this.isPostFinished = true;
                    } else {
                        ++this.currentOffsetPostKey;
                        if (!Bits.getBit(this.node.ba, this.currentOffsetPostKey)) continue;
                        int offs = (int)((long)this.currentOffsetPostVal + currentPos * (long)this.postEntryLen);
                        this.readValue(currentPos, offs);
                        this.nextPost = currentPos;
                    }
                    break;
                }
            } else {
                this.nextPost = -1L;
                if (this.postsFound >= this.nMaxPost) {
                    this.isPostFinished = true;
                } else {
                    this.currentOffsetPostKey += this.postEntryLen;
                    currentPos = Bits.readArray(this.node.ba, this.currentOffsetPostKey, Node.PIK_WIDTH(this.DIM));
                    this.readValue(currentPos, this.currentOffsetPostKey + Node.PIK_WIDTH(this.DIM));
                    this.nextPost = currentPos;
                    ++this.postsFound;
                }
            }
        }
        if (!this.isSubFinished && this.nextSub == this.next) {
            if (this.node.isSubHC()) {
                int currentPos2 = (int)this.next;
                int maxPos = 1 << this.DIM;
                this.nextSub = -1L;
                while (!this.isSubFinished) {
                    if (++currentPos2 >= maxPos) {
                        this.isSubFinished = true;
                    } else {
                        if (this.node.subNRef(currentPos2) == null) continue;
                        this.nextSub = currentPos2;
                        this.nextSubNode = this.node.subNRef(currentPos2);
                    }
                    break;
                }
            } else {
                this.nextSub = -1L;
                if (this.posSubLHC + 1 >= this.nMaxSub) {
                    this.isSubFinished = true;
                } else {
                    this.currentOffsetSub += Node.SIK_WIDTH(this.DIM);
                    currentPos = Bits.readArray(this.node.ba, this.currentOffsetSub, Node.SIK_WIDTH(this.DIM));
                    ++this.posSubLHC;
                    this.nextSub = currentPos;
                    this.nextSubNode = this.node.subNRef(this.posSubLHC);
                }
            }
        }
        if (this.isPostFinished && this.isSubFinished) {
            return -1L;
        }
        if (!this.isPostFinished && !this.isSubFinished) {
            if (this.nextSub < this.nextPost) {
                return this.nextSub;
            }
            return this.nextPost;
        }
        if (this.isPostFinished) {
            return this.nextSub;
        }
        return this.nextPost;
    }

    private void niFindNext() {
        if (this.niIterator.hasNext()) {
            long pos;
            CritBit64.Entry<PhTree8.NodeEntry<T>> e = this.niIterator.nextEntry();
            this.next = pos = e.key();
            this.nextSubNode = e.value().node;
            if (this.nextSubNode == null) {
                this.readValue(e.key(), e.value());
            } else {
                this.nextPostVal = null;
                this.nextPostKey = null;
            }
        } else {
            this.next = -1L;
        }
    }

    public int getPosSubLHC() {
        return this.posSubLHC;
    }

    public long[] getCurrentPostKey() {
        return this.nextPostKey;
    }

    public T getCurrentPostVal() {
        return this.nextPostVal;
    }

    public Node<T> getCurrentSubNode() {
        return this.nextSubNode;
    }

    public Node<T> node() {
        return this.node;
    }
}

