/*
 * Decompiled with CFR 0.152.
 */
package clib.phtree.v8;

import clib.phtree.PhFilter;
import clib.phtree.PhTreeHelper;
import clib.phtree.util.PhMapper;
import clib.phtree.v8.Bits;
import clib.phtree.v8.Node;
import clib.phtree.v8.PhTree8;
import java.util.ArrayList;
import org.zoodb.index.critbit.CritBit64;

public class NodeIteratorListReuse<T, R> {
    private final int DIM;
    private final ArrayList<R> results;
    private final int maxResults;
    private PhFilter filter;
    private PhMapper<T, R> mapper;
    private final long[] valTemplate;
    private long[] rangeMin;
    private long[] rangeMax;
    private final PhIteratorStack pool;

    NodeIteratorListReuse(int DIM, long[] valTemplate, long[] rangeMin, long[] rangeMax, ArrayList<R> results, int maxResults, PhFilter filter, PhMapper<T, R> mapper) {
        this.DIM = DIM;
        this.valTemplate = valTemplate;
        this.rangeMin = rangeMin;
        this.rangeMax = rangeMax;
        this.results = results;
        this.maxResults = maxResults;
        this.filter = filter;
        this.mapper = mapper;
        this.pool = new PhIteratorStack();
    }

    static <T, R> ArrayList<R> query(Node<T> node, long[] rangeMin, long[] rangeMax, int DIM, int maxResults, PhFilter filter, PhMapper<T, R> mapper) {
        long[] valTemplate = new long[DIM];
        ArrayList results = new ArrayList();
        if (!PhTree8.checkAndApplyInfix(node, valTemplate, rangeMin, rangeMax)) {
            return results;
        }
        NodeIteratorListReuse i = new NodeIteratorListReuse(DIM, valTemplate, rangeMin, rangeMax, results, maxResults, filter, mapper);
        i.run(node);
        return results;
    }

    ArrayList<?> resetAndRun(Node<T> node, long[] rangeMin, long[] rangeMax, PhFilter filter, PhMapper<T, R> mapper) {
        this.results.clear();
        this.rangeMin = rangeMin;
        this.rangeMax = rangeMax;
        this.filter = filter;
        this.mapper = mapper;
        this.run(node);
        return this.results;
    }

    void run(Node<T> node) {
        NodeIterator nIt;
        int i;
        long maskHcBit = 1L << node.getPostLen();
        long maskVT = -1L << node.getPostLen();
        long lowerLimit = 0L;
        long upperLimit = 0L;
        if (maskHcBit >= 0L) {
            for (i = 0; i < this.valTemplate.length; ++i) {
                lowerLimit <<= 1;
                upperLimit <<= 1;
                long nodeBisection = (this.valTemplate[i] | maskHcBit) & maskVT;
                if (this.rangeMin[i] >= nodeBisection) {
                    lowerLimit |= 1L;
                }
                if (this.rangeMax[i] < nodeBisection) continue;
                upperLimit |= 1L;
            }
        } else {
            for (i = 0; i < this.valTemplate.length; ++i) {
                lowerLimit <<= 1;
                upperLimit <<= 1;
                if (this.rangeMin[i] < 0L) {
                    upperLimit |= 1L;
                }
                if (this.rangeMax[i] >= 0L) continue;
                lowerLimit |= 1L;
            }
        }
        if ((nIt = this.pool.prepare(node)) != null) {
            nIt.reinitAndRun(node, lowerLimit, upperLimit);
        }
        this.pool.pop();
    }

    private final class NodeIterator {
        private boolean isPostHC;
        private boolean isPostNI;
        private boolean isSubHC;
        private int postLen;
        private long next = -1L;
        private long nextPost = -1L;
        private long nextSub = -1L;
        private Node<T> node;
        private int currentOffsetPostKey;
        private int currentOffsetPostVal;
        private int currentOffsetSub;
        private CritBit64.QueryIteratorMask<PhTree8.NodeEntry<T>> niIterator;
        private int nMaxPost;
        private int nMaxSub;
        private int nPostsFound = 0;
        private int posSubLHC = -1;
        private int postEntryLen;
        private long maskLower;
        private long maskUpper;
        private boolean usePostHcIncrementer;
        private boolean useSubHcIncrementer;
        private boolean isPostFinished;
        private boolean isSubFinished;

        private NodeIterator() {
        }

        void reinitAndRun(Node<T> node, long lower, long upper) {
            this.node = node;
            this.isPostHC = node.isPostHC();
            this.isPostNI = node.isPostNI();
            this.isSubHC = node.isSubHC();
            this.postLen = node.getPostLen();
            this.next = -1L;
            this.nextPost = -1L;
            this.nextSub = -1L;
            this.currentOffsetPostKey = 0;
            this.currentOffsetPostVal = 0;
            this.currentOffsetSub = 0;
            this.niIterator = null;
            this.nMaxPost = node.getPostCount();
            this.nMaxSub = node.getSubCount();
            this.nPostsFound = 0;
            this.posSubLHC = -1;
            this.isPostFinished = this.nMaxPost <= 0;
            this.isSubFinished = this.nMaxSub <= 0;
            this.maskLower = lower;
            this.maskUpper = upper;
            this.currentOffsetSub = node.getBitPos_SubNodeIndex(NodeIteratorListReuse.this.DIM);
            if (this.isPostNI) {
                this.postEntryLen = -1;
            } else {
                this.currentOffsetPostKey = node.getBitPos_PostIndex(NodeIteratorListReuse.this.DIM);
                if (this.isPostHC) {
                    this.postEntryLen = NodeIteratorListReuse.this.DIM * this.postLen;
                    this.currentOffsetPostVal = this.currentOffsetPostKey + (1 << NodeIteratorListReuse.this.DIM) * 1;
                } else {
                    this.postEntryLen = Node.PIK_WIDTH(NodeIteratorListReuse.this.DIM) + NodeIteratorListReuse.this.DIM * this.postLen;
                    this.currentOffsetPostVal = this.currentOffsetPostKey + Node.PIK_WIDTH(NodeIteratorListReuse.this.DIM);
                }
            }
            this.useSubHcIncrementer = false;
            this.usePostHcIncrementer = false;
            if (NodeIteratorListReuse.this.DIM > 3) {
                long maxHcAddr = -1L << NodeIteratorListReuse.this.DIM ^ 0xFFFFFFFFFFFFFFFFL;
                int nSetFilterBits = Long.bitCount(this.maskLower | (this.maskUpper ^ 0xFFFFFFFFFFFFFFFFL) & maxHcAddr);
                long nPossibleMatch = 1L << NodeIteratorListReuse.this.DIM - nSetFilterBits;
                if (this.isPostNI) {
                    int logNChild;
                    boolean useHcIncrementer;
                    int nChild = node.ind().size();
                    boolean bl = useHcIncrementer = (double)nChild > (double)nPossibleMatch * (double)(logNChild = 64 - Long.numberOfLeadingZeros(nChild)) * 2.0;
                    this.niIterator = useHcIncrementer && NodeIteratorListReuse.this.DIM < 50 ? null : node.ind().queryWithMask(this.maskLower, this.maskUpper);
                } else {
                    int logNSub;
                    if (this.isPostHC) {
                        this.usePostHcIncrementer = nPossibleMatch < maxHcAddr;
                    } else {
                        int logNPost = 64 - Long.numberOfLeadingZeros(this.nMaxPost) + 1;
                        boolean bl = this.usePostHcIncrementer = (double)this.nMaxPost > (double)nPossibleMatch * (double)logNPost;
                    }
                    this.useSubHcIncrementer = this.isSubHC ? nPossibleMatch < maxHcAddr : (double)this.nMaxSub > (double)nPossibleMatch * (double)(logNSub = 64 - Long.numberOfLeadingZeros(this.nMaxSub) + 1);
                }
            }
            this.next = this.getNext();
            while (this.next != -1L && NodeIteratorListReuse.this.results.size() < NodeIteratorListReuse.this.maxResults) {
                this.next = this.getNext();
            }
        }

        private boolean checkAndAddResult(PhTree8.NodeEntry<T> e) {
            if (NodeIteratorListReuse.this.filter != null && !NodeIteratorListReuse.this.filter.isValid(e.getKey())) {
                return false;
            }
            if (NodeIteratorListReuse.this.mapper == null) {
                NodeIteratorListReuse.this.results.add(e);
            } else {
                NodeIteratorListReuse.this.results.add(NodeIteratorListReuse.this.mapper.map(e));
            }
            return true;
        }

        private boolean readValue(long pos, int offsPostKey) {
            long[] key = new long[NodeIteratorListReuse.this.DIM];
            System.arraycopy(NodeIteratorListReuse.this.valTemplate, 0, key, 0, NodeIteratorListReuse.this.DIM);
            PhTreeHelper.applyHcPos(pos, this.postLen, key);
            PhTree8.NodeEntry e = this.node.getPostPOB(offsPostKey, pos, key, NodeIteratorListReuse.this.rangeMin, NodeIteratorListReuse.this.rangeMax);
            if (e == null) {
                return false;
            }
            return this.checkAndAddResult(e);
        }

        private boolean readValue(long pos, PhTree8.NodeEntry<T> e) {
            long mask = this.postLen < 63 ? -1L << this.postLen + 1 : 0L;
            long[] eKey = e.getKey();
            PhTreeHelper.applyHcPos(pos, this.postLen, eKey);
            for (int i = 0; i < eKey.length; ++i) {
                int n = i;
                eKey[n] = eKey[n] | NodeIteratorListReuse.this.valTemplate[i] & mask;
                if (eKey[i] >= NodeIteratorListReuse.this.rangeMin[i] && eKey[i] <= NodeIteratorListReuse.this.rangeMax[i]) continue;
                return false;
            }
            return this.checkAndAddResult(e);
        }

        private long getNextPostHCI(long currentPos) {
            int pob;
            do {
                if (currentPos == -1L) {
                    currentPos = this.maskLower;
                    continue;
                }
                if ((currentPos = PhTree8.inc(currentPos, this.maskLower, this.maskUpper)) > this.maskLower) continue;
                this.isPostFinished = true;
                return -1L;
            } while (this.isPostNI || (pob = this.node.getPostOffsetBits(currentPos, NodeIteratorListReuse.this.DIM)) < 0 || !this.readValue(currentPos, pob));
            return currentPos;
        }

        private long getNextSubHCI(long currentPos) {
            int subNodePos;
            while (true) {
                if (currentPos == -1L) {
                    currentPos = this.maskLower;
                } else if ((currentPos = PhTree8.inc(currentPos, this.maskLower, this.maskUpper)) <= this.maskLower) {
                    this.isSubFinished = true;
                    return -1L;
                }
                if (this.isSubHC) {
                    if (this.node.subNRef((int)currentPos) == null) continue;
                    this.traverseNode(this.node.subNRef((int)currentPos), currentPos);
                    return currentPos;
                }
                int subOffsBits = this.currentOffsetSub;
                subNodePos = Bits.binarySearch(this.node.ba, subOffsBits, this.nMaxSub, (int)currentPos, Node.SIK_WIDTH(NodeIteratorListReuse.this.DIM), 0);
                if (subNodePos >= 0) break;
            }
            this.traverseNode(this.node.subNRef(subNodePos), currentPos);
            return currentPos;
        }

        private long getNext() {
            if (this.node.isPostNI()) {
                this.niFindNext();
                return this.next;
            }
            if (!this.isPostFinished && this.nextPost == this.next) {
                if (this.usePostHcIncrementer) {
                    this.nextPost = this.getNextPostHCI(this.nextPost);
                } else if (this.isPostHC) {
                    this.getNextPostAHC();
                } else {
                    this.getNextPostLHC();
                }
            }
            if (!this.isSubFinished && this.nextSub == this.next) {
                if (this.useSubHcIncrementer) {
                    this.nextSub = this.getNextSubHCI(this.nextSub);
                } else if (this.isSubHC) {
                    this.getNextSubAHC();
                } else {
                    this.getNextSubLHC();
                }
            }
            if (this.isPostFinished && this.isSubFinished) {
                return -1L;
            }
            if (!this.isPostFinished && !this.isSubFinished) {
                if (this.nextSub < this.nextPost) {
                    return this.nextSub;
                }
                return this.nextPost;
            }
            if (this.isPostFinished) {
                return this.nextSub;
            }
            return this.nextPost;
        }

        private void getNextPostAHC() {
            long currentPos = this.next;
            this.nextPost = -1L;
            while (!this.isPostFinished) {
                if (currentPos >= 0L) {
                    ++currentPos;
                } else {
                    currentPos = this.maskLower;
                    this.currentOffsetPostKey = (int)((long)this.currentOffsetPostKey + this.maskLower * 1L);
                }
                if (currentPos >= (long)(1 << NodeIteratorListReuse.this.DIM)) {
                    this.isPostFinished = true;
                    break;
                }
                boolean bit = Bits.getBit(this.node.ba, this.currentOffsetPostKey);
                ++this.currentOffsetPostKey;
                if (!bit) continue;
                if (!this.checkHcPos(currentPos)) {
                    if (currentPos <= this.maskUpper) continue;
                    this.isPostFinished = true;
                    break;
                }
                int offs = (int)((long)this.currentOffsetPostVal + currentPos * (long)this.postEntryLen);
                if (!this.readValue(currentPos, offs)) continue;
                this.nextPost = currentPos;
                break;
            }
        }

        private void getNextPostLHC() {
            this.nextPost = -1L;
            while (!this.isPostFinished) {
                if (++this.nPostsFound > this.nMaxPost) {
                    this.isPostFinished = true;
                    break;
                }
                int offs = this.currentOffsetPostKey;
                long currentPos = Bits.readArray(this.node.ba, offs, Node.PIK_WIDTH(NodeIteratorListReuse.this.DIM));
                this.currentOffsetPostKey += this.postEntryLen;
                if (!this.checkHcPos(currentPos)) {
                    if (currentPos <= this.maskUpper) continue;
                    this.isPostFinished = true;
                    break;
                }
                if (!this.readValue(currentPos, offs + Node.PIK_WIDTH(NodeIteratorListReuse.this.DIM))) continue;
                this.nextPost = currentPos;
                break;
            }
        }

        private void getNextSubAHC() {
            int currentPos = (int)this.next;
            int maxPos = 1 << NodeIteratorListReuse.this.DIM;
            this.nextSub = -1L;
            while (!this.isSubFinished) {
                currentPos = currentPos < 0 ? (int)this.maskLower : ++currentPos;
                if (currentPos >= maxPos) {
                    this.isSubFinished = true;
                    break;
                }
                if (this.node.subNRef(currentPos) == null) continue;
                if (!this.checkHcPos(currentPos)) {
                    if ((long)currentPos <= this.maskUpper) continue;
                    this.isSubFinished = true;
                    break;
                }
                this.nextSub = currentPos;
                this.traverseNode(this.node.subNRef(currentPos), currentPos);
                break;
            }
        }

        private void getNextSubLHC() {
            this.nextSub = -1L;
            while (!this.isSubFinished) {
                if (this.posSubLHC + 1 >= this.nMaxSub) {
                    this.isSubFinished = true;
                    break;
                }
                long currentPos = Bits.readArray(this.node.ba, this.currentOffsetSub, Node.SIK_WIDTH(NodeIteratorListReuse.this.DIM));
                this.currentOffsetSub += Node.SIK_WIDTH(NodeIteratorListReuse.this.DIM);
                ++this.posSubLHC;
                if (!this.checkHcPos(currentPos)) {
                    if (currentPos <= this.maskUpper) continue;
                    this.isSubFinished = true;
                    break;
                }
                this.nextSub = currentPos;
                this.traverseNode(this.node.subNRef(this.posSubLHC), currentPos);
                break;
            }
        }

        private void niFindNext() {
            if (this.niIterator != null) {
                while (this.niIterator.hasNext()) {
                    CritBit64.Entry e = this.niIterator.nextEntry();
                    this.next = e.key();
                    Node nextSubNode = e.value().node;
                    if (nextSubNode == null) {
                        if (!this.readValue(e.key(), e.value())) {
                            continue;
                        }
                    } else {
                        this.traverseNode(nextSubNode, e.key());
                    }
                    return;
                }
                this.next = -1L;
                return;
            }
            long currentPos = this.next;
            while (currentPos == -1L || currentPos < this.maskUpper) {
                if (currentPos == -1L) {
                    currentPos = this.maskLower;
                } else if ((currentPos = PhTree8.inc(currentPos, this.maskLower, this.maskUpper)) <= this.maskLower) break;
                PhTree8.NodeEntry e = this.node.niGet(currentPos);
                if (e == null) continue;
                this.next = currentPos;
                if (e.node != null) {
                    this.traverseNode(e.node, currentPos);
                    return;
                }
                if (!this.readValue(currentPos, e)) continue;
                return;
            }
            this.next = -1L;
        }

        private boolean checkHcPos(long pos) {
            return ((pos | this.maskLower) & this.maskUpper) == pos;
        }

        private void traverseNode(Node<T> sub, long pos) {
            PhTreeHelper.applyHcPos(pos, this.node.getPostLen(), NodeIteratorListReuse.this.valTemplate);
            if (!PhTree8.checkAndApplyInfix(sub, NodeIteratorListReuse.this.valTemplate, NodeIteratorListReuse.this.rangeMin, NodeIteratorListReuse.this.rangeMax)) {
                return;
            }
            NodeIteratorListReuse.this.run(sub);
        }
    }

    public class PhIteratorStack {
        private final NodeIterator[] stack = new NodeIterator[64];
        private int size = 0;

        public NodeIterator prepare(Node<T> node) {
            NodeIterator ni;
            if (!PhTree8.checkAndApplyInfix(node, NodeIteratorListReuse.this.valTemplate, NodeIteratorListReuse.this.rangeMin, NodeIteratorListReuse.this.rangeMax)) {
                return null;
            }
            if ((ni = this.stack[this.size++]) == null) {
                this.stack[this.size - 1] = ni = new NodeIterator();
            }
            return ni;
        }

        public NodeIterator pop() {
            return this.stack[--this.size];
        }
    }
}

