/*
 * Decompiled with CFR 0.152.
 */
package clib.phtree.v8;

import clib.phtree.PhDistance;
import clib.phtree.PhEntry;
import clib.phtree.PhEntryDist;
import clib.phtree.PhFilterDistance;
import clib.phtree.PhTree;
import clib.phtree.PhTreeHelper;
import clib.phtree.v8.Node;
import clib.phtree.v8.NodeIteratorFullNoGC;
import clib.phtree.v8.PhIteratorNoGC;
import clib.phtree.v8.PhTree8;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.zoodb.index.critbit.CritBit64;

public class PhQueryKnnMbbPP<T>
implements PhTree.PhKnnQuery<T> {
    private final int DIM;
    private int nMin;
    private PhTree8<T> pht;
    private PhDistance distance;
    private final ArrayList<PhEntryDist<T>> entries = new ArrayList();
    private int resultSize = 0;
    private int currentPos = -1;
    private final long[] mbbMin;
    private final long[] mbbMax;
    private final PhIteratorNoGC<T> itEx;
    private final PhFilterDistance checker;

    public PhQueryKnnMbbPP(PhTree8<T> pht) {
        this.DIM = pht.getDim();
        this.mbbMin = new long[this.DIM];
        this.mbbMax = new long[this.DIM];
        this.pht = pht;
        this.checker = new PhFilterDistance();
        this.itEx = new PhIteratorNoGC<T>(pht, this.checker);
    }

    @Override
    public long[] nextKey() {
        return ((PhEntry)this.nextEntryReuse()).getKey();
    }

    @Override
    public T nextValue() {
        return ((PhEntry)this.nextEntryReuse()).getValue();
    }

    @Override
    public PhEntryDist<T> nextEntry() {
        return new PhEntryDist(this.nextEntryReuse());
    }

    @Override
    public PhEntryDist<T> nextEntryReuse() {
        if (this.currentPos >= this.resultSize) {
            throw new NoSuchElementException();
        }
        return this.entries.get(this.currentPos++);
    }

    @Override
    public boolean hasNext() {
        return this.currentPos < this.resultSize;
    }

    @Override
    public T next() {
        return this.nextValue();
    }

    @Override
    public PhTree.PhKnnQuery<T> reset(int nMin, PhDistance dist, long ... center) {
        this.distance = dist == null ? this.distance : dist;
        this.nMin = nMin;
        this.clearEntries();
        if (nMin > 0) {
            this.nearestNeighbourBinarySearch(center, nMin);
        }
        this.currentPos = 0;
        return this;
    }

    private void findKnnCandidate(long[] center, long[] ret) {
        this.findKnnCandidate(center, this.pht.getRoot(), ret);
    }

    private long[] findKnnCandidate(long[] key, Node<T> node, long[] ret) {
        if (node.getInfixLen() > 0) {
            long mask = -1L << node.getInfixLen() ^ 0xFFFFFFFFFFFFFFFFL;
            int shiftMask = node.getPostLen() + 1;
            mask = shiftMask == 64 ? 0L : mask << shiftMask;
            for (int i = 0; i < key.length; ++i) {
                if (((key[i] ^ node.getInfix(i)) & mask) == 0L) continue;
                return this.returnAnyValue(ret, key, node);
            }
        }
        long pos = PhTreeHelper.posInArray(key, node.getPostLen());
        if (node.isPostNI()) {
            PhTree8.NodeEntry e = node.getChildNI(pos);
            if (e == null) {
                return this.returnAnyValue(ret, key, node);
            }
            if (e.node != null) {
                return this.findKnnCandidate(key, e.node, ret);
            }
            if (this.nMin > 1 && this.distance.dist(key, e.getKey()) == 0.0) {
                Iterator it = node.ind().iterator();
                CritBit64.Entry cbe = ((CritBit64.CBIterator)it).nextEntry();
                while (((CritBit64.CBIterator)it).hasNext() && cbe.key() == pos) {
                    cbe = ((CritBit64.CBIterator)it).nextEntry();
                }
                e = (PhTree8.NodeEntry)cbe.value();
                if (e.node != null) {
                    return this.findKnnCandidate(key, e.node, ret);
                }
            }
            long[] k = e.getKey();
            System.arraycopy(k, 0, ret, 0, k.length);
            return ret;
        }
        Node<T> sub = node.getSubNode(pos, this.DIM);
        if (sub != null) {
            return this.findKnnCandidate(key, sub, ret);
        }
        int pob = node.getPostOffsetBits(pos, this.DIM);
        if (pob >= 0 && this.nMin == 1) {
            System.arraycopy(key, 0, ret, 0, key.length);
            node.getPost(pos, ret);
            return ret;
        }
        return this.returnAnyValue(ret, key, node);
    }

    private long[] returnAnyValue(long[] ret, long[] key, Node<T> node) {
        long mask = -1L << node.getPostLen() + 1;
        for (int i = 0; i < this.DIM; ++i) {
            ret[i] = key[i] & mask;
        }
        NodeIteratorFullNoGC ni = new NodeIteratorFullNoGC(this.DIM, ret);
        ni.init(node, null);
        while (ni.increment()) {
            if (ni.isNextSub()) {
                ni.init(ni.getCurrentSubNode(), null);
                continue;
            }
            PhEntry e = ni.getCurrentPost();
            if (this.nMin > 1 && this.distance.dist(key, e.getKey()) == 0.0) continue;
            System.arraycopy(e.getKey(), 0, ret, 0, key.length);
            return ret;
        }
        throw new IllegalStateException();
    }

    private void nearestNeighbourBinarySearch(long[] val, int nMin) {
        if (nMin == 1 && this.pht.contains(val)) {
            this.addEntry(new PhEntry<T>(val, this.pht.get(val)), val);
            return;
        }
        if (this.pht.size() <= nMin) {
            PhTree.PhExtent<T> itEx = this.pht.queryExtent();
            while (itEx.hasNext()) {
                Object e = itEx.nextEntryReuse();
                this.addEntry((PhEntry<T>)e, val);
            }
            this.sortEntries();
            return;
        }
        long[] cand = new long[this.DIM];
        this.findKnnCandidate(val, cand);
        double currentDist = this.distance.dist(val, cand);
        while (!this.findNeighbours(currentDist, nMin, val)) {
            currentDist *= 10.0;
        }
    }

    private final boolean findNeighbours(double maxDist, int nMin, long[] val) {
        double EPS = (double)this.DIM * maxDist / 2.251799813685248E15;
        int CONSOLIDATION_INTERVAL = 10;
        this.clearEntries();
        this.checker.set(val, this.distance, maxDist);
        this.distance.toMBB(maxDist, val, this.mbbMin, this.mbbMax);
        this.itEx.reset(this.mbbMin, this.mbbMax);
        while (this.itEx.hasNext() && this.resultSize < nMin) {
            Object en = this.itEx.nextEntryReuse();
            this.addEntry((PhEntry<T>)en, val);
        }
        this.sortEntries();
        if (this.resultSize < nMin) {
            return false;
        }
        if (!this.itEx.hasNext()) {
            return true;
        }
        maxDist = this.entries.get(nMin - 1).dist();
        this.checker.set(val, this.distance, maxDist);
        this.distance.toMBB(maxDist, val, this.mbbMin, this.mbbMax);
        int cnt = 0;
        while (this.itEx.hasNext()) {
            Object e = this.itEx.nextEntryReuse();
            this.addEntry((PhEntry<T>)e, val);
            if (++cnt % 10 != 0) continue;
            maxDist = this.consolidate(nMin, EPS, maxDist);
            this.checker.set(val, this.distance, maxDist);
            this.distance.toMBB(maxDist, val, this.mbbMin, this.mbbMax);
        }
        this.consolidate(nMin, EPS, maxDist);
        return true;
    }

    private double consolidate(int nMin, double EPS, double max) {
        this.sortEntries();
        double maxDnew = this.entries.get(nMin - 1).dist();
        if (maxDnew < max + EPS) {
            max = maxDnew;
            for (int i2 = nMin; i2 < this.resultSize; ++i2) {
                if (!(this.entries.get(i2).dist() + EPS > max)) continue;
                this.resultSize = i2;
                break;
            }
        }
        return max;
    }

    private void addEntry(PhEntry<T> e, long[] center) {
        double dist = this.distance.dist(center, e.getKey());
        if (this.resultSize < this.entries.size()) {
            this.entries.get(this.resultSize).set(e, dist);
        } else {
            PhEntryDist<T> de = new PhEntryDist<T>(e, dist);
            this.entries.add(de);
        }
        ++this.resultSize;
    }

    private void clearEntries() {
        this.resultSize = 0;
        for (int i = 0; i < this.entries.size(); ++i) {
            this.entries.get(i).setDist(Double.MAX_VALUE);
        }
    }

    private void sortEntries() {
        this.entries.sort(PhEntryDist.COMP);
    }
}

