/*
 * Decompiled with CFR 0.152.
 */
package ir.feathermc.arenasetup.utils;

import ir.feathermc.arenasetup.SetupState;
import ir.feathermc.arenasetup.builder.ItemBuilder;
import ir.feathermc.arenasetup.utils.VersionUtil;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.PlayerInventory;

public class ItemUtil {
    public final ItemBuilder waitingSpawn = new ItemBuilder(Material.BEACON).setItemName("&aWaiting Spawn");
    public final ItemBuilder spectatorSpawn = new ItemBuilder(Material.SEA_LANTERN).setItemName("&aSpectator Spawn");
    public final ItemBuilder createTeams = new ItemBuilder(Material.BOOKSHELF).setItemName("&aCreate Teams");
    public final ItemBuilder waitingLoc1 = new ItemBuilder(Material.STICK).setItemName("&aWaiting Location 1");
    public final ItemBuilder waitingLoc2 = new ItemBuilder(Material.STICK).setItemName("&aWaiting Location 2");
    public final ItemBuilder teamSpawn = new ItemBuilder(Material.BEACON).setItemName("&aTeam Spawn");
    public final ItemBuilder teamGenerator = new ItemBuilder(Material.GOLD_BLOCK).setItemName("&aTeam Generator");
    public final ItemBuilder killDrops;
    public final ItemBuilder shop = new ItemBuilder(Material.EMERALD).setItemName("&aShop");
    public final ItemBuilder upgrades;
    public final ItemBuilder diamond;
    public final ItemBuilder emerald;
    public final ItemBuilder goToSpawnSetup;
    public final ItemBuilder goToGeneratorSetup;
    public final ItemBuilder saveArena;
    public final ItemBuilder[] items;

    public ItemUtil() {
        if (!VersionUtil.isLegacy()) {
            this.killDrops = new ItemBuilder(Material.END_PORTAL_FRAME);
            this.upgrades = new ItemBuilder(Material.ENCHANTING_TABLE);
            this.goToSpawnSetup = new ItemBuilder(Material.GREEN_CONCRETE);
            this.goToGeneratorSetup = new ItemBuilder(Material.GREEN_CONCRETE);
            this.saveArena = new ItemBuilder(Material.GREEN_CONCRETE);
        } else {
            this.killDrops = new ItemBuilder(Material.valueOf((String)"ENDER_PORTAL_FRAME"));
            this.upgrades = new ItemBuilder(Material.valueOf((String)"ENCHANTMENT_TABLE"));
            this.goToSpawnSetup = new ItemBuilder(Material.valueOf((String)"STAINED_CLAY"), 1, 5);
            this.goToGeneratorSetup = new ItemBuilder(Material.valueOf((String)"STAINED_CLAY"), 1, 5);
            this.saveArena = new ItemBuilder(Material.valueOf((String)"STAINED_CLAY"), 1, 5);
        }
        this.killDrops.setItemName("&aKill Drops");
        this.upgrades.setItemName("&aUpgrades");
        this.goToSpawnSetup.setItemName("&aGo to Spawn Setup");
        this.goToGeneratorSetup.setItemName("&aGo to Generator Setup");
        this.saveArena.setItemName("&aSave Arena");
        this.diamond = new ItemBuilder(Material.DIAMOND_BLOCK).setItemName("&bDiamond Generator");
        this.emerald = new ItemBuilder(Material.EMERALD_BLOCK).setItemName("&aEmerald Generator");
        this.items = new ItemBuilder[]{this.waitingSpawn, this.spectatorSpawn, this.createTeams, this.waitingLoc1, this.waitingLoc2, this.teamSpawn, this.teamGenerator, this.shop, this.killDrops, this.upgrades, this.diamond, this.emerald, this.goToSpawnSetup, this.goToGeneratorSetup};
    }

    public void giveItems(Player player, SetupState setupState) {
        PlayerInventory inventory = player.getInventory();
        inventory.clear();
        switch (setupState) {
            case WAITING: {
                inventory.setItem(1, this.waitingSpawn.toItemStack());
                inventory.setItem(2, this.spectatorSpawn.toItemStack());
                inventory.setItem(4, this.createTeams.toItemStack());
                inventory.setItem(6, this.waitingLoc1.toItemStack());
                inventory.setItem(7, this.waitingLoc2.toItemStack());
                inventory.setItem(8, this.goToSpawnSetup.toItemStack());
                break;
            }
            case SPAWN: {
                inventory.setItem(0, this.teamSpawn.toItemStack());
                inventory.setItem(1, this.teamGenerator.toItemStack());
                inventory.setItem(2, this.killDrops.toItemStack());
                inventory.setItem(6, this.shop.toItemStack());
                inventory.setItem(7, this.upgrades.toItemStack());
                inventory.setItem(8, this.goToGeneratorSetup.toItemStack());
                break;
            }
            case GENERATORS: {
                inventory.setItem(1, this.diamond.toItemStack());
                inventory.setItem(2, this.emerald.toItemStack());
                inventory.setItem(7, this.saveArena.toItemStack());
            }
        }
    }
}

