/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.events;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.ListenerOptions;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.injector.GamePhase;
import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;

public class ListeningWhitelist {
    public static final ListeningWhitelist EMPTY_WHITELIST = new ListeningWhitelist(ListenerPriority.LOW);
    private final ListenerPriority priority;
    private final GamePhase gamePhase;
    private final Set<ListenerOptions> options;
    private final Set<PacketType> types;

    private ListeningWhitelist(Builder builder) {
        this.priority = builder.priority;
        this.types = builder.types;
        this.gamePhase = builder.gamePhase;
        this.options = builder.options;
    }

    private ListeningWhitelist(ListenerPriority priority) {
        this.priority = priority;
        this.types = new HashSet<PacketType>();
        this.gamePhase = GamePhase.PLAYING;
        this.options = EnumSet.noneOf(ListenerOptions.class);
    }

    public static boolean isEmpty(ListeningWhitelist whitelist) {
        if (whitelist == EMPTY_WHITELIST) {
            return true;
        }
        if (whitelist == null) {
            return true;
        }
        return whitelist.getTypes().isEmpty();
    }

    public static Builder newBuilder() {
        return new Builder(null);
    }

    public static Builder newBuilder(ListeningWhitelist template) {
        return new Builder(template);
    }

    private static <T extends Enum<T>> EnumSet<T> safeEnumSet(Collection<T> options, Class<T> enumClass) {
        if (options != null && !options.isEmpty()) {
            return EnumSet.copyOf(options);
        }
        return EnumSet.noneOf(enumClass);
    }

    private static <T> Set<T> safeSet(Collection<T> set) {
        if (set != null) {
            return new HashSet<T>(set);
        }
        return Collections.emptySet();
    }

    public boolean isEnabled() {
        return this.types != null && this.types.size() > 0;
    }

    public ListenerPriority getPriority() {
        return this.priority;
    }

    public Set<PacketType> getTypes() {
        return this.types;
    }

    public GamePhase getGamePhase() {
        return this.gamePhase;
    }

    public Set<ListenerOptions> getOptions() {
        return Collections.unmodifiableSet(this.options);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.priority, this.types, this.gamePhase, this.options});
    }

    public boolean equals(Object obj) {
        if (obj instanceof ListeningWhitelist) {
            ListeningWhitelist other = (ListeningWhitelist)obj;
            return Objects.equal((Object)((Object)this.priority), (Object)((Object)other.priority)) && Objects.equal(this.types, other.types) && Objects.equal((Object)((Object)this.gamePhase), (Object)((Object)other.gamePhase)) && Objects.equal(this.options, other.options);
        }
        return false;
    }

    public String toString() {
        if (this == EMPTY_WHITELIST) {
            return "EMPTY_WHITELIST";
        }
        return "ListeningWhitelist[priority=" + (Object)((Object)this.priority) + ", packets=" + this.types + ", gamephase=" + (Object)((Object)this.gamePhase) + ", options=" + this.options + "]";
    }

    public static class Builder {
        private ListenerPriority priority = ListenerPriority.NORMAL;
        private Set<PacketType> types = new HashSet<PacketType>();
        private GamePhase gamePhase = GamePhase.PLAYING;
        private Set<ListenerOptions> options = new HashSet<ListenerOptions>();

        private Builder(ListeningWhitelist template) {
            if (template != null) {
                this.priority(template.getPriority());
                this.gamePhase(template.getGamePhase());
                this.types(template.getTypes());
                this.options(template.getOptions());
            }
        }

        public Builder priority(ListenerPriority priority) {
            this.priority = priority;
            return this;
        }

        public Builder monitor() {
            return this.priority(ListenerPriority.MONITOR);
        }

        public Builder normal() {
            return this.priority(ListenerPriority.NORMAL);
        }

        public Builder lowest() {
            return this.priority(ListenerPriority.LOWEST);
        }

        public Builder low() {
            return this.priority(ListenerPriority.LOW);
        }

        public Builder highest() {
            return this.priority(ListenerPriority.HIGHEST);
        }

        public Builder high() {
            return this.priority(ListenerPriority.HIGH);
        }

        public Builder types(PacketType ... types) {
            this.types = ListeningWhitelist.safeSet(Sets.newHashSet((Object[])types));
            return this;
        }

        public Builder types(Collection<PacketType> types) {
            this.types = ListeningWhitelist.safeSet(types);
            return this;
        }

        public Builder gamePhase(GamePhase gamePhase) {
            this.gamePhase = gamePhase;
            return this;
        }

        public Builder gamePhaseBoth() {
            return this.gamePhase(GamePhase.BOTH);
        }

        public Builder options(Set<ListenerOptions> options) {
            this.options = ListeningWhitelist.safeSet(options);
            return this;
        }

        public Builder options(Collection<ListenerOptions> options) {
            this.options = ListeningWhitelist.safeSet(options);
            return this;
        }

        public Builder options(ListenerOptions[] serverOptions) {
            this.options = ListeningWhitelist.safeSet(Sets.newHashSet((Object[])serverOptions));
            return this;
        }

        public Builder mergeOptions(ListenerOptions ... serverOptions) {
            return this.mergeOptions(Arrays.asList(serverOptions));
        }

        public Builder mergeOptions(Collection<ListenerOptions> serverOptions) {
            if (this.options == null) {
                return this.options(serverOptions);
            }
            this.options.addAll(serverOptions);
            return this;
        }

        public ListeningWhitelist build() {
            return new ListeningWhitelist(this);
        }
    }
}

