/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.reflect.fuzzy;

import com.comphenix.protocol.reflect.fuzzy.AbstractFuzzyMatcher;

final class ClassTypeMatcher
implements AbstractFuzzyMatcher<Class<?>> {
    public static final ClassTypeMatcher MATCH_ALL = new ClassTypeMatcher(null, MatchVariant.MATCH_SUPER);
    private final Class<?> matcher;
    private final MatchVariant variant;

    ClassTypeMatcher(Class<?> matcher, MatchVariant variant) {
        this.matcher = matcher;
        this.variant = variant;
    }

    @Override
    public boolean isMatch(Class<?> input, Object parent) {
        if (input == null) {
            throw new IllegalArgumentException("Input class cannot be NULL.");
        }
        if (this.matcher == null) {
            return this.variant != MatchVariant.MATCH_EXACT;
        }
        switch (this.variant) {
            case MATCH_EXACT: {
                return this.matcher.equals(input);
            }
            case MATCH_DERIVED: {
                return this.matcher.isAssignableFrom(input);
            }
            case MATCH_SUPER: {
                return input.isAssignableFrom(this.matcher);
            }
        }
        return false;
    }

    public Class<?> getMatcher() {
        return this.matcher;
    }

    public MatchVariant getMatchVariant() {
        return this.variant;
    }

    public String toString() {
        switch (this.variant) {
            case MATCH_EXACT: {
                return "{ type exactly " + this.matcher + " }";
            }
            case MATCH_SUPER: {
                return "{ type " + this.matcher + " instanceof input }";
            }
            case MATCH_DERIVED: {
                return "{ type input instanceof " + this.matcher + " }";
            }
        }
        throw new IllegalArgumentException("Unknown match variant " + (Object)((Object)this.variant));
    }

    static enum MatchVariant {
        MATCH_EXACT,
        MATCH_SUPER,
        MATCH_DERIVED;

    }
}

