/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.utility;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.utility.MinecraftVersion;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class ChatExtensions {
    private static final UUID SERVER_UUID = new UUID(0L, 0L);
    private final ProtocolManager manager;

    public ChatExtensions(ProtocolManager manager) {
        this.manager = manager;
    }

    public static List<PacketContainer> createChatPackets(String message) {
        WrappedChatComponent[] components;
        ArrayList<PacketContainer> packets = new ArrayList<PacketContainer>();
        for (WrappedChatComponent component : components = WrappedChatComponent.fromChatMessage(message)) {
            PacketContainer packet;
            if (MinecraftVersion.WILD_UPDATE.atOrAbove()) {
                packet = new PacketContainer(PacketType.Play.Server.SYSTEM_CHAT);
                packet.getStrings().write(0, component.getJson());
                packet.getBooleans().write(0, false);
            } else {
                packet = new PacketContainer(PacketType.Play.Server.CHAT);
                packet.getChatComponents().write(0, component);
                packet.getChatTypes().writeSafely(0, EnumWrappers.ChatType.SYSTEM);
                packet.getBytes().writeSafely(0, (byte)1);
                packet.getUUIDs().writeSafely(0, SERVER_UUID);
            }
            packets.add(packet);
        }
        return packets;
    }

    public static String[] toFlowerBox(String[] message, String marginChar, int marginWidth, int marginHeight) {
        int i;
        String[] output = new String[message.length + marginHeight * 2];
        int width = ChatExtensions.getMaximumLength(message);
        String topButtomMargin = Strings.repeat((String)marginChar, (int)(width + marginWidth * 2));
        String leftRightMargin = Strings.repeat((String)marginChar, (int)marginWidth);
        for (i = 0; i < message.length; ++i) {
            output[i + marginHeight] = leftRightMargin + Strings.padEnd((String)message[i], (int)width, (char)' ') + leftRightMargin;
        }
        for (i = 0; i < marginHeight; ++i) {
            output[i] = topButtomMargin;
            output[output.length - i - 1] = topButtomMargin;
        }
        return output;
    }

    private static int getMaximumLength(String[] lines) {
        int current = 0;
        for (String line : lines) {
            if (current >= line.length()) continue;
            current = line.length();
        }
        return current;
    }

    public void sendMessageSilently(CommandSender receiver, String message) {
        if (receiver == null) {
            throw new IllegalArgumentException("receiver cannot be NULL.");
        }
        if (message == null) {
            throw new IllegalArgumentException("message cannot be NULL.");
        }
        if (receiver instanceof Player) {
            this.sendMessageSilently((Player)receiver, message);
        } else {
            receiver.sendMessage(message);
        }
    }

    private void sendMessageSilently(Player player, String message) {
        for (PacketContainer packet : ChatExtensions.createChatPackets(message)) {
            this.manager.sendServerPacket(player, packet, false);
        }
    }

    public void broadcastMessageSilently(String message, String permission) {
        if (message == null) {
            throw new IllegalArgumentException("message cannot be NULL.");
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (permission != null && !player.hasPermission(permission)) continue;
            this.sendMessageSilently(player, message);
        }
    }
}

