/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers;

import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.FieldAccessor;
import com.comphenix.protocol.reflect.fuzzy.FuzzyFieldContract;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.AbstractWrapper;
import com.comphenix.protocol.wrappers.ClonableWrapper;
import com.comphenix.protocol.wrappers.MinecraftKey;
import com.comphenix.protocol.wrappers.WrappedRegistry;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public final class WrappedRegistrable
extends AbstractWrapper
implements ClonableWrapper {
    @NotNull
    private final Factory factory;

    private WrappedRegistrable(@NotNull Factory factory, @NotNull Object handle) {
        super(factory.registrableClass);
        this.factory = factory;
        this.setHandle(handle);
    }

    @NotNull
    public static WrappedRegistrable fromHandle(@NotNull Factory factory, @NotNull Object handle) {
        return new WrappedRegistrable(factory, handle);
    }

    @NotNull
    public static WrappedRegistrable fromHandle(@NotNull Class<?> registrableClass, @NotNull Object handle) {
        return WrappedRegistrable.fromHandle(Factory.getOrCreate(registrableClass), handle);
    }

    @NotNull
    public static WrappedRegistrable fromClassAndKey(@NotNull Class<?> registrableClass, @NotNull MinecraftKey key) {
        Factory factory = Factory.getOrCreate(registrableClass);
        return WrappedRegistrable.fromHandle(factory, factory.getHandle(key));
    }

    @NotNull
    public static WrappedRegistrable fromClassAndKey(@NotNull Class<?> registrableClass, @NotNull String key) {
        return WrappedRegistrable.fromClassAndKey(registrableClass, new MinecraftKey(key));
    }

    @NotNull
    public static WrappedRegistrable blockEntityType(@NotNull MinecraftKey key) {
        return WrappedRegistrable.fromClassAndKey(MinecraftReflection.getBlockEntityTypeClass(), key);
    }

    @NotNull
    public static WrappedRegistrable blockEntityType(@NotNull String key) {
        return WrappedRegistrable.blockEntityType(new MinecraftKey(key));
    }

    public MinecraftKey getKey() {
        return this.factory.getKey(this.handle);
    }

    public void setKey(MinecraftKey key) {
        this.setHandle(this.factory.getHandle(key));
    }

    @Override
    public WrappedRegistrable deepClone() {
        return WrappedRegistrable.fromHandle(this.factory, this.handle);
    }

    @Override
    public String toString() {
        return "WrappedRegistrable[handle=" + this.handle + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getKey().hashCode();
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WrappedRegistrable)) {
            return false;
        }
        WrappedRegistrable that = (WrappedRegistrable)o;
        return this.handle.equals(that.handle) || this.getKey() == that.getKey();
    }

    private static final class Factory {
        private static final Map<Class<?>, Factory> CACHE = new ConcurrentHashMap();
        @NotNull
        private final Class<?> registrableClass;
        @NotNull
        private final WrappedRegistry registry;
        @NotNull
        private final FieldAccessor fieldAccessor;

        private Factory(@NotNull Class<?> registrableClass) {
            this.registrableClass = registrableClass;
            this.registry = WrappedRegistry.getRegistry(registrableClass);
            this.fieldAccessor = Accessors.getFieldAccessor(FuzzyReflection.fromClass(registrableClass, true).getField(FuzzyFieldContract.newBuilder().typeExact(registrableClass).build()));
        }

        @NotNull
        public static Factory getOrCreate(@NotNull Class<?> registrableClass) {
            return CACHE.computeIfAbsent(registrableClass, Factory::new);
        }

        @NotNull
        public MinecraftKey getKey(@NotNull Object handle) {
            return this.registry.getKey(this.fieldAccessor.get(handle));
        }

        @NotNull
        public Object getHandle(MinecraftKey key) {
            return this.registry.get(key);
        }
    }
}

