/*
 * Decompiled with CFR 0.152.
 */
package me.scruffyboy13.Economy.commands;

import com.google.common.collect.ImmutableMap;
import me.scruffyboy13.Economy.EconomyMain;
import me.scruffyboy13.Economy.utils.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PayCommand
implements CommandExecutor {
    public boolean onCommand(CommandSender sender, Command cmd, String lebel, String[] args) {
        if (sender.hasPermission("economy.command.pay")) {
            if (args.length == 2) {
                if (!(sender instanceof Player)) {
                    StringUtils.sendConfigMessage(sender, "messages.playersOnly");
                    return true;
                }
                Player player = (Player)sender;
                if (!EconomyMain.getEco().hasAccount(player.getUniqueId())) {
                    StringUtils.sendConfigMessage(player, "messages.pay.noAccount");
                    return true;
                }
                OfflinePlayer other = Bukkit.getOfflinePlayer((String)args[0]);
                if (other == null) {
                    StringUtils.sendConfigMessage(player, "messages.pay.otherDoesntExist", (ImmutableMap<String, String>)ImmutableMap.of((Object)"%player%", (Object)args[1]));
                    return true;
                }
                if (!EconomyMain.getEco().hasAccount(other.getUniqueId())) {
                    StringUtils.sendConfigMessage(player, "messages.pay.otherNoAccount", (ImmutableMap<String, String>)ImmutableMap.of((Object)"%player%", (Object)other.getName()));
                    return true;
                }
                if (other.getUniqueId().equals(player.getUniqueId())) {
                    StringUtils.sendConfigMessage(player, "messages.pay.cannotPaySelf");
                    return true;
                }
                double amount = 0.0;
                try {
                    amount = EconomyMain.getAmountFromString(args[1]);
                }
                catch (NumberFormatException e) {
                    StringUtils.sendConfigMessage(player, "messages.pay.invalidAmount", (ImmutableMap<String, String>)ImmutableMap.of((Object)"%amount%", (Object)args[1]));
                    return true;
                }
                if (amount <= 0.0) {
                    StringUtils.sendConfigMessage(sender, "messages.money.give.invalidAmount", (ImmutableMap<String, String>)ImmutableMap.of((Object)"%amount%", (Object)args[2]));
                    return true;
                }
                if (!EconomyMain.getEco().has(player.getUniqueId(), amount)) {
                    StringUtils.sendConfigMessage(player, "messages.pay.insufficientFunds");
                    return true;
                }
                EconomyMain.getEco().withdraw(player.getUniqueId(), amount);
                StringUtils.sendConfigMessage(player, "messages.pay.paid", (ImmutableMap<String, String>)ImmutableMap.of((Object)"%player%", (Object)other.getName(), (Object)"%amount%", (Object)EconomyMain.format(amount)));
                EconomyMain.getEco().deposit(other.getUniqueId(), amount);
                if (other instanceof Player) {
                    StringUtils.sendConfigMessage((Player)other, "messages.pay.received", (ImmutableMap<String, String>)ImmutableMap.of((Object)"%player%", (Object)player.getName(), (Object)"%amount%", (Object)EconomyMain.format(amount)));
                }
                return true;
            }
            StringUtils.sendConfigMessage(sender, "messages.pay.usage");
            return true;
        }
        StringUtils.sendConfigMessage(sender, "messages.nopermission");
        return true;
    }
}

