/*
 * Decompiled with CFR 0.152.
 */
package me.cubecrafter.playagain;

import com.andrei1058.bedwars.api.BedWars;
import com.andrei1058.bedwars.api.arena.IArena;
import com.andrei1058.bedwars.api.server.ServerType;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import me.cubecrafter.playagain.arena.ArenaData;
import me.cubecrafter.playagain.arena.BungeeArenaManager;
import me.cubecrafter.playagain.config.FileManager;
import me.cubecrafter.playagain.libs.bstats.bukkit.Metrics;
import me.cubecrafter.playagain.listeners.ArenaListener;
import me.cubecrafter.playagain.listeners.InventoryListener;
import me.cubecrafter.playagain.proxy.ProxyListener;
import me.cubecrafter.playagain.utils.TextUtil;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class PlayAgain
extends JavaPlugin {
    private static PlayAgain instance;
    private FileManager fileManager;
    private BedWars bedWars;
    private BungeeArenaManager bungeeManager;
    private ProxyListener proxyListener;
    private boolean bungee = false;
    private boolean lobby = false;

    public void onEnable() {
        instance = this;
        if (this.isBedWarsEnabled()) {
            this.fileManager = new FileManager(this, false);
            this.bedWars = (BedWars)Bukkit.getServicesManager().getRegistration(BedWars.class).getProvider();
            this.getServer().getPluginManager().registerEvents((Listener)new InventoryListener(), (Plugin)this);
            this.getServer().getPluginManager().registerEvents((Listener)new ArenaListener(this), (Plugin)this);
            if (this.bedWars.getServerType() == ServerType.BUNGEE) {
                this.bungee = true;
                this.bungeeManager = new BungeeArenaManager(this);
                this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
            }
        } else if (this.isBedWarsProxyEnabled()) {
            this.fileManager = new FileManager(this, true);
            this.lobby = true;
            this.proxyListener = new ProxyListener();
            this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
        } else {
            TextUtil.severe("Bedwars plugin not found! Disabling...");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        new Metrics(this, 14060);
    }

    public boolean isBedWarsEnabled() {
        return this.getServer().getPluginManager().isPluginEnabled("BedWars1058");
    }

    public boolean isBedWarsProxyEnabled() {
        return this.getServer().getPluginManager().isPluginEnabled("BedWarsProxy");
    }

    public void onDisable() {
        if (this.bungeeManager != null) {
            this.bungeeManager.close();
        }
        if (this.proxyListener != null) {
            this.proxyListener.close();
        }
        this.getServer().getScheduler().cancelTasks((Plugin)this);
        this.getServer().getMessenger().unregisterOutgoingPluginChannel((Plugin)this, "BungeeCord");
    }

    public List<String> getArenaGroups() {
        ArrayList<String> groups = new ArrayList<String>();
        groups.add("All");
        if (this.bungee) {
            groups.addAll(this.bungeeManager.getArenas().stream().map(ArenaData::getGroup).distinct().collect(Collectors.toList()));
        } else {
            groups.addAll(this.bedWars.getArenaUtil().getArenas().stream().map(IArena::getGroup).distinct().collect(Collectors.toList()));
        }
        return groups;
    }

    public FileManager getFileManager() {
        return this.fileManager;
    }

    public BedWars getBedWars() {
        return this.bedWars;
    }

    public BungeeArenaManager getBungeeManager() {
        return this.bungeeManager;
    }

    public ProxyListener getProxyListener() {
        return this.proxyListener;
    }

    public boolean isBungee() {
        return this.bungee;
    }

    public boolean isLobby() {
        return this.lobby;
    }

    public static PlayAgain getInstance() {
        return instance;
    }
}

