/*
 * Decompiled with CFR 0.152.
 */
package me.cubecrafter.playagain.arena;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import me.cubecrafter.playagain.PlayAgain;
import me.cubecrafter.playagain.arena.ArenaData;
import me.cubecrafter.playagain.arena.BungeeArenaManager;
import me.cubecrafter.playagain.config.Configuration;
import me.cubecrafter.playagain.utils.TextUtil;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class SocketTask
implements Runnable {
    private final String host = ((String)PlayAgain.getInstance().getBedWars().getConfigs().getMainConfig().getList("bungee-settings.lobby-sockets").get(0)).split(":")[0];
    private final Gson gson = new Gson();
    private Socket socket;
    private Scanner in;
    private PrintWriter out;

    public SocketTask() {
        this.connect();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)PlayAgain.getInstance(), (Runnable)this);
    }

    @Override
    public void run() {
        while (this.socket.isConnected()) {
            if (this.in.hasNext()) {
                String message = this.in.next();
                List data = (List)this.gson.fromJson(message, new TypeToken<List<ArenaData>>(){}.getType());
                BungeeArenaManager manager = PlayAgain.getInstance().getBungeeManager();
                for (ArenaData cached : new ArrayList<ArenaData>(manager.getArenas())) {
                    if (!data.stream().noneMatch(arena -> arena.getServer().equals(cached.getServer()) && arena.getName().equals(cached.getName()))) continue;
                    manager.removeCache(cached);
                }
                for (ArenaData arenaData : data) {
                    if (manager.getCache(arenaData.getServer(), arenaData.getName()) == null) {
                        manager.createCache(arenaData);
                        continue;
                    }
                    ArenaData cached = manager.getCache(arenaData.getServer(), arenaData.getName());
                    cached.setState(arenaData.getState());
                    cached.setPlayers(arenaData.getPlayers());
                }
                continue;
            }
            TextUtil.severe("Lost connection with the lobby server! Reconnecting...");
            this.connect();
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)PlayAgain.getInstance(), (Runnable)this);
            break;
        }
    }

    private void connect() {
        try {
            this.socket = new Socket(this.host, Configuration.BUNGEE_LOBBY_PORT.getAsInt());
            this.in = new Scanner(this.socket.getInputStream());
            this.out = new PrintWriter(this.socket.getOutputStream(), true);
        }
        catch (IOException e) {
            Bukkit.getScheduler().runTaskLater((Plugin)PlayAgain.getInstance(), this::connect, 100L);
            return;
        }
        TextUtil.info("Connection with the lobby server established!");
    }

    public void sendMessage(String message) {
        this.out.println(message);
    }

    public void close() {
        try {
            this.socket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

