/*
 * Decompiled with CFR 0.152.
 */
package me.cubecrafter.playagain.menus;

import java.util.List;
import java.util.Map;
import me.cubecrafter.playagain.PlayAgain;
import me.cubecrafter.playagain.menus.MenuItem;
import me.cubecrafter.playagain.utils.TextUtil;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public abstract class Menu
implements InventoryHolder {
    protected final Player player;
    private Inventory inventory;
    private BukkitTask updateTask;

    public abstract String getTitle();

    public abstract int getRows();

    public abstract Map<Integer, MenuItem> getItems();

    public abstract boolean update();

    public void openMenu() {
        this.updateMenu();
        this.player.openInventory(this.getInventory());
        if (this.update()) {
            this.updateTask = Bukkit.getScheduler().runTaskTimer((Plugin)PlayAgain.getInstance(), () -> {
                if (!this.player.isOnline() || this.player.getOpenInventory() == null) {
                    this.updateTask.cancel();
                }
                this.updateMenu();
            }, 0L, 20L);
        }
    }

    public void closeMenu() {
        this.player.closeInventory();
    }

    public void updateMenu() {
        this.getInventory().clear();
        for (Map.Entry<Integer, MenuItem> entry : this.getItems().entrySet()) {
            this.getInventory().setItem(entry.getKey().intValue(), entry.getValue().getItem());
        }
    }

    public void setFiller(ItemStack filler, List<Integer> slots) {
        slots.forEach(slot -> this.getInventory().setItem(slot.intValue(), filler));
    }

    public Inventory getInventory() {
        if (this.inventory == null) {
            this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)(this.getRows() * 9), (String)TextUtil.color(this.getTitle()));
        }
        return this.inventory;
    }

    public Menu(Player player) {
        this.player = player;
    }
}

