/*
 * Decompiled with CFR 0.152.
 */
package me.cubecrafter.playagain.menus;

import com.andrei1058.bedwars.api.arena.GameState;
import com.andrei1058.bedwars.api.arena.IArena;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.cubecrafter.playagain.PlayAgain;
import me.cubecrafter.playagain.arena.ArenaData;
import me.cubecrafter.playagain.arena.BungeeArenaManager;
import me.cubecrafter.playagain.config.Configuration;
import me.cubecrafter.playagain.libs.xseries.XSound;
import me.cubecrafter.playagain.menus.Menu;
import me.cubecrafter.playagain.menus.MenuItem;
import me.cubecrafter.playagain.utils.ItemBuilder;
import me.cubecrafter.playagain.utils.TextUtil;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class PlayAgainMenu
extends Menu {
    private final IArena playerArena;
    private Iterator<String> groupIterator;
    private String group;
    private int page = 1;
    private static final List<String> groups = PlayAgain.getInstance().getArenaGroups();
    private static final int arenasPerPage = Configuration.ARENA_ITEM_SLOTS.getAsIntegerList().size();
    private static final BungeeArenaManager manager = PlayAgain.getInstance().getBungeeManager();
    private static final PlayAgain plugin = PlayAgain.getInstance();

    public PlayAgainMenu(Player player, IArena arena) {
        super(player);
        this.playerArena = arena;
        this.group = arena.getGroup();
        this.groupIterator = this.getIterator(groups.indexOf(this.group));
    }

    @Override
    public String getTitle() {
        return Configuration.MENU_TITLE.getAsString();
    }

    @Override
    public int getRows() {
        return Configuration.MENU_ROWS.getAsInt();
    }

    @Override
    public Map<Integer, MenuItem> getItems() {
        if (Configuration.MENU_FILLER_ENABLED.getAsBoolean()) {
            this.setFiller(ItemBuilder.fromConfig(Configuration.MENU_FILLER.getAsConfigSection()).build(), Configuration.MENU_FILLER_SLOTS.getAsIntegerList());
        }
        HashMap<Integer, MenuItem> items = new HashMap<Integer, MenuItem>();
        items.put(Configuration.RANDOM_ARENA_ITEM_SLOT.getAsInt(), new MenuItem(ItemBuilder.fromConfig(Configuration.RANDOM_ARENA_ITEM.getAsConfigSection()).addPlaceholder("{current}", this.group).build()).addAction(e -> {
            if (plugin.isBungee()) {
                manager.joinRandomArena(this.player, this.group);
            } else {
                this.playerArena.removePlayer(this.player, true);
                if (this.group.equals("All")) {
                    plugin.getBedWars().getArenaUtil().joinRandomArena(this.player);
                } else {
                    plugin.getBedWars().getArenaUtil().joinRandomFromGroup(this.player, this.group);
                }
            }
            this.closeMenu();
        }, new ClickType[0]));
        items.put(Configuration.FILTER_ITEM_SLOT.getAsInt(), new MenuItem(ItemBuilder.fromConfig(Configuration.FILTER_ITEM.getAsConfigSection()).addPlaceholder("{current}", this.group).build()).addAction(e -> {
            XSound.play(this.player, Configuration.SOUNDS_MENU_CLICK.getAsString());
            this.switchGroup();
        }, new ClickType[0]));
        Iterator<Integer> it = Configuration.ARENA_ITEM_SLOTS.getAsIntegerList().iterator();
        if (plugin.isBungee()) {
            for (ArenaData arena : this.getBungeeArenas()) {
                items.put(it.next(), new MenuItem(this.getArenaItem(arena)).addAction(e -> {
                    if (!this.player.hasPermission("bw.playagain.selector")) {
                        XSound.play(this.player, Configuration.SOUNDS_PERMISSION_DENIED.getAsString());
                        TextUtil.sendMessage(this.player, Configuration.MESSAGES_SELECTOR_PERMISSION_DENIED.getAsString());
                        this.closeMenu();
                        return;
                    }
                    manager.joinArena(this.player, arena);
                    this.closeMenu();
                }, new ClickType[0]));
            }
        } else {
            for (IArena arena : this.getLocalArenas()) {
                items.put(it.next(), new MenuItem(this.getArenaItem(arena)).addAction(e -> {
                    if (!this.player.hasPermission("bw.playagain.selector")) {
                        XSound.play(this.player, Configuration.SOUNDS_PERMISSION_DENIED.getAsString());
                        TextUtil.sendMessage(this.player, Configuration.MESSAGES_SELECTOR_PERMISSION_DENIED.getAsString());
                        this.closeMenu();
                        return;
                    }
                    this.playerArena.removePlayer(this.player, true);
                    arena.addPlayer(this.player, false);
                }, new ClickType[0]));
            }
        }
        if (this.page > 1) {
            items.put(Configuration.PREVIOUS_PAGE_ITEM_SLOT.getAsInt(), new MenuItem(ItemBuilder.fromConfig(Configuration.PREVIOUS_PAGE_ITEM.getAsConfigSection()).addPlaceholder("{page}", String.valueOf(this.page - 1)).build()).addAction(e -> {
                --this.page;
                XSound.play(this.player, Configuration.SOUNDS_MENU_CLICK.getAsString());
            }, new ClickType[0]));
        }
        if (this.page < this.getMaxPages()) {
            items.put(Configuration.NEXT_PAGE_ITEM_SLOT.getAsInt(), new MenuItem(ItemBuilder.fromConfig(Configuration.NEXT_PAGE_ITEM.getAsConfigSection()).addPlaceholder("{page}", String.valueOf(this.page + 1)).build()).addAction(e -> {
                ++this.page;
                XSound.play(this.player, Configuration.SOUNDS_MENU_CLICK.getAsString());
            }, new ClickType[0]));
        }
        items.put(Configuration.BACK_ITEM_SLOT.getAsInt(), new MenuItem(ItemBuilder.fromConfig(Configuration.BACK_ITEM.getAsConfigSection()).build()).addAction(e -> this.closeMenu(), new ClickType[0]));
        return items;
    }

    @Override
    public boolean update() {
        return true;
    }

    private List<ArenaData> getBungeeArenas() {
        List<ArenaData> arenas = manager.getAvailableArenas(this.group);
        arenas.sort((o1, o2) -> {
            if (o1.getState().equals("STARTING") && o2.getState().equals("WAITING")) {
                return -1;
            }
            if (o1.getState().equals("WAITING") && o2.getState().equals("STARTING")) {
                return 1;
            }
            return o2.getPlayers() - o1.getPlayers();
        });
        return arenas.subList((this.page - 1) * arenasPerPage, Math.min(this.page * arenasPerPage, arenas.size()));
    }

    private List<IArena> getLocalArenas() {
        List<IArena> arenas = this.getAvailableArenas(this.group);
        arenas.sort((o1, o2) -> {
            if (o1.getStatus() == GameState.starting && o2.getStatus() == GameState.waiting) {
                return -1;
            }
            if (o1.getStatus() == GameState.waiting && o2.getStatus() == GameState.starting) {
                return 1;
            }
            return o2.getPlayers().size() - o1.getPlayers().size();
        });
        return arenas.subList((this.page - 1) * arenasPerPage, Math.min(this.page * arenasPerPage, arenas.size()));
    }

    private List<IArena> getAvailableArenas(String group) {
        if (group.equals("All")) {
            return PlayAgain.getInstance().getBedWars().getArenaUtil().getArenas().stream().filter(arena -> arena.getStatus() == GameState.waiting || arena.getStatus() == GameState.starting).collect(Collectors.toList());
        }
        return PlayAgain.getInstance().getBedWars().getArenaUtil().getArenas().stream().filter(arena -> arena.getGroup().equals(group)).filter(arena -> arena.getStatus() == GameState.waiting || arena.getStatus() == GameState.starting).collect(Collectors.toList());
    }

    private Iterator<String> getIterator(int index) {
        Iterator<String> it = groups.iterator();
        for (int i = 0; i < index; ++i) {
            it.next();
        }
        return it;
    }

    private void switchGroup() {
        if (!this.groupIterator.hasNext()) {
            this.groupIterator = groups.iterator();
        }
        this.group = this.groupIterator.next();
        this.page = 1;
    }

    private int getMaxPages() {
        int pages = plugin.isBungee() ? (int)Math.ceil((double)manager.getAvailableArenas(this.group).size() / (double)arenasPerPage) : (int)Math.ceil((double)this.getAvailableArenas(this.group).size() / (double)arenasPerPage);
        return Math.max(pages, 1);
    }

    private ItemStack getArenaItem(ArenaData data) {
        ItemStack original = ItemBuilder.fromConfig(Configuration.ARENA_ITEM.getAsConfigSection()).build();
        ItemMeta meta = original.getItemMeta();
        if (meta.hasDisplayName()) {
            meta.setDisplayName(TextUtil.format(meta.getDisplayName(), data));
        }
        if (meta.hasLore()) {
            meta.setLore(TextUtil.format((List<String>)meta.getLore(), data));
        }
        original.setItemMeta(meta);
        return new ItemBuilder(original).setGlow(data.getState().equals("STARTING")).build();
    }

    private ItemStack getArenaItem(IArena arena) {
        ItemStack original = ItemBuilder.fromConfig(Configuration.ARENA_ITEM.getAsConfigSection()).build();
        ItemMeta meta = original.getItemMeta();
        if (meta.hasDisplayName()) {
            meta.setDisplayName(TextUtil.format(meta.getDisplayName(), arena));
        }
        if (meta.hasLore()) {
            meta.setLore(TextUtil.format((List<String>)meta.getLore(), arena));
        }
        original.setItemMeta(meta);
        return new ItemBuilder(original).setGlow(arena.getStatus() == GameState.starting).build();
    }
}

