/*
 * Decompiled with CFR 0.152.
 */
package me.cubecrafter.playagain.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.cubecrafter.playagain.PlayAgain;
import me.cubecrafter.playagain.libs.xseries.SkullUtils;
import me.cubecrafter.playagain.libs.xseries.XMaterial;
import me.cubecrafter.playagain.utils.TextUtil;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class ItemBuilder {
    private ItemStack item;
    private final Map<String, String> placeholders = new HashMap<String, String>();

    public ItemBuilder(String material) {
        this.item = XMaterial.matchXMaterial(material).get().parseItem();
    }

    public ItemBuilder(ItemStack item) {
        this.item = item;
    }

    public ItemBuilder setDisplayName(String name) {
        ItemMeta meta = this.item.getItemMeta();
        meta.setDisplayName(TextUtil.color(name));
        this.item.setItemMeta(meta);
        return this;
    }

    public ItemBuilder setLore(List<String> lore) {
        ItemMeta meta = this.item.getItemMeta();
        meta.setLore(TextUtil.color(lore));
        this.item.setItemMeta(meta);
        return this;
    }

    public ItemBuilder setGlow(boolean glow) {
        ItemMeta meta = this.item.getItemMeta();
        if (glow) {
            meta.addEnchant(Enchantment.DURABILITY, 1, true);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        } else {
            meta.removeEnchant(Enchantment.DURABILITY);
            meta.removeItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        this.item.setItemMeta(meta);
        return this;
    }

    public ItemBuilder setTexture(String identifier) {
        ItemMeta meta = this.item.getItemMeta();
        if (!(meta instanceof SkullMeta)) {
            return this;
        }
        this.item.setItemMeta((ItemMeta)SkullUtils.applySkin(meta, identifier));
        return this;
    }

    public ItemBuilder setTag(String key, String value) {
        this.item = PlayAgain.getInstance().getBedWars().getVersionSupport().setTag(this.item, key, value);
        return this;
    }

    public ItemBuilder setAmount(int amount) {
        this.item.setAmount(amount);
        return this;
    }

    public ItemBuilder addPlaceholder(String target, String replacement) {
        this.placeholders.put(target, replacement);
        return this;
    }

    public ItemBuilder hideFlags() {
        ItemMeta meta = this.item.getItemMeta();
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_UNBREAKABLE});
        this.item.setItemMeta(meta);
        return this;
    }

    public ItemStack build() {
        this.hideFlags();
        String displayName = this.item.getItemMeta().getDisplayName();
        if (displayName != null) {
            for (Map.Entry<String, String> entry : this.placeholders.entrySet()) {
                displayName = displayName.replace(entry.getKey(), entry.getValue());
            }
            this.setDisplayName(displayName);
        }
        this.setDisplayName(displayName);
        List lore = this.item.getItemMeta().getLore();
        if (lore != null) {
            for (Map.Entry<String, String> entry : this.placeholders.entrySet()) {
                lore.replaceAll(line -> line.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue()));
            }
        }
        this.setLore(lore);
        return this.item;
    }

    public static ItemBuilder fromConfig(ConfigurationSection section) {
        ItemBuilder builder = new ItemBuilder(section.getString("material"));
        if (section.contains("displayname")) {
            builder.setDisplayName(section.getString("displayname"));
        }
        if (section.contains("lore")) {
            builder.setLore(section.getStringList("lore"));
        }
        if (section.contains("texture")) {
            builder.setTexture(section.getString("texture"));
        }
        return builder;
    }

    public static String getTag(ItemStack item, String key) {
        String tag = PlayAgain.getInstance().getBedWars().getVersionSupport().getTag(item, key);
        return tag == null ? "" : tag;
    }
}

