/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu;

import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.yapzhenyie.GadgetsMenu.GadgetsMenuData;
import com.yapzhenyie.GadgetsMenu.command.main.CommandManager;
import com.yapzhenyie.GadgetsMenu.command.main.subcommands.CommandAbout;
import com.yapzhenyie.GadgetsMenu.command.main.subcommands.CommandCheckUpdate;
import com.yapzhenyie.GadgetsMenu.command.main.subcommands.CommandEquip;
import com.yapzhenyie.GadgetsMenu.command.main.subcommands.CommandHelp;
import com.yapzhenyie.GadgetsMenu.command.main.subcommands.CommandMain;
import com.yapzhenyie.GadgetsMenu.command.main.subcommands.CommandMenu;
import com.yapzhenyie.GadgetsMenu.command.main.subcommands.CommandMenuItem;
import com.yapzhenyie.GadgetsMenu.command.main.subcommands.CommandNamePet;
import com.yapzhenyie.GadgetsMenu.command.main.subcommands.CommandPermission;
import com.yapzhenyie.GadgetsMenu.command.main.subcommands.CommandReload;
import com.yapzhenyie.GadgetsMenu.command.main.subcommands.CommandReset;
import com.yapzhenyie.GadgetsMenu.command.main.subcommands.CommandSettings;
import com.yapzhenyie.GadgetsMenu.command.main.subcommands.CommandStatus;
import com.yapzhenyie.GadgetsMenu.command.mysteryboxes.subcommand.CommandCheck;
import com.yapzhenyie.GadgetsMenu.command.mysteryboxes.subcommand.CommandGift;
import com.yapzhenyie.GadgetsMenu.command.mysteryboxes.subcommand.CommandGive;
import com.yapzhenyie.GadgetsMenu.command.mysteryboxes.subcommand.CommandGiveAll;
import com.yapzhenyie.GadgetsMenu.command.mysteryboxes.subcommand.CommandMode;
import com.yapzhenyie.GadgetsMenu.command.mysterydust.AutoTabCompleter;
import com.yapzhenyie.GadgetsMenu.command.mysterydust.subcommands.CommandAddMysteryDust;
import com.yapzhenyie.GadgetsMenu.command.mysterydust.subcommands.CommandCheckMysteryDust;
import com.yapzhenyie.GadgetsMenu.command.mysterydust.subcommands.CommandPayMysteryDust;
import com.yapzhenyie.GadgetsMenu.command.mysterydust.subcommands.CommandRemoveMysteryDust;
import com.yapzhenyie.GadgetsMenu.command.mysterydust.subcommands.CommandSetMysteryDust;
import com.yapzhenyie.GadgetsMenu.configuration.ConfigVersionManager;
import com.yapzhenyie.GadgetsMenu.configuration.ConfigurationMessageManager;
import com.yapzhenyie.GadgetsMenu.configuration.CustomConfiguration;
import com.yapzhenyie.GadgetsMenu.configuration.FileManager;
import com.yapzhenyie.GadgetsMenu.configuration.OldConfigurationManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.Category;
import com.yapzhenyie.GadgetsMenu.cosmetics.MainMenuType;
import com.yapzhenyie.GadgetsMenu.cosmetics.banners.BannerType;
import com.yapzhenyie.GadgetsMenu.cosmetics.cloaks.CloakType;
import com.yapzhenyie.GadgetsMenu.cosmetics.emotes.EmoteType;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.GadgetCategoryType;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.GadgetType;
import com.yapzhenyie.GadgetsMenu.cosmetics.hats.animated.AnimatedHatType;
import com.yapzhenyie.GadgetsMenu.cosmetics.hats.standard.HatType;
import com.yapzhenyie.GadgetsMenu.cosmetics.morphs.MorphType;
import com.yapzhenyie.GadgetsMenu.cosmetics.particles.ParticleType;
import com.yapzhenyie.GadgetsMenu.cosmetics.pets.Pet;
import com.yapzhenyie.GadgetsMenu.cosmetics.pets.PetCategoryType;
import com.yapzhenyie.GadgetsMenu.cosmetics.pets.PetType;
import com.yapzhenyie.GadgetsMenu.cosmetics.suits.SuitEquipmentType;
import com.yapzhenyie.GadgetsMenu.cosmetics.suits.SuitType;
import com.yapzhenyie.GadgetsMenu.custom.CustomAnimatedHatType;
import com.yapzhenyie.GadgetsMenu.custom.CustomBannerType;
import com.yapzhenyie.GadgetsMenu.custom.CustomEmoteType;
import com.yapzhenyie.GadgetsMenu.custom.CustomHatType;
import com.yapzhenyie.GadgetsMenu.custom.CustomParticleType;
import com.yapzhenyie.GadgetsMenu.database.DatabaseManager;
import com.yapzhenyie.GadgetsMenu.database.DatabaseStorage;
import com.yapzhenyie.GadgetsMenu.database.mysql.MySQLManager;
import com.yapzhenyie.GadgetsMenu.database.sqlite.SQLiteManager;
import com.yapzhenyie.GadgetsMenu.economy.GEconomyProvider;
import com.yapzhenyie.GadgetsMenu.economy.GStorage;
import com.yapzhenyie.GadgetsMenu.economy.HookPluginManager;
import com.yapzhenyie.GadgetsMenu.economy.storages.Economy_CoinsAPINB;
import com.yapzhenyie.GadgetsMenu.economy.storages.Economy_Default;
import com.yapzhenyie.GadgetsMenu.economy.storages.Economy_PlayerPoints;
import com.yapzhenyie.GadgetsMenu.economy.storages.Economy_Vault;
import com.yapzhenyie.GadgetsMenu.hook.PlaceholderAPI;
import com.yapzhenyie.GadgetsMenu.hook.protocollib.ProtocolLibHook;
import com.yapzhenyie.GadgetsMenu.hook.protocollib.packets.ProtocolLibHookImpl;
import com.yapzhenyie.GadgetsMenu.listeners.GadgetListener;
import com.yapzhenyie.GadgetsMenu.listeners.OpenMenuListener;
import com.yapzhenyie.GadgetsMenu.listeners.PlayerListener;
import com.yapzhenyie.GadgetsMenu.listeners.RenamePetListener;
import com.yapzhenyie.GadgetsMenu.listeners.cosmetics.ArmorStandManipulateListener;
import com.yapzhenyie.GadgetsMenu.listeners.cosmetics.CommandProcessListener;
import com.yapzhenyie.GadgetsMenu.listeners.cosmetics.CraftItemListener;
import com.yapzhenyie.GadgetsMenu.listeners.cosmetics.DropItemListener;
import com.yapzhenyie.GadgetsMenu.listeners.cosmetics.PickupItemListener;
import com.yapzhenyie.GadgetsMenu.listeners.cosmetics.SelectItemListener;
import com.yapzhenyie.GadgetsMenu.listeners.mysteryvault.MysteryVaultBreakListener;
import com.yapzhenyie.GadgetsMenu.listeners.mysteryvault.MysteryVaultPreviewListener;
import com.yapzhenyie.GadgetsMenu.listeners.v1_17.EntityListener;
import com.yapzhenyie.GadgetsMenu.listeners.v1_9.PlayerSwapItemListener;
import com.yapzhenyie.GadgetsMenu.listeners.v1_9.PrepareAnvilListener;
import com.yapzhenyie.GadgetsMenu.log.LoggerManager;
import com.yapzhenyie.GadgetsMenu.menu.menus.AnimatedHatsMenu;
import com.yapzhenyie.GadgetsMenu.menu.menus.BannersMenu;
import com.yapzhenyie.GadgetsMenu.menu.menus.CloaksMenu;
import com.yapzhenyie.GadgetsMenu.menu.menus.EmotesMenu;
import com.yapzhenyie.GadgetsMenu.menu.menus.GadgetCategoriesMenu;
import com.yapzhenyie.GadgetsMenu.menu.menus.GadgetTypesMenu;
import com.yapzhenyie.GadgetsMenu.menu.menus.HatsMenu;
import com.yapzhenyie.GadgetsMenu.menu.menus.ItemPurchaseMenu;
import com.yapzhenyie.GadgetsMenu.menu.menus.MainMenu;
import com.yapzhenyie.GadgetsMenu.menu.menus.MorphsMenu;
import com.yapzhenyie.GadgetsMenu.menu.menus.ParticlesMenu;
import com.yapzhenyie.GadgetsMenu.menu.menus.PetCategoriesMenu;
import com.yapzhenyie.GadgetsMenu.menu.menus.PetTypesMenu;
import com.yapzhenyie.GadgetsMenu.menu.menus.SettingsMenu;
import com.yapzhenyie.GadgetsMenu.menu.menus.SuitEquipmentMenu;
import com.yapzhenyie.GadgetsMenu.menu.menus.SuitsMenu;
import com.yapzhenyie.GadgetsMenu.menu.menus.mysteryboxes.ConfirmOpenMultipleBoxesMenu;
import com.yapzhenyie.GadgetsMenu.menu.menus.mysteryboxes.ConfirmOpenMysteryBoxMenu;
import com.yapzhenyie.GadgetsMenu.menu.menus.mysteryboxes.ConfirmSendGiftMenu;
import com.yapzhenyie.GadgetsMenu.menu.menus.mysteryboxes.GiftInventoryMenu;
import com.yapzhenyie.GadgetsMenu.menu.menus.mysteryboxes.MysteryBoxesCraftingMenu;
import com.yapzhenyie.GadgetsMenu.menu.menus.mysteryboxes.OpenMultipleBoxesMenu;
import com.yapzhenyie.GadgetsMenu.menu.menus.mysteryboxes.SendGiftMenu;
import com.yapzhenyie.GadgetsMenu.menu.menus.mysteryvault.MysteryVaultAnimationsMenu;
import com.yapzhenyie.GadgetsMenu.menu.menus.mysteryvault.MysteryVaultMenu;
import com.yapzhenyie.GadgetsMenu.metrics.MetricsStarter;
import com.yapzhenyie.GadgetsMenu.mysteryboxes.MysteryBoxesMessages;
import com.yapzhenyie.GadgetsMenu.nms.NMSManager;
import com.yapzhenyie.GadgetsMenu.player.GPlayer;
import com.yapzhenyie.GadgetsMenu.player.PlayerManager;
import com.yapzhenyie.GadgetsMenu.tasks.UpdateHolograms;
import com.yapzhenyie.GadgetsMenu.tasks.UpdateIndividualHologram;
import com.yapzhenyie.GadgetsMenu.tasks.UpdatePlayerMysteryDust;
import com.yapzhenyie.GadgetsMenu.updater.UpdaterChecker;
import com.yapzhenyie.GadgetsMenu.updater.UpdaterManager;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.EnumPermission;
import com.yapzhenyie.GadgetsMenu.utils.FileUtil;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.ReflectionUtils;
import com.yapzhenyie.GadgetsMenu.utils.ServerVersion;
import com.yapzhenyie.GadgetsMenu.utils.VersionManager;
import com.yapzhenyie.GadgetsMenu.utils.cosmetics.morphs.GDisguise;
import com.yapzhenyie.GadgetsMenu.utils.cosmetics.morphs.IDisguise;
import com.yapzhenyie.GadgetsMenu.utils.cosmetics.morphs.LibDisguise;
import com.yapzhenyie.GadgetsMenu.utils.discount.ItemCostDiscountManager;
import com.yapzhenyie.GadgetsMenu.utils.mysteryboxes.CosmeticItems;
import com.yapzhenyie.GadgetsMenu.utils.mysteryvault.MysteryVaultManager;
import com.yapzhenyie.GadgetsMenu.utils.mysteryvault.animations.AnimationType;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class GadgetsMenu
extends JavaPlugin {
    private static GadgetsMenu gadgetsMenu;
    private static GadgetsMenuData gadgetsMenuData;
    private static GPlayer gPlayer;
    public CustomConfiguration config;
    private File file;
    public static UpdaterChecker updaterChecker;
    private static NMSManager nmsManager;
    private static GEconomyProvider gEconomyProvider;
    private static DatabaseManager databaseManager;
    private static GDisguise gDisguise;
    private static ProtocolLibHook protocolLib;
    private static Random random;
    private static PlaceholderAPI placeholderAPI;
    private static WorldGuardPlugin worldGuardPlugin;
    private static boolean isSupport;
    private static boolean errorOnLoading;

    public void onEnable() {
        gadgetsMenu = this;
        if (!VersionManager.isSupported(VersionManager.getMinecraftVersion(), "1.8", "1.20")) {
            LoggerManager.printLogWithHeader(LoggerManager.LogLevel.INFO, "------------------------------------------------------", "This version of GadgetsMenu only", "works on spigot versions from 1.8 to 1.20.", "The plugin will be disabled.");
            isSupport = false;
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        try {
            new VersionManager();
        }
        catch (IllegalArgumentException e) {
            LoggerManager.printLogWithHeader(LoggerManager.LogLevel.INFO, "------------------------------------------------------", "This version of GadgetsMenu only", "works on spigot versions from 1.8 to 1.20.", "The plugin will be disabled.");
            isSupport = false;
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        if (VersionManager.isSupportDropped(ServerVersion.getServerVersion())) {
            LoggerManager.printLogWithHeader(LoggerManager.LogLevel.INFO, "------------------------------------------------------", "GadgetsMenu is no longer support server " + VersionManager.getMinecraftVersion() + ".", "Please update the server to the latest supported", "version. The plugin will be disabled.");
            isSupport = false;
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        try {
            this.initNMS();
            LoggerManager.printLogWithHeader(LoggerManager.LogLevel.INFO, "------------------------------------------------------", "GadgetsMenu [Free] " + this.getDescription().getVersion() + " is loading...", "[server: " + this.getServer().getVersion() + "]", "Running Java " + System.getProperty("java.version"), "Plugin by Yap Zhen Yie.", "Date Modified: 18 June 2023", "", "Initializing module " + (Object)((Object)ServerVersion.getServerVersion()));
            gadgetsMenuData = new GadgetsMenuData();
            gPlayer = new GPlayer();
            this.setupConfig();
            this.initConfiguration();
            if (FileManager.getConfigFile().get("Config-Version") != null && FileManager.getConfigFile().getString("Config-Version").startsWith("2")) {
                LoggerManager.printLogWithHeader(LoggerManager.LogLevel.WARNING, "------------------------------------------------------", "Your GadgetsMenu configuration files are based on", "the premium version which differ to your current(free)  ", "version. Therefore, this plugin will not get loaded", "correctly due to the wrong configuration format.");
            }
            if (this.config.get("Config Version") != null) {
                LoggerManager.printLogWithHeader(LoggerManager.LogLevel.INFO, "------------------------------------------------------", "Transferring data into new file...");
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, new Runnable(){

                    @Override
                    public void run() {
                        OldConfigurationManager.transferMessages();
                    }
                });
            }
            GadgetsMenu.getGadgetsMenuData().initData();
            this.initGEconomyProvider();
            MysteryBoxesMessages.initMessages();
            this.registerListeners();
            this.initCommands();
            this.initCosmetics();
            ItemCostDiscountManager.loadDiscountGroups();
        }
        catch (Exception | ExceptionInInitializerError e) {
            LoggerManager.warn("Cannot load GadgetsMenu properly, plugin will be disabled. Please contact the author for help.");
            e.printStackTrace();
            errorOnLoading = true;
            this.getPluginLoader().disablePlugin((Plugin)this);
            return;
        }
        MetricsStarter metrics = new MetricsStarter(gadgetsMenu);
        metrics.start();
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        DatabaseStorage dbStorage = GadgetsMenu.getGadgetsMenuData().getDatabaseStorage();
        if (dbStorage == DatabaseStorage.SQLITE) {
            databaseManager = new SQLiteManager();
        } else if (dbStorage == DatabaseStorage.MYSQL) {
            databaseManager = new MySQLManager();
        }
        databaseManager.init();
        if (gadgetsMenu == null || errorOnLoading) {
            return;
        }
        if (MysteryVaultManager.isIndividualHologramEnabled() && Bukkit.getPluginManager().isPluginEnabled("ProtocolLib")) {
            try {
                protocolLib = new ProtocolLibHookImpl();
                if (protocolLib.hook((Plugin)this, nmsManager)) {
                    this.getLogger().info("Enabled Mystery Vault individual hologram.");
                }
            }
            catch (Exception | NoClassDefFoundError e) {
                LoggerManager.warn("Failed to hook ProtocolLib. Please update ProtocolLib plugin to the latest version.");
            }
        }
        this.initSongsFolder();
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            try {
                placeholderAPI = new PlaceholderAPI();
                if (placeholderAPI.register()) {
                    LoggerManager.info("[Placeholder] PlaceholderAPI hooked.");
                } else {
                    LoggerManager.consoleMessage(ChatUtil.format("&cFailed to hook PlaceholderAPI."));
                }
            }
            catch (Exception e) {
                LoggerManager.consoleMessage(ChatUtil.format("&cFailed to hook PlaceholderAPI."));
                e.printStackTrace();
            }
        }
        if (GadgetsMenu.getGadgetsMenuData().getMysteryDustStorage() != GStorage.DEFAULT) {
            new HookPluginManager(this).hookPlugins(GadgetsMenu.getGadgetsMenuData().getMysteryDustStorage());
        }
        CosmeticItems.loadItems();
        MysteryVaultManager.loadMysteryVaults();
        if (gadgetsMenu == null || errorOnLoading) {
            return;
        }
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, (Runnable)new UpdateHolograms(), 10L, 10L);
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, (Runnable)new UpdateIndividualHologram(), 12L, 12L);
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this, (Runnable)new UpdatePlayerMysteryDust(), 100L, 12000L);
        if (GadgetsMenu.getGadgetsMenuData().isCheckUpdateEnabled()) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
                updaterChecker = UpdaterManager.checkUpdate((CommandSender)this.getServer().getConsoleSender(), true);
                if (GadgetsMenu.getUpdaterChecker().isOutdated()) {
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        if (!player.isOp() && !player.hasPermission(EnumPermission.COMMAND_CHECK_UPDATE.getPermission())) continue;
                        if (UpdaterManager.isDownloadedUpdate()) {
                            player.sendMessage(MessageType.UPDATE_DOWNLOADED.getFormatMessage());
                            continue;
                        }
                        player.sendMessage(GadgetsMenu.getGadgetsMenuData().getPrefix() + UpdaterManager.getMessage());
                    }
                }
            });
        }
        gPlayer.initPlayers();
    }

    public void onDisable() {
        if (isSupport && !errorOnLoading && gadgetsMenu != null) {
            if (gPlayer != null) {
                gPlayer.dispose();
            }
            MysteryVaultManager.forceRemoveHolograms();
            MysteryVaultManager.forceRemoveLootHologram();
            MysteryVaultManager.forceRemoveIndividualHologram();
            Pet.clearAll();
            if (databaseManager != null && !databaseManager.getDBConnection().isClosed()) {
                databaseManager.getDBConnection().closeConnection();
            }
            if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI") && placeholderAPI != null) {
                try {
                    placeholderAPI.unregister();
                }
                catch (NoSuchMethodError e) {
                    me.clip.placeholderapi.PlaceholderAPI.unregisterPlaceholderHook((String)"gadgetsmenu");
                }
            }
            HandlerList.unregisterAll((Plugin)GadgetsMenu.getInstance());
            Bukkit.getScheduler().cancelTasks((Plugin)GadgetsMenu.getInstance());
        }
        gadgetsMenu = null;
    }

    private void setupConfig() {
        this.file = new File(this.getDataFolder(), "config.yml");
        boolean firstLoad = false;
        if (!this.file.exists()) {
            this.file.getParentFile().mkdirs();
            FileUtil.copy(this.getResource("config.yml"), this.file);
            firstLoad = true;
        }
        this.config = CustomConfiguration.loadConfiguration(this.file);
        ConfigurationMessageManager.loadConfigMessages(firstLoad);
        ConfigVersionManager.updateConfig();
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void registerListeners() {
        this.registerListener(new PlayerListener());
        this.registerListener(new OpenMenuListener());
        this.registerListener(new com.yapzhenyie.GadgetsMenu.listeners.EntityListener());
        this.registerListener(new GadgetListener());
        this.registerListener(new RenamePetListener());
        this.registerListener(new CraftItemListener());
        this.registerListener(new DropItemListener());
        this.registerListener(new PickupItemListener());
        this.registerListener(new SelectItemListener());
        this.registerListener(new ArmorStandManipulateListener());
        if (VersionManager.is1_9OrAbove()) {
            this.registerListener(new PlayerSwapItemListener());
            this.registerListener(new PrepareAnvilListener());
        }
        if (VersionManager.is1_17OrAbove()) {
            this.registerListener(new EntityListener());
        }
        this.registerListener(new CommandProcessListener());
        this.registerListener(new MainMenu());
        this.registerListener(new HatsMenu());
        this.registerListener(new AnimatedHatsMenu());
        this.registerListener(new ParticlesMenu());
        this.registerListener(new SuitsMenu());
        this.registerListener(new SuitEquipmentMenu());
        this.registerListener(new GadgetCategoriesMenu());
        this.registerListener(new GadgetTypesMenu());
        this.registerListener(new PetCategoriesMenu());
        this.registerListener(new PetTypesMenu());
        this.registerListener(new MorphsMenu());
        this.registerListener(new BannersMenu());
        this.registerListener(new EmotesMenu());
        this.registerListener(new CloaksMenu());
        this.registerListener(new ItemPurchaseMenu());
        this.registerListener(new SettingsMenu());
        this.registerListener(new MysteryVaultBreakListener());
        this.registerListener(new MysteryVaultPreviewListener());
        this.registerListener(new MysteryVaultMenu());
        this.registerListener(new ConfirmOpenMysteryBoxMenu());
        this.registerListener(new MysteryBoxesCraftingMenu());
        this.registerListener(new GiftInventoryMenu());
        this.registerListener(new SendGiftMenu());
        this.registerListener(new ConfirmSendGiftMenu());
        this.registerListener(new MysteryVaultAnimationsMenu());
        this.registerListener(new OpenMultipleBoxesMenu());
        this.registerListener(new ConfirmOpenMultipleBoxesMenu());
    }

    private void initCommands() {
        CommandManager cmdManager = new CommandManager((Plugin)this);
        cmdManager.registerCommand(new CommandAbout());
        cmdManager.registerCommand(new CommandCheckUpdate());
        cmdManager.registerCommand(new CommandEquip());
        cmdManager.registerCommand(new CommandHelp());
        cmdManager.registerCommand(new CommandMain());
        cmdManager.registerCommand(new CommandMenu());
        cmdManager.registerCommand(new CommandMenuItem());
        cmdManager.registerCommand(new CommandNamePet());
        cmdManager.registerCommand(new CommandPermission());
        cmdManager.registerCommand(new CommandReload());
        cmdManager.registerCommand(new CommandReset());
        cmdManager.registerCommand(new CommandSettings());
        cmdManager.registerCommand(new CommandStatus());
        this.getCommand("gmenu").setTabCompleter((TabCompleter)new com.yapzhenyie.GadgetsMenu.command.main.AutoTabCompleter());
        this.getCommand("gadgetsmenu").setTabCompleter((TabCompleter)new com.yapzhenyie.GadgetsMenu.command.main.AutoTabCompleter());
        com.yapzhenyie.GadgetsMenu.command.mysterydust.CommandManager dustCmdManager = new com.yapzhenyie.GadgetsMenu.command.mysterydust.CommandManager((Plugin)this);
        dustCmdManager.registerCommand(new CommandAddMysteryDust());
        dustCmdManager.registerCommand(new CommandCheckMysteryDust());
        dustCmdManager.registerCommand(new CommandPayMysteryDust());
        dustCmdManager.registerCommand(new CommandRemoveMysteryDust());
        dustCmdManager.registerCommand(new CommandSetMysteryDust());
        this.getCommand("mysterydust").setTabCompleter((TabCompleter)new AutoTabCompleter());
        this.getCommand("dust").setTabCompleter((TabCompleter)new AutoTabCompleter());
        com.yapzhenyie.GadgetsMenu.command.mysteryboxes.CommandManager mysteryboxesCmdManager = new com.yapzhenyie.GadgetsMenu.command.mysteryboxes.CommandManager((Plugin)this);
        mysteryboxesCmdManager.registerCommand(new CommandCheck());
        mysteryboxesCmdManager.registerCommand(new CommandGift());
        mysteryboxesCmdManager.registerCommand(new CommandGive());
        mysteryboxesCmdManager.registerCommand(new CommandGiveAll());
        mysteryboxesCmdManager.registerCommand(new CommandMode());
        this.getCommand("gmysteryboxes").setTabCompleter((TabCompleter)new com.yapzhenyie.GadgetsMenu.command.mysteryboxes.AutoTabCompleter());
        this.getCommand("gmysterybox").setTabCompleter((TabCompleter)new com.yapzhenyie.GadgetsMenu.command.mysteryboxes.AutoTabCompleter());
        this.getCommand("gmb").setTabCompleter((TabCompleter)new com.yapzhenyie.GadgetsMenu.command.mysteryboxes.AutoTabCompleter());
    }

    private void initCosmetics() {
        MainMenuType.checkEnabled();
        new MainMenu();
        if (Category.HATS.isEnabled()) {
            HatType.checkEnabled();
            CustomHatType.initCustomHats();
        }
        if (Category.ANIMATED_HATS.isEnabled()) {
            AnimatedHatType.checkEnabled();
            CustomAnimatedHatType.initCustomAnimatedHats();
        }
        if (Category.PARTICLES.isEnabled()) {
            ParticleType.checkEnabled();
            CustomParticleType.initCustomParticles();
        }
        if (Category.SUITS.isEnabled()) {
            SuitType.checkEnabled();
            SuitEquipmentType.checkEnabled();
        }
        if (Category.GADGETS.isEnabled()) {
            GadgetCategoryType.checkEnabled();
            GadgetType.checkEnabled();
        }
        if (Category.PETS.isEnabled()) {
            PetCategoryType.checkEnabled();
            PetType.checkEnabled();
        }
        if (Category.MORPHS.isEnabled() && (GadgetsMenu.getGadgetsMenuData().isLibsDisguiseEnabled() || GadgetsMenu.getGadgetsMenuData().isIDisguiseEnabled())) {
            MorphType.checkEnabled();
        }
        if (Category.BANNERS.isEnabled()) {
            BannerType.checkEnabled();
            CustomBannerType.initCustomBanners();
        }
        if (Category.EMOTES.isEnabled()) {
            EmoteType.checkEnabled();
            CustomEmoteType.initCustomEmotes();
        }
        if (Category.CLOAKS.isEnabled()) {
            CloakType.checkEnabled();
        }
        AnimationType.checkEnabled();
    }

    private void initNMS() {
        Object nmsObj = null;
        try {
            Class<?> clazz = Class.forName("com.yapzhenyie.GadgetsMenu.nms." + (Object)((Object)ServerVersion.getServerVersion()) + ".NMSManagerImpl");
            nmsObj = ReflectionUtils.instantiateObject(clazz, new Object[0]);
        }
        catch (ClassNotFoundException clazz) {
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
        nmsManager = (NMSManager)nmsObj;
    }

    private void initGEconomyProvider() {
        if (GadgetsMenu.getGadgetsMenuData().getMysteryDustStorage() == GStorage.DEFAULT) {
            gEconomyProvider = new Economy_Default();
        } else if (GadgetsMenu.getGadgetsMenuData().getMysteryDustStorage() == GStorage.VAULT) {
            gEconomyProvider = new Economy_Vault();
        } else if (GadgetsMenu.getGadgetsMenuData().getMysteryDustStorage() == GStorage.PLAYERPOINTS) {
            gEconomyProvider = new Economy_PlayerPoints();
        } else if (GadgetsMenu.getGadgetsMenuData().getMysteryDustStorage() == GStorage.COINSAPI) {
            gEconomyProvider = new Economy_CoinsAPINB();
        }
    }

    private void initConfiguration() {
        ConfigurationMessageManager.loadMessagesConfigMessages();
        ConfigurationMessageManager.loadMysteryBoxesMessages();
        FileManager.getMessagesFile().reload();
        FileManager.getMessagesFile().save();
        FileManager.getMainMenuFile().reload();
        FileManager.getMainMenuFile().save();
        FileManager.getHatsFile().reload();
        FileManager.getHatsFile().save();
        FileManager.getAnimatedHatsFile().reload();
        FileManager.getAnimatedHatsFile().save();
        FileManager.getParticlesFile().reload();
        FileManager.getParticlesFile().save();
        FileManager.getGadgetsFile().reload();
        FileManager.getGadgetsFile().save();
        FileManager.getPetsFile().reload();
        FileManager.getPetsFile().save();
        FileManager.getMorphsFile().reload();
        FileManager.getMorphsFile().save();
        FileManager.getBannersFile().reload();
        FileManager.getBannersFile().save();
        FileManager.getEmotesFile().reload();
        FileManager.getEmotesFile().save();
        FileManager.getCloaksFile().reload();
        FileManager.getCloaksFile().save();
        FileManager.getCustomHatsFile().reload();
        FileManager.getCustomHatsFile().save();
        FileManager.getCustomAnimatedHatsFile().reload();
        FileManager.getCustomAnimatedHatsFile().save();
        FileManager.getCustomParticlesFile().reload();
        FileManager.getCustomParticlesFile().save();
        FileManager.getCustomBannersFile().reload();
        FileManager.getCustomBannersFile().save();
        FileManager.getCustomEmotesFile().reload();
        FileManager.getCustomEmotesFile().save();
        FileManager.getMysteryBoxesFile().reload();
        FileManager.getMysteryBoxesFile().save();
    }

    private void initSongsFolder() {
        File djBoothGadgetFolder;
        File discoBallGadgetFolder;
        File radioGadgetFolder;
        File folder = new File(this.getDataFolder().getPath() + "/songs/");
        if (!folder.exists() || folder.listFiles().length <= 0) {
            this.saveResource("songs/Bumblebee.nbs", true);
        }
        if (!(radioGadgetFolder = new File(this.getDataFolder().getPath() + "/songs/RadioGadget")).exists() || radioGadgetFolder.listFiles().length <= 0) {
            this.saveResource("songs/RadioGadget/Animals.nbs", true);
            this.saveResource("songs/RadioGadget/Another One Bites the Dust.nbs", true);
            this.saveResource("songs/RadioGadget/Beverly Hills Cop.nbs", true);
            this.saveResource("songs/RadioGadget/Carol of the Bells.nbs", true);
            this.saveResource("songs/RadioGadget/Downtown.nbs", true);
            this.saveResource("songs/RadioGadget/Everybody Dance Now.nbs", true);
            this.saveResource("songs/RadioGadget/Frosty the Snowman.nbs", true);
            this.saveResource("songs/RadioGadget/Fugue In D Minor.nbs", true);
            this.saveResource("songs/RadioGadget/Fur Elise.nbs", true);
            this.saveResource("songs/RadioGadget/Gerudo Valley.nbs", true);
            this.saveResource("songs/RadioGadget/Ghostbusters.nbs", true);
            this.saveResource("songs/RadioGadget/Grandma Got Run Over by a Reindeer.nbs", true);
            this.saveResource("songs/RadioGadget/Happy.nbs", true);
            this.saveResource("songs/RadioGadget/Hotel California.nbs", true);
            this.saveResource("songs/RadioGadget/Let It Be.nbs", true);
            this.saveResource("songs/RadioGadget/Luigi's Mansion.nbs", true);
            this.saveResource("songs/RadioGadget/Mortal Kombat.nbs", true);
            this.saveResource("songs/RadioGadget/Numb.nbs", true);
            this.saveResource("songs/RadioGadget/Ob-La-Di, Ob-La-Da.nbs", true);
            this.saveResource("songs/RadioGadget/Rainbow Tylenol.nbs", true);
            this.saveResource("songs/RadioGadget/Reptilia.nbs", true);
            this.saveResource("songs/RadioGadget/StarFox64Theme.nbs", true);
            this.saveResource("songs/RadioGadget/The Fox.nbs", true);
            this.saveResource("songs/RadioGadget/Wizards in Winter.nbs", true);
        }
        if (!(discoBallGadgetFolder = new File(this.getDataFolder().getPath() + "/songs/DiscoBallGadget")).exists() || discoBallGadgetFolder.listFiles().length <= 0) {
            this.saveResource("songs/DiscoBallGadget/Demons.nbs", true);
            this.saveResource("songs/DiscoBallGadget/Let It Go.nbs", true);
            this.saveResource("songs/DiscoBallGadget/Levels.nbs", true);
            this.saveResource("songs/DiscoBallGadget/The Fox.nbs", true);
            this.saveResource("songs/DiscoBallGadget/Wizards in Winter.nbs", true);
        }
        if (!(djBoothGadgetFolder = new File(this.getDataFolder().getPath() + "/songs/DjBoothGadget")).exists() || djBoothGadgetFolder.listFiles().length <= 0) {
            this.saveResource("songs/DjBoothGadget/Another One Bites the Dust.nbs", true);
            this.saveResource("songs/DjBoothGadget/Everybody Dance Now.nbs", true);
            this.saveResource("songs/DjBoothGadget/Wizards in Winter.nbs", true);
        }
    }

    public File getFile() {
        return this.file;
    }

    public CustomConfiguration getConfig() {
        return this.config;
    }

    public void registerListener(Listener listener) {
        Bukkit.getServer().getPluginManager().registerEvents(listener, (Plugin)GadgetsMenu.getInstance());
    }

    public static Random random() {
        return random;
    }

    public static GPlayer getGPlayer() {
        return gPlayer;
    }

    public static PlayerManager getPlayerManager(Player player) {
        return gPlayer.getPlayerManager(player);
    }

    public static GadgetsMenuData getGadgetsMenuData() {
        return gadgetsMenuData;
    }

    public static NMSManager getNMSManager() {
        return nmsManager;
    }

    public static UpdaterChecker getUpdaterChecker() {
        return updaterChecker;
    }

    public static DatabaseManager getDatabaseManager() {
        return databaseManager;
    }

    public static GEconomyProvider getGEconomyProvider() {
        return gEconomyProvider;
    }

    public static void setGEconomyProvider(GEconomyProvider storage) {
        if (storage == null) {
            return;
        }
        gEconomyProvider = storage;
    }

    public static GDisguise getGDisguise() {
        if (!GadgetsMenu.getGadgetsMenuData().isLibsDisguiseEnabled() && !GadgetsMenu.getGadgetsMenuData().isIDisguiseEnabled()) {
            return null;
        }
        if (gDisguise == null) {
            if (GadgetsMenu.getGadgetsMenuData().isLibsDisguiseEnabled()) {
                gDisguise = new LibDisguise();
                return gDisguise;
            }
            if (GadgetsMenu.getGadgetsMenuData().isIDisguiseEnabled()) {
                gDisguise = new IDisguise();
                return gDisguise;
            }
            return null;
        }
        return gDisguise;
    }

    public static WorldGuardPlugin getWorldGuardPlugin() {
        return worldGuardPlugin;
    }

    public static boolean isWorldGuardPluginHooked() {
        return worldGuardPlugin != null;
    }

    public static boolean hasProtocolLibHook() {
        return protocolLib != null;
    }

    public static ProtocolLibHook getProtocolLib() {
        return protocolLib;
    }

    public static GadgetsMenu getInstance() {
        return gadgetsMenu;
    }

    public String getPluginName() {
        return "GadgetsMenu";
    }

    static {
        nmsManager = null;
        gEconomyProvider = new Economy_Default();
        gDisguise = null;
        protocolLib = null;
        random = new Random();
        isSupport = true;
        errorOnLoading = false;
    }
}

