/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.command.main.subcommands;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.command.main.CommandManager;
import com.yapzhenyie.GadgetsMenu.command.main.SubCommand;
import com.yapzhenyie.GadgetsMenu.player.PlayerManager;
import com.yapzhenyie.GadgetsMenu.utils.EnumPermission;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.WorldUtils;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandMenuItem
extends SubCommand {
    public CommandMenuItem() {
        super("/gmenu menuitem [player]", "Give a player menu selector.", null, "gadgetsmenu.commands.menuitem", new String[]{"menuitem", "menuselector", "mi"}, true);
    }

    @Override
    protected void onCommandPlayer(Player sender, String[] args) {
        if (args.length > 2) {
            CommandManager.printMessage((CommandSender)sender, this);
            return;
        }
        Player itemReceiver = sender;
        if (!(args.length != 2 || (itemReceiver = sender.getServer().getPlayer(args[1])) != null && itemReceiver.isOnline())) {
            sender.sendMessage(MessageType.PLAYER_NOT_FOUND.getFormatMessage());
            return;
        }
        if (!WorldUtils.isWorldEnabled(itemReceiver.getWorld())) {
            sender.sendMessage(MessageType.NO_PERMISSION_FOR_MENU_ITEM_IN_THAT_WORLD.getFormatMessage().replace("{PLAYER}", itemReceiver.getName()));
            return;
        }
        if (!itemReceiver.hasPermission(EnumPermission.MENU_SELECTOR.getPermission())) {
            sender.sendMessage(MessageType.NO_PERMISSION_FOR_MENU_ITEM.getFormatMessage().replace("{PLAYER}", itemReceiver.getName()));
            return;
        }
        PlayerManager pManager = GadgetsMenu.getPlayerManager(itemReceiver);
        if (pManager == null) {
            sender.sendMessage(MessageType.ERROR.getFormatMessage());
            return;
        }
        pManager.giveMenuSelector();
        sender.sendMessage(MessageType.GIVE_MENU_ITEM.getFormatMessage().replace("{PLAYER}", itemReceiver.getName()));
        itemReceiver.sendMessage(MessageType.PLAYER_RECEIVE_MENU_ITEM.getFormatMessage());
    }

    @Override
    protected void onOtherCommandSender(CommandSender sender, String[] args) {
        if (args.length != 2) {
            CommandManager.printMessage(sender, this);
            return;
        }
        Player itemReceiver = sender.getServer().getPlayer(args[1]);
        if (itemReceiver == null || !itemReceiver.isOnline()) {
            sender.sendMessage(MessageType.PLAYER_NOT_FOUND.getFormatMessage());
            return;
        }
        if (!WorldUtils.isWorldEnabled(itemReceiver.getWorld())) {
            sender.sendMessage(MessageType.NO_PERMISSION_FOR_MENU_ITEM_IN_THAT_WORLD.getFormatMessage().replace("{PLAYER}", itemReceiver.getName()));
            return;
        }
        if (!itemReceiver.hasPermission(EnumPermission.MENU_SELECTOR.getPermission())) {
            sender.sendMessage(MessageType.NO_PERMISSION_FOR_MENU_ITEM.getFormatMessage().replace("{PLAYER}", itemReceiver.getName()));
            return;
        }
        PlayerManager pManager = GadgetsMenu.getPlayerManager(itemReceiver);
        if (pManager == null) {
            sender.sendMessage(MessageType.ERROR.getFormatMessage());
            return;
        }
        pManager.giveMenuSelector();
        sender.sendMessage(MessageType.GIVE_MENU_ITEM.getFormatMessage().replace("{PLAYER}", itemReceiver.getName()));
        itemReceiver.sendMessage(MessageType.PLAYER_RECEIVE_MENU_ITEM.getFormatMessage());
    }
}

