/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.command.main.subcommands;

import com.yapzhenyie.GadgetsMenu.command.main.CommandManager;
import com.yapzhenyie.GadgetsMenu.command.main.SubCommand;
import com.yapzhenyie.GadgetsMenu.cosmetics.banners.BannerType;
import com.yapzhenyie.GadgetsMenu.cosmetics.cloaks.CloakType;
import com.yapzhenyie.GadgetsMenu.cosmetics.emotes.EmoteType;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.GadgetType;
import com.yapzhenyie.GadgetsMenu.cosmetics.hats.animated.AnimatedHatType;
import com.yapzhenyie.GadgetsMenu.cosmetics.hats.standard.HatType;
import com.yapzhenyie.GadgetsMenu.cosmetics.morphs.MorphType;
import com.yapzhenyie.GadgetsMenu.cosmetics.particles.ParticleType;
import com.yapzhenyie.GadgetsMenu.cosmetics.pets.PetType;
import com.yapzhenyie.GadgetsMenu.cosmetics.suits.SuitEquipmentType;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.GInventory;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandPermission
extends SubCommand {
    public CommandPermission() {
        super("/gmenu permission <cosmetic|commands> [page]", "Gives a list of all permissions.", null, "gadgetsmenu.commands.permission", new String[]{"permission", "permissions", "perm"}, true);
    }

    @Override
    protected void onCommandPlayer(Player sender, String[] args) {
        this.onCommand((CommandSender)sender, args);
    }

    @Override
    protected void onOtherCommandSender(CommandSender sender, String[] args) {
        this.onCommand(sender, args);
    }

    private void onCommand(CommandSender sender, String[] args) {
        if (args.length > 3) {
            CommandManager.printMessage(sender, this);
            return;
        }
        String type = Types.COMMANDS.getName();
        if (args.length >= 2) {
            for (Types list : Types.values()) {
                if (!list.getName().equalsIgnoreCase(args[1])) continue;
                type = list.getName();
            }
            if (type == Types.COMMANDS.getName() && !args[1].equalsIgnoreCase("commands")) {
                CommandManager.printMessage(sender, this);
                sender.sendMessage(ChatUtil.format("&bCosmetics&e: &c&lCommands, Hats, Animated_Hats, Particles, Suits, Gadgets, Pets, Morphs, Banners, Emotes, Cloaks"));
                return;
            }
        }
        int size = this.getSize(type);
        int maxPages = GInventory.getMaxPagesAmount(8, size);
        int page = 1;
        if (args.length == 3) {
            try {
                page = Integer.parseInt(args[2]);
            }
            catch (NumberFormatException ex) {
                page = 1;
                sender.sendMessage(MessageType.REQUIRED_NUMBER_FORMAT.getFormatMessage());
                return;
            }
            if (Integer.valueOf(args[2]) > maxPages) {
                page = 1;
            }
        }
        int from = 1;
        if (page > 1) {
            from = 8 * (page - 1) + 1;
            if (type == Types.COMMANDS.getName()) {
                from = 8 * (page - 1) + 3;
            }
        }
        int to = 8;
        if (size < 8) {
            to = size;
        }
        if (page > 1) {
            if (size >= 8 * page) {
                to = 8 * page;
                if (type == Types.COMMANDS.getName()) {
                    to = 8 * page + 2;
                }
            } else {
                to = size;
                if (type == Types.COMMANDS.getName()) {
                    to = size + 2;
                }
            }
        }
        int num = 1;
        if (page > 1) {
            num = 8 * (page - 1) + 1;
        }
        sender.sendMessage(ChatUtil.format("&e---------------&fPermission: " + type.toLowerCase().substring(0, 1).toUpperCase() + type.toLowerCase().substring(1) + "&e---------------&b[" + page + "/" + maxPages + "]"));
        for (int it = from; it <= to; ++it) {
            try {
                if (this.getPermission(type, it) == null) {
                    ++to;
                    continue;
                }
                sender.sendMessage(ChatUtil.format(num++ + ". " + this.hasPermission(sender, this.getPermission(type, it)) + this.getPermission(type, it)));
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (page >= maxPages) {
            if (page > 1 && maxPages > 1) {
                sender.sendMessage(ChatUtil.format("&3Use &b/menu permission " + type.toLowerCase() + " " + (maxPages - 1) + " &3to display page " + (maxPages - 1) + "!"));
            }
        } else {
            sender.sendMessage(ChatUtil.format("&3Use &b/menu permission " + type.toLowerCase() + " " + (page + 1) + " &3to display page " + (page + 1) + "!"));
        }
        sender.sendMessage(ChatUtil.format("&7More Permissions: &bhttp://bit.ly/GadgetsMenu-Permissions"));
    }

    private String hasPermission(CommandSender sender, String permission) {
        if (sender.hasPermission(permission)) {
            return "&e";
        }
        return "&c";
    }

    private String getPermission(String type, int h) {
        switch (type) {
            case "commands": {
                int size = CommandManager.subCmds.size();
                if (h <= size) {
                    SubCommand cmds = CommandManager.subCmds.get(h - 1);
                    return cmds.getPermission();
                }
                if (h > size && h <= size + com.yapzhenyie.GadgetsMenu.command.mysterydust.CommandManager.subCmds.size()) {
                    com.yapzhenyie.GadgetsMenu.command.mysterydust.SubCommand mysteryDustcmds = com.yapzhenyie.GadgetsMenu.command.mysterydust.CommandManager.subCmds.get(h - 1 - size);
                    return mysteryDustcmds.getPermission();
                }
                if (h > size + com.yapzhenyie.GadgetsMenu.command.mysterydust.CommandManager.subCmds.size()) {
                    com.yapzhenyie.GadgetsMenu.command.mysteryboxes.SubCommand mysteryBoxcmds = com.yapzhenyie.GadgetsMenu.command.mysteryboxes.CommandManager.subCmds.get(h - 1 - size - com.yapzhenyie.GadgetsMenu.command.mysterydust.CommandManager.subCmds.size());
                    return mysteryBoxcmds.getPermission();
                }
            }
            case "hats": {
                HatType hat = HatType.values().get(h - 1);
                return hat.getPermission();
            }
            case "animated_hats": {
                AnimatedHatType animatedHat = AnimatedHatType.values().get(h - 1);
                return animatedHat.getPermission();
            }
            case "particles": {
                ParticleType particle = ParticleType.values().get(h - 1);
                return particle.getPermission();
            }
            case "suits": {
                SuitEquipmentType suit = SuitEquipmentType.values().get(h - 1);
                return suit.getPermission();
            }
            case "gadgets": {
                GadgetType gadget = GadgetType.values().get(h - 1);
                return gadget.getPermission();
            }
            case "pets": {
                PetType pet = PetType.values().get(h - 1);
                return pet.getPermission();
            }
            case "morphs": {
                MorphType morph = MorphType.values().get(h - 1);
                return morph.getPermission();
            }
            case "banners": {
                BannerType banner = BannerType.values().get(h - 1);
                return banner.getPermission();
            }
            case "emotes": {
                EmoteType emote = EmoteType.values().get(h - 1);
                return emote.getPermission();
            }
            case "cloaks": {
                CloakType cloak = CloakType.values().get(h - 1);
                return cloak.getPermission();
            }
        }
        return null;
    }

    private int getSize(String type) {
        int size = 0;
        switch (type) {
            case "commands": {
                size = CommandManager.subCmds.size();
                for (int i = 1; i <= CommandManager.subCmds.size(); ++i) {
                    if (CommandManager.subCmds.get(i - 1).getPermission() != null) continue;
                    --size;
                }
                size += com.yapzhenyie.GadgetsMenu.command.mysterydust.CommandManager.subCmds.size();
                size += com.yapzhenyie.GadgetsMenu.command.mysteryboxes.CommandManager.subCmds.size();
                break;
            }
            case "hats": {
                size = HatType.values().size();
                break;
            }
            case "animated_hats": {
                size = AnimatedHatType.values().size();
                break;
            }
            case "particles": {
                size = ParticleType.values().size();
                break;
            }
            case "suits": {
                size = SuitEquipmentType.values().size();
                break;
            }
            case "gadgets": {
                size = GadgetType.values().size();
                break;
            }
            case "pets": {
                size = PetType.values().size();
                break;
            }
            case "morphs": {
                size = MorphType.values().size();
                break;
            }
            case "banners": {
                size = BannerType.values().size();
                break;
            }
            case "emotes": {
                size = EmoteType.values().size();
                break;
            }
            case "cloaks": {
                size = CloakType.values().size();
            }
        }
        return size;
    }

    private static enum Types {
        COMMANDS("commands"),
        HATS("hats"),
        ANIMATED_HATS("animated_hats"),
        PARTICLES("particles"),
        SUITS("suits"),
        GADGETS("gadgets"),
        PETS("pets"),
        MORPHS("morphs"),
        BANNERS("banners"),
        EMOTES("emotes"),
        CLOAKS("cloaks");

        private String name;

        private Types(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

