/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.command.main.subcommands;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.command.main.CommandManager;
import com.yapzhenyie.GadgetsMenu.command.main.SubCommand;
import com.yapzhenyie.GadgetsMenu.economy.GStorage;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.PluginUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CommandReload
extends SubCommand {
    public CommandReload() {
        super("/gmenu reload <confirm>", "Reload the plugin.", null, "gadgetsmenu.commands.reload", new String[]{"reload", "rl"}, true);
    }

    @Override
    protected void onCommandPlayer(Player sender, String[] args) {
        this.onCommand((CommandSender)sender, args);
    }

    @Override
    protected void onOtherCommandSender(CommandSender sender, String[] args) {
        this.onCommand(sender, args);
    }

    private void onCommand(CommandSender sender, String[] args) {
        if (args.length > 2) {
            CommandManager.printMessage(sender, this);
            return;
        }
        if (GStorage.isCustomStorage(GadgetsMenu.getGadgetsMenuData().getMysteryDustStorage())) {
            sender.sendMessage(ChatUtil.format("&cYou're not allowed to reload the plugin as you're using custom economy storage!"));
            return;
        }
        if (args.length != 2 || !args[1].equalsIgnoreCase("confirm")) {
            sender.sendMessage(ChatUtil.format("&cAre you sure you want to reload the plugin? Doing so may cause bugs and memory leaks. To confirm the usage, please type &e/gmenu reload confirm"));
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)GadgetsMenu.getInstance(), () -> {
            sender.sendMessage(ChatUtil.format("&cUse this command in your own risk! It might cause bugs and memory leaks."));
            sender.sendMessage(MessageType.RELOADING_PLUGIN.getFormatMessage());
            try {
                boolean loaded = PluginUtils.reload(Bukkit.getServer().getPluginManager().getPlugin("GadgetsMenu"));
                if (!loaded) {
                    sender.sendMessage(MessageType.ERROR.getFormatMessage());
                    return;
                }
                sender.sendMessage(MessageType.PLUGIN_RELOADED.getFormatMessage());
            }
            catch (Exception e) {
                sender.sendMessage(MessageType.FAILED_TO_RELOAD_PLUGIN.getFormatMessage());
                e.printStackTrace();
            }
        });
    }
}

