/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.command.mysteryboxes;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.command.mysteryboxes.SubCommand;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.GInventory;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.WorldUtils;
import java.util.ArrayList;
import java.util.Arrays;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CommandManager
implements CommandExecutor {
    public static ArrayList<SubCommand> subCmds = new ArrayList();
    public static ArrayList<SubCommand> consoleSubCmds = new ArrayList();

    public CommandManager(Plugin plugin) {
        plugin.getServer().getPluginCommand("gmysteryboxes").setExecutor((CommandExecutor)this);
        String[] aliases = new String[]{"gmysterybox", "gmb"};
        plugin.getServer().getPluginCommand("gmysteryboxes").setAliases(Arrays.asList(aliases));
    }

    public void registerCommand(SubCommand subCommand) {
        if (!subCmds.contains(subCommand)) {
            subCmds.add(subCommand);
        }
        if (subCommand.canConsoleUse() && !consoleSubCmds.contains(subCommand)) {
            consoleSubCmds.add(subCommand);
        }
    }

    public static void printMessage(CommandSender sender, String usage, String description, String hoverText, boolean header) {
        if (header) {
            sender.sendMessage(ChatUtil.format("&e---------------&fHelp: Mystery Boxes&e---------------"));
        }
        if (sender instanceof Player) {
            if (hoverText == null) {
                hoverText = description;
            }
            GadgetsMenu.getNMSManager().newJSONMessage(ChatUtil.format(" &e" + usage + " &b- " + description)).suggestCommand(usage).showText(ChatUtil.format("&b" + usage + "\n&7" + hoverText)).send((Player)sender);
        } else {
            sender.sendMessage(ChatUtil.format(" &e" + usage + " &b- " + description));
        }
    }

    public static void printMessage(CommandSender sender, SubCommand subCommand) {
        sender.sendMessage(ChatUtil.format("&e---------------&fHelp: Mystery Boxes&e---------------"));
        if (sender instanceof Player) {
            GadgetsMenu.getNMSManager().newJSONMessage(ChatUtil.format(" &e" + subCommand.getUsage() + " &b- " + subCommand.getDescription())).suggestCommand(subCommand.getUsage()).showText(ChatUtil.format("&b" + subCommand.getUsage() + "\n&7" + subCommand.getHoverText())).send((Player)sender);
        } else {
            sender.sendMessage(ChatUtil.format(" &e" + subCommand.getUsage() + " &b- " + subCommand.getDescription()));
        }
    }

    public static void printHelpMessage(CommandSender sender, int page) {
        int maxPages = GInventory.getMaxPagesAmount(8, subCmds.size());
        int consoleMaxPages = GInventory.getMaxPagesAmount(8, consoleSubCmds.size());
        int size = sender instanceof Player ? subCmds.size() : consoleSubCmds.size();
        int from = 1;
        if (page > 1) {
            from = 8 * (page - 1) + 1;
        }
        int to = 8;
        if (size < 8) {
            to = size;
        }
        if (page > 1) {
            to = size >= 8 * page ? 8 * page : size;
        }
        if (sender instanceof Player) {
            sender.sendMessage(ChatUtil.format("&e---------------&fHelp: Mystery Boxes&e--------------- &f(" + page + "/" + maxPages + ")"));
            for (int h = from; h <= to && h <= subCmds.size(); ++h) {
                SubCommand cmds = subCmds.get(h - 1);
                GadgetsMenu.getNMSManager().newJSONMessage(ChatUtil.format(" &e" + cmds.getUsage() + " &b- " + cmds.getDescription())).suggestCommand(cmds.getUsage()).showText(ChatUtil.format("&b" + cmds.getUsage() + "\n&7" + cmds.getHoverText())).send((Player)sender);
            }
        } else {
            sender.sendMessage(ChatUtil.format("&e---------------&fHelp: Mystery Boxes&e--------------- &f(" + page + "/" + consoleMaxPages + ")"));
            for (int h = from; h <= to && h <= consoleSubCmds.size(); ++h) {
                SubCommand cmds = consoleSubCmds.get(h - 1);
                if (!cmds.canConsoleUse()) {
                    cmds = consoleSubCmds.get(h);
                    ++to;
                    continue;
                }
                sender.sendMessage(ChatUtil.format(" &e" + cmds.getUsage() + " &b- " + cmds.getDescription()));
            }
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        if (!(sender instanceof Player) && !(sender instanceof CommandSender)) {
            sender.sendMessage(MessageType.COMING_SOON.getFormatMessage());
            return true;
        }
        if (!GadgetsMenu.getGadgetsMenuData().isMysteryBoxesEnabled()) {
            sender.sendMessage(MessageType.MYSTERY_BOXES_ARE_DISABLED.getFormatMessage());
            return true;
        }
        if (args == null || args.length == 0) {
            if (sender instanceof Player) {
                if (!WorldUtils.isWorldEnabled((Player)sender, true)) {
                    return true;
                }
                CommandManager.printHelpMessage((CommandSender)((Player)sender), 1);
            } else {
                CommandManager.printHelpMessage(sender, 1);
            }
            return true;
        }
        for (SubCommand subcmd : subCmds) {
            if (!subcmd.contains(args[0])) continue;
            if (sender instanceof Player && !WorldUtils.isWorldEnabled((Player)sender, true)) {
                return true;
            }
            if (subcmd.getPermission() != null && !sender.hasPermission(subcmd.getPermission())) {
                sender.sendMessage(MessageType.NO_PERMISSION.getFormatMessage().replace("{PERMISSION}", subcmd.getPermission()));
                return true;
            }
            if (sender instanceof Player) {
                subcmd.onCommandPlayer((Player)sender, args);
            } else if (sender instanceof CommandSender) {
                subcmd.onOtherCommandSender(sender, args);
            } else {
                subcmd.notAllowed(sender);
            }
            return true;
        }
        if (sender instanceof Player) {
            if (!WorldUtils.isWorldEnabled((Player)sender, true)) {
                return true;
            }
            CommandManager.printHelpMessage((CommandSender)((Player)sender), 1);
        } else {
            CommandManager.printHelpMessage(sender, 1);
        }
        return true;
    }
}

