/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.command.mysteryboxes.subcommand;

import com.yapzhenyie.GadgetsMenu.command.mysteryboxes.CommandManager;
import com.yapzhenyie.GadgetsMenu.command.mysteryboxes.SubCommand;
import com.yapzhenyie.GadgetsMenu.utils.BlockUtil;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.mysteryvault.MysteryVault;
import com.yapzhenyie.GadgetsMenu.utils.mysteryvault.MysteryVaultAPI;
import com.yapzhenyie.GadgetsMenu.utils.mysteryvault.MysteryVaultManager;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;

public class CommandMode
extends SubCommand {
    public CommandMode() {
        super("/gmysteryboxes mode", "Shows the commands to manipulate mystery vault.", null, "gadgetsmenu.mysteryboxes.mode", new String[]{"mode", "setup", "edit"}, false);
    }

    @Override
    protected void onCommandPlayer(Player sender, String[] args) {
        if (args.length < 2) {
            CommandMode.printMessages(sender);
            return;
        }
        if (args[1].equalsIgnoreCase("add-vault") || args[1].equalsIgnoreCase("create")) {
            if (args.length != 3) {
                CommandManager.printMessage((CommandSender)sender, "/gmysteryboxes mode add-vault <vaultName>", "Create a mystery vault.", null, true);
                return;
            }
            Location location = BlockUtil.getTargetBlock(sender, 5).getLocation();
            if (location.getBlock().getType() == Material.AIR) {
                sender.sendMessage(MessageType.TARGET_A_BLOCK.getFormatMessage());
                return;
            }
            BlockFace blockFace = BlockUtil.getTargetBlockBlockFace(sender, 5);
            String name = args[2];
            Pattern p = Pattern.compile("[^A-Za-z0-9 && [^_]]");
            Matcher m = p.matcher(name);
            if (m.find()) {
                sender.sendMessage(ChatUtil.format(MessageType.DOES_NOT_SUPPORT_CHARACTERS.getFormatMessage()));
                return;
            }
            for (MysteryVault vault : MysteryVaultManager.vaults()) {
                if (vault.getName().equalsIgnoreCase(name)) {
                    sender.sendMessage(MessageType.MYSTERY_VAULT_IS_EXISTS.getFormatMessage());
                    return;
                }
                if (vault.getLocation() == null || !vault.getLocation().equals((Object)location)) continue;
                sender.sendMessage(MessageType.MYSTERY_VAULT_SAME_LOCATION.getFormatMessage());
                return;
            }
            MysteryVault mysteryVault = MysteryVaultAPI.mysteryVault(name, blockFace, location);
            mysteryVault.saveToDatabase();
            mysteryVault.createHolograms();
            sender.sendMessage(MessageType.ADDED_A_MYSTERY_VAULT.getFormatMessage().replace("{NAME}", name));
        } else if (args[1].equalsIgnoreCase("info") || args[1].equalsIgnoreCase("infomation")) {
            if (args.length != 3) {
                CommandManager.printMessage((CommandSender)sender, "/gmysteryboxes mode info <vaultName>", "Show the info of the mystery vault.", null, true);
                return;
            }
            String name = args[2];
            if (MysteryVaultManager.vaults().size() == 0) {
                sender.sendMessage(MessageType.DO_NOT_HAVE_ANY_MYSTERY_VAULT.getFormatMessage());
                return;
            }
            MysteryVault vault = MysteryVaultManager.getVaultByName(name);
            if (vault == null) {
                sender.sendMessage(MessageType.MYSTERY_VAULT_NOT_FOUND_WITH_NAME.getFormatMessage().replace("{NAME}", name));
                return;
            }
            Location location = vault.getLocation();
            sender.sendMessage(ChatUtil.format("&e---------------&fMystery Vault Info&e---------------"));
            sender.sendMessage(ChatUtil.format("&7- &r&l" + vault.getName() + " &7at world: \"" + location.getWorld().getName() + "\" x: " + location.getX() + ", y: " + location.getY() + ", z: " + location.getZ() + " (BlockFace: " + vault.getBlockFace().toString() + ")"));
        } else if (args[1].equalsIgnoreCase("list")) {
            if (args.length != 2) {
                CommandManager.printMessage((CommandSender)sender, "/gmysteryboxes mode list", "List all available mystery vaults.", null, true);
                return;
            }
            if (MysteryVaultManager.vaults().size() == 0) {
                sender.sendMessage(MessageType.DO_NOT_HAVE_ANY_MYSTERY_VAULT.getFormatMessage());
                return;
            }
            sender.sendMessage(ChatUtil.format("&e---------------&fMystery Vault List&e---------------"));
            for (MysteryVault vault : MysteryVaultManager.vaults()) {
                Location location = vault.getLocation();
                if (location == null || location.getWorld() == null) continue;
                sender.sendMessage(ChatUtil.format("&7- &r&l" + vault.getName() + " &7at world: \"" + location.getWorld().getName() + "\" x: " + location.getX() + ", y: " + location.getY() + ", z: " + location.getZ() + " (BlockFace: " + vault.getBlockFace().toString() + ")"));
            }
        } else if (args[1].equalsIgnoreCase("near")) {
            if (args.length != 3) {
                CommandManager.printMessage((CommandSender)sender, "/gmysteryboxes mode near <radius>", "Get a list of near mystery vault.", null, true);
                return;
            }
            if (MysteryVaultManager.vaults().size() == 0) {
                sender.sendMessage(MessageType.DO_NOT_HAVE_ANY_MYSTERY_VAULT.getFormatMessage());
                return;
            }
            try {
                Integer.parseInt(args[2]);
            }
            catch (NumberFormatException ex) {
                sender.sendMessage(MessageType.REQUIRED_NUMBER_FORMAT.getFormatMessage());
                return;
            }
            int radius = Integer.parseInt(args[2]);
            if (radius <= 0) {
                sender.sendMessage(MessageType.REQUIRED_POSITIVE_NUMBER.getFormatMessage());
                return;
            }
            int radiusSquared = radius * radius;
            boolean found = false;
            sender.sendMessage(ChatUtil.format("&e---------------&fNear Mystery Vault&e---------------"));
            for (MysteryVault vault : MysteryVaultManager.vaults()) {
                Location location = vault.getLocation();
                if (location == null || !location.getWorld().equals(sender.getLocation().getWorld()) || !(location.distanceSquared(sender.getLocation()) <= (double)radiusSquared)) continue;
                sender.sendMessage(ChatUtil.format("&7- &r&l" + vault.getName() + "&7 x: " + location.getX() + ", y: " + location.getY() + ", z: " + location.getZ() + " (BlockFace: " + vault.getBlockFace().toString() + ")"));
                if (found) continue;
                found = true;
            }
            if (!found) {
                sender.sendMessage(MessageType.NO_MYSTERY_VAULT_NEARBY.getFormatMessage());
                return;
            }
        } else if (args[1].equalsIgnoreCase("redefine") || args[1].equalsIgnoreCase("relocate")) {
            if (args.length != 3) {
                CommandManager.printMessage((CommandSender)sender, "/gmysteryboxes mode redefine <vaultName>", "Redefine mystery vault location.", null, true);
                return;
            }
            Location location = BlockUtil.getTargetBlock(sender, 5).getLocation();
            if (location.getBlock().getType() == Material.AIR) {
                sender.sendMessage(MessageType.TARGET_A_BLOCK.getFormatMessage());
                return;
            }
            BlockFace blockFace = BlockUtil.getTargetBlockBlockFace(sender, 5);
            String name = args[2];
            if (MysteryVaultManager.vaults().size() == 0) {
                sender.sendMessage(MessageType.DO_NOT_HAVE_ANY_MYSTERY_VAULT.getFormatMessage());
                return;
            }
            MysteryVault mysteryVault = MysteryVaultManager.getVaultByName(name);
            if (mysteryVault == null) {
                sender.sendMessage(MessageType.MYSTERY_VAULT_NOT_FOUND_WITH_NAME.getFormatMessage().replace("{NAME}", name));
                return;
            }
            for (MysteryVault vault : MysteryVaultManager.vaults()) {
                if (vault.getLocation() == null || vault.getName().equalsIgnoreCase(name) || !vault.getLocation().equals((Object)location)) continue;
                sender.sendMessage(MessageType.MYSTERY_VAULT_SAME_LOCATION.getFormatMessage());
                return;
            }
            mysteryVault.updateLocation(blockFace, location);
            mysteryVault.removeHolograms();
            mysteryVault.removeIndividualHologram();
            mysteryVault.createHolograms();
            mysteryVault.createIndividualHologram();
            sender.sendMessage(MessageType.REDEFINED_A_MYSTERY_VAULT.getFormatMessage().replace("{NAME}", name));
        } else if (args[1].equalsIgnoreCase("remove-vault") || args[1].equalsIgnoreCase("remove")) {
            if (args.length == 2) {
                Location location = BlockUtil.getTargetBlock(sender, 5).getLocation();
                if (MysteryVaultManager.vaults().size() == 0) {
                    sender.sendMessage(MessageType.DO_NOT_HAVE_ANY_MYSTERY_VAULT.getFormatMessage());
                    return;
                }
                MysteryVault vault = MysteryVaultManager.getVaultByLocation(location);
                if (vault != null) {
                    vault.delete();
                    sender.sendMessage(MessageType.REMOVED_MYSTERY_VAULT.getFormatMessage().replace("{NAME}", vault.getName()));
                    return;
                }
                sender.sendMessage(MessageType.MYSTERY_VAULT_NOT_FOUND.getFormatMessage());
                return;
            }
            if (args.length == 3) {
                String name = args[2];
                if (MysteryVaultManager.vaults().size() == 0) {
                    sender.sendMessage(MessageType.DO_NOT_HAVE_ANY_MYSTERY_VAULT.getFormatMessage());
                    return;
                }
                if (name.startsWith("r:")) {
                    try {
                        Integer.parseInt(name.replace("r:", ""));
                    }
                    catch (NumberFormatException ex) {
                        sender.sendMessage(MessageType.REQUIRED_NUMBER_FORMAT.getFormatMessage());
                        return;
                    }
                    int radius = Integer.valueOf(name.replace("r:", ""));
                    if (radius <= 0) {
                        sender.sendMessage(MessageType.REQUIRED_POSITIVE_NUMBER.getFormatMessage());
                        return;
                    }
                    int radiusSquared = radius * radius;
                    boolean found = false;
                    for (MysteryVault vault : MysteryVaultManager.vaults()) {
                        Location location = vault.getLocation();
                        if (location == null || location.getWorld() == null || !location.getWorld().equals(sender.getLocation().getWorld()) || !(location.distanceSquared(sender.getLocation()) <= (double)radiusSquared) || vault == null) continue;
                        vault.delete();
                        sender.sendMessage(MessageType.REMOVED_MYSTERY_VAULT.getFormatMessage().replace("{NAME}", vault.getName()));
                        if (found) break;
                        found = true;
                        break;
                    }
                    if (!found) {
                        sender.sendMessage(MessageType.NO_MYSTERY_VAULT_NEARBY.getFormatMessage());
                        return;
                    }
                    return;
                }
                MysteryVault vault = MysteryVaultManager.getVaultByName(name);
                if (vault == null) {
                    sender.sendMessage(MessageType.MYSTERY_VAULT_NOT_FOUND_WITH_NAME.getFormatMessage().replace("{NAME}", name));
                    return;
                }
                vault.delete();
                sender.sendMessage(MessageType.REMOVED_MYSTERY_VAULT.getFormatMessage().replace("{NAME}", name));
                return;
            }
            CommandManager.printMessage((CommandSender)sender, "/gmysteryboxes mode remove-vault [vaultName|r:{radius}]", "Remove a mystery vault.", "Remove a mystery vault.\n\n&7End with the command 'r:{radius}', will remove\n&7mystery vault in given radius.", true);
        } else if (args[1].equalsIgnoreCase("tp") || args[1].equalsIgnoreCase("teleport")) {
            if (args.length != 3) {
                CommandManager.printMessage((CommandSender)sender, "/gmysteryboxes mode teleport <vaultName>", "Teleport player to the given mystery vault.", null, true);
                return;
            }
            String name = args[2];
            if (MysteryVaultManager.vaults().size() == 0) {
                sender.sendMessage(MessageType.DO_NOT_HAVE_ANY_MYSTERY_VAULT.getFormatMessage());
                return;
            }
            MysteryVault vault = MysteryVaultManager.getVaultByName(name);
            if (vault == null) {
                sender.sendMessage(MessageType.MYSTERY_VAULT_NOT_FOUND_WITH_NAME.getFormatMessage().replace("{NAME}", name));
                return;
            }
            sender.teleport(vault.getLocation().clone().add(0.5, 1.2, 0.5), PlayerTeleportEvent.TeleportCause.PLUGIN);
            sender.sendMessage(MessageType.TELEPORTED_TO_MYSTERY_VAULT.getFormatMessage().replace("{NAME}", vault.getName()));
        } else {
            CommandMode.printMessages(sender);
        }
    }

    @Override
    protected void onOtherCommandSender(CommandSender sender, String[] args) {
        this.notAllowed(sender);
    }

    private static void printMessages(Player sender) {
        CommandManager.printMessage((CommandSender)sender, "/gmysteryboxes mode", "Shows the commands to manipulate mystery vault.", null, true);
        CommandManager.printMessage((CommandSender)sender, "/gmysteryboxes mode add-vault <vaultName>", "Create a mystery vault.", null, false);
        CommandManager.printMessage((CommandSender)sender, "/gmysteryboxes mode info <vaultName>", "Show the info of the mystery vault.", null, false);
        CommandManager.printMessage((CommandSender)sender, "/gmysteryboxes mode list", "List all available mystery vaults.", null, false);
        CommandManager.printMessage((CommandSender)sender, "/gmysteryboxes mode near <radius>", "Get a list of near mystery vault.", null, false);
        CommandManager.printMessage((CommandSender)sender, "/gmysteryboxes mode redefine <vaultName>", "Redefine mystery vault location.", null, false);
        CommandManager.printMessage((CommandSender)sender, "/gmysteryboxes mode remove-vault [vaultName|r:{radius}]", "Remove a mystery vault.", "Remove a mystery vault.\n\n&7End with the command 'r:{radius}', will remove\n&7mystery vault in given radius.", false);
        CommandManager.printMessage((CommandSender)sender, "/gmysteryboxes mode teleport <vaultName>", "Teleport player to the given mystery vault.", null, false);
    }
}

