/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.command.mysterydust.subcommands;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.command.mysterydust.CommandManager;
import com.yapzhenyie.GadgetsMenu.command.mysterydust.SubCommand;
import com.yapzhenyie.GadgetsMenu.player.OfflinePlayerManager;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CommandPayMysteryDust
extends SubCommand {
    public CommandPayMysteryDust() {
        super("/mysterydust pay <player> <amount>", "Transfer mystery dust to a player.", "Transfer mystery dust to a player.\n\n&7End with the command 'msg=false', won't send\n&7message to the player when they receive\n&7mystery dust.", "gadgetsmenu.mysterydust.pay", new String[]{"pay", "transfer"}, false);
    }

    @Override
    protected void onCommandPlayer(Player sender, String[] args) {
        if (args.length != 3 && args.length != 4) {
            CommandManager.printMessage((CommandSender)sender, this);
            return;
        }
        int selfMysteryDust = GadgetsMenu.getPlayerManager(sender).getMysteryDust();
        if (selfMysteryDust <= 0) {
            sender.sendMessage(MessageType.PLAYER_NOT_ENOUGH_MYSTERY_DUST.getFormatMessage().replace("{MYSTERY_DUST}", String.valueOf(selfMysteryDust)));
            return;
        }
        Player target = sender.getServer().getPlayer(args[1]);
        if (target == null) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)GadgetsMenu.getInstance(), () -> this.offlinePlayerCommand(sender, args));
        } else {
            if (!target.isOnline()) {
                sender.sendMessage(MessageType.PLAYER_NOT_FOUND.getFormatMessage());
                return;
            }
            if (target == sender) {
                sender.sendMessage(MessageType.PAY_MYSTERY_DUST_TO_SELF.getFormatMessage());
                return;
            }
            try {
                Integer.parseInt(args[2]);
            }
            catch (NumberFormatException e) {
                sender.sendMessage(MessageType.REQUIRED_NUMBER_FORMAT.getFormatMessage());
                return;
            }
            int mysteryDust = Integer.parseInt(args[2]);
            if (mysteryDust <= 0) {
                sender.sendMessage(MessageType.REQUIRED_POSITIVE_NUMBER.getFormatMessage());
                return;
            }
            if (mysteryDust > selfMysteryDust) {
                sender.sendMessage(MessageType.PLAYER_NOT_ENOUGH_MYSTERY_DUST.getFormatMessage().replace("{MYSTERY_DUST}", String.valueOf(selfMysteryDust)));
                return;
            }
            GadgetsMenu.getPlayerManager(sender).removeMysteryDust(mysteryDust);
            GadgetsMenu.getPlayerManager(target).addMysteryDust(mysteryDust);
            sender.sendMessage(MessageType.PLAYER_SENT_MYSTERY_DUST.getFormatMessage().replace("{MYSTERY_DUST}", String.valueOf(mysteryDust)).replace("{PLAYER}", target.getName()));
            sender.sendMessage(MessageType.REMOVED_MYSTERY_DUST_FROM_PLAYER.getFormatMessage().replace("{MYSTERY_DUST}", String.valueOf(mysteryDust)));
            if (args.length == 4 && args[3].equalsIgnoreCase("msg=false")) {
                return;
            }
            target.sendMessage(MessageType.PLAYER_RECEIVED_MYSTERY_DUST.getFormatMessage().replace("{MYSTERY_DUST}", String.valueOf(mysteryDust)).replace("{PLAYER}", sender.getName()));
        }
    }

    @Override
    protected void onOtherCommandSender(CommandSender sender, String[] args) {
        this.notAllowed(sender);
    }

    private boolean offlinePlayerCommand(Player sender, String[] args) {
        int selfMysteryDust;
        OfflinePlayerManager oPlayerManager = null;
        if (sender.getServer().getPlayer(args[1]) == null) {
            OfflinePlayer oPlayer = Bukkit.getOfflinePlayer((String)args[1]);
            if (!GadgetsMenu.getDatabaseManager().getDatabaseUtils().isExist(oPlayer)) {
                sender.sendMessage(MessageType.PLAYER_NOT_FOUND.getFormatMessage());
                return false;
            }
            oPlayerManager = new OfflinePlayerManager(oPlayer.getUniqueId());
        }
        if ((selfMysteryDust = GadgetsMenu.getPlayerManager(sender).getMysteryDust()) <= 0) {
            sender.sendMessage(MessageType.PLAYER_NOT_ENOUGH_MYSTERY_DUST.getFormatMessage().replace("{MYSTERY_DUST}", String.valueOf(selfMysteryDust)));
            return false;
        }
        try {
            Integer.parseInt(args[2]);
        }
        catch (NumberFormatException e) {
            sender.sendMessage(MessageType.REQUIRED_NUMBER_FORMAT.getFormatMessage());
            return false;
        }
        int mysteryDust = Integer.parseInt(args[2]);
        if (mysteryDust <= 0) {
            sender.sendMessage(MessageType.REQUIRED_POSITIVE_NUMBER.getFormatMessage());
            return false;
        }
        if (mysteryDust > selfMysteryDust) {
            sender.sendMessage(MessageType.PLAYER_NOT_ENOUGH_MYSTERY_DUST.getFormatMessage().replace("{MYSTERY_DUST}", String.valueOf(selfMysteryDust)));
            return false;
        }
        if (oPlayerManager.getPlayer().getName() == sender.getName()) {
            sender.sendMessage(MessageType.PAY_MYSTERY_DUST_TO_SELF.getFormatMessage());
            return false;
        }
        GadgetsMenu.getPlayerManager(sender).removeMysteryDust(mysteryDust);
        oPlayerManager.addMysteryDust(mysteryDust);
        sender.sendMessage(MessageType.PLAYER_SENT_MYSTERY_DUST.getFormatMessage().replace("{MYSTERY_DUST}", String.valueOf(mysteryDust)).replace("{PLAYER}", oPlayerManager.getName()));
        sender.sendMessage(MessageType.REMOVED_MYSTERY_DUST_FROM_PLAYER.getFormatMessage().replace("{MYSTERY_DUST}", String.valueOf(mysteryDust)));
        return true;
    }
}

