/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.command.mysterydust.subcommands;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.command.mysterydust.CommandManager;
import com.yapzhenyie.GadgetsMenu.command.mysterydust.SubCommand;
import com.yapzhenyie.GadgetsMenu.player.OfflinePlayerManager;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CommandSetMysteryDust
extends SubCommand {
    public CommandSetMysteryDust() {
        super("/mysterydust set <player> <amount>", "Sets a player's mystery dust.", "Sets a player's mystery dust.\n\n&7End with the command 'msg=false', won't send\n&7message to the player when their mystery dust\n&7has been changed.", "gadgetsmenu.mysterydust.set", new String[]{"set"}, true);
    }

    @Override
    protected void onCommandPlayer(Player sender, String[] args) {
        this.onCommand((CommandSender)sender, args);
    }

    @Override
    protected void onOtherCommandSender(CommandSender sender, String[] args) {
        this.onCommand(sender, args);
    }

    private void onCommand(CommandSender sender, String[] args) {
        if (args.length != 3 && args.length != 4) {
            CommandManager.printMessage(sender, this);
            return;
        }
        Player target = sender.getServer().getPlayer(args[1]);
        if (target == null) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)GadgetsMenu.getInstance(), () -> this.offlinePlayerCommand(sender, args));
        } else {
            if (!target.isOnline()) {
                sender.sendMessage(MessageType.PLAYER_NOT_FOUND.getFormatMessage());
                return;
            }
            try {
                Integer.parseInt(args[2]);
            }
            catch (NumberFormatException e) {
                sender.sendMessage(MessageType.REQUIRED_NUMBER_FORMAT.getFormatMessage());
                return;
            }
            int mysteryDust = Integer.parseInt(args[2]);
            if (mysteryDust < 0) {
                sender.sendMessage(MessageType.REQUIRED_POSITIVE_NUMBER.getFormatMessage());
                return;
            }
            GadgetsMenu.getPlayerManager(target).setMysteryDust(mysteryDust);
            sender.sendMessage(MessageType.PLAYER_SET_MYSTERY_DUST.getFormatMessage().replace("{MYSTERY_DUST}", String.valueOf(mysteryDust)).replace("{PLAYER}", target.getName()));
            if (args.length == 4 && args[3].equalsIgnoreCase("msg=false")) {
                return;
            }
            target.sendMessage(MessageType.SET_PLAYER_MYSTERY_DUST.getFormatMessage().replace("{MYSTERY_DUST}", String.valueOf(mysteryDust)));
        }
    }

    private boolean offlinePlayerCommand(CommandSender sender, String[] args) {
        OfflinePlayerManager oPlayerManager = null;
        if (sender.getServer().getPlayer(args[1]) == null) {
            OfflinePlayer oPlayer = Bukkit.getOfflinePlayer((String)args[1]);
            if (!GadgetsMenu.getDatabaseManager().getDatabaseUtils().isExist(oPlayer)) {
                sender.sendMessage(MessageType.PLAYER_NOT_FOUND.getFormatMessage());
                return false;
            }
            oPlayerManager = new OfflinePlayerManager(oPlayer.getUniqueId());
        }
        try {
            Integer.parseInt(args[2]);
        }
        catch (NumberFormatException e) {
            sender.sendMessage(MessageType.REQUIRED_NUMBER_FORMAT.getFormatMessage());
            return false;
        }
        int mysteryDust = Integer.parseInt(args[2]);
        if (mysteryDust < 0) {
            sender.sendMessage(MessageType.REQUIRED_POSITIVE_NUMBER.getFormatMessage());
            return false;
        }
        oPlayerManager.setMysteryDust(mysteryDust);
        sender.sendMessage(MessageType.PLAYER_SET_MYSTERY_DUST.getFormatMessage().replace("{MYSTERY_DUST}", String.valueOf(mysteryDust)).replace("{PLAYER}", oPlayerManager.getName()));
        return true;
    }
}

