/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.configuration;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.configuration.CustomConfiguration;
import com.yapzhenyie.GadgetsMenu.configuration.FileManager;
import com.yapzhenyie.GadgetsMenu.database.query.SelectQuery;
import com.yapzhenyie.GadgetsMenu.log.LoggerManager;
import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;

public class OldConfigurationManager {
    private static CustomConfiguration config = FileManager.getConfigFile();
    private static FileManager messages = FileManager.getMessagesFile();
    private static FileManager mysteryVault = FileManager.getMysteryVaultFile();
    private static boolean executed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void migrateUserData(boolean migrateMysteryDust) {
        if (executed) {
            return;
        }
        executed = true;
        long startTime = System.currentTimeMillis();
        int migrated = 0;
        File folder = new File(GadgetsMenu.getInstance().getDataFolder(), "/userdata");
        if (folder.exists()) {
            LoggerManager.printLogWithHeader(LoggerManager.LogLevel.INFO, "------------------------------------------------------", "Migrating user's data from flat file to SQLite.", "Processing in async task, it might takes a while.");
            File[] list = (File[])new File(GadgetsMenu.getInstance().getDataFolder(), "/userdata/").listFiles().clone();
            LoggerManager.info("There are " + list.length + " file(s) waiting for migration.");
            SelectQuery sQuery = null;
            ResultSet rs = null;
            String name = "unknown";
            String uuid = "unknown";
            int mysteryDust = 0;
            int mysteryGiftPacks = 0;
            int mysteryGiftSent = 0;
            int mysteryGiftReceived = 0;
            String petName = "pet";
            boolean selfMorphView = true;
            boolean bypassCooldown = false;
            String recentLootsFound = "";
            String mysteryVaultAnimation = "Normal";
            String hat = "none";
            String animatedHat = "none";
            String particle = "none";
            String suitHelmet = "none";
            String suitChestplate = "none";
            String suitLeggings = "none";
            String suitBoots = "none";
            String gadget = "none";
            String pet = "none";
            String morph = "none";
            String banner = "none";
            String emote = "none";
            String cloak = "none";
            int uid = -1;
            for (File userFile : list) {
                if ((float)migrated % (float)(list.length / 10) == 0.0f) {
                    LoggerManager.info("Files migrated: " + (int)((float)migrated / (float)list.length * 100.0f) + "%");
                }
                if (userFile.getName().contains("broken")) {
                    LoggerManager.info(userFile.getName() + " file is broken. Skipping this file...");
                    continue;
                }
                FileConfiguration file = FileManager.loadConfiguration(userFile);
                if (file == null) {
                    LoggerManager.warn("Failed to migrate a user data to SQLite database! (File Corrupted) Skipping this file...");
                    continue;
                }
                if (file.get("Name") != null) {
                    name = file.getString("Name");
                }
                if (file.get("UUID") != null) {
                    uuid = file.getString("UUID");
                }
                if (migrateMysteryDust && file.get("Mystery Dust") != null) {
                    mysteryDust = file.getInt("Mystery Dust");
                }
                if (file.get("Mystery-Gift.Gift-Packs") != null) {
                    mysteryGiftPacks = file.getInt("Mystery-Gift.Gift-Packs");
                }
                if (file.get("Mystery-Gift.Gift-Sent") != null) {
                    mysteryGiftSent = file.getInt("Mystery-Gift.Gift-Sent");
                }
                if (file.get("Mystery-Gift.Gift-Received") != null) {
                    mysteryGiftReceived = file.getInt("Mystery-Gift.Gift-Received");
                }
                if (file.get("Settings.Pet-Name") != null) {
                    petName = file.getString("Settings.Pet-Name");
                }
                if (file.get("Settings.Self-Morph-View") != null) {
                    selfMorphView = file.getBoolean("Settings.Self-Morph-View");
                }
                if (file.get("Settings.Bypass-Cooldown") != null) {
                    bypassCooldown = file.getBoolean("Settings.Bypass-Cooldown");
                }
                if (file.get("Recent-Loots-Found") != null) {
                    recentLootsFound = file.getString("Recent-Loots-Found");
                }
                if (file.get("Settings.Mystery-Vault-Animation") != null) {
                    mysteryVaultAnimation = file.getString("Settings.Mystery-Vault-Animation");
                }
                if (file.get("Selected-Cosmetics.Hat") != null) {
                    hat = file.getString("Selected-Cosmetics.Hat");
                }
                if (file.get("Selected-Cosmetics.Animated-Hat") != null) {
                    animatedHat = file.getString("Selected-Cosmetics.Animated-Hat");
                }
                if (file.get("Selected-Cosmetics.Particle") != null) {
                    particle = file.getString("Selected-Cosmetics.Particle");
                }
                if (file.get("Selected-Cosmetics.Suits.Helmet") != null) {
                    suitHelmet = file.getString("Selected-Cosmetics.Suits.Helmet");
                }
                if (file.get("Selected-Cosmetics.Suits.Chestplate") != null) {
                    suitChestplate = file.getString("Selected-Cosmetics.Suits.Chestplate");
                }
                if (file.get("Selected-Cosmetics.Suits.Leggings") != null) {
                    suitLeggings = file.getString("Selected-Cosmetics.Suits.Leggings");
                }
                if (file.get("Selected-Cosmetics.Suits.Boots") != null) {
                    suitBoots = file.getString("Selected-Cosmetics.Suits.Boots");
                }
                if (file.get("Selected-Cosmetics.Gadget") != null) {
                    gadget = file.getString("Selected-Cosmetics.Gadget");
                }
                if (file.get("Selected-Cosmetics.Pet") != null) {
                    pet = file.getString("Selected-Cosmetics.Pet");
                }
                if (file.get("Selected-Cosmetics.Morph") != null) {
                    morph = file.getString("Selected-Cosmetics.Morph");
                }
                if (file.get("Selected-Cosmetics.Banner") != null) {
                    banner = file.getString("Selected-Cosmetics.Banner");
                }
                if (file.get("Selected-Cosmetics.Emote") != null) {
                    emote = file.getString("Selected-Cosmetics.Emote");
                }
                if (file.get("Selected-Cosmetics.Cloak") != null) {
                    cloak = file.getString("Selected-Cosmetics.Cloak");
                }
                if (uuid == "unknown") {
                    LoggerManager.warn("Failed to migrate a user data to SQLite database! (Unknown UUID) Skipping this file...");
                    continue;
                }
                sQuery = GadgetsMenu.getDatabaseManager().getTable().select().where("UUID", uuid);
                rs = sQuery.execute();
                try {
                    if (!rs.next()) {
                        GadgetsMenu.getDatabaseManager().getTable().insert().insert("UUID, Name, Mystery_Dust, Mystery_Gift_Packs, Mystery_Gift_Sent, Mystery_Gift_Received, Pet_Name, Self_Morph_View, Bypass_Cooldown, Recent_Loots_Found, Mystery_Vault_Animation, Selected_Hat, Selected_Animated_Hat, Selected_Particle, Selected_Suit_Helmet, Selected_Suit_Chestplate, Selected_Suit_Leggings, Selected_Suit_Boots, Selected_Gadget, Selected_Pet, Selected_Morph, Selected_Banner, Selected_Emote, Selected_Cloak").value(uuid).value(name).value(mysteryDust).value(mysteryGiftPacks).value(mysteryGiftSent).value(mysteryGiftReceived).value(petName).value(selfMorphView ? "true" : "false").value(bypassCooldown ? "true" : "false").value(recentLootsFound).value(mysteryVaultAnimation).value(hat).value(animatedHat).value(particle).value(suitHelmet).value(suitChestplate).value(suitLeggings).value(suitBoots).value(gadget).value(pet).value(morph).value(banner).value(emote).value(cloak).execute();
                    } else {
                        GadgetsMenu.getDatabaseManager().getTable().update().set("Mystery_Dust", mysteryDust).set("Mystery_Gift_Packs", mysteryGiftPacks).set("Mystery_Gift_Sent", mysteryGiftSent).set("Mystery_Gift_Received", mysteryGiftReceived).set("Pet_Name", petName).set("Self_Morph_View", selfMorphView ? "true" : "false").set("Bypass_Cooldown", bypassCooldown ? "true" : "false").set("Recent_Loots_Found", recentLootsFound).set("Mystery_Vault_Animation", mysteryVaultAnimation).set("Selected_Hat", hat).set("Selected_Animated_Hat", animatedHat).set("Selected_Particle", particle).set("Selected_Suit_Helmet", suitHelmet).set("Selected_Suit_Chestplate", suitChestplate).set("Selected_Suit_Leggings", suitLeggings).set("Selected_Suit_Boots", suitBoots).set("Selected_Gadget", gadget).set("Selected_Pet", pet).set("Selected_Morph", morph).set("Selected_Banner", banner).set("Selected_Emote", emote).set("Selected_Cloak", cloak).where("UUID", uuid).execute();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                finally {
                    if (sQuery != null) {
                        sQuery.close();
                    }
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                }
                try {
                    sQuery = GadgetsMenu.getDatabaseManager().getTable().select().where("UUID", uuid.toString());
                    rs = sQuery.execute();
                    rs.next();
                    uid = rs.getInt("id");
                }
                catch (SQLException sQLException) {
                }
                finally {
                    if (sQuery != null) {
                        sQuery.close();
                    }
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                }
                if (uid == -1) {
                    LoggerManager.warn("Failed to migrate a user data to SQLite database! (Unknown UID) Skipping this file...");
                    continue;
                }
                if (file.get("Mystery-Boxes") != null) {
                    for (String loot : file.getStringList("Mystery-Boxes")) {
                        GadgetsMenu.getDatabaseManager().getMysteryBoxesTable().insert().insert("UUID, UID, Loots").value(uuid).value(uid).value(loot).execute();
                    }
                }
                userFile.delete();
                ++migrated;
            }
            boolean removeFolder = false;
            if (list.length == migrated) {
                removeFolder = true;
                folder.delete();
            }
            long consume = System.currentTimeMillis() - startTime;
            LoggerManager.info("----------------------------------");
            LoggerManager.info("Successful migrated " + migrated + " users.");
            LoggerManager.info(list.length - migrated + " file(s) failed to migrate.");
            if (removeFolder) {
                LoggerManager.info("Removed userdata folder.");
            }
            LoggerManager.info("Time elapsed " + consume + " ms.");
            LoggerManager.info("Migrated completed!");
            LoggerManager.info("----------------------------------");
        }
    }

    public static void transferMessages() {
        if (config.get("Config Version") != null) {
            File cosmetics;
            File oldFile = new File(GadgetsMenu.getInstance().getDataFolder(), "/cosmetics/hats.yml");
            File newFile = new File(GadgetsMenu.getInstance().getDataFolder(), "/categories/hats.yml");
            if (newFile.exists()) {
                newFile.delete();
            }
            if (oldFile.exists()) {
                oldFile.renameTo(newFile);
                oldFile.delete();
            }
            oldFile = new File(GadgetsMenu.getInstance().getDataFolder(), "/cosmetics/particles.yml");
            newFile = new File(GadgetsMenu.getInstance().getDataFolder(), "/categories/particles.yml");
            if (newFile.exists()) {
                newFile.delete();
            }
            if (oldFile.exists()) {
                oldFile.renameTo(newFile);
                oldFile.delete();
            }
            oldFile = new File(GadgetsMenu.getInstance().getDataFolder(), "/cosmetics/suits.yml");
            newFile = new File(GadgetsMenu.getInstance().getDataFolder(), "/categories/suits.yml");
            if (newFile.exists()) {
                newFile.delete();
            }
            if (oldFile.exists()) {
                oldFile.renameTo(newFile);
                oldFile.delete();
            }
            oldFile = new File(GadgetsMenu.getInstance().getDataFolder(), "/cosmetics/gadgets.yml");
            newFile = new File(GadgetsMenu.getInstance().getDataFolder(), "/categories/gadgets.yml");
            if (newFile.exists()) {
                newFile.delete();
            }
            if (oldFile.exists()) {
                oldFile.renameTo(newFile);
                oldFile.delete();
            }
            oldFile = new File(GadgetsMenu.getInstance().getDataFolder(), "/cosmetics/pets.yml");
            newFile = new File(GadgetsMenu.getInstance().getDataFolder(), "/categories/pets.yml");
            if (newFile.exists()) {
                newFile.delete();
            }
            if (oldFile.exists()) {
                oldFile.renameTo(newFile);
                oldFile.delete();
            }
            oldFile = new File(GadgetsMenu.getInstance().getDataFolder(), "/cosmetics/morphs.yml");
            newFile = new File(GadgetsMenu.getInstance().getDataFolder(), "/categories/morphs.yml");
            if (newFile.exists()) {
                newFile.delete();
            }
            if (oldFile.exists()) {
                oldFile.renameTo(newFile);
                oldFile.delete();
            }
            oldFile = new File(GadgetsMenu.getInstance().getDataFolder(), "/cosmetics/banners.yml");
            newFile = new File(GadgetsMenu.getInstance().getDataFolder(), "/categories/banners.yml");
            if (newFile.exists()) {
                newFile.delete();
            }
            if (oldFile.exists()) {
                oldFile.renameTo(newFile);
                oldFile.delete();
            }
            oldFile = new File(GadgetsMenu.getInstance().getDataFolder(), "/cosmetics/emotes.yml");
            newFile = new File(GadgetsMenu.getInstance().getDataFolder(), "/categories/emotes.yml");
            if (newFile.exists()) {
                newFile.delete();
            }
            if (oldFile.exists()) {
                oldFile.renameTo(newFile);
                oldFile.delete();
            }
            oldFile = new File(GadgetsMenu.getInstance().getDataFolder(), "/cosmetics/cloaks.yml");
            newFile = new File(GadgetsMenu.getInstance().getDataFolder(), "/categories/cloaks.yml");
            if (newFile.exists()) {
                newFile.delete();
            }
            if (oldFile.exists()) {
                oldFile.renameTo(newFile);
                oldFile.delete();
            }
            oldFile = new File(GadgetsMenu.getInstance().getDataFolder(), "/cosmetics/mainmenu.yml");
            newFile = new File(GadgetsMenu.getInstance().getDataFolder(), "/categories/mainmenu.yml");
            if (newFile.exists()) {
                newFile.delete();
            }
            if (oldFile.exists()) {
                oldFile.renameTo(newFile);
                oldFile.delete();
            }
            oldFile = new File(GadgetsMenu.getInstance().getDataFolder(), "/songs/BroadcastRadioGadget");
            newFile = new File(GadgetsMenu.getInstance().getDataFolder(), "/songs/RadioGadget");
            if (newFile.exists()) {
                newFile.delete();
            }
            if (oldFile.exists()) {
                oldFile.renameTo(newFile);
                oldFile.delete();
            }
            if ((cosmetics = new File(GadgetsMenu.getInstance().getDataFolder(), "/cosmetics")).exists()) {
                cosmetics.delete();
            }
            File oldMysteryVaultFile = new File(GadgetsMenu.getInstance().getDataFolder(), "/Mystery Vault.yml");
            File newMysteryVaultFile = new File(GadgetsMenu.getInstance().getDataFolder(), "/mystery vaults.yml");
            if (newMysteryVaultFile.exists()) {
                newMysteryVaultFile.delete();
            }
            if (oldMysteryVaultFile.exists()) {
                oldMysteryVaultFile.renameTo(newMysteryVaultFile);
                oldMysteryVaultFile.delete();
                FileManager.getMysteryVaultFile().reload();
                FileManager.getMysteryVaultFile().save();
            }
            if (config.get("GadgetsMenu") != null) {
                if (config.get("GadgetsMenu.Prefix") != null) {
                    messages.set("Prefix", config.getString("GadgetsMenu.Prefix"));
                }
                if (config.get("GadgetsMenu.GUI") != null) {
                    if (config.get("GadgetsMenu.GUI.MainMenu") != null) {
                        messages.set("GUI-Menus.Main", config.getString("GadgetsMenu.GUI.MainMenu"));
                    }
                    if (config.get("GadgetsMenu.GUI.Hats") != null) {
                        messages.set("GUI-Menus.Hats", config.getString("GadgetsMenu.GUI.Hats"));
                    }
                    if (config.get("GadgetsMenu.GUI.Particles") != null) {
                        messages.set("GUI-Menus.Particles", config.getString("GadgetsMenu.GUI.Particles"));
                    }
                    if (config.get("GadgetsMenu.GUI.Suits") != null) {
                        messages.set("GUI-Menus.Suits", config.getString("GadgetsMenu.GUI.Suits"));
                    }
                    if (config.get("GadgetsMenu.GUI.Gadgets") != null) {
                        messages.set("GUI-Menus.Gadgets", config.getString("GadgetsMenu.GUI.Gadgets"));
                    }
                    if (config.get("GadgetsMenu.GUI.Pets") != null) {
                        messages.set("GUI-Menus.Pets", config.getString("GadgetsMenu.GUI.Pets"));
                    }
                    if (config.get("GadgetsMenu.GUI.Morphs") != null) {
                        messages.set("GUI-Menus.Morphs", config.getString("GadgetsMenu.GUI.Morphs"));
                    }
                    if (config.get("GadgetsMenu.GUI.Banners") != null) {
                        messages.set("GUI-Menus.Banners", config.getString("GadgetsMenu.GUI.Banners"));
                    }
                    if (config.get("GadgetsMenu.GUI.Emotes") != null) {
                        messages.set("GUI-Menus.Emotes", config.getString("GadgetsMenu.GUI.Emotes"));
                    }
                    if (config.get("GadgetsMenu.GUI.Cloaks") != null) {
                        messages.set("GUI-Menus.Cloaks", config.getString("GadgetsMenu.GUI.Cloaks"));
                    }
                }
                if (config.get("GadgetsMenu.Settings") != null) {
                    if (config.get("GadgetsMenu.Settings.Default Pet Name") != null) {
                        config.set("Settings.Default-Pet-Name", config.getString("GadgetsMenu.Settings.Default Pet Name"));
                    }
                    if (config.get("Purchase System.Starter Mystery Dust") != null) {
                        config.set("Settings.Starting-Mystery-Dust", config.getInt("Purchase System.Starter Mystery Dust"));
                    }
                    if (config.get("GadgetsMenu.Settings.Max-Name-Pet-Length") != null) {
                        config.set("Settings.Max-Pet-Name-Characters", config.getInt("GadgetsMenu.Settings.Max-Name-Pet-Length"));
                    }
                    if (config.get("GadgetsMenu.Settings.Gadget-Slot") != null) {
                        config.set("Settings.Gadget-Slot", config.getInt("GadgetsMenu.Settings.Gadget-Slot"));
                    }
                }
            }
            if (config.get("Player-Data") != null && config.get("Player-Data.Database") != null) {
                config.set("Player-Data.Storage", config.getBoolean("Player-Data.Database") ? "mysql" : "file");
            }
            if (config.get("Purchase System") != null) {
                if (config.get("Purchase System.Enabled") != null) {
                    config.set("Cosmetic-Item-Purchase.Enabled", config.getBoolean("Purchase System.Enabled"));
                }
                if (config.get("Purchase System.Storage") != null) {
                    config.set("Cosmetic-Item-Purchase.Mystery-Dust-Storage", config.getString("Purchase System.Storage"));
                }
                if (config.get("Purchase System.Enabled Cosmetics") != null) {
                    if (config.get("Purchase System.Enabled Cosmetics.Hats") != null) {
                        config.set("Cosmetic-Item-Purchase.Enabled-Cosmetics.Hats", config.getBoolean("Purchase System.Enabled Cosmetics.Hats"));
                    }
                    if (config.get("Purchase System.Enabled Cosmetics.Particles") != null) {
                        config.set("Cosmetic-Item-Purchase.Enabled-Cosmetics.Particles", config.getBoolean("Purchase System.Enabled Cosmetics.Particles"));
                    }
                    if (config.get("Purchase System.Enabled Cosmetics.Suits") != null) {
                        config.set("Cosmetic-Item-Purchase.Enabled-Cosmetics.Suits", config.getBoolean("Purchase System.Enabled Cosmetics.Suits"));
                    }
                    if (config.get("Purchase System.Enabled Cosmetics.Gadgets") != null) {
                        config.set("Cosmetic-Item-Purchase.Enabled-Cosmetics.Gadgets", config.getBoolean("Purchase System.Enabled Cosmetics.Gadgets"));
                    }
                    if (config.get("Purchase System.Enabled Cosmetics.Pets") != null) {
                        config.set("Cosmetic-Item-Purchase.Enabled-Cosmetics.Pets", config.getBoolean("Purchase System.Enabled Cosmetics.Pets"));
                    }
                    if (config.get("Purchase System.Enabled Cosmetics.Morphs") != null) {
                        config.set("Cosmetic-Item-Purchase.Enabled-Cosmetics.Morphs", config.getBoolean("Purchase System.Enabled Cosmetics.Morphs"));
                    }
                    if (config.get("Purchase System.Enabled Cosmetics.Banners") != null) {
                        config.set("Cosmetic-Item-Purchase.Enabled-Cosmetics.Banners", config.getBoolean("Purchase System.Enabled Cosmetics.Banners"));
                    }
                    if (config.get("Purchase System.Enabled Cosmetics.Emotes") != null) {
                        config.set("Cosmetic-Item-Purchase.Enabled-Cosmetics.Emotes", config.getBoolean("Purchase System.Enabled Cosmetics.Emotes"));
                    }
                    if (config.get("Purchase System.Enabled Cosmetics.Cloaks") != null) {
                        config.set("Cosmetic-Item-Purchase.Enabled-Cosmetics.Cloaks", config.getBoolean("Purchase System.Enabled Cosmetics.Cloaks"));
                    }
                }
                if (config.get("Purchase System.Run-Command") != null) {
                    config.set("Cosmetic-Item-Purchase.Execute-Command", config.getString("Purchase System.Run-Command"));
                }
                if (config.get("Purchase System.Lore") != null) {
                    if (config.get("Purchase System.Lore.Enough Mystery Dust") != null) {
                        messages.set("Items.Enough-Mystery-Dust.Lore", config.getStringList("Purchase System.Lore.Enough Mystery Dust"));
                    }
                    if (config.get("Purchase System.Lore.Not Enough Mystery Dust") != null) {
                        messages.set("Items.Not-Enough-Mystery-Dust.Lore", config.getStringList("Purchase System.Lore.Not Enough Mystery Dust"));
                    }
                    if (config.get("Purchase System.Lore.Item Unpurchasable") != null) {
                        messages.set("Items.Item-Unpurchasable.Lore", config.getStringList("Purchase System.Lore.Item Unpurchasable"));
                    }
                }
            }
            if (config.get("Menu Item") != null) {
                if (config.get("Menu Item.Name") != null) {
                    config.set("Menu-Item.Name", config.getString("Menu Item.Name"));
                }
                if (config.get("Menu Item.Material") != null) {
                    config.set("Menu-Item.Material", config.getString("Menu Item.Material"));
                }
                if (config.get("Menu Item.Slot") != null) {
                    config.set("Menu-Item.Slot", config.getInt("Menu Item.Slot"));
                }
                if (config.get("Menu Item.Give Item") != null) {
                    config.set("Menu-Item.Give-On-Join", config.getBoolean("Menu Item.Give Item"));
                }
                if (config.get("Menu Item.Able to Move") != null) {
                    config.set("Menu-Item.Able-To-Move", config.getBoolean("Menu Item.Able to Move"));
                }
            }
            if (config.get("Enabled Worlds") != null) {
                config.set("Enabled-Worlds", config.getStringList("Enabled Worlds"));
            }
            if (config.get("Disabled Cosmetics") != null) {
                if (config.get("Disabled Cosmetics.Hats") != null) {
                    config.set("Disabled-Cosmetics.Hats", config.getBoolean("Disabled Cosmetics.Hats"));
                }
                if (config.get("Disabled Cosmetics.Particles") != null) {
                    config.set("Disabled-Cosmetics.Particles", config.getBoolean("Disabled Cosmetics.Particles"));
                }
                if (config.get("Disabled Cosmetics.Suits") != null) {
                    config.set("Disabled-Cosmetics.Suits", config.getBoolean("Disabled Cosmetics.Suits"));
                }
                if (config.get("Disabled Cosmetics.Gadgets") != null) {
                    config.set("Disabled-Cosmetics.Gadgets", config.getBoolean("Disabled Cosmetics.Gadgets"));
                }
                if (config.get("Disabled Cosmetics.Pets") != null) {
                    config.set("Disabled-Cosmetics.Pets", config.getBoolean("Disabled Cosmetics.Pets"));
                }
                if (config.get("Disabled Cosmetics.Morphs") != null) {
                    config.set("Disabled-Cosmetics.Morphs", config.getBoolean("Disabled Cosmetics.Morphs"));
                }
                if (config.get("Disabled Cosmetics.Banners") != null) {
                    config.set("Disabled-Cosmetics.Banners", config.getBoolean("Disabled Cosmetics.Banners"));
                }
                if (config.get("Disabled Cosmetics.Emotes") != null) {
                    config.set("Disabled-Cosmetics.Emotes", config.getBoolean("Disabled Cosmetics.Emotes"));
                }
                if (config.get("Disabled Cosmetics.Cloaks") != null) {
                    config.set("Disabled-Cosmetics.Cloaks", config.getBoolean("Disabled Cosmetics.Cloaks"));
                }
            }
            if (config.get("Close GUI Menu After Select") != null) {
                if (config.get("Close GUI Menu After Select.No Permission") != null) {
                    config.set("Permission.No-Permission.Close-GUI-Menu-After-Select", config.getBoolean("Close GUI Menu After Select.No Permission"));
                }
                if (config.get("Close GUI Menu After Select.Select") != null) {
                    config.set("Permission.Has-Permission.Close-GUI-Menu-After-Select", config.getBoolean("Close GUI Menu After Select.Select"));
                }
            }
            if (config.get("Permission") != null) {
                if (config.get("Permission.No Permission") != null) {
                    if (config.get("Permission.No Permission.Material") != null) {
                        config.set("Permission.No-Permission.Show-Custom-Item.Material", config.getString("Permission.No Permission.Material"));
                    }
                    if (config.get("Permission.No Permission.Play Sound.Enabled") != null) {
                        config.set("Permission.No-Permission.Play-Sound.Enabled", config.getBoolean("Permission.No Permission.Play Sound.Enabled"));
                    }
                    if (config.get("Permission.No Permission.Play Sound.Sound") != null) {
                        config.set("Permission.No-Permission.Play-Sound.Sound", config.getString("Permission.No Permission.Play Sound.Sound"));
                    }
                    if (config.get("Permission.No Permission.Lore") != null && !config.getString("Permission.No Permission.Lore").equals("")) {
                        config.set("Permission.No-Permission.Lore", config.getStringList("Permission.No Permission.Lore"));
                    }
                }
                if (config.get("Permission.Has Permission") != null) {
                    if (config.get("Permission.Has Permission.Play Sound.Enabled") != null) {
                        config.set("Permission.Has-Permission.Play-Sound.Enabled", config.getBoolean("Permission.Has Permission.Play Sound.Enabled"));
                    }
                    if (config.get("Permission.Has Permission.Play Sound.Sound") != null) {
                        config.set("Permission.Has-Permission.Play-Sound.Sound", config.getString("Permission.Has Permission.Play Sound.Sound"));
                    }
                    if (config.get("Permission.Has Permission.Lore") != null && !config.getString("Permission.Has Permission.Lore").equals("")) {
                        config.set("Permission.Has-Permission.Lore", config.getStringList("Permission.Has Permission.Lore"));
                    }
                }
            }
            if (config.get("Check Update") != null) {
                config.set("Check-Update", config.getBoolean("Check Update"));
            }
            if (config.get("Auto Update") != null) {
                config.set("Auto-Update", config.getBoolean("Auto Update"));
            }
            if (mysteryVault.get("Mystery Vault") != null) {
                for (String name : mysteryVault.getConfigurationSection("Mystery Vault").getKeys(false)) {
                    if (mysteryVault.get("Mystery Vault." + name + ".BlockFace") != null) {
                        mysteryVault.set("Mystery-Vaults." + name + ".BlockFace", mysteryVault.getString("Mystery Vault." + name + ".BlockFace"));
                    }
                    if (mysteryVault.get("Mystery Vault." + name + ".Location.world") != null) {
                        mysteryVault.set("Mystery-Vaults." + name + ".Location.world", mysteryVault.getString("Mystery Vault." + name + ".Location.world"));
                    }
                    if (mysteryVault.get("Mystery Vault." + name + ".Location.x") != null) {
                        mysteryVault.set("Mystery-Vaults." + name + ".Location.x", mysteryVault.getDouble("Mystery Vault." + name + ".Location.x"));
                    }
                    if (mysteryVault.get("Mystery Vault." + name + ".Location.y") != null) {
                        mysteryVault.set("Mystery-Vaults." + name + ".Location.y", mysteryVault.getDouble("Mystery Vault." + name + ".Location.y"));
                    }
                    if (mysteryVault.get("Mystery Vault." + name + ".Location.z") == null) continue;
                    mysteryVault.set("Mystery-Vaults." + name + ".Location.z", mysteryVault.getDouble("Mystery Vault." + name + ".Location.z"));
                }
            }
            if (messages.get("Items") != null) {
                if (messages.get("Items.Go Back") != null) {
                    if (messages.get("Items.Go Back.Name") != null) {
                        messages.set("Items.Go-Back.Name", messages.getString("Items.Go Back.Name"));
                    }
                    if (messages.get("Items.Go Back.Material") != null) {
                        messages.set("Items.Go-Back.Material", messages.getString("Items.Go Back.Material"));
                    }
                    if (messages.get("Items.Go Back.Show") != null) {
                        messages.set("Items.Go-Back.Show", messages.getBoolean("Items.Go Back.Show"));
                    }
                    if (messages.get("Items.Go Back.Lore") != null && !messages.getString("Items.Go Back.Lore").equals("")) {
                        messages.set("Items.Go-Back.Lore", messages.getStringList("Items.Go Back.Lore"));
                    }
                }
                if (messages.get("Items.Previous Page") != null) {
                    if (messages.get("Items.Previous Page.Name") != null) {
                        messages.set("Items.Previous-Page.Name", messages.getString("Items.Previous Page.Name"));
                    }
                    if (messages.get("Items.Previous Page.Material") != null) {
                        messages.set("Items.Previous-Page.Material", messages.getString("Items.Previous Page.Material"));
                    }
                }
                if (messages.get("Items.Next Page") != null) {
                    if (messages.get("Items.Next Page.Name") != null) {
                        messages.set("Items.Next-Page.Name", messages.getString("Items.Next Page.Name"));
                    }
                    if (messages.get("Items.Next Page.Material") != null) {
                        messages.set("Items.Next-Page.Material", messages.getString("Items.Next Page.Material"));
                    }
                }
                if (messages.get("Items.Already Selected") != null) {
                    if (messages.get("Items.Already Selected.Show in Lore") != null) {
                        messages.set("Items.Already-Selected.Show-In-Lore", messages.getBoolean("Items.Already Selected.Show in Lore"));
                    }
                    if (messages.get("Items.Already Selected.Lore") != null && !messages.getString("Items.Already Selected.Lore").equals("")) {
                        messages.set("Items.Already-Selected.Lore", messages.getStringList("Items.Already Selected.Lore"));
                    }
                }
                if (messages.get("Items.Click To Select") != null) {
                    if (messages.get("Items.Click To Select.Show in Lore") != null) {
                        messages.set("Items.Click-To-Select.Show-In-Lore", messages.getBoolean("Items.Click To Select.Show in Lore"));
                    }
                    if (messages.get("Items.Click To Select.Lore") != null && !messages.getString("Items.Click To Select.Lore").equals("")) {
                        messages.set("Items.Click-To-Select.Lore", messages.getStringList("Items.Click To Select.Lore"));
                    }
                }
                if (messages.get("Items.Unlocked") != null && messages.get("Items.Unlocked.Show in Lore") != null) {
                    messages.set("Items.Unlocked.Show-In-Lore", messages.getBoolean("Items.Unlocked.Show in Lore"));
                }
                if (messages.get("Items.MainMenu Button") != null) {
                    if (messages.get("Items.MainMenu Button.Name") != null) {
                        messages.set("Items.MainMenu-Item.Name", messages.getString("Items.MainMenu Button.Name"));
                    }
                    if (messages.get("Items.MainMenu Button.Material") != null) {
                        messages.set("Items.MainMenu-Item.Material", messages.getString("Items.MainMenu Button.Material"));
                    }
                    if (messages.get("Items.MainMenu Button.Show") != null) {
                        messages.set("Items.MainMenu-Item.Show", messages.getBoolean("Items.MainMenu Button.Show"));
                    }
                    if (messages.get("Items.MainMenu Button.Lore") != null && !messages.getString("Items.MainMenu Button.Lore").equals("")) {
                        messages.set("Items.MainMenu-Item.Lore", messages.getStringList("Items.MainMenu Button.Lore"));
                    }
                }
                if (messages.get("Items.Morph Slimeball") != null) {
                    messages.set("Items.Morph-Slimeball.Name", messages.getString("Items.Morph Slimeball.Name"));
                }
                if (messages.get("Items.Morphs Self View") != null) {
                    if (messages.get("Items.Morphs Self View.Name") != null) {
                        messages.set("Items.Self-Morph-View.Name", messages.getString("Items.Morphs Self View.Name"));
                    }
                    if (messages.get("Items.Morphs Self View.Material") != null) {
                        messages.set("Items.Self-Morph-View.Material", messages.getString("Items.Morphs Self View.Material"));
                    }
                    if (messages.get("Items.Morphs Self View.Show") != null) {
                        messages.set("Items.Self-Morph-View.Show", messages.getBoolean("Items.Morphs Self View.Show"));
                    }
                    if (messages.get("Items.Morphs Self View.Lore") != null && !messages.getString("Items.Morphs Self View.Lore").equals("")) {
                        messages.set("Items.Self-Morph-View.Lore", messages.getStringList("Items.Morphs Self View.Lore"));
                    }
                }
                if (messages.get("Items.Rename Pet") != null) {
                    if (messages.get("Items.Rename Pet.Name") != null) {
                        messages.set("Items.Rename-Pet.Name", messages.getString("Items.Rename Pet.Name"));
                    }
                    if (messages.get("Items.Rename Pet.Material") != null) {
                        messages.set("Items.Rename-Pet.Material", messages.getString("Items.Rename Pet.Material"));
                    }
                    if (messages.get("Items.Rename Pet.Show") != null) {
                        messages.set("Items.Rename-Pet.Show", messages.getBoolean("Items.Rename Pet.Show"));
                    }
                    if (messages.get("Items.Rename Pet.Lore") != null && !messages.getString("Items.Rename Pet.Lore").equals("")) {
                        messages.set("Items.Rename-Pet.Lore", messages.getStringList("Items.Rename Pet.Lore"));
                    }
                }
            }
            if (messages.get("Reset Button") != null) {
                if (messages.get("Reset Button.") != null) {
                    if (messages.get("Reset Button.Reset Cosmetics.Name") != null) {
                        messages.set("Reset-Buttons.Reset-Cosmetics.Name", messages.getString("Reset Button.Reset Cosmetics.Name"));
                    }
                    if (messages.get("Reset Button.Reset Cosmetics.Material") != null) {
                        messages.set("Reset-Buttons.Reset-Cosmetics.Material", messages.getString("Reset Button.Reset Cosmetics.Material"));
                    }
                    if (messages.get("Reset Button.Reset Cosmetics.Show") != null) {
                        messages.set("Reset-Buttons.Reset-Cosmetics.Show", messages.getBoolean("Reset Button.Reset Cosmetics.Show"));
                    }
                    if (messages.get("Reset Button.Reset Cosmetics.Lore") != null && !messages.getString("Reset Button.Reset Cosmetics.Lore").equals("")) {
                        messages.set("Reset-Buttons.Reset-Cosmetics.Lore", messages.getStringList("Reset Button.Reset Cosmetics.Lore"));
                    }
                    if (messages.get("Reset Button.Reset Cosmetics.Play Sound.Enabled") != null) {
                        messages.set("Reset-Buttons.Reset-Cosmetics.Play-Sound.Enabled", messages.getBoolean("Reset Button.Reset Cosmetics.Play Sound.Enabled"));
                    }
                    if (messages.get("Reset Button.Reset Cosmetics.Play Sound.Sound") != null) {
                        messages.set("Reset-Buttons.Reset-Cosmetics.Play-Sound.Sound", messages.getString("Reset Button.Reset Cosmetics.Play Sound.Sound"));
                    }
                }
                if (messages.get("Reset Button.Reset Hat") != null) {
                    if (messages.get("Reset Button.Reset Hat.Name") != null) {
                        messages.set("Reset-Buttons.Reset-Hat.Name", messages.getString("Reset Button.Reset Hat.Name"));
                    }
                    if (messages.get("Reset Button.Reset Hat.Material") != null) {
                        messages.set("Reset-Buttons.Reset-Hat.Material", messages.getString("Reset Button.Reset Hat.Material"));
                    }
                    if (messages.get("Reset Button.Reset Hat.Show") != null) {
                        messages.set("Reset-Buttons.Reset-Hat.Show", messages.getBoolean("Reset Button.Reset Hat.Show"));
                    }
                    if (messages.get("Reset Button.Reset Hat.Lore") != null && !messages.getString("Reset Button.Reset Hat.Lore").equals("")) {
                        messages.set("Reset-Buttons.Reset-Hat.Lore", messages.getStringList("Reset Button.Reset Hat.Lore"));
                    }
                    if (messages.get("Reset Button.Reset Hat.Play Sound.Enabled") != null) {
                        messages.set("Reset-Buttons.Reset-Hat.Play-Sound.Enabled", messages.getBoolean("Reset Button.Reset Hat.Play Sound.Enabled"));
                    }
                    if (messages.get("Reset Button.Reset Hat.Play Sound.Sound") != null) {
                        messages.set("Reset-Buttons.Reset-Hat.Play-Sound.Sound", messages.getString("Reset Button.Reset Hat.Play Sound.Sound"));
                    }
                }
                if (messages.get("Reset Button.Reset Particle") != null) {
                    if (messages.get("Reset Button.Reset Particle.Name") != null) {
                        messages.set("Reset-Buttons.Reset-Particle.Name", messages.getString("Reset Button.Reset Particle.Name"));
                    }
                    if (messages.get("Reset Button.Reset Particle.Material") != null) {
                        messages.set("Reset-Buttons.Reset-Particle.Material", messages.getString("Reset Button.Reset Particle.Material"));
                    }
                    if (messages.get("Reset Button.Reset Particle.Show") != null) {
                        messages.set("Reset-Buttons.Reset-Particle.Show", messages.getBoolean("Reset Button.Reset Particle.Show"));
                    }
                    if (messages.get("Reset Button.Reset Particle.Lore") != null && !messages.getString("Reset Button.Reset Particle.Lore").equals("")) {
                        messages.set("Reset-Buttons.Reset-Particle.Lore", messages.getStringList("Reset Button.Reset Particle.Lore"));
                    }
                    if (messages.get("Reset Button.Reset Particle.Play Sound.Enabled") != null) {
                        messages.set("Reset-Buttons.Reset-Particle.Play-Sound.Enabled", messages.getBoolean("Reset Button.Reset Particle.Play Sound.Enabled"));
                    }
                    if (messages.get("Reset Button.Reset Particle.Play Sound.Sound") != null) {
                        messages.set("Reset-Buttons.Reset-Particle.Play-Sound.Sound", messages.getString("Reset Button.Reset Particle.Play Sound.Sound"));
                    }
                }
                if (messages.get("Reset Button.Reset Suit") != null) {
                    if (messages.get("Reset Button.Reset Suit.Name") != null) {
                        messages.set("Reset-Buttons.Reset-Suit.Name", messages.getString("Reset Button.Reset Suit.Name"));
                    }
                    if (messages.get("Reset Button.Reset Suit.Material") != null) {
                        messages.set("Reset-Buttons.Reset-Suit.Material", messages.getString("Reset Button.Reset Suit.Material"));
                    }
                    if (messages.get("Reset Button.Reset Suit.Show") != null) {
                        messages.set("Reset-Buttons.Reset-Suit.Show", messages.getBoolean("Reset Button.Reset Suit.Show"));
                    }
                    if (messages.get("Reset Button.Reset Suit.Lore") != null && !messages.getString("Reset Button.Reset Suit.Lore").equals("")) {
                        messages.set("Reset-Buttons.Reset-Suit.Lore", messages.getStringList("Reset Button.Reset Suit.Lore"));
                    }
                    if (messages.get("Reset Button.Reset Suit.Play Sound.Enabled") != null) {
                        messages.set("Reset-Buttons.Reset-Suit.Play-Sound.Enabled", messages.getBoolean("Reset Button.Reset Suit.Play Sound.Enabled"));
                    }
                    if (messages.get("Reset Button.Reset Suit.Play Sound.Sound") != null) {
                        messages.set("Reset-Buttons.Reset-Suit.Play-Sound.Sound", messages.getString("Reset Button.Reset Suit.Play Sound.Sound"));
                    }
                }
                if (messages.get("Reset Button.Reset Gadget") != null) {
                    if (messages.get("Reset Button.Reset Gadget.Name") != null) {
                        messages.set("Reset-Buttons.Reset-Gadget.Name", messages.getString("Reset Button.Reset Gadget.Name"));
                    }
                    if (messages.get("Reset Button.Reset Gadget.Material") != null) {
                        messages.set("Reset-Buttons.Reset-Gadget.Material", messages.getString("Reset Button.Reset Gadget.Material"));
                    }
                    if (messages.get("Reset Button.Reset Gadget.Show") != null) {
                        messages.set("Reset-Buttons.Reset-Gadget.Show", messages.getBoolean("Reset Button.Reset Gadget.Show"));
                    }
                    if (messages.get("Reset Button.Reset Gadget.Lore") != null && !messages.getString("Reset Button.Reset Gadget.Lore").equals("")) {
                        messages.set("Reset-Buttons.Reset-Gadget.Lore", messages.getStringList("Reset Button.Reset Gadget.Lore"));
                    }
                    if (messages.get("Reset Button.Reset Gadget.Play Sound.Enabled") != null) {
                        messages.set("Reset-Buttons.Reset-Gadget.Play-Sound.Enabled", messages.getBoolean("Reset Button.Reset Gadget.Play Sound.Enabled"));
                    }
                    if (messages.get("Reset Button.Reset Gadget.Play Sound.Sound") != null) {
                        messages.set("Reset-Buttons.Reset-Gadget.Play-Sound.Sound", messages.getString("Reset Button.Reset Gadget.Play Sound.Sound"));
                    }
                }
                if (messages.get("Reset Button.Reset Pet") != null) {
                    if (messages.get("Reset Button.Reset Pet.Name") != null) {
                        messages.set("Reset-Buttons.Reset-Pet.Name", messages.getString("Reset Button.Reset Pet.Name"));
                    }
                    if (messages.get("Reset Button.Reset Pet.Material") != null) {
                        messages.set("Reset-Buttons.Reset-Pet.Material", messages.getString("Reset Button.Reset Pet.Material"));
                    }
                    if (messages.get("Reset Button.Reset Pet.Show") != null) {
                        messages.set("Reset-Buttons.Reset-Pet.Show", messages.getBoolean("Reset Button.Reset Pet.Show"));
                    }
                    if (messages.get("Reset Button.Reset Pet.Lore") != null && !messages.getString("Reset Button.Reset Pet.Lore").equals("")) {
                        messages.set("Reset-Buttons.Reset-Pet.Lore", messages.getStringList("Reset Button.Reset Pet.Lore"));
                    }
                    if (messages.get("Reset Button.Reset Pet.Play Sound.Enabled") != null) {
                        messages.set("Reset-Buttons.Reset-Pet.Play-Sound.Enabled", messages.getBoolean("Reset Button.Reset Pet.Play Sound.Enabled"));
                    }
                    if (messages.get("Reset Button.Reset Pet.Play Sound.Sound") != null) {
                        messages.set("Reset-Buttons.Reset-Pet.Play-Sound.Sound", messages.getString("Reset Button.Reset Pet.Play Sound.Sound"));
                    }
                }
                if (messages.get("Reset Button.Reset Morph") != null) {
                    if (messages.get("Reset Button.Reset Morph.Name") != null) {
                        messages.set("Reset-Buttons.Reset-Morph.Name", messages.getString("Reset Button.Reset Morph.Name"));
                    }
                    if (messages.get("Reset Button.Reset Morph.Material") != null) {
                        messages.set("Reset-Buttons.Reset-Morph.Material", messages.getString("Reset Button.Reset Morph.Material"));
                    }
                    if (messages.get("Reset Button.Reset Morph.Show") != null) {
                        messages.set("Reset-Buttons.Reset-Morph.Show", messages.getBoolean("Reset Button.Reset Morph.Show"));
                    }
                    if (messages.get("Reset Button.Reset Morph.Lore") != null && !messages.getString("Reset Button.Reset Morph.Lore").equals("")) {
                        messages.set("Reset-Buttons.Reset-Morph.Lore", messages.getStringList("Reset Button.Reset Morph.Lore"));
                    }
                    if (messages.get("Reset Button.Reset Morph.Play Sound.Enabled") != null) {
                        messages.set("Reset-Buttons.Reset-Morph.Play-Sound.Enabled", messages.getBoolean("Reset Button.Reset Morph.Play Sound.Enabled"));
                    }
                    if (messages.get("Reset Button.Reset Morph.Play Sound.Sound") != null) {
                        messages.set("Reset-Buttons.Reset-Morph.Play-Sound.Sound", messages.getString("Reset Button.Reset Morph.Play Sound.Sound"));
                    }
                }
                if (messages.get("Reset Button.Reset Banner") != null) {
                    if (messages.get("Reset Button.Reset Banner.Name") != null) {
                        messages.set("Reset-Buttons.Reset-Banner.Name", messages.getString("Reset Button.Reset Banner.Name"));
                    }
                    if (messages.get("Reset Button.Reset Banner.Material") != null) {
                        messages.set("Reset-Buttons.Reset-Banner.Material", messages.getString("Reset Button.Reset Banner.Material"));
                    }
                    if (messages.get("Reset Button.Reset Banner.Show") != null) {
                        messages.set("Reset-Buttons.Reset-Banner.Show", messages.getBoolean("Reset Button.Reset Banner.Show"));
                    }
                    if (messages.get("Reset Button.Reset Banner.Lore") != null && !messages.getString("Reset Button.Reset Banner.Lore").equals("")) {
                        messages.set("Reset-Buttons.Reset-Banner.Lore", messages.getStringList("Reset Button.Reset Banner.Lore"));
                    }
                    if (messages.get("Reset Button.Reset Banner.Play Sound.Enabled") != null) {
                        messages.set("Reset-Buttons.Reset-Banner.Play-Sound.Enabled", messages.getBoolean("Reset Button.Reset Banner.Play Sound.Enabled"));
                    }
                    if (messages.get("Reset Button.Reset Banner.Play Sound.Sound") != null) {
                        messages.set("Reset-Buttons.Reset-Banner.Play-Sound.Sound", messages.getString("Reset Button.Reset Banner.Play Sound.Sound"));
                    }
                }
                if (messages.get("Reset Button.Reset Emote") != null) {
                    if (messages.get("Reset Button.Reset Emote.Name") != null) {
                        messages.set("Reset-Buttons.Reset-Emote.Name", messages.getString("Reset Button.Reset Emote.Name"));
                    }
                    if (messages.get("Reset Button..Material") != null) {
                        messages.set("Reset-Buttons.Reset-Emote.Material", messages.getString("Reset Button.Reset Emote.Material"));
                    }
                    if (messages.get("Reset Button..Show") != null) {
                        messages.set("Reset-Buttons.Reset-Emote.Show", messages.getBoolean("Reset Button.Reset Emote.Show"));
                    }
                    if (messages.get("Reset Button.Reset Emote.Lore") != null && !messages.getString("Reset Button.Reset Emote.Lore").equals("")) {
                        messages.set("Reset-Buttons.Reset-Emote.Lore", messages.getStringList("Reset Button.Reset Emote.Lore"));
                    }
                    if (messages.get("Reset Button.Reset Emote.Play Sound.Enabled") != null) {
                        messages.set("Reset-Buttons.Reset-Emote.Play-Sound.Enabled", messages.getBoolean("Reset Button.Reset Emote.Play Sound.Enabled"));
                    }
                    if (messages.get("Reset Button.Reset Emote.Play Sound.Sound") != null) {
                        messages.set("Reset-Buttons.Reset-Emote.Play-Sound.Sound", messages.getString("Reset Button.Reset Emote.Play Sound.Sound"));
                    }
                }
                if (messages.get("Reset Button.Reset Cloak") != null) {
                    if (messages.get("Reset Button.Reset Cloak.Name") != null) {
                        messages.set("Reset-Buttons.Reset-Cloak.Name", messages.getString("Reset Button.Reset Cloak.Name"));
                    }
                    if (messages.get("Reset Button.Reset Cloak.Material") != null) {
                        messages.set("Reset-Buttons.Reset-Cloak.Material", messages.getString("Reset Button.Reset Cloak.Material"));
                    }
                    if (messages.get("Reset Button.Reset Cloak.Show") != null) {
                        messages.set("Reset-Buttons.Reset-Cloak.Show", messages.getBoolean("Reset Button.Reset Cloak.Show"));
                    }
                    if (messages.get("Reset Button.Reset Cloak.Lore") != null && !messages.getString("Reset Button.Reset Cloak.Lore").equals("")) {
                        messages.set("Reset-Buttons.Reset-Cloak.Lore", messages.getStringList("Reset Button.Reset Cloak.Lore"));
                    }
                    if (messages.get("Reset Button.Reset Cloak.Play Sound.Enabled") != null) {
                        messages.set("Reset-Buttons.Reset-Cloak.Play-Sound.Enabled", messages.getBoolean("Reset Button.Reset Cloak.Play Sound.Enabled"));
                    }
                    if (messages.get("Reset Button.Reset Cloak.Play Sound.Sound") != null) {
                        messages.set("Reset-Buttons.Reset-Cloak.Play-Sound.Sound", messages.getString("Reset Button.Reset Cloak.Play Sound.Sound"));
                    }
                }
            }
            if (messages.get("GUI-Menus") != null) {
                if (messages.get("GUI-Menus.Purchase Menu") != null) {
                    if (messages.get("GUI-Menus.Purchase Menu.GUI-Name") != null) {
                        messages.set("GUI-Menus.Purchase-Menu.GUI-Name", messages.getString("GUI-Menus.Purchase Menu.GUI-Name"));
                    }
                    if (messages.get("GUI-Menus.Purchase Menu.Items.Confirm") != null) {
                        if (messages.get("GUI-Menus.Purchase Menu.Items.Confirm.Name") != null) {
                            messages.set("GUI-Menus.Purchase-Menu.Items.Confirm.Name", messages.getString("GUI-Menus.Purchase Menu.Items.Confirm.Name"));
                        }
                        if (messages.get("GUI-Menus.Purchase Menu.Items.Confirm.Material") != null) {
                            messages.set("GUI-Menus.Purchase-Menu.Items.Confirm.Material", messages.getString("GUI-Menus.Purchase Menu.Items.Confirm.Material"));
                        }
                        if (messages.get("GUI-Menus.Purchase Menu.Items.Confirm.Lore") != null && !messages.getString("GUI-Menus.Purchase Menu.Items.Confirm.Lore").equals("")) {
                            messages.set("GUI-Menus.Purchase-Menu.Items.Confirm.Lore", messages.getStringList("GUI-Menus.Purchase Menu.Items.Confirm.Lore"));
                        }
                    }
                    if (messages.get("GUI-Menus.Purchase Menu.Items.Cancel") != null) {
                        if (messages.get("GUI-Menus.Purchase Menu.Items.Cancel.Name") != null) {
                            messages.set("GUI-Menus.Purchase-Menu.Items.Cancel.Name", messages.getString("GUI-Menus.Purchase Menu.Items.Cancel.Name"));
                        }
                        if (messages.get("GUI-Menus.Purchase Menu.Items.Cancel.Material") != null) {
                            messages.set("GUI-Menus.Purchase-Menu.Items.Cancel.Material", messages.getString("GUI-Menus.Purchase Menu.Items.Cancel.Material"));
                        }
                        if (messages.get("GUI-Menus.Purchase Menu.Items.Cancel.Lore") != null && !messages.getString("GUI-Menus.Purchase Menu.Items.Cancel.Lore").equals("")) {
                            messages.set("GUI-Menus.Purchase-Menu.Items.Cancel.Lore", messages.getStringList("GUI-Menus.Purchase Menu.Items.Cancel.Lore"));
                        }
                    }
                }
                if (messages.get("GUI-Menus.Confirm Menu") != null) {
                    if (messages.get("GUI-Menus.Confirm Menu.GUI-Name") != null) {
                        messages.set("GUI-Menus.Confirm-Open-Mystery-Box-Menu.GUI-Name", messages.getString("GUI-Menus.Confirm Menu.GUI-Name"));
                    }
                    if (messages.get("GUI-Menus.Confirm Menu.Items.Open") != null) {
                        if (messages.get("GUI-Menus.Confirm Menu.Items.Open.Name") != null) {
                            messages.set("GUI-Menus.Confirm-Open-Mystery-Box-Menu.Items.Open.Name", messages.getString("GUI-Menus.Confirm Menu.Items.Open.Name"));
                        }
                        if (messages.get("GUI-Menus.Confirm Menu.Items.Open.Material") != null) {
                            messages.set("GUI-Menus.Confirm-Open-Mystery-Box-Menu.Items.Open.Material", messages.getString("GUI-Menus.Confirm Menu.Items.Open.Material"));
                        }
                        if (messages.get("GUI-Menus.Confirm Menu.Items.Open.Lore") != null && !messages.getString("GUI-Menus.Confirm Menu.Items.Open.Lore").equals("")) {
                            messages.set("GUI-Menus.Confirm-Open-Mystery-Box-Menu.Items.Open.Lore", messages.getStringList("GUI-Menus.Confirm Menu.Items.Open.Lore"));
                        }
                    }
                    if (messages.get("GUI-Menus.Confirm Menu.Items.Cancel") != null) {
                        if (messages.get("GUI-Menus.Confirm Menu.Items.Cancel.Name") != null) {
                            messages.set("GUI-Menus.Confirm-Open-Mystery-Box-Menu.Items.Cancel.Name", messages.getString("GUI-Menus.Confirm Menu.Items.Cancel.Name"));
                        }
                        if (messages.get("GUI-Menus.Confirm Menu.Items.Cancel.Material") != null) {
                            messages.set("GUI-Menus.Confirm-Open-Mystery-Box-Menu.Items.Cancel.Material", messages.getString("GUI-Menus.Confirm Menu.Items.Cancel.Material"));
                        }
                        if (messages.get("GUI-Menus.Confirm Menu.Items.Cancel.Lore") != null && !messages.getString("GUI-Menus.Confirm Menu.Items.Cancel.Lore").equals("")) {
                            messages.set("GUI-Menus.Confirm-Open-Mystery-Box-Menu.Items.Cancel.Lore", messages.getStringList("GUI-Menus.Confirm Menu.Items.Cancel.Lore"));
                        }
                    }
                }
                if (messages.get("GUI-Menus.Mystery Vault Menu") != null) {
                    if (messages.get("GUI-Menus.Mystery Vault Menu.GUI-Name") != null) {
                        messages.set("GUI-Menus.Mystery-Vault-Menu.GUI-Name", messages.getString("GUI-Menus.Mystery Vault Menu.GUI-Name"));
                    }
                    if (messages.get("GUI-Menus.Mystery Vault Menu.Items") != null) {
                        if (messages.get("GUI-Menus.Mystery Vault Menu.Items.Error") != null) {
                            if (messages.get("GUI-Menus.Mystery Vault Menu.Items.Error.Name") != null) {
                                messages.set("GUI-Menus.Mystery-Vault-Menu.Items.Error.Name", messages.getString("GUI-Menus.Mystery Vault Menu.Items.Error.Name"));
                            }
                            if (messages.get("GUI-Menus.Mystery Vault Menu.Items.Error.Material") != null) {
                                messages.set("GUI-Menus.Mystery-Vault-Menu.Items.Error.Material", messages.getString("GUI-Menus.Mystery Vault Menu.Items.Error.Material"));
                            }
                            if (messages.get("GUI-Menus.Mystery Vault Menu.Items.Error.Lore") != null && !messages.getString("GUI-Menus.Mystery Vault Menu.Items.Error.Lore").equals("")) {
                                messages.set("GUI-Menus.Mystery-Vault-Menu.Items.Error.Lore", messages.getStringList("GUI-Menus.Mystery Vault Menu.Items.Error.Lore"));
                            }
                        }
                        if (messages.get("GUI-Menus.Mystery Vault Menu.Items.Craft Mystery Boxes") != null) {
                            if (messages.get("GUI-Menus.Mystery Vault Menu.Items.Craft Mystery Boxes.Name") != null) {
                                messages.set("GUI-Menus.Mystery-Vault-Menu.Items.Craft-Mystery-Boxes.Name", messages.getString("GUI-Menus.Mystery Vault Menu.Items.Craft Mystery Boxes.Name"));
                            }
                            if (messages.get("GUI-Menus.Mystery Vault Menu.Items.Craft Mystery Boxes.Material") != null) {
                                messages.set("GUI-Menus.Mystery-Vault-Menu.Items.Craft-Mystery-Boxes.Material", messages.getString("GUI-Menus.Mystery Vault Menu.Items.Craft Mystery Boxes.Material"));
                            }
                            if (messages.get("GUI-Menus.Mystery Vault Menu.Items.Craft Mystery Boxes.Lore") != null && !messages.getString("GUI-Menus.Mystery Vault Menu.Items.Craft Mystery Boxes.Lore").equals("")) {
                                messages.set("GUI-Menus.Mystery-Vault-Menu.Items.Craft-Mystery-Boxes.Lore", messages.getStringList("GUI-Menus.Mystery Vault Menu.Items.Craft Mystery Boxes.Lore"));
                            }
                        }
                    }
                }
                if (messages.get("GUI-Menus.Craft Mystery Boxes Menu") != null) {
                    if (messages.get("GUI-Menus.Craft Mystery Boxes Menu.GUI-Name") != null) {
                        messages.set("GUI-Menus.Mystery-Box-Crafting-Menu.GUI-Name", messages.getString("GUI-Menus.Craft Mystery Boxes Menu.GUI-Name"));
                    }
                    if (messages.get("GUI-Menus.Craft Mystery Boxes Menu.Items") != null) {
                        if (messages.get("GUI-Menus.Craft Mystery Boxes Menu.Items.1 Star") != null) {
                            if (messages.get("GUI-Menus.Craft Mystery Boxes Menu.Items.1 Star.Name") != null) {
                                messages.set("GUI-Menus.Mystery-Box-Crafting-Menu.Items.1-Star.Name", messages.getString("GUI-Menus.Craft Mystery Boxes Menu.Items.1 Star.Name"));
                            }
                            if (messages.get("GUI-Menus.Craft Mystery Boxes Menu.Items.1 Star.Material") != null) {
                                messages.set("GUI-Menus.Mystery-Box-Crafting-Menu.Items.1-Star.Material", messages.getString("GUI-Menus.Craft Mystery Boxes Menu.Items.1 Star.Material"));
                            }
                            if (messages.get("GUI-Menus.Craft Mystery Boxes Menu.Items.1 Star.Price") != null) {
                                messages.set("GUI-Menus.Mystery-Box-Crafting-Menu.Items.1-Star.Price", messages.getInt("GUI-Menus.Craft Mystery Boxes Menu.Items.1 Star.Price"));
                            }
                            if (messages.get("GUI-Menus.Craft Mystery Boxes Menu.Items.1 Star.Lore") != null && !messages.getString("GUI-Menus.Craft Mystery Boxes Menu.Items.1 Star.Lore").equals("")) {
                                messages.set("GUI-Menus.Mystery-Box-Crafting-Menu.Items.1-Star.Lore", messages.getStringList("GUI-Menus.Craft Mystery Boxes Menu.Items.1 Star.Lore"));
                            }
                        }
                        if (messages.get("GUI-Menus.Craft Mystery Boxes Menu.Items.2 Star") != null) {
                            if (messages.get("GUI-Menus.Craft Mystery Boxes Menu.Items.2 Star.Name") != null) {
                                messages.set("GUI-Menus.Mystery-Box-Crafting-Menu.Items.2-Star.Name", messages.getString("GUI-Menus.Craft Mystery Boxes Menu.Items.2 Star.Name"));
                            }
                            if (messages.get("GUI-Menus.Craft Mystery Boxes Menu.Items.2 Star.Material") != null) {
                                messages.set("GUI-Menus.Mystery-Box-Crafting-Menu.Items.2-Star.Material", messages.getString("GUI-Menus.Craft Mystery Boxes Menu.Items.2 Star.Material"));
                            }
                            if (messages.get("GUI-Menus.Craft Mystery Boxes Menu.Items.2 Star.Price") != null) {
                                messages.set("GUI-Menus.Mystery-Box-Crafting-Menu.Items.2-Star.Price", messages.getInt("GUI-Menus.Craft Mystery Boxes Menu.Items.2 Star.Price"));
                            }
                            if (messages.get("GUI-Menus.Craft Mystery Boxes Menu.Items.2 Star.Lore") != null && !messages.getString("GUI-Menus.Craft Mystery Boxes Menu.Items.2 Star.Lore").equals("")) {
                                messages.set("GUI-Menus.Mystery-Box-Crafting-Menu.Items.2-Star.Lore", messages.getStringList("GUI-Menus.Craft Mystery Boxes Menu.Items.2 Star.Lore"));
                            }
                        }
                        if (messages.get("GUI-Menus.Craft Mystery Boxes Menu.Items.3 Star") != null) {
                            if (messages.get("GUI-Menus.Craft Mystery Boxes Menu.Items.3 Star.Name") != null) {
                                messages.set("GUI-Menus.Mystery-Box-Crafting-Menu.Items.3-Star.Name", messages.getString("GUI-Menus.Craft Mystery Boxes Menu.Items.3 Star.Name"));
                            }
                            if (messages.get("GUI-Menus.Craft Mystery Boxes Menu.Items.3 Star.Material") != null) {
                                messages.set("GUI-Menus.Mystery-Box-Crafting-Menu.Items.3-Star.Material", messages.getString("GUI-Menus.Craft Mystery Boxes Menu.Items.3 Star.Material"));
                            }
                            if (messages.get("GUI-Menus.Craft Mystery Boxes Menu.Items.3 Star.Price") != null) {
                                messages.set("GUI-Menus.Mystery-Box-Crafting-Menu.Items.3-Star.Price", messages.getInt("GUI-Menus.Craft Mystery Boxes Menu.Items.3 Star.Price"));
                            }
                            if (messages.get("GUI-Menus.Craft Mystery Boxes Menu.Items.3 Star.Lore") != null && !messages.getString("GUI-Menus.Craft Mystery Boxes Menu.Items.3 Star.Lore").equals("")) {
                                messages.set("GUI-Menus.Mystery-Box-Crafting-Menu.Items.3-Star.Lore", messages.getStringList("GUI-Menus.Craft Mystery Boxes Menu.Items.3 Star.Lore"));
                            }
                        }
                        if (messages.get("GUI-Menus.Craft Mystery Boxes Menu.Items.4 Star") != null) {
                            if (messages.get("GUI-Menus.Craft Mystery Boxes Menu.Items.4 Star.Name") != null) {
                                messages.set("GUI-Menus.Mystery-Box-Crafting-Menu.Items.4-Star.Name", messages.getString("GUI-Menus.Craft Mystery Boxes Menu.Items.4 Star.Name"));
                            }
                            if (messages.get("GUI-Menus.Craft Mystery Boxes Menu.Items.4 Star.Material") != null) {
                                messages.set("GUI-Menus.Mystery-Box-Crafting-Menu.Items.4-Star.Material", messages.getString("GUI-Menus.Craft Mystery Boxes Menu.Items.4 Star.Material"));
                            }
                            if (messages.get("GUI-Menus.Craft Mystery Boxes Menu.Items.4 Star.Price") != null) {
                                messages.set("GUI-Menus.Mystery-Box-Crafting-Menu.Items.4-Star.Price", messages.getInt("GUI-Menus.Craft Mystery Boxes Menu.Items.4 Star.Price"));
                            }
                            if (messages.get("GUI-Menus.Craft Mystery Boxes Menu.Items.4 Star.Lore") != null && !messages.getString("GUI-Menus.Craft Mystery Boxes Menu.Items.4 Star.Lore").equals("")) {
                                messages.set("GUI-Menus.Mystery-Box-Crafting-Menu.Items.4-Star.Lore", messages.getStringList("GUI-Menus.Craft Mystery Boxes Menu.Items.4 Star.Lore"));
                            }
                        }
                        if (messages.get("GUI-Menus.Craft Mystery Boxes Menu.Items.5 Star") != null) {
                            if (messages.get("GUI-Menus.Craft Mystery Boxes Menu.Items.5 Star.Name") != null) {
                                messages.set("GUI-Menus.Mystery-Box-Crafting-Menu.Items.5-Star.Name", messages.getString("GUI-Menus.Craft Mystery Boxes Menu.Items.5 Star.Name"));
                            }
                            if (messages.get("GUI-Menus.Craft Mystery Boxes Menu.Items.5 Star.Material") != null) {
                                messages.set("GUI-Menus.Mystery-Box-Crafting-Menu.Items.5-Star.Material", messages.getString("GUI-Menus.Craft Mystery Boxes Menu.Items.5 Star.Material"));
                            }
                            if (messages.get("GUI-Menus.Craft Mystery Boxes Menu.Items.5 Star.Price") != null) {
                                messages.set("GUI-Menus.Mystery-Box-Crafting-Menu.Items.5-Star.Price", messages.getInt("GUI-Menus.Craft Mystery Boxes Menu.Items.5 Star.Price"));
                            }
                            if (messages.get("GUI-Menus.Craft Mystery Boxes Menu.Items.5 Star.Lore") != null && !messages.getString("GUI-Menus.Craft Mystery Boxes Menu.Items.5 Star.Lore").equals("")) {
                                messages.set("GUI-Menus.Mystery-Box-Crafting-Menu.Items.5-Star.Lore", messages.getStringList("GUI-Menus.Craft Mystery Boxes Menu.Items.5 Star.Lore"));
                            }
                        }
                    }
                }
                if (messages.get("GUI-Menus.Settings Menu") != null) {
                    if (messages.get("GUI-Menus.Settings Menu.GUI-Name") != null) {
                        messages.set("GUI-Menus.Settings-Menu.GUI-Name", messages.getString("GUI-Menus.Settings Menu.GUI-Name"));
                    }
                    if (messages.get("GUI-Menus.Settings Menu.Items") != null) {
                        if (messages.get("GUI-Menus.Settings Menu.Items.Ignore Cooldown") != null) {
                            if (messages.get("GUI-Menus.Settings Menu.Items.Ignore Cooldown.Name") != null) {
                                messages.set("GUI-Menus.Settings-Menu.Items.Ignore-Cooldown.Name", messages.getString("GUI-Menus.Settings Menu.Items.Ignore Cooldown.Name"));
                            }
                            if (messages.get("GUI-Menus.Settings Menu.Items.Ignore Cooldown.Material") != null) {
                                messages.set("GUI-Menus.Settings-Menu.Items.Ignore-Cooldown.Material", messages.getString("GUI-Menus.Settings Menu.Items.Ignore Cooldown.Material"));
                            }
                        }
                        if (messages.get("GUI-Menus.Settings Menu.Items.Morphs Self View") != null) {
                            if (messages.get("GUI-Menus.Settings Menu.Items.Morphs Self View.Name") != null) {
                                messages.set("GUI-Menus.Settings-Menu.Items.Self-Morph-View.Name", messages.getString("GUI-Menus.Settings Menu.Items.Morphs Self View.Name"));
                            }
                            if (messages.get("GUI-Menus.Settings Menu.Items.Morphs Self View.Material") != null) {
                                messages.set("GUI-Menus.Settings-Menu.Items.Self-Morph-View.Material", messages.getString("GUI-Menus.Settings Menu.Items.Morphs Self View.Material"));
                            }
                        }
                        if (messages.get("GUI-Menus.Settings Menu.Items.Enabled") != null) {
                            if (messages.get("GUI-Menus.Settings Menu.Items.Enabled.Name") != null) {
                                messages.set("GUI-Menus.Settings-Menu.Items.Enabled.Name", messages.getString("GUI-Menus.Settings Menu.Items.Enabled.Name"));
                            }
                            if (messages.get("GUI-Menus.Settings Menu.Items.Enabled.Material") != null) {
                                messages.set("GUI-Menus.Settings-Menu.Items.Enabled.Material", messages.getString("GUI-Menus.Settings Menu.Items.Enabled.Material"));
                            }
                        }
                        if (messages.get("GUI-Menus.Settings Menu.Items.Disabled") != null) {
                            if (messages.get("GUI-Menus.Settings Menu.Items.Disabled.Name") != null) {
                                messages.set("GUI-Menus.Settings-Menu.Items.Disabled.Name", messages.getString("GUI-Menus.Settings Menu.Items.Disabled.Name"));
                            }
                            if (messages.get("GUI-Menus.Settings Menu.Items.Disabled.Material") != null) {
                                messages.set("GUI-Menus.Settings-Menu.Items.Disabled.Material", messages.getString("GUI-Menus.Settings Menu.Items.Disabled.Material"));
                            }
                        }
                    }
                }
            }
            config.set("GadgetsMenu", null);
            config.set("Player-Data.Database", null);
            config.set("Purchase System", null);
            config.set("Menu Item", null);
            config.set("Enabled Worlds", null);
            config.set("Disabled Cosmetics", null);
            config.set("Close GUI Menu After Select", null);
            config.set("Permission.Show in Lore", null);
            config.set("Permission.No Permission", null);
            config.set("Permission.Has Permission", null);
            config.set("Check Update", null);
            config.set("Auto Update", null);
            config.set("Config Version", null);
            config.set("Mystery Box", null);
            messages.set("Items.Go Back", null);
            messages.set("Items.Previous Page", null);
            messages.set("Items.Next Page", null);
            messages.set("Items.Already Selected", null);
            messages.set("Items.Click To Select", null);
            messages.set("Items.Unlocked.Show in Lore", null);
            messages.set("Items.MainMenu Button", null);
            messages.set("Items.Page", null);
            messages.set("Items.Morph Slimeball", null);
            messages.set("Items.Morphs Self View", null);
            messages.set("Items.Rename Pet", null);
            messages.set("GUI-Menus.Purchase Menu", null);
            messages.set("GUI-Menus.Settings Menu", null);
            messages.set("GUI-Menus.Confirm Menu", null);
            messages.set("GUI-Menus.Mystery Vault Menu", null);
            messages.set("GUI-Menus.Craft Mystery Boxes Menu", null);
            messages.set("Reset Button", null);
            messages.set("Plugin-Reloaded", null);
            messages.set("Reloading-Plugin", null);
            messages.set("Purchase-Is-Disabled", null);
            messages.set("Give-Selector", null);
            messages.set("No-Pet-Spawned", null);
            messages.set("Received-Menu", null);
            messages.set("Morphs-Self-View", null);
            messages.set("Radius-Is-Too-Big", null);
            messages.set("Play-A-Track", null);
            messages.set("Length-Too-Long", null);
            mysteryVault.set("Mystery Vault", null);
            config.set("Config-Version", "1.0.0", "Do not edit this.");
            FileManager.getGadgetsFile().set("Gadgets.Movement.Types.Paint Trail.BlackList", null);
            FileManager.getGadgetsFile().set("Gadgets.Projectile.Types.Paintball Gun.BlackList", null);
            FileManager.getGadgetsFile().set("Gadgets.Musical.Types.Jukebox.Items.Stop Track", null);
            GadgetsMenu.getInstance().config = CustomConfiguration.loadConfiguration(GadgetsMenu.getInstance().getFile());
            try {
                config.save(GadgetsMenu.getInstance().getFile());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            FileManager.getMessagesFile().reload();
            FileManager.getMessagesFile().save();
            FileManager.getMysteryVaultFile().reload();
            FileManager.getMysteryVaultFile().save();
            LoggerManager.printLogWithHeader(LoggerManager.LogLevel.INFO, "------------------------------------------------------", "Disable GadgetsMenu due to first time load this plugin.", "You need to restart server to enable GadgetsMenu plugin.");
            GadgetsMenu.getInstance().getServer().getPluginManager().disablePlugin((Plugin)GadgetsMenu.getInstance());
            return;
        }
    }
}

