/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.gadgets;

import com.yapzhenyie.GadgetsMenu.configuration.FileManager;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.EnumMaterial;
import com.yapzhenyie.GadgetsMenu.utils.GMaterial;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GadgetCategoryType {
    private static final List<GadgetCategoryType> ENABLED = new ArrayList<GadgetCategoryType>();
    private static final List<GadgetCategoryType> VALUES = new ArrayList<GadgetCategoryType>();
    public static final GadgetCategoryType Fun_AND_GAMES = new GadgetCategoryType("Fun And Games", "&eFun & Games", new GMaterial("head:b89042082bb7a7618b784ee7605a134c58834e21e374c888937161057f6c7"), Arrays.asList("gadgetsmenu.gadgets.magic9ball", "gadgetsmenu.gadgets.fortunecookie", "gadgetsmenu.gadgets.tetherball", "gadgetsmenu.gadgets.divingboard", "gadgetsmenu.gadgets.trampoline", "gadgetsmenu.gadgets.flowergiver", "gadgetsmenu.gadgets.sandcastle", "gadgetsmenu.gadgets.bbqgrill", "gadgetsmenu.gadgets.pocketbeach", "gadgetsmenu.gadgets.icecreamstand", "gadgetsmenu.gadgets.tictactoe"), Arrays.asList("&7Play games or just", "&7generally mess around in", "&7lobbies with these fun", "&7gadgets!"));
    public static final GadgetCategoryType MOBS_AND_NPCS = new GadgetCategoryType("Mobs And NPCs", "&eMobs & NPCs", new GMaterial(EnumMaterial.CREEPER_HEAD), Arrays.asList("gadgetsmenu.gadgets.piggybank", "gadgetsmenu.gadgets.catapult", "gadgetsmenu.gadgets.whenpigsfly", "gadgetsmenu.gadgets.creeperastronaut", "gadgetsmenu.gadgets.explodingsheep", "gadgetsmenu.gadgets.batlauncher", "gadgetsmenu.gadgets.scarecrow"), Arrays.asList("&7Spawn and play with wacky", "&7creatures using these Mobs", "&7& NPC gadgets!"));
    public static final GadgetCategoryType MOVEMENT = new GadgetCategoryType("Movement", "&eMovement", new GMaterial(EnumMaterial.GOLDEN_BOOTS), Arrays.asList("gadgetsmenu.gadgets.cowboy", "gadgetsmenu.gadgets.teleportstick", "gadgetsmenu.gadgets.firetrail", "gadgetsmenu.gadgets.painttrail", "gadgetsmenu.gadgets.parachute", "gadgetsmenu.gadgets.teleporter", "gadgetsmenu.gadgets.rocket", "gadgetsmenu.gadgets.letitsnow"), Arrays.asList("&7Change the way you walk,", "&7run or fly around lobbies", "&7with these movement-altering", "&7gadgets!"));
    public static final GadgetCategoryType MUSICAL = new GadgetCategoryType("Musical", "&eMusical", new GMaterial(EnumMaterial.JUKEBOX), Arrays.asList("gadgetsmenu.gadgets.jukebox", "gadgetsmenu.gadgets.radio", "gadgetsmenu.gadgets.discoball", "gadgetsmenu.gadgets.djbooth"), Arrays.asList("&7Make some noise with these", "&7sound-emitting musical", "&7gadgets!"));
    public static final GadgetCategoryType PROJECTILE = new GadgetCategoryType("Projectile", "&eProjectile", new GMaterial(EnumMaterial.BOW), Arrays.asList("gadgetsmenu.gadgets.mobgun", "gadgetsmenu.gadgets.railgun", "gadgetsmenu.gadgets.paintballgun", "gadgetsmenu.gadgets.explosivebow", "gadgetsmenu.gadgets.melonlauncher"), Arrays.asList("&7Fire at will! Shoot your", "&7way around the lobbies with", "&7these fun projectile", "&7gadgets!"));
    public static final GadgetCategoryType VISUAL = new GadgetCategoryType("Visual", "&eVisual", new GMaterial("head:fec5963e1f78f2f05943f4dd32224661374c220ecfde1e54754f5ee1e555dd"), Arrays.asList("gadgetsmenu.gadgets.kookiefountain", "gadgetsmenu.gadgets.pyromaniac", "gadgetsmenu.gadgets.diamondshower", "gadgetsmenu.gadgets.goldfountain", "gadgetsmenu.gadgets.kawariminojutsu", "gadgetsmenu.gadgets.cryotube", "gadgetsmenu.gadgets.ghosts", "gadgetsmenu.gadgets.partypopper", "gadgetsmenu.gadgets.poopbomb", "gadgetsmenu.gadgets.tntfountain", "gadgetsmenu.gadgets.dracula"), Arrays.asList("&7Change the way you or the", "&7lobby looks with these", "&7visual gadgets!"));
    private String name;
    private String displayName;
    private GMaterial material;
    private List<String> permission;
    private List<String> lore;
    private boolean isEnable;

    private GadgetCategoryType(String name, String displayName, GMaterial material, List<String> permission, List<String> lore) {
        this.name = name;
        if (FileManager.getGadgetsFile().get("Gadgets." + this.name + ".Name") == null) {
            this.displayName = displayName;
            FileManager.getGadgetsFile().set("Gadgets." + this.name + ".Name", this.displayName);
        } else {
            this.displayName = FileManager.getGadgetsFile().getString("Gadgets." + this.name + ".Name");
        }
        if (FileManager.getGadgetsFile().get("Gadgets." + this.name + ".Material") == null) {
            this.material = material;
            FileManager.getGadgetsFile().set("Gadgets." + this.name + ".Material", material.getCombinedMaterial());
        } else {
            GMaterial gMaterial;
            this.material = gMaterial = new GMaterial(FileManager.getGadgetsFile().getString("Gadgets." + this.name + ".Material"));
        }
        this.permission = permission;
        if (FileManager.getGadgetsFile().get("Gadgets." + this.name + ".Enabled") == null) {
            this.isEnable = true;
            FileManager.getGadgetsFile().set("Gadgets." + this.name + ".Enabled", true);
        } else {
            this.isEnable = FileManager.getGadgetsFile().getBoolean("Gadgets." + this.name + ".Enabled");
        }
        if (FileManager.getGadgetsFile().get("Gadgets." + this.name + ".Lore") == null) {
            this.lore = lore;
            if (lore == null) {
                FileManager.getGadgetsFile().set("Gadgets." + this.name + ".Lore", "");
            } else {
                FileManager.getGadgetsFile().set("Gadgets." + this.name + ".Lore", this.lore);
            }
        } else {
            this.lore = FileManager.getGadgetsFile().getStringList("Gadgets." + this.name + ".Lore");
        }
        if (!VALUES.contains(this)) {
            VALUES.add(this);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return ChatUtil.format(this.displayName);
    }

    public String getDisplayNameStripColor() {
        return ChatUtil.stripColor(this.displayName);
    }

    public GMaterial getMaterial() {
        return this.material;
    }

    public List<String> getPermission() {
        return this.permission;
    }

    public List<String> getLore() {
        return this.lore;
    }

    public boolean isEnabled() {
        return this.isEnable;
    }

    public static List<GadgetCategoryType> enabled() {
        return ENABLED;
    }

    public static List<GadgetCategoryType> values() {
        return VALUES;
    }

    public static void checkEnabled() {
        for (GadgetCategoryType type : GadgetCategoryType.values()) {
            if (!type.isEnabled() || ENABLED.contains(type)) continue;
            ENABLED.add(type);
        }
    }

    public String toString() {
        return this.name;
    }

    public static GadgetCategoryType valueOf(String name) throws NullPointerException {
        for (GadgetCategoryType type : GadgetCategoryType.values()) {
            if (!type.getName().equalsIgnoreCase(name)) continue;
            return type;
        }
        return null;
    }
}

