/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.GadgetType;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types.Gadget;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.ParticleEffect;
import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.entity.Bat;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class GadgetDracula
extends Gadget {
    private boolean activated = false;
    private ArrayList<Bat> bats = new ArrayList();

    public GadgetDracula(UUID uuid) {
        super(uuid, GadgetType.DRACULA);
    }

    @Override
    protected boolean checkRequirements() {
        if (this.activated) {
            this.getPlayer().sendMessage(MessageType.GADGET_IS_ACTIVATED.getFormatMessage().replace("{GADGET}", this.getType().getDisplayNameStripColor()));
            return false;
        }
        return true;
    }

    @Override
    public void onClick() {
        this.activated = true;
        Location location = this.getPlayer().getLocation().add(0.0, 1.0, 0.0);
        for (int i = 0; i < 5; ++i) {
            Bat bat = (Bat)location.getWorld().spawn(location, Bat.class);
            bat.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
            this.bats.add(bat);
        }
        this.getPlayer().addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, 200, 0));
        new BukkitRunnable(){
            int step = 0;

            public void run() {
                ++this.step;
                if (!GadgetDracula.this.getPlayer().isOnline() || GadgetsMenu.getPlayerManager(GadgetDracula.this.getPlayer()).getCurrentGadget() == null || GadgetsMenu.getPlayerManager(GadgetDracula.this.getPlayer()).getCurrentGadget().getType() != GadgetDracula.this.getType()) {
                    this.step = 10;
                    GadgetDracula.this.onClear();
                    this.cancel();
                }
                if (this.step >= 10) {
                    GadgetDracula.this.clearAll();
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)GadgetsMenu.getInstance(), 0L, 20L);
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public void onClear() {
        this.clearAll();
        HandlerList.unregisterAll((Listener)this);
    }

    private void clearAll() {
        for (Bat bat : this.bats) {
            if (bat.isValid()) {
                ParticleEffect.SMOKE_LARGE.display(bat.getLocation(), 0.1f, 0.1f, 0.1f, 3);
            }
            bat.remove();
        }
        this.bats.clear();
        if (this.getPlayer().hasPotionEffect(PotionEffectType.INVISIBILITY)) {
            this.getPlayer().removePotionEffect(PotionEffectType.INVISIBILITY);
        }
        this.activated = false;
    }
}

