/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.GadgetType;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types.Gadget;
import com.yapzhenyie.GadgetsMenu.utils.CuboID;
import com.yapzhenyie.GadgetsMenu.utils.EnumMaterial;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.ParticleEffect;
import com.yapzhenyie.GadgetsMenu.utils.ReflectionUtils;
import com.yapzhenyie.GadgetsMenu.utils.SoundEffect;
import com.yapzhenyie.GadgetsMenu.utils.VersionManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.GlowItemFrame;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class GadgetKawarimiNoJutsu
extends Gadget {
    private static int maxRadius = 8;
    private boolean activated = false;
    private ArrayList<Block> blocks = new ArrayList();
    private HashMap<Location, String> groundBlock = new HashMap();

    public GadgetKawarimiNoJutsu(UUID uuid) {
        super(uuid, GadgetType.KAWARIMI_NO_JUTSU);
    }

    @Override
    protected boolean checkRequirements() {
        Location loc2;
        if (this.activated) {
            this.getPlayer().sendMessage(MessageType.GADGET_IS_ACTIVATED.getFormatMessage().replace("{GADGET}", this.getType().getDisplayNameStripColor()));
            return false;
        }
        Location loc1 = this.getPlayer().getLocation().clone().add(0.0, 0.0, 0.0);
        CuboID checkCuboid = new CuboID(loc1, loc2 = this.getPlayer().getLocation().clone().add(0.0, 3.0, 0.0));
        if (!checkCuboid.isEmpty()) {
            this.getPlayer().sendMessage(MessageType.NOT_ENOUGH_SPACE.getFormatMessage());
            return false;
        }
        for (Entity e : this.getPlayer().getWorld().getNearbyEntities(loc1, 1.0, 3.0, 1.0)) {
            if (e instanceof Entity && e != this.getPlayer()) {
                this.getPlayer().sendMessage(MessageType.NOT_ENOUGH_SPACE.getFormatMessage());
                return false;
            }
            if (!(e instanceof ItemFrame) && !(e instanceof Painting) && (!VersionManager.is1_17OrAbove() || !(e instanceof GlowItemFrame)) || !checkCuboid.contains(e.getLocation())) continue;
            this.getPlayer().sendMessage(MessageType.NOT_ENOUGH_SPACE.getFormatMessage());
            return false;
        }
        return true;
    }

    @Override
    public void onClick() {
        this.activated = true;
        final Location oldlocation = this.getPlayer().getLocation().clone();
        Location location = this.getPlayer().getLocation().clone();
        location.setX(this.getPlayer().getLocation().getX() + Math.random() * (double)maxRadius * 2.0 - (double)maxRadius);
        location.setZ(this.getPlayer().getLocation().getZ() + Math.random() * (double)maxRadius * 2.0 - (double)maxRadius);
        location.setY((double)(this.getPlayer().getLocation().getWorld().getHighestBlockAt(location.getBlockX(), location.getBlockZ()).getY() + 1));
        this.getPlayer().teleport(location);
        GadgetsMenu.getPlayerManager(this.getPlayer()).disableFallDamage();
        SoundEffect.ENTITY_ENDERMAN_TELEPORT.playSound(this.getPlayer().getLocation());
        this.getPlayer().addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, 120, 0));
        this.setToRestore(this.getPlayer(), oldlocation.clone().add(0.0, -1.0, 0.0).getBlock(), 200);
        new BukkitRunnable(){
            int step = 0;

            public void run() {
                if (!GadgetKawarimiNoJutsu.this.getPlayer().isOnline() || GadgetsMenu.getPlayerManager(GadgetKawarimiNoJutsu.this.getPlayer()).getCurrentGadget() == null || GadgetsMenu.getPlayerManager(GadgetKawarimiNoJutsu.this.getPlayer()).getCurrentGadget().getType() != GadgetKawarimiNoJutsu.this.getType()) {
                    this.step = 40;
                    GadgetKawarimiNoJutsu.this.onClear();
                    this.cancel();
                    return;
                }
                ++this.step;
                if (this.step <= 40) {
                    for (int i = 0; i <= 2; ++i) {
                        Block log = oldlocation.clone().add(0.0, (double)i, 0.0).getBlock();
                        if (log.getType() == EnumMaterial.OAK_LOG.getType()) continue;
                        log.setType(EnumMaterial.OAK_LOG.getType());
                        log.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
                        GadgetKawarimiNoJutsu.this.blocks.add(log);
                        ParticleEffect.SMOKE_LARGE.display(log.getLocation());
                    }
                } else {
                    GadgetKawarimiNoJutsu.this.clearAll();
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)GadgetsMenu.getInstance(), 0L, 5L);
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public void onClear() {
        this.clearAll();
        HandlerList.unregisterAll((Listener)this);
    }

    private void clearAll() {
        for (Block block : this.blocks) {
            block.setType(Material.AIR);
            block.removeMetadata(GadgetsMenu.getInstance().getPluginName(), (Plugin)GadgetsMenu.getInstance());
        }
        this.blocks.clear();
        this.forceRestore();
        if (this.getPlayer().isOnGround()) {
            GadgetsMenu.getPlayerManager(this.getPlayer()).enableFallDamage();
        }
        this.activated = false;
    }

    private void forceRestore() {
        if (this.groundBlock.isEmpty()) {
            return;
        }
        for (Location loc : this.groundBlock.keySet()) {
            Block b = loc.getBlock();
            if (VersionManager.is1_13OrAbove()) {
                try {
                    BlockData blockData = Bukkit.getServer().createBlockData(this.groundBlock.get(loc));
                    b.setBlockData(blockData);
                }
                catch (NoSuchMethodError blockData) {}
            } else {
                String s = this.groundBlock.get(loc);
                Material m = Material.valueOf((String)s.split(",")[0]);
                byte d = Byte.valueOf(s.split(",")[1]);
                b.setType(m);
                ReflectionUtils.setData(b, d);
            }
            b.removeMetadata(GadgetsMenu.getInstance().getPluginName(), (Plugin)GadgetsMenu.getInstance());
        }
        this.blocks.clear();
    }

    private void restoreBlock(Player player, Location location) {
        if (!this.groundBlock.containsKey(location)) {
            return;
        }
        Block b = location.getBlock();
        if (VersionManager.is1_13OrAbove()) {
            try {
                BlockData blockData = Bukkit.getServer().createBlockData(this.groundBlock.get(location));
                b.setBlockData(blockData);
            }
            catch (NoSuchMethodError blockData) {}
        } else {
            String s = this.groundBlock.get(location);
            Material m = Material.valueOf((String)s.split(",")[0]);
            byte d = Byte.valueOf(s.split(",")[1]);
            b.setType(m);
            ReflectionUtils.setData(b, d);
        }
        b.removeMetadata(GadgetsMenu.getInstance().getPluginName(), (Plugin)GadgetsMenu.getInstance());
        this.groundBlock.remove(location);
    }

    private void setToRestore(final Player player, final Block block, int tickDelay) {
        if (this.groundBlock.containsKey(block.getLocation()) || block.hasMetadata(GadgetsMenu.getInstance().getPluginName())) {
            return;
        }
        if (!this.groundBlock.containsKey(block.getLocation())) {
            if (VersionManager.is1_13OrAbove()) {
                try {
                    this.groundBlock.put(block.getLocation(), block.getBlockData().getAsString());
                }
                catch (NoSuchMethodError noSuchMethodError) {}
            } else {
                try {
                    this.groundBlock.put(block.getLocation(), block.getType().toString() + "," + block.getData());
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
            }
            block.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
            Bukkit.getScheduler().runTaskLater((Plugin)GadgetsMenu.getInstance(), new Runnable(){

                @Override
                public void run() {
                    GadgetKawarimiNoJutsu.this.restoreBlock(player, block.getLocation());
                }
            }, (long)tickDelay);
        }
    }
}

