/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.GadgetType;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types.Gadget;
import com.yapzhenyie.GadgetsMenu.utils.EnumMaterial;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.SoundEffect;
import com.yapzhenyie.GadgetsMenu.utils.items.ItemUtils;
import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.entity.Item;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class GadgetKookieFountain
extends Gadget {
    private boolean activated = false;
    private ArrayList<Item> items = new ArrayList();

    public GadgetKookieFountain(UUID uuid) {
        super(uuid, GadgetType.KOOKIE_FOUNTAIN);
    }

    @Override
    protected boolean checkRequirements() {
        if (this.activated) {
            this.getPlayer().sendMessage(MessageType.GADGET_IS_ACTIVATED.getFormatMessage().replace("{GADGET}", this.getType().getDisplayNameStripColor()));
            return false;
        }
        return true;
    }

    @Override
    public void onClick() {
        this.activated = true;
        new BukkitRunnable(){
            int step = 0;

            public void run() {
                ++this.step;
                if (!GadgetKookieFountain.this.getPlayer().isOnline() || GadgetsMenu.getPlayerManager(GadgetKookieFountain.this.getPlayer()).getCurrentGadget() == null || GadgetsMenu.getPlayerManager(GadgetKookieFountain.this.getPlayer()).getCurrentGadget().getType() != GadgetKookieFountain.this.getType()) {
                    this.step = 60;
                    GadgetKookieFountain.this.onClear();
                    this.cancel();
                    return;
                }
                if (this.step <= 60) {
                    Item item = GadgetKookieFountain.this.getPlayer().getWorld().dropItem(GadgetKookieFountain.this.getPlayer().getEyeLocation(), ItemUtils.item(UUID.randomUUID().toString(), EnumMaterial.COOKIE, 0));
                    item.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
                    item.setPickupDelay(Integer.MAX_VALUE);
                    item.setVelocity(new Vector((GadgetsMenu.random().nextDouble() - 0.5) * 0.4, 0.4, (GadgetsMenu.random().nextDouble() - 0.5) * 0.4));
                    SoundEffect.ENTITY_CHICKEN_EGG.playSound(GadgetKookieFountain.this.getPlayer().getLocation());
                    GadgetKookieFountain.this.items.add(item);
                } else {
                    GadgetKookieFountain.this.clearAll();
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)GadgetsMenu.getInstance(), 0L, 4L);
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public void onClear() {
        this.clearAll();
        HandlerList.unregisterAll((Listener)this);
    }

    private void clearAll() {
        for (Item item : this.items) {
            item.remove();
        }
        this.items.clear();
        this.activated = false;
    }
}

