/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.GadgetType;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types.Gadget;
import com.yapzhenyie.GadgetsMenu.utils.EnumMaterial;
import com.yapzhenyie.GadgetsMenu.utils.SoundEffect;
import com.yapzhenyie.GadgetsMenu.utils.items.ItemUtils;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Effect;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class GadgetMelonLauncher
extends Gadget {
    private ArrayList<Item> melons = new ArrayList();
    private ArrayList<Item> melonBlocks = new ArrayList();

    public GadgetMelonLauncher(UUID uuid) {
        super(uuid, GadgetType.MELON_LAUNCHER);
    }

    @Override
    public void onClick() {
        SoundEffect.ENTITY_GENERIC_EXPLODE.playSound(this.getPlayer());
        Item item = this.getPlayer().getWorld().dropItem(this.getPlayer().getEyeLocation(), ItemUtils.item(UUID.randomUUID().toString(), EnumMaterial.MELON, 0));
        item.setPickupDelay(Integer.MAX_VALUE);
        item.setVelocity(this.getPlayer().getEyeLocation().getDirection().multiply(1.3));
        item.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
        this.melonBlocks.add(item);
        BukkitRunnable runnable = new BukkitRunnable(){
            int step = 0;

            public void run() {
                ++this.step;
                if (!GadgetMelonLauncher.this.getPlayer().isOnline() || GadgetsMenu.getPlayerManager(GadgetMelonLauncher.this.getPlayer()).getCurrentGadget() == null || GadgetsMenu.getPlayerManager(GadgetMelonLauncher.this.getPlayer()).getCurrentGadget().getType() != GadgetMelonLauncher.this.getType() || this.step >= 24) {
                    this.step = 24;
                    this.cancel();
                    return;
                }
                Bukkit.getScheduler().runTask((Plugin)GadgetsMenu.getInstance(), () -> {
                    Iterator melonBlockIterator = GadgetMelonLauncher.this.melonBlocks.iterator();
                    while (melonBlockIterator.hasNext()) {
                        Item item2 = (Item)melonBlockIterator.next();
                        if (!item2.isOnGround()) continue;
                        item2.getWorld().playEffect(item2.getLocation(), Effect.STEP_SOUND, 103);
                        for (int i = 0; i <= 8; ++i) {
                            Item melon = GadgetMelonLauncher.this.getPlayer().getWorld().dropItem(item2.getLocation(), ItemUtils.item(UUID.randomUUID().toString(), EnumMaterial.MELON_SLICE, 0));
                            melon.setVelocity(new Vector(GadgetsMenu.random().nextDouble() - 0.5, GadgetsMenu.random().nextDouble() / 2.0, GadgetsMenu.random().nextDouble() - 0.5).multiply(0.75));
                            melon.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
                            GadgetMelonLauncher.this.melons.add(melon);
                        }
                        item2.remove();
                        melonBlockIterator.remove();
                    }
                });
            }
        };
        runnable.runTaskTimerAsynchronously((Plugin)GadgetsMenu.getInstance(), 0L, 5L);
    }

    @Override
    public void onUpdate() {
        try {
            Bukkit.getScheduler().runTask((Plugin)GadgetsMenu.getInstance(), () -> {
                for (Item melon : this.melons) {
                    if (!melon.isValid() || melon.getTicksLived() <= 100) continue;
                    melon.remove();
                }
                for (Item melonBlock : this.melonBlocks) {
                    if (!melonBlock.isValid() || melonBlock.getTicksLived() <= 120) continue;
                    melonBlock.remove();
                }
            });
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    @Override
    public void onClear() {
        this.clearAll();
        HandlerList.unregisterAll((Listener)this);
    }

    private void clearAll() {
        for (Item melon : this.melons) {
            if (!melon.isValid()) continue;
            melon.remove();
        }
        this.melons.clear();
        for (Item melonBlock : this.melonBlocks) {
            if (!melonBlock.isValid()) continue;
            melonBlock.remove();
        }
        this.melonBlocks.clear();
    }

    @EventHandler
    public void onPickUpMelon(PlayerPickupItemEvent e) {
        Player p = e.getPlayer();
        if (e.getItem().hasMetadata(GadgetsMenu.getInstance().getPluginName()) && e.getItem().getItemStack().getType() == EnumMaterial.MELON_SLICE.getType()) {
            p.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 100, 2));
            SoundEffect.ENTITY_GENERIC_EAT.playSound(p);
            e.getItem().remove();
            e.setCancelled(true);
            this.melons.remove(e.getItem());
        }
        if (this.melonBlocks.contains(e.getItem())) {
            e.setCancelled(true);
        }
    }
}

