/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.configuration.FileManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.GadgetType;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types.Gadget;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.EnumMaterial;
import com.yapzhenyie.GadgetsMenu.utils.FireworkUtils;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.ParticleEffect;
import com.yapzhenyie.GadgetsMenu.utils.VersionManager;
import com.yapzhenyie.GadgetsMenu.utils.items.ItemUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.FireworkEffect;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Item;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Pig;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Villager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class GadgetMobGun
extends Gadget {
    private static EntityType[] types = new EntityType[]{EntityType.PIG, EntityType.VILLAGER, EntityType.OCELOT, EntityType.COW, EntityType.CREEPER, EntityType.SPIDER, EntityType.SQUID, EntityType.CHICKEN, EntityType.SHEEP, EntityType.WOLF, EntityType.WITCH, EntityType.BLAZE, EntityType.HORSE, EntityType.ZOMBIE, EntityType.SKELETON, EntityType.MUSHROOM_COW, EntityType.CAVE_SPIDER, VersionManager.is1_16OrAbove() ? EntityType.ZOMBIFIED_PIGLIN : EntityType.valueOf((String)"PIG_ZOMBIE")};
    private static EnumMaterial[] type_drops = new EnumMaterial[]{EnumMaterial.COOKED_PORKCHOP, EnumMaterial.EMERALD, EnumMaterial.COOKED_COD, EnumMaterial.COOKED_BEEF, EnumMaterial.GUNPOWDER, EnumMaterial.STRING, EnumMaterial.INK_SAC, EnumMaterial.FEATHER, EnumMaterial.WHITE_WOOL, EnumMaterial.BONE, EnumMaterial.SPLASH_POTION, EnumMaterial.BLAZE_ROD, EnumMaterial.APPLE, EnumMaterial.ROTTEN_FLESH, EnumMaterial.ARROW, EnumMaterial.MUSHROOM_STEW, EnumMaterial.FIRE_CHARGE, EnumMaterial.GOLD_INGOT};
    public static String[] name = new String[]{"Pig", "Villager", "Ocelot", "Cow", "Creeper", "Spider", "Squid", "Chicken", "Sheep", "Wolf", "Witch", "Blaze", "Horse", "Zombie", "Skeleton", "MushroomCow", "CaveSpider", "PigZombie"};
    private static String[] displayName = new String[]{"Pig", "Villager", "Ocelot", "Cow", "Creeper", "Spider", "Squid", "Chicken", "Sheep", "Wolf", "Witch", "Blaze", "Horse", "Zombie", "Skeleton", "MushroomCow", "CaveSpider", "PigZombie"};
    private static String actionbarMessage = FileManager.getGadgetsFile().getString("Gadgets.Projectile.Types.MobGun.Actionbar-Message");
    private int type = 0;
    private Entity entity = null;
    private boolean activated = false;
    private ArrayList<Item> items = new ArrayList();

    public GadgetMobGun(UUID uuid) {
        super(uuid, GadgetType.MOB_GUN);
        int i = 0;
        for (String entity : name) {
            if (FileManager.getGadgetsFile().get("Gadgets.Projectile.Types.MobGun.Mob-Name." + entity) == null) continue;
            GadgetMobGun.displayName[i++] = ChatUtil.stripColor(FileManager.getGadgetsFile().getString("Gadgets.Projectile.Types.MobGun.Mob-Name." + entity));
        }
    }

    @Override
    protected boolean checkRequirements() {
        if (this.activated) {
            this.getPlayer().sendMessage(MessageType.GADGET_IS_ACTIVATED.getFormatMessage().replace("{GADGET}", this.getType().getDisplayNameStripColor()));
            return false;
        }
        return true;
    }

    @Override
    void onClick() {
        final int typeObject = this.type;
        Entity mob = this.getPlayer().getWorld().spawnEntity(this.getPlayer().getEyeLocation().add(0.0, -0.5, 0.0), types[typeObject]);
        if (types[typeObject] == EntityType.PIG) {
            ((Pig)mob).setSaddle(true);
        } else if (types[typeObject] == EntityType.VILLAGER) {
            ((Villager)mob).setProfession(Villager.Profession.BUTCHER);
        } else if (types[typeObject] == EntityType.OCELOT) {
            if (!VersionManager.is1_14OrAbove()) {
                ((Ocelot)mob).setCatType(Ocelot.Type.WILD_OCELOT);
            }
        } else if (types[typeObject] == EntityType.SHEEP) {
            ((Sheep)mob).setColor(DyeColor.WHITE);
        } else if (types[typeObject] == EntityType.HORSE) {
            if (!VersionManager.is1_11OrAbove()) {
                ((Horse)mob).setVariant(Horse.Variant.HORSE);
            }
            ((Horse)mob).setColor(Horse.Color.BROWN);
        }
        mob.setPassenger(null);
        mob.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
        mob.setVelocity(new Vector(mob.getLocation().getDirection().getX() / 2.0, 0.0, mob.getLocation().getDirection().getZ() / 2.0));
        GadgetsMenu.getNMSManager().removePathfinders(mob);
        this.entity = mob;
        this.activated = true;
        new BukkitRunnable(){

            public void run() {
                if (!GadgetMobGun.this.getPlayer().isOnline() || GadgetsMenu.getPlayerManager(GadgetMobGun.this.getPlayer()).getCurrentGadget() == null || GadgetsMenu.getPlayerManager(GadgetMobGun.this.getPlayer()).getCurrentGadget().getType() != GadgetMobGun.this.getType()) {
                    GadgetMobGun.this.onClear();
                    this.cancel();
                    return;
                }
                FireworkUtils.displayFirework(GadgetMobGun.this.entity.getLocation(), FireworkEffect.Type.BURST, false, false, Arrays.asList(Color.RED), Arrays.asList(Color.RED));
                for (int i = 0; i <= 25; ++i) {
                    Item item = GadgetMobGun.this.getPlayer().getWorld().dropItem(GadgetMobGun.this.entity.getLocation(), ItemUtils.item(UUID.randomUUID().toString(), type_drops[typeObject], 0));
                    item.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
                    item.setVelocity(new Vector((GadgetsMenu.random().nextDouble() - 0.5) / 1.7, 0.4, (GadgetsMenu.random().nextDouble() - 0.5) / 1.7));
                    GadgetMobGun.this.items.add(item);
                }
                if (GadgetMobGun.this.entity != null) {
                    GadgetMobGun.this.entity.remove();
                }
                GadgetMobGun.this.entity = null;
                new BukkitRunnable(){

                    public void run() {
                        GadgetMobGun.this.clearAll();
                    }
                }.runTaskLater((Plugin)GadgetsMenu.getInstance(), 40L);
            }
        }.runTaskLater((Plugin)GadgetsMenu.getInstance(), 80L);
    }

    @Override
    void onUpdate() {
        Bukkit.getScheduler().runTask((Plugin)GadgetsMenu.getInstance(), () -> {
            if (this.activated && this.entity != null && this.entity.isValid()) {
                try {
                    if (this.entity.getFireTicks() > 0) {
                        this.entity.setFireTicks(0);
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                this.entity.setVelocity(new Vector(this.entity.getLocation().getDirection().getX() / 1.7, -0.07, this.entity.getLocation().getDirection().getZ() / 1.7));
                ParticleEffect.REDSTONE.displayColor(this.entity.getLocation(), GadgetsMenu.random().nextInt(255), GadgetsMenu.random().nextInt(255), GadgetsMenu.random().nextInt(255));
            }
        });
    }

    @Override
    public void onClear() {
        HandlerList.unregisterAll((Listener)this);
        this.clearAll();
        this.type = 0;
    }

    private void clearAll() {
        for (Item item : this.items) {
            item.remove();
        }
        this.items.clear();
        if (this.entity != null) {
            this.entity.remove();
        }
        this.entity = null;
        this.activated = false;
    }

    @EventHandler
    public void onPlayerChangingMobType(PlayerInteractEvent e) {
        if (e.getAction() != Action.LEFT_CLICK_AIR && e.getAction() != Action.LEFT_CLICK_BLOCK) {
            return;
        }
        if (e.getPlayer() == this.getPlayer() && this.getPlayer().isOnline() && GadgetsMenu.getPlayerManager(this.getPlayer()).getCurrentGadget() != null && GadgetsMenu.getPlayerManager(this.getPlayer()).getCurrentGadget().getType() == this.getType() && this.getPlayer().getItemInHand().hasItemMeta() && this.getPlayer().getItemInHand().getItemMeta().hasDisplayName() && this.getPlayer().getItemInHand().getItemMeta().getDisplayName().startsWith(ChatUtil.format(this.getType().getDisplayName())) && this.getPlayer().getItemInHand().getType() == this.getType().getMaterial().getEnumMaterial().getType()) {
            if (this.type < 17) {
                ++this.type;
            } else if (this.type >= 17) {
                this.type = 0;
            }
            GadgetsMenu.getPlayerManager(e.getPlayer()).sendActionMessage(ChatUtil.format(actionbarMessage.replace("{GADGET}", this.getType().getDisplayName()).replace("{MOB}", displayName[this.type])));
            e.setCancelled(true);
            return;
        }
    }
}

