/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.configuration.FileManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.GadgetType;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types.Gadget;
import com.yapzhenyie.GadgetsMenu.utils.BlockUtil;
import com.yapzhenyie.GadgetsMenu.utils.EnumMaterial;
import com.yapzhenyie.GadgetsMenu.utils.GMaterial;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.ReflectionUtils;
import com.yapzhenyie.GadgetsMenu.utils.VersionManager;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class GadgetPaintTrail
extends Gadget {
    private boolean activated = false;
    private HashMap<Location, String> blocks = new HashMap();
    private List<String> blackList = FileManager.getGadgetsFile().getStringList("Gadgets.Movement.Types.Paint Trail.Blacklist");

    public GadgetPaintTrail(UUID uuid) {
        super(uuid, GadgetType.PAINT_TRAIL);
    }

    @Override
    protected boolean checkRequirements() {
        if (this.activated) {
            this.getPlayer().sendMessage(MessageType.GADGET_IS_ACTIVATED.getFormatMessage().replace("{GADGET}", this.getType().getDisplayNameStripColor()));
            return false;
        }
        return true;
    }

    @Override
    public void onClick() {
        this.activated = true;
        new BukkitRunnable(){
            int step = 0;
            Random r = new Random();

            public void run() {
                if (!GadgetPaintTrail.this.getPlayer().isOnline() || GadgetsMenu.getPlayerManager(GadgetPaintTrail.this.getPlayer()).getCurrentGadget() == null || GadgetsMenu.getPlayerManager(GadgetPaintTrail.this.getPlayer()).getCurrentGadget().getType() != GadgetPaintTrail.this.getType()) {
                    this.step = 200;
                    GadgetPaintTrail.this.onClear();
                    this.cancel();
                    return;
                }
                ++this.step;
                byte color = (byte)this.r.nextInt(15);
                EnumMaterial material = EnumMaterial.valueOf(159, color);
                if (this.step <= 200) {
                    Block getBlock = GadgetPaintTrail.this.getPlayer().getLocation().subtract(0.0, 1.0, 0.0).getBlock();
                    if (!getBlock.isEmpty() && GadgetPaintTrail.this.getPlayer().isOnGround()) {
                        for (Block block : BlockUtil.getBlocksInRadius(getBlock.getLocation(), 1, false)) {
                            GadgetPaintTrail.this.setToRestore(GadgetPaintTrail.this.getPlayer(), block, material, color, 60);
                        }
                    }
                } else {
                    GadgetPaintTrail.this.clearAll();
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)GadgetsMenu.getInstance(), 0L, 1L);
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public void onClear() {
        this.clearAll();
        HandlerList.unregisterAll((Listener)this);
    }

    private void clearAll() {
        this.forceRestore();
        this.activated = false;
    }

    private void forceRestore() {
        if (this.blocks.isEmpty()) {
            return;
        }
        for (Location loc : this.blocks.keySet()) {
            Block b = loc.getBlock();
            if (VersionManager.is1_13OrAbove()) {
                try {
                    BlockData blockData = Bukkit.getServer().createBlockData(this.blocks.get(loc));
                    b.setBlockData(blockData);
                }
                catch (Exception blockData) {}
            } else {
                String s = this.blocks.get(loc);
                Material m = Material.valueOf((String)s.split(",")[0]);
                byte d = Byte.valueOf(s.split(",")[1]);
                b.setType(m);
                ReflectionUtils.setData(b, d);
            }
            b.removeMetadata(GadgetsMenu.getInstance().getPluginName(), (Plugin)GadgetsMenu.getInstance());
        }
        this.blocks.clear();
    }

    private void restoreBlock(Player player, Location location) {
        if (!this.blocks.containsKey(location)) {
            return;
        }
        Block b = location.getBlock();
        if (VersionManager.is1_13OrAbove()) {
            try {
                BlockData blockData = Bukkit.getServer().createBlockData(this.blocks.get(location));
                b.setBlockData(blockData);
            }
            catch (Exception blockData) {}
        } else {
            String s = this.blocks.get(location);
            Material m = Material.valueOf((String)s.split(",")[0]);
            byte d = Byte.valueOf(s.split(",")[1]);
            b.setType(m);
            ReflectionUtils.setData(b, d);
        }
        b.removeMetadata(GadgetsMenu.getInstance().getPluginName(), (Plugin)GadgetsMenu.getInstance());
        this.blocks.remove(location);
    }

    private void setToRestore(final Player player, final Block block, EnumMaterial material, byte data, int tickDelay) {
        if (this.blocks.containsKey(block.getLocation())) {
            return;
        }
        Block bUP = block.getRelative(BlockFace.UP);
        if (!(block.getType() == EnumMaterial.ANVIL.getType() || block.getType() == EnumMaterial.ATTACHED_MELON_STEM.getType() || block.getType() == EnumMaterial.ATTACHED_PUMPKIN_STEM.getType() || block.getType().toString().toLowerCase().contains("banner") || block.getType() == EnumMaterial.BARREL.getType() || block.getType() == EnumMaterial.BARRIER.getType() || block.getType() == EnumMaterial.BEACON.getType() || block.getType().toString().toLowerCase().contains("bed") || block.getType() == EnumMaterial.BEETROOTS.getType() || block.getType() == EnumMaterial.BREWING_STAND.getType() || block.getType() == EnumMaterial.BROWN_MUSHROOM.getType() || block.getType() == EnumMaterial.CACTUS.getType() || block.getType().toString().toLowerCase().contains("cake_block") || block.getType() == EnumMaterial.CAKE.getType() || block.getType() == EnumMaterial.CARROTS.getType() || block.getType().toString().toLowerCase().contains("carpet") || block.getType() == EnumMaterial.CHEST.getType() || block.getType() == EnumMaterial.COBWEB.getType() || block.getType() == EnumMaterial.COCOA.getType() || block.getType().toString().toLowerCase().contains("command") || block.getType() == EnumMaterial.CRAFTING_TABLE.getType() || block.getType().toString().toLowerCase().contains("crops") || block.getType() == EnumMaterial.DANDELION.getType() || block.getType() == EnumMaterial.DEAD_BUSH.getType() || block.getType() == EnumMaterial.DISPENSER.getType() || block.getType().toString().toLowerCase().contains("double_plant") || block.getType().toString().toLowerCase().contains("door") || block.getType() == EnumMaterial.DRAGON_EGG.getType() || block.getType() == EnumMaterial.DROPPER.getType() || block.getType() == EnumMaterial.ENCHANTING_TABLE.getType() || block.getType() == EnumMaterial.END_PORTAL.getType() || block.getType() == EnumMaterial.END_PORTAL_FRAME.getType() || block.getType() == EnumMaterial.FARMLAND.getType() || block.getType() == EnumMaterial.FERN.getType() || block.getType() == EnumMaterial.FLOWER_POT.getType() || block.getType().toString().toLowerCase().contains("flower_pot") || block.getType() == EnumMaterial.FIRE.getType() || block.getType().toString().toLowerCase().contains("furnace") || block.getType() == EnumMaterial.GRASS.getType() || block.getType().toString().toLowerCase().contains("head") || block.getType() == EnumMaterial.HOPPER.getType() || block.getType() == EnumMaterial.JUKEBOX.getType() || block.getType() == EnumMaterial.LADDER.getType() || block.getType() == EnumMaterial.LARGE_FERN.getType() || block.getType() == EnumMaterial.LEVER.getType() || block.getType() == EnumMaterial.LILY_PAD.getType() || block.getType() == EnumMaterial.LILAC.getType() || block.getType().toString().toLowerCase().contains("long_grass") || block.getType() == EnumMaterial.MELON_STEM.getType() || block.getType() == EnumMaterial.MUSHROOM_STEM.getType() || block.getType() == EnumMaterial.NETHER_WART.getType() || block.getType() == EnumMaterial.NETHER_PORTAL.getType() || block.getType() == EnumMaterial.NOTE_BLOCK.getType() || block.getType() == EnumMaterial.PEONY.getType() || block.getType().toString().toLowerCase().contains("piston_") || block.getType().toString().toLowerCase().contains("plate") || block.getType() == EnumMaterial.POTATOES.getType() || block.getType().toString().toLowerCase().contains("potted_") || block.getType() == EnumMaterial.PUMPKIN_STEM.getType() || block.getType().toString().toLowerCase().contains("redstone_comparator") || block.getType().toString().toLowerCase().contains("redstone_lamp") || block.getType().toString().toLowerCase().contains("redstone_torch") || block.getType() == EnumMaterial.REDSTONE_WIRE.getType() || block.getType() == EnumMaterial.REPEATER.getType() || block.getType() == EnumMaterial.RED_MUSHROOM.getType() || block.getType().toString().toLowerCase().contains("red_rose") || block.getType() == EnumMaterial.ROSE_BUSH.getType() || block.getType().toString().toLowerCase().contains("sapling") || block.getType().toString().toLowerCase().contains("seeds") || block.getType().toString().toLowerCase().contains("sign") || block.getType().toString().toLowerCase().contains("shulker_box") || block.getType().toString().toLowerCase().contains("skull") || block.getType() == EnumMaterial.SMOKER.getType() || block.getType() == EnumMaterial.SNOW.getType() || block.getType() == EnumMaterial.SPAWNER.getType() || block.getType() == EnumMaterial.SUGAR_CANE.getType() || block.getType().toString().toLowerCase().contains("sugar_cane_block") || block.getType() == EnumMaterial.SUNFLOWER.getType() || block.getType() == EnumMaterial.SWEET_BERRY_BUSH.getType() || block.getType() == EnumMaterial.TALL_GRASS.getType() || block.getType() == EnumMaterial.TORCH.getType() || block.getType() == EnumMaterial.TRAPPED_CHEST.getType() || block.getType() == EnumMaterial.TRIPWIRE_HOOK.getType() || block.getType() == EnumMaterial.TRIPWIRE.getType() || block.getType().toString().toLowerCase().contains("tulip") || block.getType() == EnumMaterial.VINE.getType() || block.getType() == EnumMaterial.WHEAT.getType() || block.getType().toString().toLowerCase().contains("_button") || block.isEmpty() || block.isLiquid() || BlockUtil.isPortalBlock(block) || BlockUtil.isCocoaBlock(block) || BlockUtil.isStem(block) || BlockUtil.isChorusPlant(block) || BlockUtil.isMushroomBlock(block) || BlockUtil.hasBlockObject(block) || BlockUtil.hasBlockObject(bUP) || block.hasMetadata(GadgetsMenu.getInstance().getPluginName()))) {
            for (String blackList : this.blackList) {
                GMaterial gMaterial = new GMaterial(blackList);
                if (block.getType() != gMaterial.getEnumMaterial().getType() || !VersionManager.is1_13OrAbove() && block.getData() != gMaterial.getData()) continue;
                return;
            }
            if (!this.blocks.containsKey(block.getLocation())) {
                if (VersionManager.is1_13OrAbove()) {
                    try {
                        this.blocks.put(block.getLocation(), block.getBlockData().getAsString());
                    }
                    catch (NoSuchMethodError noSuchMethodError) {}
                } else {
                    try {
                        this.blocks.put(block.getLocation(), block.getType().toString() + "," + block.getData());
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        // empty catch block
                    }
                }
                block.setType(material.getType());
                ReflectionUtils.setData(block, data);
                block.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
                Bukkit.getScheduler().runTaskLater((Plugin)GadgetsMenu.getInstance(), new Runnable(){

                    @Override
                    public void run() {
                        GadgetPaintTrail.this.restoreBlock(player, block.getLocation());
                    }
                }, (long)tickDelay);
            }
        }
    }
}

