/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.configuration.FileManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.GadgetType;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types.Gadget;
import com.yapzhenyie.GadgetsMenu.utils.BlockUtil;
import com.yapzhenyie.GadgetsMenu.utils.EnumMaterial;
import com.yapzhenyie.GadgetsMenu.utils.GMaterial;
import com.yapzhenyie.GadgetsMenu.utils.ParticleEffect;
import com.yapzhenyie.GadgetsMenu.utils.ReflectionUtils;
import com.yapzhenyie.GadgetsMenu.utils.SoundEffect;
import com.yapzhenyie.GadgetsMenu.utils.VersionManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Snowball;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class GadgetPaintballGun
extends Gadget {
    private Map<UUID, ArrayList<Projectile>> projectiles = new HashMap<UUID, ArrayList<Projectile>>();
    private int radius = FileManager.getGadgetsFile().get("Gadgets.Projectile.Types.Paintball Gun.Radius") == null ? 3 : FileManager.getGadgetsFile().getInt("Gadgets.Projectile.Types.Paintball Gun.Radius");
    private HashMap<Location, String> blocks = new HashMap();
    private List<String> blackList = FileManager.getGadgetsFile().getStringList("Gadgets.Projectile.Types.Paintball Gun.Blacklist");

    public GadgetPaintballGun(UUID uuid) {
        super(uuid, GadgetType.PAINTBALL_GUN);
    }

    @Override
    public void onClick() {
        final Projectile snowball = this.getPlayer().launchProjectile(Snowball.class, this.getPlayer().getLocation().getDirection().multiply(2));
        snowball.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
        if (this.projectiles.containsKey(this.getPlayer().getUniqueId())) {
            this.projectiles.get(this.getPlayer().getUniqueId()).add(snowball);
        } else {
            ArrayList<Projectile> projectilesList = new ArrayList<Projectile>();
            projectilesList.add(snowball);
            this.projectiles.put(this.getPlayer().getUniqueId(), projectilesList);
        }
        SoundEffect.ENTITY_CHICKEN_EGG.playSound(this.getPlayer());
        new BukkitRunnable(){
            int step = 0;

            public void run() {
                ++this.step;
                if (this.step >= 100) {
                    this.cancel();
                }
                if (snowball.isDead()) {
                    GadgetPaintballGun.this.removeProjectile(snowball);
                    Location center = snowball.getLocation();
                    for (Block block : BlockUtil.getBlocksInRadius(center.getBlock().getLocation(), GadgetPaintballGun.this.radius, false)) {
                        byte color = (byte)GadgetsMenu.random().nextInt(16);
                        EnumMaterial material = EnumMaterial.valueOf(159, color);
                        int random = GadgetsMenu.random().nextInt(7);
                        if (GadgetPaintballGun.this.radius <= 2) {
                            GadgetPaintballGun.this.setToRestore(GadgetPaintballGun.this.getPlayer(), block, material, color, 60);
                            SoundEffect.BLOCK_STONE_PLACE.playSound(block.getLocation());
                            continue;
                        }
                        if (random > 1) continue;
                        GadgetPaintballGun.this.setToRestore(GadgetPaintballGun.this.getPlayer(), block, material, color, 60);
                        SoundEffect.BLOCK_STONE_PLACE.playSound(block.getLocation());
                    }
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)GadgetsMenu.getInstance(), 1L, 5L);
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public void onClear() {
        this.clearAll();
        HandlerList.unregisterAll((Listener)this);
    }

    private void clearAll() {
        for (ArrayList<Projectile> projs : this.projectiles.values()) {
            for (Projectile proj : projs) {
                proj.remove();
            }
            projs.clear();
        }
        this.forceRestore();
    }

    private void forceRestore() {
        if (this.blocks.isEmpty()) {
            return;
        }
        for (Location loc : this.blocks.keySet()) {
            Block b = loc.getBlock();
            if (VersionManager.is1_13OrAbove()) {
                try {
                    BlockData blockData = Bukkit.getServer().createBlockData(this.blocks.get(loc));
                    b.setBlockData(blockData);
                }
                catch (NoSuchMethodError blockData) {}
            } else {
                String s = this.blocks.get(loc);
                Material m = Material.valueOf((String)s.split(",")[0]);
                byte d = Byte.valueOf(s.split(",")[1]);
                b.setType(m);
                ReflectionUtils.setData(b, d);
            }
            b.removeMetadata(GadgetsMenu.getInstance().getPluginName(), (Plugin)GadgetsMenu.getInstance());
        }
        this.blocks.clear();
    }

    private void restoreBlock(Player player, Location location) {
        if (!this.blocks.containsKey(location)) {
            return;
        }
        Block b = location.getBlock();
        if (VersionManager.is1_13OrAbove()) {
            try {
                BlockData blockData = Bukkit.getServer().createBlockData(this.blocks.get(location));
                b.setBlockData(blockData);
            }
            catch (Exception blockData) {}
        } else {
            String s = this.blocks.get(location);
            Material m = Material.valueOf((String)s.split(",")[0]);
            byte d = Byte.valueOf(s.split(",")[1]);
            b.setType(m);
            ReflectionUtils.setData(b, d);
        }
        b.removeMetadata(GadgetsMenu.getInstance().getPluginName(), (Plugin)GadgetsMenu.getInstance());
        this.blocks.remove(location);
    }

    private void setToRestore(final Player player, final Block block, EnumMaterial material, byte data, int tickDelay) {
        if (this.blocks.containsKey(block.getLocation())) {
            return;
        }
        Block bUp = block.getRelative(BlockFace.UP);
        if (!(block.getType() == Material.AIR || block.getType() == EnumMaterial.ATTACHED_MELON_STEM.getType() || block.getType() == EnumMaterial.ATTACHED_PUMPKIN_STEM.getType() || block.getType() == EnumMaterial.ANVIL.getType() || block.getType().toString().toLowerCase().contains("banner") || block.getType() == EnumMaterial.BARREL.getType() || block.getType() == EnumMaterial.BARRIER.getType() || block.getType() == EnumMaterial.BEACON.getType() || block.getType().toString().toLowerCase().contains("bed") || block.getType() == EnumMaterial.BEETROOTS.getType() || block.getType() == EnumMaterial.BEETROOTS.getType() || block.getType() == EnumMaterial.BREWING_STAND.getType() || block.getType() == EnumMaterial.BROWN_MUSHROOM.getType() || block.getType() == EnumMaterial.CACTUS.getType() || block.getType().toString().toLowerCase().contains("cake_block") || block.getType() == EnumMaterial.CAKE.getType() || block.getType() == EnumMaterial.CARROTS.getType() || block.getType().toString().toLowerCase().contains("carpet") || block.getType() == EnumMaterial.CHEST.getType() || block.getType() == EnumMaterial.COBWEB.getType() || block.getType() == EnumMaterial.COCOA.getType() || block.getType().toString().toLowerCase().contains("command") || block.getType() == EnumMaterial.CRAFTING_TABLE.getType() || block.getType().toString().toLowerCase().contains("crops") || block.getType() == EnumMaterial.DANDELION.getType() || block.getType() == EnumMaterial.DEAD_BUSH.getType() || block.getType() == EnumMaterial.DISPENSER.getType() || block.getType().toString().toLowerCase().contains("double_plant") || block.getType().toString().toLowerCase().contains("door") || block.getType() == EnumMaterial.DRAGON_EGG.getType() || block.getType() == EnumMaterial.DROPPER.getType() || block.getType() == EnumMaterial.ENCHANTING_TABLE.getType() || block.getType() == EnumMaterial.END_PORTAL.getType() || block.getType() == EnumMaterial.END_PORTAL_FRAME.getType() || block.getType() == EnumMaterial.FARMLAND.getType() || block.getType() == EnumMaterial.FERN.getType() || block.getType() == EnumMaterial.FLOWER_POT.getType() || block.getType().toString().toLowerCase().contains("flower_pot") || block.getType() == EnumMaterial.FIRE.getType() || block.getType().toString().toLowerCase().contains("furnace") || block.getType() == EnumMaterial.GRASS.getType() || block.getType().toString().toLowerCase().contains("head") || block.getType() == EnumMaterial.HOPPER.getType() || block.getType() == EnumMaterial.JUKEBOX.getType() || block.getType() == EnumMaterial.LADDER.getType() || block.getType() == EnumMaterial.LARGE_FERN.getType() || block.getType().toString().toLowerCase().endsWith("lava") || block.getType() == EnumMaterial.LEVER.getType() || block.getType() == EnumMaterial.LILY_PAD.getType() || block.getType() == EnumMaterial.LILAC.getType() || block.getType().toString().toLowerCase().contains("long_grass") || block.getType() == EnumMaterial.MELON_STEM.getType() || block.getType() == EnumMaterial.MUSHROOM_STEM.getType() || block.getType() == EnumMaterial.NETHER_WART.getType() || block.getType() == EnumMaterial.NETHER_PORTAL.getType() || block.getType() == EnumMaterial.NOTE_BLOCK.getType() || block.getType() == EnumMaterial.PEONY.getType() || block.getType().toString().toLowerCase().contains("piston_") || block.getType().toString().toLowerCase().contains("plate") || block.getType() == EnumMaterial.POTATOES.getType() || block.getType().toString().toLowerCase().contains("potted_") || block.getType() == EnumMaterial.PUMPKIN_STEM.getType() || block.getType().toString().toLowerCase().contains("redstone_comparator") || block.getType().toString().toLowerCase().contains("redstone_lamp") || block.getType().toString().toLowerCase().contains("redstone_torch") || block.getType() == EnumMaterial.REDSTONE_WIRE.getType() || block.getType() == EnumMaterial.REPEATER.getType() || block.getType() == EnumMaterial.RED_MUSHROOM.getType() || block.getType().toString().toLowerCase().contains("red_rose") || block.getType() == EnumMaterial.ROSE_BUSH.getType() || block.getType().toString().toLowerCase().contains("sapling") || block.getType().toString().toLowerCase().contains("seeds") || block.getType().toString().toLowerCase().contains("sign") || block.getType().toString().toLowerCase().contains("shulker_box") || block.getType().toString().toLowerCase().contains("skull") || block.getType() == EnumMaterial.SMOKER.getType() || block.getType() == EnumMaterial.SNOW.getType() || block.getType() == EnumMaterial.SPAWNER.getType() || block.getType() == EnumMaterial.SUGAR_CANE.getType() || block.getType().toString().toLowerCase().contains("sugar_cane_block") || block.getType() == EnumMaterial.SUNFLOWER.getType() || block.getType() == EnumMaterial.SWEET_BERRY_BUSH.getType() || block.getType() == EnumMaterial.TALL_GRASS.getType() || block.getType() == EnumMaterial.TORCH.getType() || block.getType() == EnumMaterial.TRAPPED_CHEST.getType() || block.getType() == EnumMaterial.TRIPWIRE_HOOK.getType() || block.getType() == EnumMaterial.TRIPWIRE.getType() || block.getType().toString().toLowerCase().contains("tulip") || block.getType() == EnumMaterial.VINE.getType() || block.getType().toString().toLowerCase().endsWith("water") || block.getType() == EnumMaterial.WHEAT.getType() || block.getType().toString().toLowerCase().contains("_button") || BlockUtil.isItemFrame(block) || BlockUtil.isPortalBlock(block) || BlockUtil.isCocoaBlock(block) || BlockUtil.isStem(block) || BlockUtil.isChorusPlant(block) || BlockUtil.isMushroomBlock(block) || BlockUtil.hasBlockObject(bUp) || block.hasMetadata(GadgetsMenu.getInstance().getPluginName()))) {
            for (String blackList : this.blackList) {
                GMaterial gMaterial = new GMaterial(blackList);
                if (block.getType() != gMaterial.getEnumMaterial().getType() || !VersionManager.is1_13OrAbove() && block.getData() != gMaterial.getData()) continue;
                return;
            }
            if (!this.blocks.containsKey(block.getLocation()) && !block.hasMetadata(GadgetsMenu.getInstance().getPluginName())) {
                if (VersionManager.is1_13OrAbove()) {
                    try {
                        this.blocks.put(block.getLocation(), block.getBlockData().getAsString());
                    }
                    catch (NoSuchMethodError noSuchMethodError) {}
                } else {
                    try {
                        this.blocks.put(block.getLocation(), block.getType().toString() + "," + block.getData());
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        // empty catch block
                    }
                }
                block.setType(material.getType());
                ReflectionUtils.setData(block, data);
                ParticleEffect.BLOCK_CRACK.display(new ParticleEffect.BlockData(EnumMaterial.LIGHT_GRAY_TERRACOTTA, 8), block.getLocation().clone().add(0.0, 0.8, 0.0), 0.15f, 0.15f, 0.15f, 1.0f, 3);
                block.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
                Bukkit.getScheduler().runTaskLater((Plugin)GadgetsMenu.getInstance(), new Runnable(){

                    @Override
                    public void run() {
                        GadgetPaintballGun.this.restoreBlock(player, block.getLocation());
                    }
                }, (long)tickDelay);
            }
        }
    }

    private boolean mapContainsProjectile(Projectile projectile) {
        for (ArrayList<Projectile> plist : this.projectiles.values()) {
            if (!plist.contains(projectile)) continue;
            return true;
        }
        return false;
    }

    private void removeProjectile(Projectile projectile) {
        for (UUID uuid : this.projectiles.keySet()) {
            ArrayList<Projectile> plist = this.projectiles.get(uuid);
            if (!plist.contains(projectile)) continue;
            plist.remove(projectile);
            if (plist.isEmpty()) {
                this.projectiles.remove(uuid);
            }
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onVehicleDestroy(VehicleDestroyEvent e) {
        for (ArrayList<Projectile> projectile : this.projectiles.values()) {
            for (Projectile proj : projectile) {
                if (proj.getWorld() != e.getVehicle().getWorld()) {
                    return;
                }
                if (!(proj.getLocation().distance(e.getVehicle().getLocation()) < 10.0)) continue;
                e.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onItemFrameBreak(HangingBreakByEntityEvent e) {
        if (e.getCause() == HangingBreakEvent.RemoveCause.ENTITY && e.getRemover() == this.getPlayer() && this.getPlayer().getItemInHand().equals((Object)this.getType().getItemStack())) {
            e.setCancelled(true);
            return;
        }
        if (e.getRemover() instanceof Projectile && this.mapContainsProjectile((Projectile)e.getRemover())) {
            e.setCancelled(true);
            return;
        }
    }
}

