/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.GadgetType;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types.Gadget;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.ParticleEffect;
import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.entity.Firework;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class GadgetRailgun
extends Gadget {
    private boolean activated = false;
    private ArrayList<Firework> fireworks = new ArrayList();

    public GadgetRailgun(UUID uuid) {
        super(uuid, GadgetType.RAIL_GUN);
    }

    @Override
    protected boolean checkRequirements() {
        if (this.activated) {
            this.getPlayer().sendMessage(MessageType.GADGET_IS_ACTIVATED.getFormatMessage().replace("{GADGET}", this.getType().getDisplayNameStripColor()));
            return false;
        }
        return true;
    }

    @Override
    void onClick() {
        this.activated = true;
        Location blockloc = this.getPlayer().getLocation().clone().add(this.getPlayer().getLocation().clone().getDirection().multiply(100));
        this.spawnStraightLine(this.getPlayer().getLocation(), blockloc, 25);
        new BukkitRunnable(){

            public void run() {
                GadgetRailgun.this.clearAll();
            }
        }.runTaskLater((Plugin)GadgetsMenu.getInstance(), 5L);
    }

    @Override
    void onUpdate() {
    }

    @Override
    public void onClear() {
        this.clearAll();
        HandlerList.unregisterAll((Listener)this);
    }

    private void clearAll() {
        this.activated = false;
        for (Firework fw : this.fireworks) {
            fw.remove();
        }
    }

    private void spawnStraightLine(Location start, Location end, int amount) {
        double dist = Math.abs(end.distance(start));
        for (int i = -1; i < amount; ++i) {
            double delta = (double)i / dist;
            double x = (1.0 - delta) * start.getX() + delta * (end.getX() + 0.5);
            double y = (1.0 - delta) * start.getY() + delta * (end.getY() + 0.5);
            double z = (1.0 - delta) * start.getZ() + delta * (end.getZ() + 0.5);
            Location l = new Location(start.getWorld(), x, y, z);
            Firework firework = (Firework)l.getWorld().spawn(l, Firework.class);
            ParticleEffect.FIREWORKS_SPARK.display(l, (float)GadgetsMenu.random().nextGaussian() * 0.05f, (float)(-(l.getZ() * (double)1.15f)) * 0.5f, (float)GadgetsMenu.random().nextGaussian() * 0.05f);
            this.fireworks.add(firework);
        }
    }
}

