/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.configuration.FileManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.banners.BannerType;
import com.yapzhenyie.GadgetsMenu.cosmetics.emotes.EmoteType;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.GadgetType;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types.Gadget;
import com.yapzhenyie.GadgetsMenu.cosmetics.hats.animated.AnimatedHatType;
import com.yapzhenyie.GadgetsMenu.cosmetics.hats.standard.HatType;
import com.yapzhenyie.GadgetsMenu.cosmetics.suits.SuitEquipmentType;
import com.yapzhenyie.GadgetsMenu.player.PlayerManager;
import com.yapzhenyie.GadgetsMenu.utils.BlockUtil;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.CuboID;
import com.yapzhenyie.GadgetsMenu.utils.EnumArmorType;
import com.yapzhenyie.GadgetsMenu.utils.EnumMaterial;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.ParticleEffect;
import com.yapzhenyie.GadgetsMenu.utils.PlayerUtils;
import com.yapzhenyie.GadgetsMenu.utils.ReflectionUtils;
import com.yapzhenyie.GadgetsMenu.utils.VersionManager;
import com.yapzhenyie.GadgetsMenu.utils.items.ItemUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.entity.Bat;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class GadgetScarecrow
extends Gadget {
    private boolean activated = false;
    private HashMap<Location, String> blocks = new HashMap();
    private ArrayList<Bat> bats = new ArrayList();
    private HashMap<Player, ItemStack> players = new HashMap();
    private Location centerLocation;
    public static HashMap<Player, ItemStack> pumpkinPlayers = new HashMap();
    private static String lanternDisplayName = FileManager.getGadgetsFile().getString("Gadgets.Mobs And NPCs.Types.Scarecrow.Jack-O-Lantern-DisplayName");

    public GadgetScarecrow(UUID uuid) {
        super(uuid, GadgetType.SCARECROW);
    }

    @Override
    protected boolean checkRequirements() {
        Location loc2;
        if (this.activated) {
            this.getPlayer().sendMessage(MessageType.GADGET_IS_ACTIVATED.getFormatMessage().replace("{GADGET}", this.getType().getDisplayNameStripColor()));
            return false;
        }
        if (!this.getPlayer().isOnGround()) {
            this.getPlayer().sendMessage(MessageType.NOT_ON_GROUND.getFormatMessage());
            return false;
        }
        Location loc1 = this.getPlayer().getLocation().clone().add(1.0, 0.0, -1.0);
        CuboID cuboid = new CuboID(loc1, loc2 = this.getPlayer().getLocation().clone().add(1.0, 2.0, 1.0));
        if (!cuboid.isEmpty() || cuboid.hasHangingEntities()) {
            this.getPlayer().sendMessage(MessageType.NOT_ENOUGH_SPACE.getFormatMessage());
            return false;
        }
        return true;
    }

    @Override
    public void onClick() {
        this.centerLocation = this.getPlayer().getLocation().getBlock().getLocation().clone();
        this.centerLocation.setYaw(-90.0f);
        this.centerLocation.setPitch(this.getPlayer().getLocation().getPitch());
        this.getPlayer().teleport(this.centerLocation.clone().add(0.5, 0.0, 0.5));
        this.setBlock(this.getLocation(1, 0, 0), EnumMaterial.OAK_FENCE, false, (byte)0);
        this.setBlock(this.getLocation(1, 1, -1), EnumMaterial.OAK_FENCE, false, (byte)0);
        this.setBlock(this.getLocation(1, 1, 1), EnumMaterial.OAK_FENCE, false, (byte)0);
        this.setBlock(this.getLocation(1, 1, 0), EnumMaterial.YELLOW_TERRACOTTA, false, (byte)4);
        this.setBlock(this.getLocation(1, 2, 0), EnumMaterial.JACK_O_LANTERN, true, (byte)1);
        new BukkitRunnable(){

            public void run() {
                try {
                    if (!GadgetScarecrow.this.getPlayer().isOnline() || GadgetsMenu.getPlayerManager(GadgetScarecrow.this.getPlayer()).getCurrentGadget() == null || GadgetsMenu.getPlayerManager(GadgetScarecrow.this.getPlayer()).getCurrentGadget().getType() != GadgetScarecrow.this.getType() || !GadgetScarecrow.this.activated) {
                        this.cancel();
                        return;
                    }
                    Bat bat = (Bat)GadgetScarecrow.this.getPlayer().getWorld().spawnEntity(GadgetScarecrow.this.centerLocation.clone().add(1.0 + GadgetsMenu.random().nextDouble(), 1.5 + GadgetsMenu.random().nextDouble(), GadgetsMenu.random().nextDouble()), EntityType.BAT);
                    GadgetScarecrow.this.bats.add(bat);
                    bat.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    GadgetScarecrow.this.clearAll();
                }
            }
        }.runTaskTimer((Plugin)GadgetsMenu.getInstance(), 10L, 15L);
        Bukkit.getScheduler().runTaskLater((Plugin)GadgetsMenu.getInstance(), () -> {
            if (!this.getPlayer().isOnline() || GadgetsMenu.getPlayerManager(this.getPlayer()).getCurrentGadget() == null || GadgetsMenu.getPlayerManager(this.getPlayer()).getCurrentGadget().getType() != this.getType() || !this.activated) {
                return;
            }
            this.clearAll();
        }, 200L);
        this.activated = true;
    }

    @Override
    public void onUpdate() {
        if (this.activated) {
            Bukkit.getScheduler().runTask((Plugin)GadgetsMenu.getInstance(), () -> {
                if (!this.getPlayer().isOnline() || GadgetsMenu.getPlayerManager(this.getPlayer()).getCurrentGadget() == null || GadgetsMenu.getPlayerManager(this.getPlayer()).getCurrentGadget().getType() != this.getType() || !this.activated) {
                    return;
                }
                ParticleEffect.SMOKE_LARGE.display(this.centerLocation.clone().add(1.0, 0.5, 0.0), 1.3f, 0.3f, 1.3f, 0.0f, 2);
                for (Player p : PlayerUtils.getNearbyPlayers(this.centerLocation, 5.0)) {
                    if (pumpkinPlayers.containsKey(p) || this.players.containsKey(p) || p.hasMetadata("NPC")) continue;
                    pumpkinPlayers.put(p, p.getInventory().getHelmet());
                    this.players.put(p, p.getInventory().getHelmet());
                    ItemStack item = ItemUtils.item(lanternDisplayName, EnumMaterial.JACK_O_LANTERN, 0);
                    item = GadgetsMenu.getNMSManager().setNBTTag(item, "Cosmetics", "true");
                    item = GadgetsMenu.getNMSManager().setNBTTag(item, "Category", "Gadget");
                    p.getInventory().setHelmet(item);
                }
            });
        }
    }

    @Override
    public void onClear() {
        this.clearAll();
        HandlerList.unregisterAll((Listener)this);
    }

    private void clearAll() {
        for (Location location : this.blocks.keySet()) {
            Block b = location.clone().getBlock();
            b.setType(Material.AIR);
            b.removeMetadata(GadgetsMenu.getInstance().getPluginName(), (Plugin)GadgetsMenu.getInstance());
        }
        this.blocks.clear();
        for (Bat bat : this.bats) {
            if (!bat.isValid()) continue;
            ParticleEffect.SMOKE_LARGE.display(bat.getLocation(), 0.1f, 0.1f, 0.1f, 1);
            bat.remove();
        }
        this.bats.clear();
        for (Player p : this.players.keySet()) {
            if (p == null || !p.isOnline()) continue;
            GadgetScarecrow.unequipLitPumpkin(p);
        }
        this.players.clear();
        this.centerLocation = null;
        this.activated = false;
    }

    public static void unequipLitPumpkin(Player player) {
        if (player == null || !player.isOnline()) {
            return;
        }
        if (pumpkinPlayers.containsKey(player)) {
            if (player.getInventory().getHelmet() != null && player.getInventory().getHelmet().getItemMeta() != null && player.getInventory().getHelmet().getItemMeta().hasDisplayName() && player.getInventory().getHelmet().getItemMeta().getDisplayName().equals(ChatUtil.format(lanternDisplayName))) {
                ItemStack i = pumpkinPlayers.get(player);
                if (i != null && i.getItemMeta() != null && i.getItemMeta().hasDisplayName()) {
                    String name = ChatUtil.format(i.getItemMeta().getDisplayName());
                    PlayerManager pManager = GadgetsMenu.getPlayerManager(player);
                    if (pManager != null) {
                        for (HatType hatType : HatType.values()) {
                            if (!hatType.getDisplayName().equals(name) || GadgetsMenu.getPlayerManager(player).getSelectedHat() != null) continue;
                            player.getInventory().setHelmet(null);
                            player.updateInventory();
                            pumpkinPlayers.remove(player);
                            return;
                        }
                        for (AnimatedHatType animatedHatType : AnimatedHatType.values()) {
                            if (!animatedHatType.getDisplayName().equals(name) || GadgetsMenu.getPlayerManager(player).getSelectedAnimatedHat() != null) continue;
                            player.getInventory().setHelmet(null);
                            player.updateInventory();
                            pumpkinPlayers.remove(player);
                            return;
                        }
                        for (SuitEquipmentType suitEquipmentType : SuitEquipmentType.values()) {
                            if (suitEquipmentType.getArmorType() != EnumArmorType.HELMET || !suitEquipmentType.getDisplayName().equals(name) || !pManager.getSelectedSuitEquipment().isEmpty() && (pManager.getSelectedSuitEquipment().isEmpty() || GadgetsMenu.getPlayerManager(player).getSelectedSuitEquipment().containsKey((Object)EnumArmorType.HELMET))) continue;
                            player.getInventory().setHelmet(null);
                            player.updateInventory();
                            pumpkinPlayers.remove(player);
                            return;
                        }
                        for (BannerType bannerType : BannerType.values()) {
                            if (!bannerType.getDisplayName().equals(name) || GadgetsMenu.getPlayerManager(player).getSelectedBanner() != null) continue;
                            player.getInventory().setHelmet(null);
                            player.updateInventory();
                            pumpkinPlayers.remove(player);
                            return;
                        }
                        for (EmoteType emoteType : EmoteType.values()) {
                            if (!emoteType.getDisplayName().equals(name) || GadgetsMenu.getPlayerManager(player).getSelectedEmote() != null) continue;
                            player.getInventory().setHelmet(null);
                            player.updateInventory();
                            pumpkinPlayers.remove(player);
                            return;
                        }
                    }
                }
                player.getInventory().setHelmet(pumpkinPlayers.get(player));
            }
            pumpkinPlayers.remove(player);
        }
    }

    private void setBlock(Block block, EnumMaterial material, boolean changeFacing, byte facing) {
        if (!this.blocks.containsKey(block.getLocation())) {
            if (VersionManager.is1_13OrAbove()) {
                try {
                    this.blocks.put(block.getLocation(), block.getBlockData().getAsString());
                }
                catch (NoSuchMethodError noSuchMethodError) {}
            } else {
                try {
                    this.blocks.put(block.getLocation(), block.getType().toString() + "," + block.getData());
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
            }
            block.setType(material.getType());
            if (VersionManager.is1_13OrAbove()) {
                if (changeFacing) {
                    BlockData blockData = block.getBlockData();
                    ((Directional)blockData).setFacing(BlockUtil.getBlockFace(facing));
                    block.setBlockData(blockData);
                }
            } else {
                ReflectionUtils.setData(block, changeFacing ? facing : material.getData());
            }
            block.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
        }
    }

    private Block getLocation(int x, int y, int z) {
        return this.centerLocation.getBlock().getRelative(x, y, z);
    }
}

