/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.configuration.FileManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.GadgetType;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types.Gadget;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.CuboID;
import com.yapzhenyie.GadgetsMenu.utils.EnumMaterial;
import com.yapzhenyie.GadgetsMenu.utils.MathUtil;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.PlayerUtils;
import com.yapzhenyie.GadgetsMenu.utils.ReflectionUtils;
import com.yapzhenyie.GadgetsMenu.utils.SoundEffect;
import com.yapzhenyie.GadgetsMenu.utils.VersionManager;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class GadgetSwing
extends Gadget {
    private boolean activated = false;
    private Location location;
    private HashMap<Location, String> blocks = new HashMap();
    private static List<String> messages = FileManager.getGadgetsFile().getStringList("Gadgets.Fun And Games.Types.Swing.Messages");

    public GadgetSwing(UUID uuid) {
        super(uuid, GadgetType.BAT_LAUNCHER);
    }

    @Override
    protected boolean checkRequirements() {
        Location loc2;
        if (this.activated) {
            this.getPlayer().sendMessage(MessageType.GADGET_IS_ACTIVATED.getFormatMessage().replace("{GADGET}", this.getType().getDisplayNameStripColor()));
            return false;
        }
        if (!this.getPlayer().isOnGround()) {
            this.getPlayer().sendMessage(MessageType.NOT_ON_GROUND.getFormatMessage());
            return false;
        }
        Location loc1 = this.getPlayer().getLocation().clone().add(0.0, 0.0, -1.0);
        CuboID cuboid = new CuboID(loc1, loc2 = this.getPlayer().getLocation().clone().add(0.0, 4.0, 1.0));
        if (!cuboid.isEmpty()) {
            this.getPlayer().sendMessage(MessageType.NOT_ENOUGH_SPACE.getFormatMessage());
            return false;
        }
        return true;
    }

    @Override
    public void onClick() {
        this.location = this.getPlayer().getLocation().clone();
        Location teleportLoc = this.getPlayer().getLocation().getBlock().getLocation().clone().add(0.5, 5.0, 0.5);
        teleportLoc.setYaw(-90.0f);
        this.getPlayer().teleport(teleportLoc);
        this.genetateSwing();
        new BukkitRunnable(){

            public void run() {
                if (!GadgetSwing.this.getPlayer().isOnline() || GadgetsMenu.getPlayerManager(GadgetSwing.this.getPlayer()).getCurrentGadget() == null || GadgetsMenu.getPlayerManager(GadgetSwing.this.getPlayer()).getCurrentGadget().getType() != GadgetSwing.this.getType() || !GadgetSwing.this.activated) {
                    return;
                }
                GadgetSwing.this.clearAll();
            }
        }.runTaskLater((Plugin)GadgetsMenu.getInstance(), 800L);
        this.activated = true;
    }

    @Override
    public void onUpdate() {
        if (this.activated) {
            Bukkit.getScheduler().runTask((Plugin)GadgetsMenu.getInstance(), new Runnable(){

                @Override
                public void run() {
                    for (Player player : PlayerUtils.getNearbyPlayers(GadgetSwing.this.getLocation(2, 4, 0).getLocation(), 2.0)) {
                        Block b = player.getLocation().getBlock().getRelative(BlockFace.DOWN);
                        if (b.getType() != EnumMaterial.OAK_SLAB.getType() || b.getData() != 0) continue;
                        MathUtil.applyVelocity((Entity)player, new Vector(0.3, 1.8, 0.0));
                        SoundEffect.BLOCK_WOODEN_TRAPDOOR_OPEN.playSound(b.getLocation());
                        if (!GadgetsMenu.random().nextBoolean()) continue;
                        player.sendMessage(ChatUtil.format((String)messages.get(GadgetsMenu.random().nextInt(messages.size()))));
                    }
                }
            });
        }
    }

    @Override
    public void onClear() {
        this.clearAll();
        HandlerList.unregisterAll((Listener)this);
    }

    private void clearAll() {
        if (this.location != null) {
            // empty if block
        }
        for (Location location : this.blocks.keySet()) {
            Block b = location.clone().getBlock();
            b.setType(Material.AIR);
            b.removeMetadata(GadgetsMenu.getInstance().getPluginName(), (Plugin)GadgetsMenu.getInstance());
        }
        this.blocks.clear();
        this.activated = false;
    }

    private void genetateSwing() {
        this.setBlock(this.getLocation(0, 0, -1), EnumMaterial.OAK_FENCE, (byte)0);
        this.setBlock(this.getLocation(0, 1, -1), EnumMaterial.OAK_FENCE, (byte)0);
        this.setBlock(this.getLocation(0, 2, -1), EnumMaterial.OAK_FENCE, (byte)0);
        this.setBlock(this.getLocation(0, 0, 1), EnumMaterial.OAK_FENCE, (byte)0);
        this.setBlock(this.getLocation(0, 1, 1), EnumMaterial.OAK_FENCE, (byte)0);
        this.setBlock(this.getLocation(0, 2, 1), EnumMaterial.OAK_FENCE, (byte)0);
        ArmorStand as1 = (ArmorStand)this.getPlayer().getWorld().spawnEntity(this.location.clone().add(0.5, 0.0, 0.5), EntityType.ARMOR_STAND);
        as1.setVisible(false);
        as1.setGravity(false);
        as1.setSmall(true);
        as1.setArms(false);
        as1.setBasePlate(false);
        if (VersionManager.is1_9OrAbove()) {
            as1.setSilent(true);
        }
        as1.setHelmet(new ItemStack(EnumMaterial.OAK_SLAB.getType()));
        as1.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
    }

    private void setBlock(Block block, EnumMaterial material, byte data) {
        if (!this.blocks.containsKey(block.getLocation())) {
            if (VersionManager.is1_13OrAbove()) {
                try {
                    this.blocks.put(block.getLocation(), block.getBlockData().getAsString());
                }
                catch (NoSuchMethodError noSuchMethodError) {}
            } else {
                try {
                    this.blocks.put(block.getLocation(), block.getType().toString() + "," + block.getData());
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
            }
        }
        block.setType(material.getType());
        ReflectionUtils.setData(block, data);
        block.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
    }

    private Block getLocation(int x, int y, int z) {
        return this.location.getBlock().getRelative(x, y, z);
    }
}

