/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.configuration.FileManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.GadgetType;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types.Gadget;
import com.yapzhenyie.GadgetsMenu.utils.BlockUtil;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.ParticleEffect;
import com.yapzhenyie.GadgetsMenu.utils.SoundEffect;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class GadgetTeleportStick
extends Gadget {
    private Location targetLocation;
    private static int range = 30;

    public GadgetTeleportStick(UUID uuid) {
        super(uuid, GadgetType.TELEPORT_STICK);
        if (FileManager.getGadgetsFile().get(this.getType().getFilePath() + ".Range") != null) {
            range = FileManager.getGadgetsFile().getInt(this.getType().getFilePath() + ".Range");
        }
    }

    @Override
    protected boolean checkRequirements() {
        Block block = BlockUtil.getTargetBlock(this.getPlayer(), range);
        if (block == null) {
            this.getPlayer().sendMessage(MessageType.TARGET_A_BLOCK.getFormatMessage());
            return false;
        }
        Location location = block.getLocation();
        if (location == null || location != null && location.getBlock().isEmpty()) {
            this.getPlayer().sendMessage(MessageType.TARGET_A_BLOCK.getFormatMessage());
            return false;
        }
        Location location2 = ((Block)this.getPlayer().getLastTwoTargetBlocks((Set)null, range).get(0)).getLocation();
        if (!location.clone().add(0.0, 1.0, 0.0).getBlock().isEmpty() || !location.clone().add(0.0, 2.0, 0.0).getBlock().isEmpty() && location2.clone().getBlock().isEmpty() && location2.clone().add(0.0, 1.0, 0.0).getBlock().isEmpty() && location2.clone().add(0.0, 2.0, 0.0).getBlock().isEmpty() && location2.clone().add(0.0, 3.0, 0.0).getBlock().isEmpty()) {
            if (BlockUtil.isOutsideOfBorder(location2)) {
                this.getPlayer().sendMessage(MessageType.NOT_ALLOWED_TELEPORT_TO_THAT_LOCATION.getFormatMessage());
                return false;
            }
            this.targetLocation = location2;
            return true;
        }
        if (BlockUtil.isOutsideOfBorder(location)) {
            this.getPlayer().sendMessage(MessageType.NOT_ALLOWED_TELEPORT_TO_THAT_LOCATION.getFormatMessage());
            return false;
        }
        if (!location.add(0.0, 1.0, 0.0).getBlock().isEmpty() || !location.add(0.0, 2.0, 0.0).getBlock().isEmpty()) {
            this.getPlayer().sendMessage(MessageType.NOT_ENOUGH_SPACE.getFormatMessage());
            return false;
        }
        this.targetLocation = location;
        return true;
    }

    @Override
    public void onClick() {
        this.targetLocation.setDirection(this.getPlayer().getLocation().getDirection());
        this.targetLocation.add(0.0, 1.25, 0.0);
        this.getPlayer().teleport(this.targetLocation);
        ParticleEffect.SMOKE_LARGE.display(this.targetLocation, 0.5f, 0.5f, 0.5f, 15);
        ParticleEffect.ENCHANTMENT_TABLE.display(this.targetLocation, 0.5f, 0.5f, 0.5f, 20);
        SoundEffect.ENTITY_ENDERMAN_TELEPORT.playSound(this.targetLocation);
        Bukkit.getScheduler().runTaskLater((Plugin)GadgetsMenu.getInstance(), new Runnable(){

            @Override
            public void run() {
                GadgetsMenu.getPlayerManager(GadgetTeleportStick.this.getPlayer()).disableFallDamage();
            }
        }, 4L);
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public void onClear() {
        HandlerList.unregisterAll((Listener)this);
    }
}

