/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.configuration.FileManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.GadgetType;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types.Gadget;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.SoundEffect;
import com.yapzhenyie.GadgetsMenu.utils.WorldUtils;
import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;

public class GadgetTeleporter
extends Gadget {
    private boolean activated = false;
    private boolean stopCounting = false;
    private int steps = 0;
    private Player targetPlayer = null;
    private static String initiatingMessage = FileManager.getGadgetsFile().getString("Gadgets.Movement.Types.Teleporter.Messages.Initiating-Teleport-Sequence");
    private static String scanningMessage = FileManager.getGadgetsFile().getString("Gadgets.Movement.Types.Teleporter.Messages.Scanning-Players");
    private static String targetAcquiredMessage = FileManager.getGadgetsFile().getString("Gadgets.Movement.Types.Teleporter.Messages.Target-Acquired");
    private static String teleportInitiatingMessage = FileManager.getGadgetsFile().getString("Gadgets.Movement.Types.Teleporter.Messages.Teleport-Initiating");
    private static String teleportCompleteMessage = FileManager.getGadgetsFile().getString("Gadgets.Movement.Types.Teleporter.Messages.Teleport-Complete");
    private static String processFailedMessage = FileManager.getGadgetsFile().getString("Gadgets.Movement.Types.Teleporter.Messages.Process-Failed");
    private static String abortedMessage = FileManager.getGadgetsFile().getString("Gadgets.Movement.Types.Teleporter.Messages.Aborted-Teleport-Sequence");

    public GadgetTeleporter(UUID uuid) {
        super(uuid, GadgetType.TELEPORTER);
    }

    @Override
    protected boolean checkRequirements() {
        if (this.activated) {
            this.getPlayer().sendMessage(MessageType.GADGET_IS_ACTIVATED.getFormatMessage().replace("{GADGET}", this.getType().getDisplayNameStripColor()));
            return false;
        }
        return true;
    }

    @Override
    public void onClick() {
        this.activated = true;
    }

    @Override
    public void onUpdate() {
        if (this.activated) {
            if (this.steps % 40 == 0 && !this.stopCounting) {
                if (Bukkit.getOnlinePlayers().size() <= 1 && this.steps / 40 == 2) {
                    this.sendFailedMessage();
                    return;
                }
                if (this.steps / 40 > 2) {
                    if (this.targetPlayer == null) {
                        this.sendFailedMessage();
                        return;
                    }
                    if (!this.targetPlayer.isOnline()) {
                        this.sendFailedMessage();
                        return;
                    }
                }
                if (this.steps == 0) {
                    this.getPlayer().sendMessage(ChatUtil.format(initiatingMessage));
                } else if (this.steps / 40 == 1) {
                    this.getPlayer().sendMessage(ChatUtil.format(scanningMessage));
                    SoundEffect.ENTITY_ENDER_DRAGON_HURT.playSound(this.getPlayer());
                } else if (this.steps / 40 == 2) {
                    this.getPlayer().sendMessage(ChatUtil.format(targetAcquiredMessage));
                    SoundEffect.ENTITY_ENDER_DRAGON_HURT.playSound(this.getPlayer());
                    ArrayList<Player> players = new ArrayList<Player>();
                    for (Player p : Bukkit.getOnlinePlayers()) {
                        if (p == this.getPlayer() || !WorldUtils.isWorldEnabled(p.getWorld()) || !p.isOnline()) continue;
                        players.add(p);
                    }
                    if (players.isEmpty()) {
                        this.sendFailedMessage();
                        return;
                    }
                    this.targetPlayer = (Player)players.get(GadgetsMenu.random().nextInt(players.size()));
                } else if (this.steps / 40 == 3) {
                    this.getPlayer().sendMessage(ChatUtil.format(teleportInitiatingMessage));
                    SoundEffect.ENTITY_ENDER_DRAGON_HURT.playSound(this.getPlayer());
                } else if (this.steps / 40 == 4) {
                    Bukkit.getScheduler().runTask((Plugin)GadgetsMenu.getInstance(), () -> {
                        if (this.targetPlayer == null) {
                            this.sendFailedMessage();
                            return;
                        }
                        if (!this.targetPlayer.isOnline()) {
                            this.sendFailedMessage();
                            return;
                        }
                        this.getPlayer().teleport((Entity)this.targetPlayer, PlayerTeleportEvent.TeleportCause.PLUGIN);
                        this.getPlayer().sendMessage(ChatUtil.format(teleportCompleteMessage));
                        SoundEffect.ENTITY_ENDER_DRAGON_FLAP.playSound(this.getPlayer());
                        this.clearAll();
                    });
                }
            }
            ++this.steps;
        }
    }

    @Override
    public void onClear() {
        this.clearAll();
        HandlerList.unregisterAll((Listener)this);
    }

    private void clearAll() {
        this.stopCounting = false;
        this.targetPlayer = null;
        this.steps = 0;
        this.activated = false;
    }

    private void sendFailedMessage() {
        this.getPlayer().sendMessage(ChatUtil.format(processFailedMessage));
        SoundEffect.ENTITY_ENDERMAN_DEATH.playSound(this.getPlayer());
        this.stopCounting = true;
        Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)GadgetsMenu.getInstance(), () -> {
            if (!this.getPlayer().isOnline() || GadgetsMenu.getPlayerManager(this.getPlayer()).getCurrentGadget() == null || GadgetsMenu.getPlayerManager(this.getPlayer()).getCurrentGadget().getType() != this.getType() || !this.activated) {
                this.onClear();
                return;
            }
            this.getPlayer().sendMessage(ChatUtil.format(abortedMessage));
            this.clearAll();
        }, 20L);
    }
}

