/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.configuration.FileManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.GadgetType;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types.Gadget;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.EnumItem;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.PlayerUtils;
import com.yapzhenyie.GadgetsMenu.utils.SoundEffect;
import com.yapzhenyie.GadgetsMenu.utils.StringUtils;
import com.yapzhenyie.GadgetsMenu.utils.WorldUtils;
import com.yapzhenyie.GadgetsMenu.utils.items.InventoryUtils;
import com.yapzhenyie.GadgetsMenu.utils.items.ItemUtils;
import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class GadgetTicTacToe
extends Gadget {
    public static ArrayList<Player> pendingPlayers = new ArrayList();
    public static ArrayList<Player> acceptedPlayers = new ArrayList();
    public static ArrayList<Player> declinedPlayers = new ArrayList();
    private boolean activated = false;
    private Player targetPlayer;
    private boolean challengerTurn = true;
    private ItemStack[] symbols = new ItemStack[]{null, null, null, null, null, null, null, null, null};
    private static int[] slots = new int[]{3, 4, 5, 12, 13, 14, 21, 22, 23};
    private static ItemStack c = EnumItem.TIC_TAC_TOE_CHALLENGER_SYMBOL.getItemStack();
    private static ItemStack o = EnumItem.TIC_TAC_TOE_OPPONENT_SYMBOL.getItemStack();
    private static String TicTacToeGUIName = ChatUtil.format(FileManager.getGadgetsFile().getString("Gadgets.Fun And Games.Types.Tic Tac Toe.Items.GUI-Name"));
    private static int[][] winMethods = new int[][]{{0, 1, 2}, {3, 4, 5}, {6, 7, 8}, {0, 3, 6}, {1, 4, 7}, {2, 5, 8}, {0, 4, 8}, {2, 4, 6}};
    private static String targetAPlayerMessage = FileManager.getGadgetsFile().getString("Gadgets.Fun And Games.Types.Tic Tac Toe.Messages.Target-A-Player");
    private static String targetOtherPlayerMessage = FileManager.getGadgetsFile().getString("Gadgets.Fun And Games.Types.Tic Tac Toe.Messages.Target-Other-Player");
    private static String sendChallengeMessage = FileManager.getGadgetsFile().getString("Gadgets.Fun And Games.Types.Tic Tac Toe.Messages.Challenge");
    private static String alreadySentARequestMessage = FileManager.getGadgetsFile().getString("Gadgets.Fun And Games.Types.Tic Tac Toe.Messages.Already-Sent-A-Request");
    private static String receivedChallengeMessage = FileManager.getGadgetsFile().getString("Gadgets.Fun And Games.Types.Tic Tac Toe.Messages.Received-Challenge");
    private static String acceptMessage = FileManager.getGadgetsFile().getString("Gadgets.Fun And Games.Types.Tic Tac Toe.Messages.Accept");
    private static String declineMessage = FileManager.getGadgetsFile().getString("Gadgets.Fun And Games.Types.Tic Tac Toe.Messages.Decline");
    private static String acceptJsonMessage = FileManager.getGadgetsFile().getString("Gadgets.Fun And Games.Types.Tic Tac Toe.Messages.Accept-Json-message");
    private static String declineJsonMessage = FileManager.getGadgetsFile().getString("Gadgets.Fun And Games.Types.Tic Tac Toe.Messages.Decline-Json-message");
    public static String noPendingChallengeMessage = FileManager.getGadgetsFile().getString("Gadgets.Fun And Games.Types.Tic Tac Toe.Messages.No-Pending-Challenge");
    private static String acceptedChallengeMessage = FileManager.getGadgetsFile().getString("Gadgets.Fun And Games.Types.Tic Tac Toe.Messages.Accepted-Challenge");
    private static String declinedChallengeMessage = FileManager.getGadgetsFile().getString("Gadgets.Fun And Games.Types.Tic Tac Toe.Messages.Declined-Challenge");
    private static String drawMessage = FileManager.getGadgetsFile().getString("Gadgets.Fun And Games.Types.Tic Tac Toe.Messages.Draw");
    private static String winMessage = FileManager.getGadgetsFile().getString("Gadgets.Fun And Games.Types.Tic Tac Toe.Messages.Win");
    private static String lossMessage = FileManager.getGadgetsFile().getString("Gadgets.Fun And Games.Types.Tic Tac Toe.Messages.Loss");
    private static String playerLeftMessage = FileManager.getGadgetsFile().getString("Gadgets.Fun And Games.Types.Tic Tac Toe.Messages.Player-Left-Game");
    private static String opponentLeftMessage = FileManager.getGadgetsFile().getString("Gadgets.Fun And Games.Types.Tic Tac Toe.Messages.Opponent-Left-Game");

    public GadgetTicTacToe(UUID uuid) {
        super(uuid, GadgetType.TIC_TAC_TOE);
    }

    @Override
    protected boolean checkRequirements() {
        if (this.activated) {
            this.getPlayer().sendMessage(MessageType.GADGET_IS_ACTIVATED.getFormatMessage().replace("{GADGET}", this.getType().getDisplayNameStripColor()));
            return false;
        }
        Entity target = PlayerUtils.getEntityPlayerLookingAt(this.getPlayer(), 10);
        if (target == null) {
            this.getPlayer().sendMessage(ChatUtil.format(targetAPlayerMessage));
            return false;
        }
        if (!(target instanceof Player)) {
            this.getPlayer().sendMessage(ChatUtil.format(targetAPlayerMessage));
            return false;
        }
        if (!this.getPlayer().canSee((Player)target) || PlayerUtils.isVanished((Player)target)) {
            this.getPlayer().sendMessage(ChatUtil.format(targetAPlayerMessage));
            return false;
        }
        if (this.targetPlayer != null && target == this.targetPlayer) {
            this.getPlayer().sendMessage(ChatUtil.format(alreadySentARequestMessage).replace("{PLAYER}", this.targetPlayer.getName()));
            return false;
        }
        if (acceptedPlayers.contains(target)) {
            this.getPlayer().sendMessage(ChatUtil.format(targetOtherPlayerMessage));
            return false;
        }
        if (pendingPlayers.contains(target)) {
            this.getPlayer().sendMessage(ChatUtil.format(targetOtherPlayerMessage));
            return false;
        }
        if (this.targetPlayer != null && pendingPlayers.contains(this.targetPlayer)) {
            pendingPlayers.remove(this.targetPlayer);
        }
        this.targetPlayer = (Player)target;
        return true;
    }

    @Override
    public void onClick() {
        if (this.targetPlayer != null && this.targetPlayer.isOnline()) {
            this.getPlayer().sendMessage(ChatUtil.format(sendChallengeMessage).replace("{PLAYER}", this.targetPlayer.getName()));
            this.targetPlayer.sendMessage(ChatUtil.format(receivedChallengeMessage).replace("{PLAYER}", this.getPlayer().getName()));
            GadgetsMenu.getNMSManager().newJSONMessage(ChatUtil.format(acceptMessage)).showText(ChatUtil.format(acceptJsonMessage)).runCommand("/tictactoe accept {PLAYER}".replace("{PLAYER}", this.getPlayer().getName())).then(" ").then(ChatUtil.format(declineMessage)).showText(ChatUtil.format(declineJsonMessage)).runCommand("/tictactoe decline {PLAYER}".replace("{PLAYER}", this.getPlayer().getName())).send(this.targetPlayer);
            if (!pendingPlayers.contains(this.targetPlayer)) {
                pendingPlayers.add(this.targetPlayer);
            }
        } else {
            this.getPlayer().sendMessage(ChatUtil.format(targetAPlayerMessage));
            return;
        }
    }

    @Override
    public void onUpdate() {
        if (declinedPlayers.contains(this.getPlayer())) {
            this.clearAll();
        }
        if (this.activated) {
            if (this.getPlayer() == null || this.getPlayer() != null && !this.getPlayer().isOnline()) {
                this.targetPlayer.sendMessage(ChatUtil.format(opponentLeftMessage));
                this.clearAll();
                return;
            }
            if (this.targetPlayer == null || this.targetPlayer != null && !this.targetPlayer.isOnline()) {
                this.getPlayer().sendMessage(ChatUtil.format(opponentLeftMessage));
                this.clearAll();
                return;
            }
            boolean orange = true;
            boolean blue = true;
            for (int[] w : winMethods) {
                orange = true;
                blue = true;
                for (int i : w) {
                    ItemStack item = this.symbols[i];
                    if (item == null) {
                        orange = false;
                        blue = false;
                        break;
                    }
                    if (item != EnumItem.TIC_TAC_TOE_CHALLENGER_SYMBOL.getItemStack()) {
                        orange = false;
                    }
                    if (item == EnumItem.TIC_TAC_TOE_OPPONENT_SYMBOL.getItemStack()) continue;
                    blue = false;
                }
                if (orange || blue) break;
            }
            if (!orange && !blue) {
                boolean draw = true;
                for (int i = 0; i <= 8; ++i) {
                    if (this.symbols[i] != null) continue;
                    draw = false;
                    break;
                }
                if (draw) {
                    try {
                        this.getPlayer().sendMessage(ChatUtil.format(drawMessage.replace("{PLAYER}", this.targetPlayer.getName())));
                        this.targetPlayer.sendMessage(ChatUtil.format(drawMessage.replace("{PLAYER}", this.getPlayer().getName())));
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    this.clearAll();
                    return;
                }
            }
            if (orange) {
                try {
                    this.getPlayer().sendMessage(ChatUtil.format(winMessage.replace("{PLAYER}", this.targetPlayer.getName())));
                    this.targetPlayer.sendMessage(ChatUtil.format(lossMessage.replace("{PLAYER}", this.getPlayer().getName())));
                    SoundEffect.ENTITY_PLAYER_LEVELUP.playSound(this.getPlayer(), 1.0f, 1.0f);
                    SoundEffect.ENTITY_ENDERMAN_DEATH.playSound(this.targetPlayer, 1.0f, 1.0f);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                this.clearAll();
                return;
            }
            if (blue) {
                try {
                    this.getPlayer().sendMessage(ChatUtil.format(lossMessage.replace("{PLAYER}", this.targetPlayer.getName())));
                    this.targetPlayer.sendMessage(ChatUtil.format(winMessage.replace("{PLAYER}", this.getPlayer().getName())));
                    SoundEffect.ENTITY_PLAYER_LEVELUP.playSound(this.targetPlayer, 1.0f, 1.0f);
                    SoundEffect.ENTITY_ENDERMAN_DEATH.playSound(this.getPlayer(), 1.0f, 1.0f);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                this.clearAll();
                return;
            }
            if (this.getPlayer().getOpenInventory() == null || this.getPlayer().getOpenInventory() != null && !this.getPlayer().getOpenInventory().getTitle().startsWith(ChatUtil.format(TicTacToeGUIName.replace("{OPPONENT}", this.targetPlayer.getName())))) {
                try {
                    this.getPlayer().sendMessage(ChatUtil.format(playerLeftMessage));
                    this.targetPlayer.sendMessage(ChatUtil.format(opponentLeftMessage));
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                this.clearAll();
                return;
            }
            if (this.targetPlayer.getOpenInventory() == null || this.targetPlayer.getOpenInventory() != null && !this.targetPlayer.getOpenInventory().getTitle().startsWith(ChatUtil.format(TicTacToeGUIName.replace("{OPPONENT}", this.getPlayer().getName())))) {
                try {
                    this.targetPlayer.sendMessage(ChatUtil.format(playerLeftMessage));
                    this.getPlayer().sendMessage(ChatUtil.format(opponentLeftMessage));
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                this.clearAll();
                return;
            }
        }
    }

    @Override
    public void onClear() {
        this.clearAll();
        HandlerList.unregisterAll((Listener)this);
    }

    private void clearAll() {
        if (!GadgetsMenu.getInstance().isEnabled()) {
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)GadgetsMenu.getInstance(), () -> {
            if (this.targetPlayer != null) {
                if (pendingPlayers.contains(this.targetPlayer)) {
                    pendingPlayers.remove(this.targetPlayer);
                }
                if (acceptedPlayers.contains(this.targetPlayer)) {
                    if (this.targetPlayer.getOpenInventory() != null && this.activated) {
                        this.targetPlayer.closeInventory();
                    }
                    acceptedPlayers.remove(this.targetPlayer);
                }
            }
            if (this.getPlayer().getOpenInventory() != null && this.activated) {
                this.getPlayer().closeInventory();
            }
            if (acceptedPlayers.contains(this.getPlayer())) {
                acceptedPlayers.remove(this.getPlayer());
            }
            if (declinedPlayers.contains(this.getPlayer())) {
                declinedPlayers.remove(this.getPlayer());
            }
            this.targetPlayer = null;
            this.challengerTurn = true;
            for (int i = 0; i <= 8; ++i) {
                this.symbols[i] = null;
            }
            this.activated = false;
        });
    }

    public void openTicTacToeMenu(Player player, Player opponent) {
        if (player != this.getPlayer() && player != this.targetPlayer) {
            return;
        }
        if (opponent != this.getPlayer() && opponent != this.targetPlayer) {
            return;
        }
        Inventory invTicTacToe = Bukkit.createInventory(null, (int)27, (String)ChatUtil.format(TicTacToeGUIName.replace("{OPPONENT}", opponent.getName())));
        int i = 0;
        if (player == this.getPlayer()) {
            if (this.challengerTurn) {
                for (ItemStack symbol : this.symbols) {
                    InventoryUtils.inventory(invTicTacToe, symbol == null ? EnumItem.TIC_TAC_TOE_PLACE_SYMBOL.getItemStack() : symbol, slots[i++]);
                }
            } else {
                for (ItemStack symbol : this.symbols) {
                    InventoryUtils.inventory(invTicTacToe, symbol == null ? EnumItem.TIC_TAC_TOE_NOT_YOUR_TURN.getItemStack() : symbol, slots[i++]);
                }
            }
        } else if (!this.challengerTurn) {
            for (ItemStack symbol : this.symbols) {
                InventoryUtils.inventory(invTicTacToe, symbol == null ? EnumItem.TIC_TAC_TOE_PLACE_SYMBOL.getItemStack() : symbol, slots[i++]);
            }
        } else {
            for (ItemStack symbol : this.symbols) {
                InventoryUtils.inventory(invTicTacToe, symbol == null ? EnumItem.TIC_TAC_TOE_NOT_YOUR_TURN.getItemStack() : symbol, slots[i++]);
            }
        }
        InventoryUtils.inventory(invTicTacToe, StringUtils.addPlaceholder(EnumItem.TIC_TAC_TOE_CHALLENGER.getDisplayName(), "{PLAYER}", player == this.getPlayer() ? player.getName() : opponent.getName()), EnumItem.TIC_TAC_TOE_CHALLENGER.getMaterial(), StringUtils.addPlaceholder(EnumItem.TIC_TAC_TOE_CHALLENGER.getLore(), "{PLAYER}", player == this.getPlayer() ? player.getName() : opponent.getName()), player == this.getPlayer() ? EnumItem.TIC_TAC_TOE_CHALLENGER.getSlot() : EnumItem.TIC_TAC_TOE_OPPONENT.getSlot());
        InventoryUtils.inventory(invTicTacToe, StringUtils.addPlaceholder(EnumItem.TIC_TAC_TOE_OPPONENT.getDisplayName(), "{PLAYER}", player == this.getPlayer() ? opponent.getName() : player.getName()), EnumItem.TIC_TAC_TOE_OPPONENT.getMaterial(), StringUtils.addPlaceholder(EnumItem.TIC_TAC_TOE_OPPONENT.getLore(), "{PLAYER}", player == this.getPlayer() ? opponent.getName() : player.getName()), player == this.getPlayer() ? EnumItem.TIC_TAC_TOE_OPPONENT.getSlot() : EnumItem.TIC_TAC_TOE_CHALLENGER.getSlot());
        player.openInventory(invTicTacToe);
    }

    private void placeSymbol(Player player, int num) {
        if (player != this.getPlayer() && player != this.targetPlayer) {
            return;
        }
        if (this.targetPlayer != null && this.targetPlayer.isOnline()) {
            if (player == this.getPlayer()) {
                if (this.challengerTurn) {
                    this.symbols[num] = c;
                    this.challengerTurn = false;
                }
            } else if (player == this.targetPlayer && !this.challengerTurn) {
                this.symbols[num] = o;
                this.challengerTurn = true;
            }
            Player opponent = this.targetPlayer;
            if (player == this.getPlayer()) {
                opponent = this.targetPlayer;
            } else if (player == this.targetPlayer) {
                opponent = this.getPlayer();
            }
            this.openTicTacToeMenu(player, opponent);
            this.openTicTacToeMenu(opponent, player);
        } else {
            this.clearAll();
        }
    }

    @EventHandler
    private void onInvClickTicTacToe(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (this.targetPlayer != null && (player == this.getPlayer() || player == this.targetPlayer) && event.getView().getTitle().startsWith(TicTacToeGUIName.replace("{OPPONENT}", ""))) {
            if (event.getClickedInventory() == null || event.getClickedInventory().getSize() != 27 || event.getClickedInventory().getType() != InventoryType.CHEST) {
                event.setCancelled(true);
                return;
            }
            if (!WorldUtils.isWorldEnabled(player, true)) {
                player.closeInventory();
                event.setCancelled(true);
                return;
            }
            if (event.getCurrentItem() == null || event.getCurrentItem().getItemMeta() == null || event.getCurrentItem().getItemMeta().getDisplayName() == null) {
                event.setCancelled(true);
                return;
            }
            if (event.getClick() == ClickType.SHIFT_LEFT || event.getClick() == ClickType.SHIFT_RIGHT || event.getClick() == ClickType.NUMBER_KEY || event.getClick() == ClickType.UNKNOWN) {
                player.closeInventory();
                event.setCancelled(true);
                return;
            }
            int i = 0;
            for (int s : slots) {
                if (ItemUtils.getCurrentItem(event, EnumItem.TIC_TAC_TOE_PLACE_SYMBOL.getItemStack(), s)) {
                    this.placeSymbol(player, i);
                    event.setCancelled(true);
                    return;
                }
                ++i;
            }
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onPlayerExecuteTicTacToeCommand(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        if (player == this.targetPlayer && event.getMessage().startsWith("/tictactoe") && pendingPlayers.contains(player)) {
            Player sender;
            if (event.getMessage().contains("accept")) {
                Player sender2 = Bukkit.getPlayer((String)event.getMessage().replace("/tictactoe accept ", ""));
                if (sender2 != null && sender2.isOnline()) {
                    sender2.sendMessage(ChatUtil.format(acceptedChallengeMessage).replace("{PLAYER}", player.getName()));
                    if (!acceptedPlayers.contains(sender2)) {
                        acceptedPlayers.add(sender2);
                    }
                    if (!acceptedPlayers.contains(player)) {
                        acceptedPlayers.add(player);
                    }
                    this.openTicTacToeMenu(player, sender2);
                    this.openTicTacToeMenu(sender2, player);
                    this.activated = true;
                }
            } else if (event.getMessage().contains("decline") && (sender = Bukkit.getPlayer((String)event.getMessage().replace("/tictactoe decline ", ""))) != null && sender.isOnline()) {
                sender.sendMessage(ChatUtil.format(declinedChallengeMessage).replace("{PLAYER}", player.getName()));
                if (!declinedPlayers.contains(sender)) {
                    declinedPlayers.add(sender);
                }
                if (this.targetPlayer == event.getPlayer()) {
                    this.targetPlayer = null;
                }
            }
            pendingPlayers.remove(player);
            event.setCancelled(true);
            return;
        }
    }
}

