/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.hats.animated;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.cosmetics.Category;
import com.yapzhenyie.GadgetsMenu.cosmetics.hats.animated.AnimatedHatType;
import com.yapzhenyie.GadgetsMenu.utils.EnumArmorType;
import com.yapzhenyie.GadgetsMenu.utils.EnumPermission;
import com.yapzhenyie.GadgetsMenu.utils.PermissionUtils;
import com.yapzhenyie.GadgetsMenu.utils.WorldUtils;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class AnimatedHat {
    private UUID uuid;
    private AnimatedHatType type;
    private Player player;

    public AnimatedHat(UUID uuid, final AnimatedHatType type) {
        this.type = type;
        if (!type.isEnabled()) {
            return;
        }
        if (uuid != null) {
            this.uuid = uuid;
            this.player = Bukkit.getPlayer((UUID)uuid);
            if (PermissionUtils.noPermission(this.getPlayer(), type.getPermission(), EnumPermission.ANIMATED_HATS.getPermission(), true)) {
                GadgetsMenu.getPlayerManager(this.getPlayer()).unequipAnimatedHat();
                return;
            }
            if (GadgetsMenu.getPlayerManager(this.getPlayer()).getCurrentAnimatedHat() != null) {
                GadgetsMenu.getPlayerManager(this.getPlayer()).unequipAnimatedHat();
            }
            try {
                BukkitRunnable runnable = new BukkitRunnable(){
                    int step = -1;

                    public void run() {
                        if (AnimatedHat.this.getPlayerUUID() != null && Bukkit.getPlayer((UUID)AnimatedHat.this.getPlayerUUID()) != null && GadgetsMenu.getPlayerManager(AnimatedHat.this.getPlayer()).getCurrentAnimatedHat() != null && GadgetsMenu.getPlayerManager(AnimatedHat.this.getPlayer()).getCurrentAnimatedHat().getType() == AnimatedHat.this.getType()) {
                            if (!Category.ANIMATED_HATS.isEnabled() || !WorldUtils.isWorldEnabled(AnimatedHat.this.getPlayer(), true)) {
                                GadgetsMenu.getPlayerManager(AnimatedHat.this.getPlayer()).unequipAnimatedHat();
                                AnimatedHat.this.getPlayer().updateInventory();
                                return;
                            }
                            if (PermissionUtils.noPermission(AnimatedHat.this.getPlayer(), type.getPermission(), EnumPermission.ANIMATED_HATS.getPermission(), true)) {
                                GadgetsMenu.getPlayerManager(AnimatedHat.this.getPlayer()).unequipAnimatedHat();
                                AnimatedHat.this.getPlayer().updateInventory();
                                return;
                            }
                            if (AnimatedHat.this.getPlayer().getInventory().getHelmet() != null && !GadgetsMenu.getNMSManager().isNBTTagEqual(AnimatedHat.this.getPlayer().getInventory().getHelmet(), "Category", "Animated_Hat")) {
                                if (GadgetsMenu.getPlayerManager(AnimatedHat.this.getPlayer()).getSelectedHat() != null) {
                                    GadgetsMenu.getPlayerManager(AnimatedHat.this.getPlayer()).unequipHat();
                                } else if (!GadgetsMenu.getPlayerManager(AnimatedHat.this.getPlayer()).getSelectedSuitEquipment().isEmpty() && GadgetsMenu.getPlayerManager(AnimatedHat.this.getPlayer()).getSelectedSuitEquipment().containsKey((Object)EnumArmorType.HELMET)) {
                                    GadgetsMenu.getPlayerManager(AnimatedHat.this.getPlayer()).unequipSuitEquipment(EnumArmorType.HELMET);
                                } else if (GadgetsMenu.getPlayerManager(AnimatedHat.this.getPlayer()).getSelectedBanner() != null) {
                                    GadgetsMenu.getPlayerManager(AnimatedHat.this.getPlayer()).unequipBanner();
                                } else if (GadgetsMenu.getPlayerManager(AnimatedHat.this.getPlayer()).getSelectedEmote() != null) {
                                    GadgetsMenu.getPlayerManager(AnimatedHat.this.getPlayer()).unequipEmote();
                                } else {
                                    Bukkit.getScheduler().runTask((Plugin)GadgetsMenu.getInstance(), () -> {
                                        AnimatedHat.this.getPlayer().getWorld().dropItemNaturally(AnimatedHat.this.getPlayer().getLocation(), AnimatedHat.this.getPlayer().getInventory().getHelmet().clone());
                                        AnimatedHat.this.getPlayer().getInventory().setHelmet(null);
                                        AnimatedHat.this.getPlayer().updateInventory();
                                    });
                                }
                            }
                            ++this.step;
                            try {
                                if (this.step >= AnimatedHat.this.getType().getFrames().size()) {
                                    this.step = 0;
                                }
                                if (this.step <= AnimatedHat.this.getType().getFrames().size() - 1) {
                                    AnimatedHat.this.player.getInventory().setHelmet(AnimatedHat.this.getType().getFrames().get(this.step));
                                }
                            }
                            catch (Exception ex) {
                                AnimatedHat.this.clearAll();
                                this.cancel();
                            }
                        } else {
                            this.cancel();
                        }
                    }
                };
                runnable.runTaskTimerAsynchronously((Plugin)GadgetsMenu.getInstance(), 1L, this.getType().getTicksPerFrame().longValue());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            GadgetsMenu.getPlayerManager(this.getPlayer()).setCurrentAnimatedHat(this);
        }
    }

    public UUID getPlayerUUID() {
        return this.uuid;
    }

    public AnimatedHatType getType() {
        return this.type;
    }

    protected Player getPlayer() {
        return this.player;
    }

    public void clear() {
        if (this.uuid == null) {
            return;
        }
        if (GadgetsMenu.getPlayerManager(this.getPlayer()).getCurrentAnimatedHat() != null) {
            GadgetsMenu.getPlayerManager(this.getPlayer()).setCurrentAnimatedHat(null);
        }
        this.uuid = null;
    }

    private void clearAll() {
        this.player.getInventory().setHelmet(null);
    }
}

