/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.hats.animated;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.configuration.FileManager;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.GMaterial;
import com.yapzhenyie.GadgetsMenu.utils.items.ItemUtils;
import com.yapzhenyie.GadgetsMenu.utils.mysteryboxes.utils.Rarity;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.inventory.ItemStack;

public class AnimatedHatType {
    private static final List<AnimatedHatType> ENABLED = new ArrayList<AnimatedHatType>();
    private static final List<AnimatedHatType> VALUES = new ArrayList<AnimatedHatType>();
    public static final AnimatedHatType SIREN = new AnimatedHatType("Siren", "&9Siren Animated Hat", new GMaterial.GMaterialHead("de1fa6b8449fc4d6e3edce48b8416038d1637ebf4d929e9f89bc2153ddcd690"), "gadgetsmenu.animatedhats.siren", 20, Rarity.RARE, null, 15L);
    public static final AnimatedHatType SAMMY_THE_COOKIE = new AnimatedHatType("Sammy The Cookie", "&9Sammy The Cookie Animated Hat", new GMaterial.GMaterialHead("3023b1dd91d2b36cade5665c3f7897fcb8de1ae619a4e96185637b19bdcff47"), "gadgetsmenu.animatedhats.sammythecookie", 25, Rarity.RARE, null, 8L);
    public static final AnimatedHatType CHROMA_SLIME = new AnimatedHatType("Chroma Slime", "&9Chroma Slime Animated Hat", new GMaterial.GMaterialHead("dad2fadea3e3d71630f4bfd9d457dd5dab7f799651fd37c36f257cf59908ef0d"), "gadgetsmenu.animatedhats.chromaslime", 28, Rarity.RARE, null, 8L);
    public static final AnimatedHatType COLOR_BLOCK = new AnimatedHatType("Color Block", "&9Color Block Animated Hat", new GMaterial.GMaterialHead("97c1f1ead4d531caa4a5b0d69edbce29af789a2550e5ddbd23775be05e2df2c4"), "gadgetsmenu.animatedhats.colorblock", 28, Rarity.RARE, null, 8L);
    private String name;
    private String displayName;
    private GMaterial material;
    private String permission;
    private int mysteryDust;
    private Rarity rarity;
    private List<String> lore;
    private Long ticksPerFrame;
    private boolean isEnable;
    private boolean canBeFound;
    private boolean purchasable;
    private ArrayList<ItemStack> frames;

    private AnimatedHatType(String name, String displayName, GMaterial.GMaterialHead material, String permission, int mysteryDust, Rarity rarity, List<String> lore, Long ticksPerFrame) {
        this.name = name;
        if (FileManager.getAnimatedHatsFile().get("Animated-Hats." + this.name + ".Name") == null) {
            this.displayName = displayName;
            FileManager.getAnimatedHatsFile().set("Animated-Hats." + this.name + ".Name", this.displayName);
        } else {
            this.displayName = FileManager.getAnimatedHatsFile().getString("Animated-Hats." + this.name + ".Name");
        }
        this.material = material.getMaterial();
        this.permission = permission;
        if (FileManager.getAnimatedHatsFile().get("Animated-Hats." + this.name + ".Mystery Dust") == null) {
            this.mysteryDust = mysteryDust;
            FileManager.getAnimatedHatsFile().set("Animated-Hats." + this.name + ".Mystery Dust", this.mysteryDust);
        } else {
            this.mysteryDust = FileManager.getAnimatedHatsFile().getInt("Animated-Hats." + this.name + ".Mystery Dust");
        }
        if (FileManager.getAnimatedHatsFile().get("Animated-Hats." + this.name + ".Rarity") == null) {
            this.rarity = rarity;
            FileManager.getAnimatedHatsFile().set("Animated-Hats." + this.name + ".Rarity", this.rarity.getName());
        } else {
            this.rarity = Rarity.getName(FileManager.getAnimatedHatsFile().getString("Animated-Hats." + this.name + ".Rarity"));
        }
        if (FileManager.getAnimatedHatsFile().get("Animated-Hats." + this.name + ".Enabled") == null) {
            this.isEnable = true;
            FileManager.getAnimatedHatsFile().set("Animated-Hats." + this.name + ".Enabled", true);
        } else {
            this.isEnable = FileManager.getAnimatedHatsFile().getBoolean("Animated-Hats." + this.name + ".Enabled");
        }
        if (FileManager.getAnimatedHatsFile().get("Animated-Hats." + this.name + ".CanBeFound") == null) {
            this.canBeFound = true;
            FileManager.getAnimatedHatsFile().set("Animated-Hats." + this.name + ".CanBeFound", true);
        } else {
            this.canBeFound = FileManager.getAnimatedHatsFile().getBoolean("Animated-Hats." + this.name + ".CanBeFound");
        }
        if (FileManager.getAnimatedHatsFile().get("Animated-Hats." + this.name + ".Purchasable") == null) {
            this.purchasable = true;
            FileManager.getAnimatedHatsFile().set("Animated-Hats." + this.name + ".Purchasable", true);
        } else {
            this.purchasable = FileManager.getAnimatedHatsFile().getBoolean("Animated-Hats." + this.name + ".Purchasable");
        }
        if (FileManager.getAnimatedHatsFile().get("Animated-Hats." + this.name + ".Lore") == null) {
            this.lore = lore;
            if (lore == null) {
                FileManager.getAnimatedHatsFile().set("Animated-Hats." + this.name + ".Lore", "");
            } else {
                FileManager.getAnimatedHatsFile().set("Animated-Hats." + this.name + ".Lore", this.lore);
            }
        } else {
            this.lore = FileManager.getAnimatedHatsFile().getStringList("Animated-Hats." + this.name + ".Lore");
        }
        this.ticksPerFrame = ticksPerFrame;
        this.frames = new ArrayList();
        if (!VALUES.contains(this)) {
            VALUES.add(this);
        }
    }

    public AnimatedHatType(String name, String displayName, GMaterial.GMaterialHead material, String permission, int mysteryDust, Rarity rarity, List<String> lore, Long ticksPerFrame, boolean isEnable, boolean canBeFound, boolean purchasable, ArrayList<ItemStack> frames) {
        this.name = name;
        this.displayName = displayName;
        this.material = material.getMaterial();
        this.permission = permission;
        this.mysteryDust = mysteryDust;
        this.rarity = rarity;
        this.lore = lore;
        this.ticksPerFrame = ticksPerFrame;
        this.isEnable = isEnable;
        this.canBeFound = canBeFound;
        this.purchasable = purchasable;
        this.frames = frames;
        if (!VALUES.contains(this)) {
            VALUES.add(this);
        }
        if (isEnable && !ENABLED.contains(this)) {
            ENABLED.add(this);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return ChatUtil.format(this.displayName);
    }

    public String getDisplayNameStripColor() {
        return ChatUtil.stripColor(this.displayName);
    }

    public GMaterial getMaterial() {
        return this.material;
    }

    public String getPermission() {
        return this.permission;
    }

    public int getMysteryDust() {
        return this.mysteryDust;
    }

    public Rarity getRarity() {
        return this.rarity;
    }

    public List<String> getLore() {
        return this.lore;
    }

    public Long getTicksPerFrame() {
        return this.ticksPerFrame;
    }

    public void addTexture(int amount, String texture) {
        ItemStack item = ItemUtils.itemSkull(this.displayName, texture);
        item = GadgetsMenu.getNMSManager().setNBTTag(item, "Cosmetics", "true");
        item = GadgetsMenu.getNMSManager().setNBTTag(item, "Category", "Animated_Hat");
        if (amount == 1) {
            this.frames.add(item);
        } else {
            for (int i = 0; i < amount; ++i) {
                this.frames.add(item);
            }
        }
    }

    public ArrayList<ItemStack> getFrames() {
        return this.frames;
    }

    public boolean isEnabled() {
        return this.isEnable;
    }

    public boolean canBeFound() {
        return this.canBeFound;
    }

    public boolean isPurchasable() {
        return this.purchasable;
    }

    public static List<AnimatedHatType> enabled() {
        return ENABLED;
    }

    public static List<AnimatedHatType> values() {
        return VALUES;
    }

    public static void checkEnabled() {
        for (AnimatedHatType type : AnimatedHatType.values()) {
            if (!type.isEnabled() || ENABLED.contains(type)) continue;
            ENABLED.add(type);
        }
    }

    public String toString() {
        return this.name;
    }

    public static AnimatedHatType valueOf(String name) throws NullPointerException {
        for (AnimatedHatType type : AnimatedHatType.values()) {
            if (!type.getName().equalsIgnoreCase(name)) continue;
            return type;
        }
        return null;
    }

    static {
        SIREN.addTexture(1, "de1fa6b8449fc4d6e3edce48b8416038d1637ebf4d929e9f89bc2153ddcd690");
        SIREN.addTexture(1, "3834f686997b64fa996c5528e44c7ed54d0f3660f936ddb6da1f3681bd1e1c");
        SAMMY_THE_COOKIE.addTexture(1, "3023b1dd91d2b36cade5665c3f7897fcb8de1ae619a4e96185637b19bdcff47");
        SAMMY_THE_COOKIE.addTexture(1, "56e61019132de9d1b06bcacf587fe5fafbe4e9ceaa2ae9ff7c9e2cb2fe749ec");
        SAMMY_THE_COOKIE.addTexture(1, "2586f81751eedcc502a66814fcd9d734fad4d4cf3256c44075215965ed49e6b4");
        SAMMY_THE_COOKIE.addTexture(1, "27b493551c6fb2e75e10ab7c164d14af4e440faf8d51242fce615fef7bbf7f58");
        CHROMA_SLIME.addTexture(1, "dad2fadea3e3d71630f4bfd9d457dd5dab7f799651fd37c36f257cf59908ef0d");
        CHROMA_SLIME.addTexture(1, "78e972ce80afd6176fa37f7156a6f0cbc49b3a28d0be29fe692742edf950d2");
        CHROMA_SLIME.addTexture(1, "72521833a613ffd2ed8d8be5daea145204828867e5de78ab482b698290b4af");
        CHROMA_SLIME.addTexture(1, "dc96ed4ebfa4fedd2c6d7711e7362d0905beef3fcdf7d1aceda5ef0c9a4e62");
        CHROMA_SLIME.addTexture(1, "2166a434ae4165e2a2e29dc28aa78f3fa9a9cdf89a66b3378645f8320eee446");
        CHROMA_SLIME.addTexture(1, "16ad20fc2d579be250d3db659c832da2b478a73a698b7ea10d18c9162e4d9b5");
        CHROMA_SLIME.addTexture(1, "141fd629eaeb6c656e50526e9fed35981113eb29ee157799df976bac7cf9");
        CHROMA_SLIME.addTexture(1, "74d578ff3231c32f43f13d464343574d3153bb5655bb75544b9dfde8a0a6db");
        CHROMA_SLIME.addTexture(1, "f69a60d0c71a81e38a358c62c693d63b863836fe2a0c71478837ff698d08864");
        CHROMA_SLIME.addTexture(1, "20ec2a665fc17f79b96fcdaf442626ec1e15ca8f8f22a781bd6a27a651a29d7e");
        COLOR_BLOCK.addTexture(1, "3f46c31d6ee6ea619f72e785232cb048ab270462db0cb1454514436251c1a");
        COLOR_BLOCK.addTexture(1, "97c1f1ead4d531caa4a5b0d69edbce29af789a2550e5ddbd23775be05e2df2c4");
        COLOR_BLOCK.addTexture(1, "4bac77520b9eee65068ef1cd8abeadb013b4de3953fd29ac68e90e4866227");
        COLOR_BLOCK.addTexture(1, "fea590b681589fb9b0e8664ee945b41eb3851faf66aaf48525fba169c34270");
        COLOR_BLOCK.addTexture(1, "d3cdb16abb1751d1a481ed87b57db3b883e9961da2f9d485a2986487e2");
        COLOR_BLOCK.addTexture(1, "14c4141c1edf3f7e41236bd658c5bc7b5aa7abf7e2a852b647258818acd70d8");
        COLOR_BLOCK.addTexture(1, "36f69f7b7538b41dc3439f3658abbd59facca366f190bcf1d6d0a026c8f96");
        COLOR_BLOCK.addTexture(1, "cad01592ca44189f8abad0c2efa3cae6aafae76daaa7ea46655cc1293489ff");
        COLOR_BLOCK.addTexture(1, "361e5b333c2a3868bb6a58b6674a2639323815738e77e053977419af3f77");
        COLOR_BLOCK.addTexture(1, "c96540ce762125e398ca53d4cd9b668396d0467e128b30da5aa62be9ce060");
        COLOR_BLOCK.addTexture(1, "b839e381d9fedab6f8b59396a2764238dceb2f7eea856dc6fc44767da382f1");
        COLOR_BLOCK.addTexture(1, "3b19dc4d467882dbca1b5c37465f0cfc70ff1f829ecf4a865796b8e5c2809a");
        COLOR_BLOCK.addTexture(1, "c1482b755858657fb51b7d3fbf4cd8c090c05e35bd8cdba98b19499d7833acb2");
        COLOR_BLOCK.addTexture(1, "489ce89526fc12624678f305493aa65da8a1b360546a505d118eb1fad775");
        COLOR_BLOCK.addTexture(1, "7d31d21cb54294ee3a2056137d123b576f78bfc4878cd8144cd51e1931c39b5");
        COLOR_BLOCK.addTexture(1, "e9352bcabfc27edb44ceb51b04786542f26a299a0529475346186ee94738f");
        COLOR_BLOCK.addTexture(1, "7557db5f15ca6f3701903cca402ce77ec6f885036b6812e8288abd7e94");
        COLOR_BLOCK.addTexture(1, "855654b3f1bfb2cdf0f4b52d6360a03d31ddafc710f8afaea99fba667e482df");
        COLOR_BLOCK.addTexture(1, "9133fa52dd74d711e53747da963b8adecf92db946be113b56c38b3dc270eeb3");
    }
}

