/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.morphs.types;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.cosmetics.morphs.MorphType;
import com.yapzhenyie.GadgetsMenu.utils.EnumItem;
import com.yapzhenyie.GadgetsMenu.utils.EnumPermission;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.PermissionUtils;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public abstract class Morph
implements Listener {
    public UUID uuid;
    private MorphType type;
    private Player player;
    private Listener listener;

    public Morph(UUID uuid, final MorphType type) {
        this.type = type;
        if (!type.isEnabled()) {
            return;
        }
        if (uuid != null) {
            this.uuid = uuid;
            this.player = Bukkit.getPlayer((UUID)uuid);
            if (PermissionUtils.noPermission(this.getPlayer(), type.getPermission(), EnumPermission.MORPHS.getPermission(), false)) {
                GadgetsMenu.getPlayerManager(this.getPlayer()).unequipMorph();
                return;
            }
            if (GadgetsMenu.getPlayerManager(this.getPlayer()).getCurrentMorph() != null) {
                GadgetsMenu.getPlayerManager(this.getPlayer()).removeMorph();
            }
            try {
                BukkitRunnable runnable = new BukkitRunnable(){

                    public void run() {
                        if (Morph.this.getPlayerUUID() != null && Bukkit.getPlayer((UUID)Morph.this.getPlayerUUID()) != null && GadgetsMenu.getPlayerManager(Morph.this.getPlayer()).getCurrentMorph() != null && GadgetsMenu.getPlayerManager(Morph.this.getPlayer()).getCurrentMorph().getType() == Morph.this.getType()) {
                            if (GadgetsMenu.getGadgetsMenuData().isCooldownInActionBar() && GadgetsMenu.getPlayerManager(Morph.this.player).morphCooldown().containsKey(Morph.this.getType())) {
                                if (GadgetsMenu.getPlayerManager(Morph.this.player).morphCooldown().get(Morph.this.getType()) - System.currentTimeMillis() > 0L && !GadgetsMenu.getPlayerManager(Morph.this.player).isBypassCooldown()) {
                                    GadgetsMenu.getPlayerManager(Morph.this.getPlayer()).sendCooldownBar(type.getDisplayName(), GadgetsMenu.getPlayerManager(Morph.this.player).morphCooldown().get(Morph.this.getType()), type.getCooldown());
                                } else {
                                    GadgetsMenu.getPlayerManager(Morph.this.getPlayer()).resetCooldownBar();
                                    GadgetsMenu.getPlayerManager(Morph.this.player).morphCooldown().remove(Morph.this.getType());
                                }
                            }
                            Morph.this.onUpdate();
                        } else {
                            this.cancel();
                        }
                    }
                };
                runnable.runTaskTimerAsynchronously((Plugin)GadgetsMenu.getInstance(), 0L, 1L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.listener = new MorphListener(this);
            GadgetsMenu.getInstance().registerListener(this.listener);
            GadgetsMenu.getInstance().registerListener(this);
            GadgetsMenu.getPlayerManager(this.getPlayer()).setCurrentMorph(this);
        }
    }

    protected UUID getPlayerUUID() {
        return this.uuid;
    }

    public MorphType getType() {
        return this.type;
    }

    protected Player getPlayer() {
        return this.player;
    }

    abstract void onClick();

    abstract void onUpdate();

    public abstract void onClear();

    protected boolean checkRequirements() {
        return true;
    }

    public void removeListener() {
        HandlerList.unregisterAll((Listener)this);
    }

    public void unregisterListeners() {
        try {
            HandlerList.unregisterAll((Listener)this);
            HandlerList.unregisterAll((Listener)this.listener);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void clear() {
        if (this.uuid == null) {
            return;
        }
        if (GadgetsMenu.getPlayerManager(this.getPlayer()).getCurrentMorph() != null) {
            GadgetsMenu.getPlayerManager(this.getPlayer()).setCurrentMorph(null);
        }
        this.unregisterListeners();
        this.uuid = null;
    }

    public class MorphListener
    implements Listener {
        private Morph morph;

        public MorphListener(Morph morph) {
            this.morph = morph;
        }

        @EventHandler
        protected void onPlayerActivateMorphSkill(PlayerInteractEvent event) {
            Player player = event.getPlayer();
            UUID uuid = player.getUniqueId();
            if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
                return;
            }
            if (!player.getItemInHand().hasItemMeta() || !player.getItemInHand().getItemMeta().hasDisplayName()) {
                return;
            }
            if (!uuid.equals(this.morph.uuid)) {
                return;
            }
            if (!GadgetsMenu.getGDisguise().isDisguised(player) || GadgetsMenu.getPlayerManager(player).getSelectedMorph() == null) {
                event.setCancelled(true);
                return;
            }
            if (player.getItemInHand().getItemMeta().getDisplayName().equals(EnumItem.MORPH_SLIMEBALL.getDisplayName()) && player.getItemInHand().getType() == Material.SLIME_BALL) {
                if (GadgetsMenu.getPlayerManager(player).morphCooldown().containsKey(Morph.this.getType()) && !GadgetsMenu.getPlayerManager(player).isBypassCooldown()) {
                    if (GadgetsMenu.getPlayerManager(player).morphCooldown().get(Morph.this.getType()) - System.currentTimeMillis() <= 0L) {
                        GadgetsMenu.getPlayerManager(player).morphCooldown().remove(Morph.this.getType());
                    } else {
                        player.sendMessage(MessageType.COOLDOWN.getFormatMessage().replace("{COOLDOWN}", String.valueOf((GadgetsMenu.getPlayerManager(player).morphCooldown().get(Morph.this.getType()) - System.currentTimeMillis()) / 1000L + 1L)));
                        player.updateInventory();
                        event.setCancelled(true);
                        return;
                    }
                }
                if (PermissionUtils.noPermission(player, Morph.this.type.getPermission(), EnumPermission.MORPHS.getPermission(), true)) {
                    GadgetsMenu.getPlayerManager(player).unequipMorph();
                    player.updateInventory();
                    event.setCancelled(true);
                    return;
                }
                if (!Morph.this.type.isAbilityEnabled()) {
                    player.sendMessage(MessageType.MORPH_ABILITY_IS_DISABLED.getFormatMessage().replace("{MORPH}", Morph.this.type.getDisplayNameStripColor()));
                    player.updateInventory();
                    event.setCancelled(true);
                    return;
                }
                if (!GadgetsMenu.getGadgetsMenuData().isLibsDisguiseEnabled()) {
                    player.updateInventory();
                    event.setCancelled(true);
                    return;
                }
                if (Morph.this.checkRequirements()) {
                    this.morph.onClick();
                    if (!GadgetsMenu.getPlayerManager(player).isBypassCooldown()) {
                        GadgetsMenu.getPlayerManager(player).morphCooldown().put(Morph.this.getType(), System.currentTimeMillis() + (long)Morph.this.getType().getCooldown() * 1000L);
                    }
                    player.updateInventory();
                    event.setCancelled(true);
                    return;
                }
                player.updateInventory();
                event.setCancelled(true);
                return;
            }
        }
    }
}

