/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.morphs.types;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.cosmetics.morphs.MorphType;
import com.yapzhenyie.GadgetsMenu.cosmetics.morphs.types.Morph;
import com.yapzhenyie.GadgetsMenu.utils.BlockUtil;
import com.yapzhenyie.GadgetsMenu.utils.EnumMaterial;
import com.yapzhenyie.GadgetsMenu.utils.MathUtil;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.ParticleEffect;
import com.yapzhenyie.GadgetsMenu.utils.SoundEffect;
import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class MorphIronGolem
extends Morph {
    private boolean activated = false;
    private ArrayList<FallingBlock> fallingBlocks = new ArrayList();

    public MorphIronGolem(UUID uuid) {
        super(uuid, MorphType.IRON_GOLEM);
    }

    @Override
    protected boolean checkRequirements() {
        if (this.activated) {
            this.getPlayer().sendMessage(MessageType.MORPH_SKILL_IS_ACTIVATED.getFormatMessage().replace("{MORPH}", this.getType().getDisplayNameStripColor()));
            return false;
        }
        return true;
    }

    @Override
    void onClick() {
        this.activated = true;
        SoundEffect.ENTITY_FIREWORK_ROCKET_LAUNCH.playSound(this.getPlayer().getLocation(), 2.0f, 1.0f);
        this.getPlayer().setVelocity(new Vector(0, 2, 0));
        new BukkitRunnable(){
            int step = 0;

            public void run() {
                ++this.step;
                if (!MorphIronGolem.this.getPlayer().isOnline() || GadgetsMenu.getPlayerManager(MorphIronGolem.this.getPlayer()).getCurrentMorph() == null || GadgetsMenu.getPlayerManager(MorphIronGolem.this.getPlayer()).getCurrentMorph().getType() != MorphIronGolem.this.getType()) {
                    MorphIronGolem.this.onClear();
                    this.step = 16;
                    this.cancel();
                    return;
                }
                if (this.step > 15) {
                    this.cancel();
                }
                ParticleEffect.CLOUD.display(MorphIronGolem.this.getPlayer().getLocation());
            }
        }.runTaskTimer((Plugin)GadgetsMenu.getInstance(), 0L, 1L);
        Bukkit.getScheduler().runTaskLater((Plugin)GadgetsMenu.getInstance(), new Runnable(){

            @Override
            public void run() {
                if (!MorphIronGolem.this.getPlayer().isOnline() || GadgetsMenu.getPlayerManager(MorphIronGolem.this.getPlayer()).getCurrentMorph() == null || GadgetsMenu.getPlayerManager(MorphIronGolem.this.getPlayer()).getCurrentMorph().getType() != MorphIronGolem.this.getType()) {
                    MorphIronGolem.this.onClear();
                    return;
                }
                MorphIronGolem.this.getPlayer().setVelocity(new Vector(0, -2, 0));
            }
        }, 25L);
        new BukkitRunnable(){

            public void run() {
                if (!MorphIronGolem.this.getPlayer().isOnline() || GadgetsMenu.getPlayerManager(MorphIronGolem.this.getPlayer()).getCurrentMorph() == null || GadgetsMenu.getPlayerManager(MorphIronGolem.this.getPlayer()).getCurrentMorph().getType() != MorphIronGolem.this.getType()) {
                    MorphIronGolem.this.onClear();
                    this.cancel();
                    return;
                }
                if (MorphIronGolem.this.getPlayer().isOnGround()) {
                    MorphIronGolem.this.spawnFallingBlock(MorphIronGolem.this.getPlayer());
                    Bukkit.getScheduler().runTaskLater((Plugin)GadgetsMenu.getInstance(), new Runnable(){

                        @Override
                        public void run() {
                            try {
                                MorphIronGolem.this.clearAll();
                            }
                            catch (Exception e) {
                                MorphIronGolem.this.onClear();
                            }
                            SoundEffect.BLOCK_GRASS_STEP.playSound(MorphIronGolem.this.getPlayer().getLocation());
                            MorphIronGolem.this.fallingBlocks.remove(MorphIronGolem.this.getPlayer().getUniqueId());
                        }
                    }, 15L);
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)GadgetsMenu.getInstance(), 10L, 1L);
    }

    @Override
    void onUpdate() {
    }

    @Override
    public void onClear() {
        this.clearAll();
        HandlerList.unregisterAll((Listener)this);
    }

    private void clearAll() {
        for (FallingBlock fallingblock : this.fallingBlocks) {
            if (fallingblock == null) continue;
            fallingblock.remove();
        }
        this.fallingBlocks.clear();
        this.activated = false;
    }

    private void spawnFallingBlock(final Player player) {
        final Location loc = player.getLocation();
        SoundEffect.ENTITY_GENERIC_EXPLODE.playSound(player.getLocation(), 2.0f, 1.0f);
        new BukkitRunnable(){
            int step = 1;

            public void run() {
                if (!player.isOnline() || GadgetsMenu.getPlayerManager(MorphIronGolem.this.getPlayer()).getCurrentMorph() == null || GadgetsMenu.getPlayerManager(MorphIronGolem.this.getPlayer()).getCurrentMorph().getType() != MorphIronGolem.this.getType() || !MorphIronGolem.this.activated) {
                    this.step = 5;
                    MorphIronGolem.this.clearAll();
                    this.cancel();
                }
                if (this.step >= 5) {
                    this.cancel();
                }
                for (FallingBlock fallingblock : MorphIronGolem.this.fallingBlocks) {
                    if (fallingblock.getTicksLived() <= 3) continue;
                    fallingblock.remove();
                }
                for (Block b : BlockUtil.getBlocksInRadius(loc.clone().add(1.0, -1.0, 1.0), this.step, true)) {
                    if (b.getType() == Material.AIR || b.getType().toString().toLowerCase().contains("banner") || b.getType() == EnumMaterial.BARRIER.getType() || b.getType().toString().toLowerCase().contains("bed") || b.getType() == EnumMaterial.BREWING_STAND.getType() || b.getType() == EnumMaterial.BROWN_MUSHROOM.getType() || b.getType() == EnumMaterial.CACTUS.getType() || b.getType() == EnumMaterial.CARROT.getType() || b.getType() == EnumMaterial.CARROTS.getType() || b.getType().toString().toLowerCase().contains("carpet") || b.getType() == EnumMaterial.CHEST.getType() || b.getType() == EnumMaterial.COCOA.getType() || b.getType().toString().toLowerCase().contains("crops") || b.getType() == EnumMaterial.DANDELION.getType() || b.getType() == EnumMaterial.DEAD_BUSH.getType() || b.getType().toString().toLowerCase().contains("double_plant") || b.getType() == EnumMaterial.DRAGON_EGG.getType() || b.getType() == EnumMaterial.END_PORTAL.getType() || b.getType() == EnumMaterial.END_PORTAL_FRAME.getType() || b.getType() == EnumMaterial.FARMLAND.getType() || b.getType() == EnumMaterial.FERN.getType() || b.getType() == EnumMaterial.FIRE.getType() || b.getType() == EnumMaterial.FLOWER_POT.getType() || b.getType().toString().toLowerCase().contains("flower_pot") || b.getType() == EnumMaterial.GRASS.getType() || b.getType().toString().toLowerCase().contains("head") || b.getType() == EnumMaterial.LADDER.getType() || b.getType() == EnumMaterial.LARGE_FERN.getType() || b.getType().toString().toLowerCase().endsWith("lava") || b.getType() == EnumMaterial.LILY_PAD.getType() || b.getType() == EnumMaterial.LILAC.getType() || b.getType().toString().toLowerCase().contains("long_grass") || b.getType() == EnumMaterial.MELON_STEM.getType() || b.getType() == EnumMaterial.MUSHROOM_STEM.getType() || b.getType() == EnumMaterial.NETHER_PORTAL.getType() || b.getType() == EnumMaterial.NETHER_WART.getType() || b.getType() == EnumMaterial.PEONY.getType() || b.getType().toString().toLowerCase().contains("piston_") || b.getType() == EnumMaterial.POTATO.getType() || b.getType() == EnumMaterial.POTATOES.getType() || b.getType().toString().toLowerCase().contains("potted_") || b.getType() == EnumMaterial.PUMPKIN_STEM.getType() || b.getType() == EnumMaterial.RED_MUSHROOM.getType() || b.getType().toString().toLowerCase().contains("redstone_lamp") || b.getType().toString().toLowerCase().contains("redstone_torch") || b.getType().toString().toLowerCase().contains("red_rose") || b.getType() == EnumMaterial.REDSTONE_WIRE.getType() || b.getType() == EnumMaterial.ROSE_BUSH.getType() || b.getType().toString().toLowerCase().contains("sapling") || b.getType().toString().toLowerCase().contains("seeds") || b.getType().toString().toLowerCase().contains("sign") || b.getType().toString().toLowerCase().contains("skull") || b.getType() == EnumMaterial.SNOW.getType() || b.getType() == EnumMaterial.SUGAR_CANE.getType() || b.getType().toString().toLowerCase().contains("sugar_cane_block") || b.getType() == EnumMaterial.SUNFLOWER.getType() || b.getType() == EnumMaterial.TALL_GRASS.getType() || b.getType() == EnumMaterial.TORCH.getType() || b.getType() == EnumMaterial.TRIPWIRE.getType() || b.getType().toString().toLowerCase().contains("tulip") || b.getType() == EnumMaterial.VINE.getType() || b.getType().toString().toLowerCase().endsWith("water") || b.getType() == EnumMaterial.WHEAT.getType() || b.getType().toString().toLowerCase().contains("_button") || b.getType().toString().toLowerCase().contains("_plate") || b.hasMetadata(GadgetsMenu.getInstance().getPluginName()) || !b.getType().isSolid() || b.getRelative(BlockFace.UP).getType() != Material.AIR) continue;
                    FallingBlock fb = loc.getWorld().spawnFallingBlock(b.getLocation().clone().add(0.0, (double)1.1f, 0.0), b.getType(), b.getData());
                    fb.setVelocity(new Vector(0.0f, 0.3f, 0.0f));
                    fb.setDropItem(false);
                    fb.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
                    MorphIronGolem.this.fallingBlocks.add(fb);
                    for (Entity entity : fb.getNearbyEntities(1.5, 1.0, 1.5)) {
                        if (entity == player || !(entity instanceof Player)) continue;
                        MathUtil.applyVelocity(entity, new Vector(entity.getVelocity().getX(), 0.7, entity.getVelocity().getZ()).add(MathUtil.getRandomCircleVector().multiply(0.15)));
                    }
                }
                ++this.step;
            }
        }.runTaskTimer((Plugin)GadgetsMenu.getInstance(), 0L, 3L);
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onBlockChange(EntityChangeBlockEvent event) {
        FallingBlock fb;
        if (event.getEntityType() == EntityType.FALLING_BLOCK && (fb = (FallingBlock)event.getEntity()).hasMetadata(GadgetsMenu.getInstance().getPluginName())) {
            event.setCancelled(true);
        }
    }
}

