/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.suits.types;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.cosmetics.suits.SuitType;
import com.yapzhenyie.GadgetsMenu.cosmetics.suits.types.Suit;
import com.yapzhenyie.GadgetsMenu.utils.BlockUtil;
import com.yapzhenyie.GadgetsMenu.utils.EnumMaterial;
import com.yapzhenyie.GadgetsMenu.utils.ParticleEffect;
import com.yapzhenyie.GadgetsMenu.utils.ReflectionUtils;
import com.yapzhenyie.GadgetsMenu.utils.VersionManager;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class SuitIceWalker
extends Suit {
    private boolean activated = false;
    private HashMap<Location, String> snowBlocks = new HashMap();

    public SuitIceWalker(UUID uuid) {
        super(uuid, SuitType.ICE_WALKER);
    }

    @Override
    public void onUpdate() {
        ParticleEffect.SNOWBALL.display(this.getPlayer().getLocation().add(0.0, 1.0, 0.0), 1.0f, 0.7f, 1.0f, 1.0f, 15);
        this.activated = true;
    }

    @Override
    public void onClear() {
        this.clearAll();
        HandlerList.unregisterAll((Listener)this);
    }

    private void clearAll() {
        this.forceRestore();
        this.activated = false;
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent e) {
        if (e.getPlayer() == this.getPlayer() && this.activated) {
            Block block = this.getPlayer().getLocation().getBlock();
            Block downBlock = this.getPlayer().getLocation().add(0.0, -1.0, 0.0).getBlock();
            if (!(!block.isEmpty() || downBlock.isEmpty() || downBlock.isLiquid() || !this.getPlayer().isOnGround() || downBlock.getType().toString().toLowerCase().contains("banner") || downBlock.getType() == EnumMaterial.BARRIER.getType() || downBlock.getType().toString().toLowerCase().contains("bed") || downBlock.getType() == EnumMaterial.BREWING_STAND.getType() || downBlock.getType() == EnumMaterial.BROWN_MUSHROOM.getType() || downBlock.getType() == EnumMaterial.CACTUS.getType() || downBlock.getType() == EnumMaterial.CAKE.getType() || downBlock.getType().toString().toLowerCase().contains("cake_block") || downBlock.getType() == EnumMaterial.CARROTS.getType() || downBlock.getType().toString().toLowerCase().contains("carpet") || downBlock.getType() == EnumMaterial.COBWEB.getType() || downBlock.getType() == EnumMaterial.COCOA.getType() || downBlock.getType().toString().toLowerCase().contains("crops") || downBlock.getType() == EnumMaterial.DANDELION.getType() || downBlock.getType() == EnumMaterial.DEAD_BUSH.getType() || downBlock.getType().toString().toLowerCase().contains("double_plant") || downBlock.getType() == EnumMaterial.DRAGON_EGG.getType() || downBlock.getType() == EnumMaterial.END_PORTAL.getType() || downBlock.getType() == EnumMaterial.END_PORTAL_FRAME.getType() || downBlock.getType() == EnumMaterial.FARMLAND.getType() || downBlock.getType() == EnumMaterial.FERN.getType() || downBlock.getType() == EnumMaterial.FIRE.getType() || downBlock.getType() == EnumMaterial.FLOWER_POT.getType() || downBlock.getType().toString().toLowerCase().contains("flower_pot") || downBlock.getType() == EnumMaterial.GRASS.getType() || downBlock.getType().toString().toLowerCase().contains("head") || downBlock.getType() == EnumMaterial.LADDER.getType() || downBlock.getType() == EnumMaterial.LARGE_FERN.getType() || downBlock.getType().toString().toLowerCase().endsWith("lava") || downBlock.getType() == EnumMaterial.LEVER.getType() || downBlock.getType() == EnumMaterial.LILAC.getType() || downBlock.getType() == EnumMaterial.LILY_PAD.getType() || downBlock.getType().toString().toLowerCase().contains("long_grass") || downBlock.getType() == EnumMaterial.MELON_STEM.getType() || downBlock.getType() == EnumMaterial.MUSHROOM_STEM.getType() || downBlock.getType() == EnumMaterial.NETHER_PORTAL.getType() || downBlock.getType() == EnumMaterial.NETHER_WART.getType() || downBlock.getType() == EnumMaterial.PEONY.getType() || downBlock.getType().toString().toLowerCase().contains("piston_") || downBlock.getType() == EnumMaterial.POTATOES.getType() || downBlock.getType().toString().toLowerCase().contains("potted_") || downBlock.getType() == EnumMaterial.PUMPKIN_STEM.getType() || downBlock.getType().toString().toLowerCase().contains("redstone_lamp") || downBlock.getType().toString().toLowerCase().contains("redstone_torch") || downBlock.getType() == EnumMaterial.RED_MUSHROOM.getType() || downBlock.getType().toString().toLowerCase().contains("red_rose") || downBlock.getType() == EnumMaterial.REDSTONE_WIRE.getType() || downBlock.getType() == EnumMaterial.ROSE_BUSH.getType() || downBlock.getType().toString().toLowerCase().contains("sapling") || downBlock.getType().toString().toLowerCase().contains("seeds") || downBlock.getType().toString().toLowerCase().contains("sign") || downBlock.getType().toString().toLowerCase().contains("skull") || downBlock.getType() == EnumMaterial.SNOW.getType() || downBlock.getType() == EnumMaterial.SPAWNER.getType() || downBlock.getType() == EnumMaterial.SUGAR_CANE.getType() || downBlock.getType().toString().toLowerCase().contains("sugar_cane_block") || downBlock.getType() == EnumMaterial.SUNFLOWER.getType() || downBlock.getType() == EnumMaterial.TALL_GRASS.getType() || downBlock.getType() == EnumMaterial.TORCH.getType() || downBlock.getType() == EnumMaterial.TRIPWIRE.getType() || downBlock.getType() == EnumMaterial.TRIPWIRE_HOOK.getType() || downBlock.getType().toString().toLowerCase().contains("tulip") || downBlock.getType() == EnumMaterial.VINE.getType() || downBlock.getType().toString().toLowerCase().endsWith("water") || downBlock.getType() == EnumMaterial.WHEAT.getType() || downBlock.getType().toString().toLowerCase().contains("_button") || BlockUtil.isPortalBlock(downBlock) || BlockUtil.isCocoaBlock(downBlock) || BlockUtil.isChorusPlant(downBlock))) {
                this.setToRestore(this.getPlayer(), block, EnumMaterial.SNOW, (byte)0, 60);
            }
        }
    }

    private void setToRestore(final Player player, final Block block, EnumMaterial material, byte data, int tickDelay) {
        if (this.snowBlocks.containsKey(block.getLocation())) {
            return;
        }
        if (!block.hasMetadata(GadgetsMenu.getInstance().getPluginName()) && !this.snowBlocks.containsKey(block.getLocation())) {
            if (VersionManager.is1_13OrAbove()) {
                try {
                    this.snowBlocks.put(block.getLocation(), block.getBlockData().getAsString());
                }
                catch (NoSuchMethodError noSuchMethodError) {}
            } else {
                try {
                    this.snowBlocks.put(block.getLocation(), block.getType().toString() + "," + block.getData());
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
            }
            block.setType(material.getType());
            ReflectionUtils.setData(block, data);
            block.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
            Bukkit.getScheduler().runTaskLater((Plugin)GadgetsMenu.getInstance(), new Runnable(){

                @Override
                public void run() {
                    SuitIceWalker.this.restoreBlock(player, block.getLocation());
                }
            }, (long)tickDelay);
        }
    }

    private void forceRestore() {
        if (this.snowBlocks.isEmpty()) {
            return;
        }
        for (Location loc : this.snowBlocks.keySet()) {
            Block b = loc.getBlock();
            if (VersionManager.is1_13OrAbove()) {
                try {
                    BlockData blockData = Bukkit.getServer().createBlockData(this.snowBlocks.get(loc));
                    b.setBlockData(blockData);
                }
                catch (Exception blockData) {}
            } else {
                String s = this.snowBlocks.get(loc);
                Material m = Material.valueOf((String)s.split(",")[0]);
                byte d = Byte.valueOf(s.split(",")[1]);
                b.setType(m);
                ReflectionUtils.setData(b, d);
            }
            b.removeMetadata(GadgetsMenu.getInstance().getPluginName(), (Plugin)GadgetsMenu.getInstance());
        }
        this.snowBlocks.clear();
    }

    private void restoreBlock(Player player, Location location) {
        if (!this.snowBlocks.containsKey(location)) {
            return;
        }
        Block b = location.getBlock();
        if (VersionManager.is1_13OrAbove()) {
            try {
                BlockData blockData = Bukkit.getServer().createBlockData(this.snowBlocks.get(location));
                b.setBlockData(blockData);
            }
            catch (Exception blockData) {}
        } else {
            String s = this.snowBlocks.get(location);
            Material m = Material.valueOf((String)s.split(",")[0]);
            byte d = Byte.valueOf(s.split(",")[1]);
            b.setType(m);
            ReflectionUtils.setData(b, d);
        }
        b.removeMetadata(GadgetsMenu.getInstance().getPluginName(), (Plugin)GadgetsMenu.getInstance());
        this.snowBlocks.remove(location);
    }
}

